/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.collections;

public class SynchronizedQueue<T> {
    public static final int DEFAULT_SIZE = 128;
    private Object[] queue;
    private int size;
    private int insert = 0;
    private int remove = 0;

    public SynchronizedQueue() {
        this(128);
    }

    public SynchronizedQueue(int n) {
        this.queue = new Object[n];
        this.size = n;
    }

    public synchronized boolean offer(T t) {
        this.queue[this.insert++] = t;
        if (this.insert == this.size) {
            this.insert = 0;
        }
        if (this.insert == this.remove) {
            this.expand();
        }
        return true;
    }

    public synchronized T poll() {
        if (this.insert == this.remove) {
            return null;
        }
        Object object = this.queue[this.remove];
        this.queue[this.remove] = null;
        ++this.remove;
        if (this.remove == this.size) {
            this.remove = 0;
        }
        return (T)object;
    }

    private void expand() {
        int n = this.size * 2;
        Object[] objectArray = new Object[n];
        System.arraycopy(this.queue, this.insert, objectArray, 0, this.size - this.insert);
        System.arraycopy(this.queue, 0, objectArray, this.size - this.insert, this.insert);
        this.insert = this.size;
        this.remove = 0;
        this.queue = objectArray;
        this.size = n;
    }

    public synchronized int size() {
        int n = this.insert - this.remove;
        if (n < 0) {
            n += this.size;
        }
        return n;
    }

    public synchronized void clear() {
        this.queue = new Object[this.size];
        this.insert = 0;
        this.remove = 0;
    }
}

