/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.internal.parser.v0.factories;

import org.openjdk.jmc.common.IMCMethod;
import org.openjdk.jmc.common.IMCType;
import org.openjdk.jmc.common.unit.ContentType;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.MCMethod;
import org.openjdk.jmc.flightrecorder.internal.parser.v0.factories.IPoolFactory;
import org.openjdk.jmc.flightrecorder.internal.parser.v0.model.ValueDescriptor;
import org.openjdk.jmc.flightrecorder.internal.util.CanonicalConstantMap;

final class MethodFactory
implements IPoolFactory<IMCMethod> {
    private final int m_methodClass;
    private final int m_methodName;
    private final int m_methodSignatureIndex;
    private final int m_methodModifiers;
    private final CanonicalConstantMap<IMCMethod> methodMap;

    public MethodFactory(ValueDescriptor[] descriptors, CanonicalConstantMap<IMCMethod> methodMap) {
        this.methodMap = methodMap;
        this.m_methodClass = ValueDescriptor.getIndex(descriptors, "class");
        this.m_methodName = ValueDescriptor.getIndex(descriptors, "name");
        this.m_methodSignatureIndex = ValueDescriptor.getIndex(descriptors, "signature");
        this.m_methodModifiers = ValueDescriptor.getIndex(descriptors, "modifiers");
    }

    @Override
    public IMCMethod createObject(long identifier, Object source) {
        Object[] o = (Object[])source;
        if (o != null) {
            return this.methodMap.canonicalize(this.createMethod(o));
        }
        return null;
    }

    private IMCMethod createMethod(Object[] o) {
        String formalDesc = null;
        String methodName = null;
        Integer modifier = null;
        IMCType type = null;
        if (this.m_methodSignatureIndex != -1) {
            formalDesc = (String)o[this.m_methodSignatureIndex];
        }
        if (this.m_methodName != -1) {
            methodName = (String)o[this.m_methodName];
        }
        if (this.m_methodModifiers != -1) {
            Number s = (Number)o[this.m_methodModifiers];
            Integer n = modifier = s != null ? Integer.valueOf(s.intValue()) : null;
        }
        if (this.m_methodClass != -1) {
            type = (IMCType)o[this.m_methodClass];
        }
        return new MCMethod(type, methodName, formalDesc, modifier, null);
    }

    @Override
    public ContentType<IMCMethod> getContentType() {
        return UnitLookup.METHOD;
    }
}

