/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.settings;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.ref.SoftReference;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.settings.ContextProvider;
import org.netbeans.modules.settings.Env;
import org.netbeans.modules.settings.SaveSupport;
import org.netbeans.modules.settings.ScheduledRequest;
import org.netbeans.modules.settings.convertors.SerialDataNode;
import org.netbeans.spi.settings.Convertor;
import org.openide.cookies.InstanceCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

final class InstanceProvider
extends FileChangeAdapter
implements PropertyChangeListener,
FileSystem.AtomicAction {
    private static final Logger LOG = Logger.getLogger(InstanceProvider.class.getName());
    private final InstanceContent lkpContent;
    private final Lookup lookup;
    private final DataObject dobj;
    private final FileObject settingFO;
    private final FileObject providerFO;
    private final NodeConvertor node;
    private SaveSupport saver;
    private SaveCookie scCache;
    private boolean wasReportedProblem = false;
    private Set<String> instanceOfSet;
    private String instanceClassName;
    final Object READWRITE_LOCK = new Object();
    private Convertor convertor;
    private ScheduledRequest request;

    public InstanceProvider(DataObject dataObject, FileObject fileObject) {
        this.settingFO = dataObject.getPrimaryFile();
        this.providerFO = fileObject;
        this.dobj = dataObject;
        this.settingFO.addFileChangeListener(FileUtil.weakFileChangeListener((FileChangeListener)this, (Object)this.settingFO));
        this.lkpContent = new InstanceContent();
        this.lkpContent.add((Object)this.createInstance(null));
        this.node = new NodeConvertor();
        this.lkpContent.add((Object)this, (InstanceContent.Convertor)this.node);
        this.lookup = new AbstractLookup((AbstractLookup.Content)this.lkpContent);
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    FileObject getProvider() {
        return this.providerFO;
    }

    FileObject getFile() {
        return this.settingFO;
    }

    DataObject getDataObject() {
        return this.dobj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent == null) {
            return;
        }
        String string = propertyChangeEvent.getPropertyName();
        if (string == null) {
            return;
        }
        if (string == "savecookie") {
            this.provideSaveCookie();
        } else if (string == "fileChanged") {
            InstanceProvider instanceProvider = this;
            synchronized (instanceProvider) {
                this.instanceOfSet = null;
            }
            this.instanceCookieChanged(null);
        }
    }

    public void fileChanged(FileEvent fileEvent) {
        if (this.saver != null && fileEvent.firedFrom((FileSystem.AtomicAction)this.saver.getSaveCookie())) {
            return;
        }
        this.propertyChange(new PropertyChangeEvent(this, "fileChanged", null, null));
    }

    public void fileDeleted(FileEvent fileEvent) {
        if (this.saver != null && fileEvent.firedFrom((FileSystem.AtomicAction)this.saver.getSaveCookie())) {
            return;
        }
        this.releaseInstance();
    }

    private synchronized void attachToInstance(Object object) {
        if (this.saver != null) {
            this.saver.removePropertyChangeListener(this);
            this.getScheduledRequest().forceToFinish();
        }
        this.saver = this.createSaveSupport(object);
        this.saver.addPropertyChangeListener(this);
    }

    private InstanceCookie.Of createInstance(Object object) {
        return new InstanceCookieImpl(object);
    }

    private SaveSupport createSaveSupport(Object object) {
        return new SaveSupport(this, object);
    }

    private void provideSaveCookie() {
        SaveCookie saveCookie = this.saver.getSaveCookie();
        if (this.scCache != null) {
            if (!this.saver.isChanged()) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("remove save cookie: " + this.dobj);
                }
                this.lkpContent.remove((Object)this.scCache);
                this.scCache = null;
                return;
            }
        } else if (this.saver.isChanged()) {
            this.scCache = saveCookie;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("add save cookie: " + this.dobj + " cookie: " + saveCookie);
            }
            this.lkpContent.add((Object)saveCookie);
            return;
        }
    }

    private void releaseInstance() {
        SaveSupport saveSupport = this.saver;
        if (saveSupport != null) {
            saveSupport.removePropertyChangeListener(this);
        }
        if (this.scCache != null) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("release instance and remove save cookie: " + this.dobj);
            }
            this.lkpContent.remove((Object)this.scCache);
            this.getScheduledRequest().cancel();
            this.scCache = null;
        }
        this.lkpContent.remove((Object)this, (InstanceContent.Convertor)this.node);
    }

    private void instanceCookieChanged(Object object) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("instanceCookieChanged: " + this.dobj + " inst: " + object);
        }
        this.releaseInstance();
        this.lkpContent.add((Object)this, (InstanceContent.Convertor)this.node);
        Object object2 = this.lookup.lookup(InstanceCookie.class);
        this.lkpContent.remove(object2);
        InstanceCookie.Of of = this.createInstance(object);
        this.lkpContent.add((Object)of);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("cookie replaced: " + this.dobj + " old: " + object2 + " new: " + of);
        }
    }

    Convertor getConvertor() throws IOException {
        if (this.convertor == null) {
            Object object = this.providerFO.getAttribute("settings.convertor");
            if (object == null || !(object instanceof Convertor)) {
                throw new IOException("cannot create convertor: " + object + ", provider:" + this.providerFO);
            }
            this.convertor = (Convertor)object;
        }
        return this.convertor;
    }

    private synchronized String getInstanceClassName() {
        if (this.instanceClassName == null) {
            Object object = this.providerFO.getAttribute("settings.instanceClass");
            this.instanceClassName = object != null && object instanceof String ? Utilities.translate((String)((String)object)) : null;
        }
        return this.instanceClassName;
    }

    public String toString() {
        return this.getClass().getName() + '@' + Integer.toHexString(System.identityHashCode(this)) + '[' + this.getDataObject() + ", " + this.getProvider() + ']';
    }

    public void run() throws IOException {
        this.saver.writeDown();
    }

    synchronized ScheduledRequest getScheduledRequest() {
        if (this.request == null) {
            this.request = new ScheduledRequest(this.settingFO, this);
        }
        return this.request;
    }

    private static final class NodeConvertor
    implements InstanceContent.Convertor<InstanceProvider, Node> {
        NodeConvertor() {
        }

        public Node convert(InstanceProvider instanceProvider) {
            return new SerialDataNode(instanceProvider.getDataObject());
        }

        public Class<Node> type(InstanceProvider instanceProvider) {
            return Node.class;
        }

        public String id(InstanceProvider instanceProvider) {
            return instanceProvider.toString();
        }

        public String displayName(InstanceProvider instanceProvider) {
            return instanceProvider.toString();
        }
    }

    final class InstanceCookieImpl
    implements InstanceCookie.Of {
        private SoftReference<Object> cachedInstance;

        public InstanceCookieImpl(Object object) {
            this.setCachedInstance(object);
        }

        public Class instanceClass() throws IOException, ClassNotFoundException {
            String string = InstanceProvider.this.getInstanceClassName();
            if (string == null) {
                Object object = this.instanceCreate();
                if (object != null) {
                    return object.getClass();
                }
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "instance could not be created for: {0}", InstanceProvider.this.getInstanceClassName());
                }
                return null;
            }
            return ((ClassLoader)Lookup.getDefault().lookup(ClassLoader.class)).loadClass(string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object instanceCreate() throws IOException, ClassNotFoundException {
            Object object;
            Object object2;
            Object object3 = this;
            synchronized (object3) {
                object2 = this.getCachedInstance();
                if (object2 != null) {
                    return object2;
                }
            }
            try {
                object3 = InstanceProvider.this.READWRITE_LOCK;
                synchronized (object3) {
                    object = ContextProvider.createReaderContextProvider(new InputStreamReader(InstanceProvider.this.settingFO.getInputStream(), StandardCharsets.UTF_8), InstanceProvider.this.getFile());
                    object2 = InstanceProvider.this.getConvertor().read((Reader)object);
                }
            }
            catch (IOException iOException) {
                throw (IOException)Exceptions.attachLocalizedMessage((Throwable)iOException, (String)InstanceProvider.this.toString());
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw (ClassNotFoundException)Exceptions.attachLocalizedMessage((Throwable)classNotFoundException, (String)InstanceProvider.this.toString());
            }
            object3 = this;
            synchronized (object3) {
                object = this.getCachedInstance();
                if (object != null) {
                    return object;
                }
                this.setCachedInstance(object2);
            }
            InstanceProvider.this.attachToInstance(object2);
            return object2;
        }

        public String instanceName() {
            String string = InstanceProvider.this.getInstanceClassName();
            if (string != null) {
                return string;
            }
            Exception exception = null;
            try {
                Class clazz = this.instanceClass();
                if (clazz != null) {
                    return clazz.getName();
                }
            }
            catch (IOException iOException) {
                exception = iOException;
            }
            catch (ClassNotFoundException classNotFoundException) {
                exception = classNotFoundException;
            }
            if (exception != null && !InstanceProvider.this.wasReportedProblem) {
                InstanceProvider.this.wasReportedProblem = true;
                Exceptions.attachLocalizedMessage((Throwable)exception, (String)InstanceProvider.this.dobj.toString());
                Logger.getLogger(InstanceProvider.class.getName()).log(Level.WARNING, null, exception);
            }
            return "Unknown";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean instanceOf(Class<?> clazz) {
            Object object;
            Object object2 = InstanceProvider.this;
            synchronized (object2) {
                if (InstanceProvider.this.instanceOfSet == null) {
                    InstanceProvider.this.instanceOfSet = Env.parseAttribute(InstanceProvider.this.providerFO.getAttribute("settings.instanceOf"));
                    object = InstanceProvider.this.instanceOfSet.iterator();
                    InstanceProvider.this.instanceOfSet = new HashSet(InstanceProvider.this.instanceOfSet.size() * 5 / 4);
                    while (object.hasNext()) {
                        InstanceProvider.this.instanceOfSet.add(Utilities.translate((String)((String)object.next())));
                    }
                }
            }
            if (InstanceProvider.this.instanceOfSet.isEmpty()) {
                object2 = null;
                try {
                    object = this.instanceClass();
                    if (object != null) {
                        return clazz.isAssignableFrom((Class<?>)object);
                    }
                }
                catch (IOException iOException) {
                    object2 = iOException;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    object2 = classNotFoundException;
                }
                if (object2 != null && !InstanceProvider.this.wasReportedProblem) {
                    InstanceProvider.this.wasReportedProblem = true;
                    Exceptions.attachLocalizedMessage((Throwable)object2, (String)InstanceProvider.this.dobj.toString());
                    Logger.getLogger(InstanceProvider.class.getName()).log(Level.WARNING, null, (Throwable)object2);
                }
                return false;
            }
            return InstanceProvider.this.instanceOfSet.contains(clazz.getName());
        }

        public void setInstance(Object object, boolean bl) throws IOException {
            InstanceProvider.this.instanceCookieChanged(object);
            if (object != null) {
                InstanceProvider.this.attachToInstance(object);
                if (bl) {
                    InstanceProvider.this.getScheduledRequest().runAndWait();
                }
            }
        }

        private Object getCachedInstance() {
            return this.cachedInstance.get();
        }

        private void setCachedInstance(Object object) {
            this.cachedInstance = new SoftReference<Object>(object);
        }
    }
}

