/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.java.impl;

import java.util.Iterator;
import java.util.List;
import javax.swing.SortOrder;
import org.graalvm.visualvm.heapviewer.java.ClassNode;
import org.graalvm.visualvm.heapviewer.java.InstanceNode;
import org.graalvm.visualvm.heapviewer.java.impl.Bundle;
import org.graalvm.visualvm.heapviewer.model.DataType;
import org.graalvm.visualvm.heapviewer.model.HeapViewerNode;
import org.graalvm.visualvm.heapviewer.model.HeapViewerNodeFilter;
import org.graalvm.visualvm.heapviewer.model.Progress;
import org.graalvm.visualvm.heapviewer.model.TextNode;
import org.graalvm.visualvm.heapviewer.ui.UIThresholds;
import org.graalvm.visualvm.heapviewer.utils.NodesComputer;
import org.graalvm.visualvm.heapviewer.utils.ProgressIterator;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.jfluid.heap.JavaClass;

public class JavaInstancesProvider
extends HeapViewerNode.Provider {
    @Override
    public String getName() {
        return Bundle.JavaInstancesProvider_Name();
    }

    @Override
    public boolean supportsView(Heap heap, String viewID) {
        return !viewID.startsWith("diff");
    }

    @Override
    public boolean supportsNode(HeapViewerNode parent, Heap heap, String viewID) {
        return parent instanceof ClassNode;
    }

    @Override
    public HeapViewerNode[] getNodes(HeapViewerNode parent, Heap heap, String viewID, HeapViewerNodeFilter viewFilter, List<DataType> dataTypes, List<SortOrder> sortOrders, Progress progress) throws InterruptedException {
        final JavaClass jclass = HeapViewerNode.getValue(parent, DataType.CLASS, heap);
        if (jclass == null) {
            return null;
        }
        NodesComputer<Instance> computer = new NodesComputer<Instance>(jclass.getInstancesCount(), UIThresholds.MAX_CLASS_INSTANCES){

            @Override
            protected boolean sorts(DataType dataType) {
                return !DataType.COUNT.equals(dataType) && (!DataType.OWN_SIZE.equals(dataType) || jclass.isArray());
            }

            @Override
            protected HeapViewerNode createNode(Instance instance) {
                return new InstanceNode(instance);
            }

            @Override
            protected ProgressIterator<Instance> objectsIterator(int index, Progress progress) {
                Iterator iterator = jclass.getInstancesIterator();
                return new ProgressIterator<Instance>(iterator, index, true, progress);
            }

            @Override
            protected String getMoreNodesString(String moreNodesCount) {
                return Bundle.JavaInstancesProvider_MoreNodes(moreNodesCount);
            }

            @Override
            protected String getSamplesContainerString(String objectsCount) {
                return Bundle.JavaInstancesProvider_SamplesContainer(objectsCount);
            }

            @Override
            protected String getNodesContainerString(String firstNodeIdx, String lastNodeIdx) {
                return Bundle.JavaInstancesProvider_NodesContainer(firstNodeIdx, lastNodeIdx);
            }
        };
        return computer.computeNodes(parent, heap, viewID, null, dataTypes, sortOrders, progress);
    }

    public static HeapViewerNode[] getHeapInstances(HeapViewerNode parent, final Heap heap, String viewID, HeapViewerNodeFilter viewFilter, List<DataType> dataTypes, List<SortOrder> sortOrders, Progress progress) throws InterruptedException {
        HeapViewerNode[] heapViewerNodeArray;
        long totalInstancesL = heap.getSummary().getTotalLiveInstances();
        int totalInstancesI = totalInstancesL < 0L || totalInstancesL > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)totalInstancesL;
        NodesComputer<Instance> computer = new NodesComputer<Instance>(totalInstancesI, UIThresholds.MAX_TOPLEVEL_INSTANCES){

            @Override
            protected boolean sorts(DataType dataType) {
                return !DataType.COUNT.equals(dataType);
            }

            @Override
            protected HeapViewerNode createNode(Instance instance) {
                return new InstanceNode(instance);
            }

            @Override
            protected ProgressIterator<Instance> objectsIterator(int index, Progress progress) {
                Iterator iterator = heap.getAllInstancesIterator();
                return new ProgressIterator<Instance>(iterator, index, true, progress);
            }

            @Override
            protected String getMoreNodesString(String moreNodesCount) {
                return Bundle.JavaInstancesProvider_MoreNodes(moreNodesCount);
            }

            @Override
            protected String getSamplesContainerString(String objectsCount) {
                return Bundle.JavaInstancesProvider_SamplesContainer(objectsCount);
            }

            @Override
            protected String getNodesContainerString(String firstNodeIdx, String lastNodeIdx) {
                return Bundle.JavaInstancesProvider_NodesContainer(firstNodeIdx, lastNodeIdx);
            }
        };
        HeapViewerNode[] nodes = computer.computeNodes(parent, heap, viewID, viewFilter, dataTypes, sortOrders, progress);
        if (nodes.length == 0) {
            HeapViewerNode[] heapViewerNodeArray2 = new HeapViewerNode[1];
            heapViewerNodeArray = heapViewerNodeArray2;
            heapViewerNodeArray2[0] = new TextNode(JavaInstancesProvider.getNoInstancesString(viewFilter));
        } else {
            heapViewerNodeArray = nodes;
        }
        return heapViewerNodeArray;
    }

    private static String getNoInstancesString(HeapViewerNodeFilter viewFilter) {
        return viewFilter == null ? Bundle.JavaInstancesProvider_NoInstances() : Bundle.JavaInstancesProvider_NoInstancesFilter();
    }
}

