/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.jvm.JvmGeneratorExtensions;
import org.jetbrains.kotlin.backend.jvm.JvmIrDeserializer;
import org.jetbrains.kotlin.backend.jvm.JvmIrTypeSystemContext;
import org.jetbrains.kotlin.backend.jvm.lower.SingletonObjectJvmStaticTransformer;
import org.jetbrains.kotlin.backend.jvm.serialization.DeserializeLazyDeclarationsKt;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.linkage.IrProvider;
import org.jetbrains.kotlin.ir.util.SymbolTable;
import org.jetbrains.kotlin.load.kotlin.JvmPackagePartSource;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinarySourceElement;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/JvmIrDeserializerImpl;", "Lorg/jetbrains/kotlin/backend/jvm/JvmIrDeserializer;", "()V", "deserializeTopLevelClass", "", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "irBuiltIns", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "symbolTable", "Lorg/jetbrains/kotlin/ir/util/SymbolTable;", "irProviders", "", "Lorg/jetbrains/kotlin/ir/linkage/IrProvider;", "extensions", "Lorg/jetbrains/kotlin/backend/jvm/JvmGeneratorExtensions;", "backend.jvm.entrypoint"})
public final class JvmIrDeserializerImpl
implements JvmIrDeserializer {
    @Override
    public boolean deserializeTopLevelClass(@NotNull IrClass irClass2, @NotNull IrBuiltIns irBuiltIns, @NotNull SymbolTable symbolTable, @NotNull List<? extends IrProvider> irProviders, @NotNull JvmGeneratorExtensions extensions) {
        Object object;
        Intrinsics.checkNotNullParameter(irClass2, "irClass");
        Intrinsics.checkNotNullParameter(irBuiltIns, "irBuiltIns");
        Intrinsics.checkNotNullParameter(symbolTable, "symbolTable");
        Intrinsics.checkNotNullParameter(irProviders, "irProviders");
        Intrinsics.checkNotNullParameter(extensions, "extensions");
        SourceElement source = irClass2.getSource();
        Object object2 = source instanceof KotlinJvmBinarySourceElement ? ((KotlinJvmBinarySourceElement)source).getBinaryClass().getClassHeader().getSerializedIr() : (source instanceof JvmPackagePartSource ? (Object)((object = ((JvmPackagePartSource)source).getKnownJvmBinaryClass()) != null && (object = object.getClassHeader()) != null ? ((KotlinClassHeader)object).getSerializedIr() : null) : null);
        if (object2 == null) {
            return false;
        }
        byte[] serializedIr = object2;
        DeserializeLazyDeclarationsKt.deserializeFromByteArray(serializedIr, irBuiltIns, symbolTable, irProviders, irClass2, new JvmIrTypeSystemContext(irBuiltIns));
        irClass2.transform(new SingletonObjectJvmStaticTransformer(irBuiltIns, extensions.getCachedFields()), null);
        return true;
    }
}

