"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TRANSFORM_ROUTE_PREFIX = exports.Setting = exports.SM_ROUTE_PREFIX = exports.SECURITY_EXCEPTION_PREFIX = exports.NOTIFICATION_CONFIGS_ROUTE = exports.NOTIFICATIONS_API_ROUTE_PREFIX = exports.INDEX = exports.DEFAULT_HEADERS = exports.CLUSTER = exports.CHANNELS_ROUTE = exports.API_ROUTE_PREFIX_ROLLUP = exports.API_ROUTE_PREFIX = exports.API = void 0;

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
const API_ROUTE_PREFIX = "/_plugins/_ism";
exports.API_ROUTE_PREFIX = API_ROUTE_PREFIX;
const API_ROUTE_PREFIX_ROLLUP = "/_plugins/_rollup";
exports.API_ROUTE_PREFIX_ROLLUP = API_ROUTE_PREFIX_ROLLUP;
const TRANSFORM_ROUTE_PREFIX = "/_plugins/_transform";
exports.TRANSFORM_ROUTE_PREFIX = TRANSFORM_ROUTE_PREFIX;
const NOTIFICATIONS_API_ROUTE_PREFIX = "/_plugins/_notifications";
exports.NOTIFICATIONS_API_ROUTE_PREFIX = NOTIFICATIONS_API_ROUTE_PREFIX;
const CHANNELS_ROUTE = `${NOTIFICATIONS_API_ROUTE_PREFIX}/channels`;
exports.CHANNELS_ROUTE = CHANNELS_ROUTE;
const NOTIFICATION_CONFIGS_ROUTE = `${NOTIFICATIONS_API_ROUTE_PREFIX}/configs`;
exports.NOTIFICATION_CONFIGS_ROUTE = NOTIFICATION_CONFIGS_ROUTE;
const SM_ROUTE_PREFIX = "/_plugins/_sm";
exports.SM_ROUTE_PREFIX = SM_ROUTE_PREFIX;
const API = {
  POLICY_BASE: `${API_ROUTE_PREFIX}/policies`,
  EXPLAIN_BASE: `${API_ROUTE_PREFIX}/explain`,
  RETRY_BASE: `${API_ROUTE_PREFIX}/retry`,
  ADD_POLICY_BASE: `${API_ROUTE_PREFIX}/add`,
  REMOVE_POLICY_BASE: `${API_ROUTE_PREFIX}/remove`,
  CHANGE_POLICY_BASE: `${API_ROUTE_PREFIX}/change_policy`,
  ROLLUP_JOBS_BASE: `${API_ROUTE_PREFIX_ROLLUP}/jobs`,
  TRANSFORM_BASE: `${TRANSFORM_ROUTE_PREFIX}`,
  CHANNELS_BASE: `${CHANNELS_ROUTE}`,
  NOTIFICATION_CONFIGS_BASE: `${NOTIFICATION_CONFIGS_ROUTE}`,
  SM_POLICY_BASE: `${SM_ROUTE_PREFIX}/policies`
};
exports.API = API;
const DEFAULT_HEADERS = {
  "Content-Type": "application/json",
  Accept: "application/json"
};
exports.DEFAULT_HEADERS = DEFAULT_HEADERS;
let CLUSTER;
exports.CLUSTER = CLUSTER;

(function (CLUSTER) {
  CLUSTER["ADMIN"] = "admin";
  CLUSTER["ISM"] = "opendistro_ism";
  CLUSTER["DATA"] = "data";
})(CLUSTER || (exports.CLUSTER = CLUSTER = {}));

let INDEX;
exports.INDEX = INDEX;

(function (INDEX) {
  INDEX["OPENDISTRO_ISM_CONFIG"] = ".opendistro-ism-config";
})(INDEX || (exports.INDEX = INDEX = {}));

let Setting;
exports.Setting = Setting;

(function (Setting) {
  Setting["RolloverAlias"] = "plugins.index_state_management.rollover_alias";
})(Setting || (exports.Setting = Setting = {}));

const SECURITY_EXCEPTION_PREFIX = "[security_exception]";
exports.SECURITY_EXCEPTION_PREFIX = SECURITY_EXCEPTION_PREFIX;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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