class ParseError extends Error{sourceStart;sourceEnd;parserState;constructor(e,n,r,t){super(e),this.name="ParseError",this.sourceStart=n,this.sourceEnd=r,this.parserState=t}}class Reader{cursor;source="";codePointSource=[];length=0;representationStart=0;representationEnd=-1;constructor(e){this.cursor=0,this.source=e,this.length=e.length,this.codePointSource=new Array(this.length);for(let e=0;e<this.length;e++)this.codePointSource[e]=this.source.charCodeAt(e)}advanceCodePoint(e=1){this.cursor+=e,this.representationEnd=this.cursor-1}readCodePoint(e=1){const n=this.codePointSource[this.cursor];return void 0!==n&&(this.cursor+=e,this.representationEnd=this.cursor-1,n)}unreadCodePoint(e=1){this.cursor-=e,this.representationEnd=this.cursor-1}}var e,n,r;function mirrorVariantType(n){switch(n){case e.OpenParen:return e.CloseParen;case e.CloseParen:return e.OpenParen;case e.OpenCurly:return e.CloseCurly;case e.CloseCurly:return e.OpenCurly;case e.OpenSquare:return e.CloseSquare;case e.CloseSquare:return e.OpenSquare;default:return null}}function mirrorVariant(n){switch(n[0]){case e.OpenParen:return[e.CloseParen,")",-1,-1,void 0];case e.CloseParen:return[e.OpenParen,"(",-1,-1,void 0];case e.OpenCurly:return[e.CloseCurly,"}",-1,-1,void 0];case e.CloseCurly:return[e.OpenCurly,"{",-1,-1,void 0];case e.OpenSquare:return[e.CloseSquare,"]",-1,-1,void 0];case e.CloseSquare:return[e.OpenSquare,"[",-1,-1,void 0];default:return null}}!function(e){e.Comment="comment",e.AtKeyword="at-keyword-token",e.BadString="bad-string-token",e.BadURL="bad-url-token",e.CDC="CDC-token",e.CDO="CDO-token",e.Colon="colon-token",e.Comma="comma-token",e.Delim="delim-token",e.Dimension="dimension-token",e.EOF="EOF-token",e.Function="function-token",e.Hash="hash-token",e.Ident="ident-token",e.Number="number-token",e.Percentage="percentage-token",e.Semicolon="semicolon-token",e.String="string-token",e.URL="url-token",e.Whitespace="whitespace-token",e.OpenParen="(-token",e.CloseParen=")-token",e.OpenSquare="[-token",e.CloseSquare="]-token",e.OpenCurly="{-token",e.CloseCurly="}-token"}(e||(e={})),function(e){e.Integer="integer",e.Number="number"}(n||(n={})),function(e){e.Unrestricted="unrestricted",e.ID="id"}(r||(r={}));const t=Object.values(e);function isToken(e){return!!Array.isArray(e)&&(!(e.length<4)&&(!!t.includes(e[0])&&("string"==typeof e[1]&&("number"==typeof e[2]&&"number"==typeof e[3]))))}function stringify(...e){let n="";for(let r=0;r<e.length;r++)n+=e[r][1];return n}const o=39,i=42,c=8,s=13,a=9,u=58,d=44,p=64,S=127,P=33,C=12,l=46,f=62,E=45,h=31,m=69,v=101,k=123,g=40,I=91,T=60,O=10,w=11,A=95,U=1114111,D=0,L=35,y=37,q=43,R=34,x=65533,N=92,b=125,W=41,F=93,V=59,B=14,H=47,z=32;function checkIfFourCodePointsWouldStartCDO(e,n){return n.codePointSource[n.cursor]===T&&n.codePointSource[n.cursor+1]===P&&n.codePointSource[n.cursor+2]===E&&n.codePointSource[n.cursor+3]===E}function isDigitCodePoint(e){return e>=48&&e<=57}function isUppercaseLetterCodePoint(e){return e>=65&&e<=90}function isLowercaseLetterCodePoint(e){return e>=97&&e<=122}function isHexDigitCodePoint(e){return isDigitCodePoint(e)||e>=97&&e<=102||e>=65&&e<=70}function isLetterCodePoint(e){return isLowercaseLetterCodePoint(e)||isUppercaseLetterCodePoint(e)}function isNonASCIICodePoint(e){return e>=128}function isIdentStartCodePoint(e){return isLetterCodePoint(e)||isNonASCIICodePoint(e)||e===A}function isIdentCodePoint(e){return isIdentStartCodePoint(e)||isDigitCodePoint(e)||e===E}function isNewLine(e){return 10===e||13===e||12===e}function isWhitespace(e){return 32===e||10===e||9===e||13===e||12===e}function checkIfTwoCodePointsAreAValidEscape(e,n){return n.codePointSource[n.cursor]===N&&!isNewLine(n.codePointSource[n.cursor+1])}function checkIfThreeCodePointsWouldStartAnIdentSequence(e,n){return n.codePointSource[n.cursor]===E?n.codePointSource[n.cursor+1]===E||(!!isIdentStartCodePoint(n.codePointSource[n.cursor+1])||n.codePointSource[n.cursor+1]===N&&!isNewLine(n.codePointSource[n.cursor+2])):!!isIdentStartCodePoint(n.codePointSource[n.cursor])||checkIfTwoCodePointsAreAValidEscape(0,n)}function checkIfThreeCodePointsWouldStartANumber(e,n){return n.codePointSource[n.cursor]===q||n.codePointSource[n.cursor]===E?!!isDigitCodePoint(n.codePointSource[n.cursor+1])||n.codePointSource[n.cursor+1]===l&&isDigitCodePoint(n.codePointSource[n.cursor+2]):n.codePointSource[n.cursor]===l?isDigitCodePoint(n.codePointSource[n.cursor+1]):isDigitCodePoint(n.codePointSource[n.cursor])}function checkIfTwoCodePointsStartAComment(e,n){return n.codePointSource[n.cursor]===H&&n.codePointSource[n.cursor+1]===i}function checkIfThreeCodePointsWouldStartCDC(e,n){return n.codePointSource[n.cursor]===E&&n.codePointSource[n.cursor+1]===E&&n.codePointSource[n.cursor+2]===f}function consumeComment(n,r){for(r.advanceCodePoint(2);;){const e=r.readCodePoint();if(!1===e){n.onParseError(new ParseError("Unexpected EOF while consuming a comment.",r.representationStart,r.representationEnd,["4.3.2. Consume comments","Unexpected EOF"]));break}if(e===i&&(void 0!==r.codePointSource[r.cursor]&&r.codePointSource[r.cursor]===H)){r.advanceCodePoint();break}}return[e.Comment,r.source.slice(r.representationStart,r.representationEnd+1),r.representationStart,r.representationEnd,void 0]}function consumeEscapedCodePoint(e,n){const r=n.readCodePoint();if(!1===r)return e.onParseError(new ParseError("Unexpected EOF while consuming an escaped code point.",n.representationStart,n.representationEnd,["4.3.7. Consume an escaped code point","Unexpected EOF"])),x;if(isHexDigitCodePoint(r)){const e=[r];for(;void 0!==n.codePointSource[n.cursor]&&isHexDigitCodePoint(n.codePointSource[n.cursor])&&e.length<6;)e.push(n.codePointSource[n.cursor]),n.advanceCodePoint();isWhitespace(n.codePointSource[n.cursor])&&n.advanceCodePoint();const o=parseInt(String.fromCharCode(...e),16);return 0===o?x:(t=o)>=55296&&t<=57343||o>U?x:o}var t;return r}function consumeIdentSequence(e,n){const r=[];for(;;)if(isIdentCodePoint(n.codePointSource[n.cursor]))r.push(n.codePointSource[n.cursor]),n.advanceCodePoint();else{if(!checkIfTwoCodePointsAreAValidEscape(0,n))return r;n.advanceCodePoint(),r.push(consumeEscapedCodePoint(e,n))}}function consumeHashToken(n,t){if(t.advanceCodePoint(),void 0!==t.codePointSource[t.cursor]&&(isIdentCodePoint(t.codePointSource[t.cursor])||checkIfTwoCodePointsAreAValidEscape(0,t))){let o=r.Unrestricted;checkIfThreeCodePointsWouldStartAnIdentSequence(0,t)&&(o=r.ID);const i=consumeIdentSequence(n,t);return[e.Hash,t.source.slice(t.representationStart,t.representationEnd+1),t.representationStart,t.representationEnd,{value:String.fromCharCode(...i),type:o}]}return[e.Delim,"#",t.representationStart,t.representationEnd,{value:"#"}]}function consumeNumber(e,r){let t=n.Integer;for(r.codePointSource[r.cursor]!==q&&r.codePointSource[r.cursor]!==E||r.advanceCodePoint();isDigitCodePoint(r.codePointSource[r.cursor]);)r.advanceCodePoint();if(r.codePointSource[r.cursor]===l&&isDigitCodePoint(r.codePointSource[r.cursor+1]))for(r.advanceCodePoint(2),t=n.Number;isDigitCodePoint(r.codePointSource[r.cursor]);)r.advanceCodePoint();if(r.codePointSource[r.cursor]===v||r.codePointSource[r.cursor]===m){if(isDigitCodePoint(r.codePointSource[r.cursor+1]))r.advanceCodePoint(2);else{if(r.codePointSource[r.cursor+1]!==E&&r.codePointSource[r.cursor+1]!==q||!isDigitCodePoint(r.codePointSource[r.cursor+2]))return t;r.advanceCodePoint(3)}for(t=n.Number;isDigitCodePoint(r.codePointSource[r.cursor]);)r.advanceCodePoint()}return t}function consumeNumericToken(n,r){const t=consumeNumber(0,r),o=parseFloat(r.source.slice(r.representationStart,r.representationEnd+1));if(checkIfThreeCodePointsWouldStartAnIdentSequence(0,r)){const i=consumeIdentSequence(n,r);return[e.Dimension,r.source.slice(r.representationStart,r.representationEnd+1),r.representationStart,r.representationEnd,{value:o,type:t,unit:String.fromCharCode(...i)}]}return r.codePointSource[r.cursor]===y?(r.advanceCodePoint(),[e.Percentage,r.source.slice(r.representationStart,r.representationEnd+1),r.representationStart,r.representationEnd,{value:o}]):[e.Number,r.source.slice(r.representationStart,r.representationEnd+1),r.representationStart,r.representationEnd,{value:o,type:t}]}function consumeWhiteSpace(n,r){for(;isWhitespace(r.codePointSource[r.cursor]);)r.advanceCodePoint();return[e.Whitespace,r.source.slice(r.representationStart,r.representationEnd+1),r.representationStart,r.representationEnd,void 0]}function consumeStringToken(n,r){let t="";const o=r.readCodePoint();for(;;){const i=r.readCodePoint();if(!1===i)return n.onParseError(new ParseError("Unexpected EOF while consuming a string token.",r.representationStart,r.representationEnd,["4.3.5. Consume a string token","Unexpected EOF"])),[e.String,r.source.slice(r.representationStart,r.representationEnd+1),r.representationStart,r.representationEnd,{value:t}];if(isNewLine(i))return n.onParseError(new ParseError("Unexpected newline while consuming a string token.",r.representationStart,r.representationEnd,["4.3.5. Consume a string token","Unexpected newline"])),r.unreadCodePoint(),[e.BadString,r.source.slice(r.representationStart,r.representationEnd+1),r.representationStart,r.representationEnd,void 0];if(i===o)return[e.String,r.source.slice(r.representationStart,r.representationEnd+1),r.representationStart,r.representationEnd,{value:t}];if(i!==N)t+=String.fromCharCode(i);else{if(void 0===r.codePointSource[r.cursor])continue;if(isNewLine(r.codePointSource[r.cursor])){r.advanceCodePoint();continue}t+=String.fromCharCode(consumeEscapedCodePoint(n,r))}}}const K="u".charCodeAt(0),M="U".charCodeAt(0),$="r".charCodeAt(0),J="R".charCodeAt(0),j="l".charCodeAt(0),Q="L".charCodeAt(0);function checkIfCodePointsMatchURLIdent(e,n){return 3===n.length&&((n[0]===K||n[0]===M)&&((n[1]===$||n[1]===J)&&(n[2]===j||n[2]===Q)))}function consumeBadURL(e,n){for(;;){if(void 0===n.codePointSource[n.cursor])return;if(n.codePointSource[n.cursor]===W)return void n.advanceCodePoint();checkIfTwoCodePointsAreAValidEscape(0,n)?(n.advanceCodePoint(),consumeEscapedCodePoint(e,n)):n.advanceCodePoint()}}function consumeUrlToken(n,r){consumeWhiteSpace(0,r);let t="";for(;;){if(void 0===r.codePointSource[r.cursor])return n.onParseError(new ParseError("Unexpected EOF while consuming a url token.",r.representationStart,r.representationEnd,["4.3.6. Consume a url token","Unexpected EOF"])),[e.URL,r.source.slice(r.representationStart,r.representationEnd+1),r.representationStart,r.representationEnd,{value:t}];if(r.codePointSource[r.cursor]===W)return r.advanceCodePoint(),[e.URL,r.source.slice(r.representationStart,r.representationEnd+1),r.representationStart,r.representationEnd,{value:t}];if(isWhitespace(r.codePointSource[r.cursor]))return consumeWhiteSpace(0,r),void 0===r.codePointSource[r.cursor]?(n.onParseError(new ParseError("Unexpected EOF while consuming a url token.",r.representationStart,r.representationEnd,["4.3.6. Consume a url token","Consume as much whitespace as possible","Unexpected EOF"])),[e.URL,r.source.slice(r.representationStart,r.representationEnd+1),r.representationStart,r.representationEnd,{value:t}]):r.codePointSource[r.cursor]===W?(r.advanceCodePoint(),[e.URL,r.source.slice(r.representationStart,r.representationEnd+1),r.representationStart,r.representationEnd,{value:t}]):(consumeBadURL(n,r),[e.BadURL,r.source.slice(r.representationStart,r.representationEnd+1),r.representationStart,r.representationEnd,void 0]);if(r.codePointSource[r.cursor]===R||r.codePointSource[r.cursor]===o||r.codePointSource[r.cursor]===g||((i=r.codePointSource[r.cursor])===w||i===S||D<=i&&i<=c||B<=i&&i<=h))return consumeBadURL(n,r),n.onParseError(new ParseError("Unexpected character while consuming a url token.",r.representationStart,r.representationEnd,["4.3.6. Consume a url token","Unexpected U+0022 QUOTATION MARK (\"), U+0027 APOSTROPHE ('), U+0028 LEFT PARENTHESIS (() or non-printable code point"])),[e.BadURL,r.source.slice(r.representationStart,r.representationEnd+1),r.representationStart,r.representationEnd,void 0];if(r.codePointSource[r.cursor]===N){if(checkIfTwoCodePointsAreAValidEscape(0,r)){r.advanceCodePoint(),t+=String.fromCharCode(consumeEscapedCodePoint(n,r));continue}return consumeBadURL(n,r),n.onParseError(new ParseError("Invalid escape sequence while consuming a url token.",r.representationStart,r.representationEnd,["4.3.6. Consume a url token","U+005C REVERSE SOLIDUS (\\)","The input stream does not start with a valid escape sequence"])),[e.BadURL,r.source.slice(r.representationStart,r.representationEnd+1),r.representationStart,r.representationEnd,void 0]}t+=String.fromCharCode(r.codePointSource[r.cursor]),r.advanceCodePoint()}var i}function consumeIdentLikeToken(n,r){const t=consumeIdentSequence(n,r);if(r.codePointSource[r.cursor]!==g)return[e.Ident,r.source.slice(r.representationStart,r.representationEnd+1),r.representationStart,r.representationEnd,{value:String.fromCharCode(...t)}];if(checkIfCodePointsMatchURLIdent(0,t)){r.advanceCodePoint();let i=0;for(;;){const n=isWhitespace(r.codePointSource[r.cursor]),c=isWhitespace(r.codePointSource[r.cursor+1]);if(n&&c){i+=1,r.advanceCodePoint(1);continue}const s=n?r.codePointSource[r.cursor+1]:r.codePointSource[r.cursor];if(s===R||s===o)return i>0&&r.unreadCodePoint(i),[e.Function,r.source.slice(r.representationStart,r.representationEnd+1),r.representationStart,r.representationEnd,{value:String.fromCharCode(...t)}];break}return consumeUrlToken(n,r)}return r.advanceCodePoint(),[e.Function,r.source.slice(r.representationStart,r.representationEnd+1),r.representationStart,r.representationEnd,{value:String.fromCharCode(...t)}]}function tokenize(e,n){const r=tokenizer(e,n),t=[];{for(;!r.endOfFile();){const e=r.nextToken();e&&t.push(e)}const e=r.nextToken();e&&t.push(e)}return t}function tokenizer(n,r){const t=n.css.valueOf(),i=new Reader(t),c={onParseError:(null==r?void 0:r.onParseError)??(()=>{})};return{nextToken:function nextToken(){if(i.representationStart=i.cursor,i.representationEnd=-1,checkIfTwoCodePointsStartAComment(0,i))return consumeComment(c,i);const n=i.codePointSource[i.cursor];if(void 0===n)return[e.EOF,"",-1,-1,void 0];if(isIdentStartCodePoint(n))return consumeIdentLikeToken(c,i);if(isDigitCodePoint(n))return consumeNumericToken(c,i);switch(n){case d:return i.advanceCodePoint(),[e.Comma,",",i.representationStart,i.representationEnd,void 0];case u:return i.advanceCodePoint(),[e.Colon,":",i.representationStart,i.representationEnd,void 0];case V:return i.advanceCodePoint(),[e.Semicolon,";",i.representationStart,i.representationEnd,void 0];case g:return i.advanceCodePoint(),[e.OpenParen,"(",i.representationStart,i.representationEnd,void 0];case W:return i.advanceCodePoint(),[e.CloseParen,")",i.representationStart,i.representationEnd,void 0];case I:return i.advanceCodePoint(),[e.OpenSquare,"[",i.representationStart,i.representationEnd,void 0];case F:return i.advanceCodePoint(),[e.CloseSquare,"]",i.representationStart,i.representationEnd,void 0];case k:return i.advanceCodePoint(),[e.OpenCurly,"{",i.representationStart,i.representationEnd,void 0];case b:return i.advanceCodePoint(),[e.CloseCurly,"}",i.representationStart,i.representationEnd,void 0];case o:case R:return consumeStringToken(c,i);case L:return consumeHashToken(c,i);case q:case l:return checkIfThreeCodePointsWouldStartANumber(0,i)?consumeNumericToken(c,i):(i.advanceCodePoint(),[e.Delim,i.source[i.representationStart],i.representationStart,i.representationEnd,{value:i.source[i.representationStart]}]);case O:case s:case C:case a:case z:return consumeWhiteSpace(0,i);case E:return checkIfThreeCodePointsWouldStartANumber(0,i)?consumeNumericToken(c,i):checkIfThreeCodePointsWouldStartCDC(0,i)?(i.advanceCodePoint(3),[e.CDC,"--\x3e",i.representationStart,i.representationEnd,void 0]):checkIfThreeCodePointsWouldStartAnIdentSequence(0,i)?consumeIdentLikeToken(c,i):(i.advanceCodePoint(),[e.Delim,"-",i.representationStart,i.representationEnd,{value:"-"}]);case T:return checkIfFourCodePointsWouldStartCDO(0,i)?(i.advanceCodePoint(4),[e.CDO,"\x3c!--",i.representationStart,i.representationEnd,void 0]):(i.advanceCodePoint(),[e.Delim,"<",i.representationStart,i.representationEnd,{value:"<"}]);case p:if(i.advanceCodePoint(),checkIfThreeCodePointsWouldStartAnIdentSequence(0,i)){const n=consumeIdentSequence(c,i);return[e.AtKeyword,i.source.slice(i.representationStart,i.representationEnd+1),i.representationStart,i.representationEnd,{value:String.fromCharCode(...n)}]}return[e.Delim,"@",i.representationStart,i.representationEnd,{value:"@"}];case N:return checkIfTwoCodePointsAreAValidEscape(0,i)?consumeIdentLikeToken(c,i):(i.advanceCodePoint(),c.onParseError(new ParseError('Invalid escape sequence after "\\"',i.representationStart,i.representationEnd,["4.3.1. Consume a token","U+005C REVERSE SOLIDUS (\\)","The input stream does not start with a valid escape sequence"])),[e.Delim,"\\",i.representationStart,i.representationEnd,{value:"\\"}])}return i.advanceCodePoint(),[e.Delim,i.source[i.representationStart],i.representationStart,i.representationEnd,{value:i.source[i.representationStart]}]},endOfFile:function endOfFile(){return void 0===i.codePointSource[i.cursor]}}}function cloneTokens(e){return"undefined"!=typeof globalThis&&"structuredClone"in globalThis?structuredClone(e):JSON.parse(JSON.stringify(e))}function mutateIdent(e,n){let r="";const t=new Array(n.length);for(let e=0;e<n.length;e++)t[e]=n.charCodeAt(e);let o=0;t[0]===E&&t[1]===E?(r="--",o=2):t[0]===E&&t[1]?(r="-",o=2,isIdentStartCodePoint(t[1])?r+=n[1]:r+=`\\${t[1].toString(16)} `):isIdentStartCodePoint(t[0])?(r=n[0],o=1):(r=`\\${t[0].toString(16)} `,o=1);for(let e=o;e<t.length;e++)isIdentCodePoint(t[e])?r+=n[e]:r+=`\\${t[e].toString(16)} `;e[1]=r,e[4].value=n}export{n as NumberType,ParseError,Reader,e as TokenType,cloneTokens,isToken,mirrorVariant,mirrorVariantType,mutateIdent,stringify,tokenize,tokenizer};
