/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.contributions.libraries;

import cc.arduino.Constants;
import cc.arduino.contributions.libraries.ContributedLibrary;
import cc.arduino.contributions.libraries.LibrariesIndex;
import cc.arduino.contributions.packages.ContributedPlatform;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.compress.utils.IOUtils;
import processing.app.BaseNoGui;
import processing.app.I18n;
import processing.app.helpers.filefilters.OnlyDirs;
import processing.app.packages.LegacyUserLibrary;
import processing.app.packages.LibraryList;
import processing.app.packages.UserLibrary;
import processing.app.packages.UserLibraryFolder;
import processing.app.packages.UserLibraryPriorityComparator;

public class LibrariesIndexer {
    private LibrariesIndex index;
    private final LibraryList installedLibraries = new LibraryList();
    private List<UserLibraryFolder> librariesFolders;
    private final File indexFile;
    private final File stagingFolder;
    private final List<String> badLibNotified = new ArrayList<String>();
    private UserLibraryPriorityComparator priorityComparator = new UserLibraryPriorityComparator(null);

    public LibrariesIndexer(File preferencesFolder) {
        this.indexFile = new File(preferencesFolder, "library_index.json");
        this.stagingFolder = new File(new File(preferencesFolder, "staging"), "libraries");
    }

    public void parseIndex() throws IOException {
        this.index = new LibrariesIndex();
        if (!this.indexFile.exists()) {
            return;
        }
        this.parseIndex(this.indexFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void parseIndex(File file) throws IOException {
        FileInputStream indexIn = null;
        try {
            indexIn = new FileInputStream(file);
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
            mapper.configure(DeserializationFeature.EAGER_DESERIALIZER_FETCH, true);
            mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            LibrariesIndex newIndex = (LibrariesIndex)mapper.readValue((InputStream)indexIn, LibrariesIndex.class);
            newIndex.getLibraries().stream().filter(library -> library.getCategory() == null || "".equals(library.getCategory()) || !Constants.LIBRARY_CATEGORIES.contains(library.getCategory())).forEach(library -> library.setCategory("Uncategorized"));
            this.index = newIndex;
        }
        catch (JsonParseException | JsonMappingException e) {
            System.err.println(I18n.format(I18n.tr("Error parsing libraries index: {0}\nTry to open the Library Manager to update the libraries index."), e.getMessage()));
            IOUtils.closeQuietly((Closeable)indexIn);
        }
        catch (Exception e2) {
            System.err.println(I18n.format(I18n.tr("Error reading libraries index: {0}"), e2.getMessage()));
            {
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(indexIn);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((Closeable)indexIn);
        }
        IOUtils.closeQuietly((Closeable)indexIn);
    }

    public void setLibrariesFolders(List<UserLibraryFolder> folders) {
        this.librariesFolders = folders;
    }

    public void setLibrariesFoldersAndRescan(List<UserLibraryFolder> folders) {
        this.setLibrariesFolders(folders);
        this.rescanLibraries();
    }

    public List<UserLibraryFolder> getLibrariesFolders() {
        return this.librariesFolders;
    }

    public void addToInstalledLibraries(UserLibrary lib) {
        UserLibrary toReplace = this.installedLibraries.getByName(lib.getName());
        if (toReplace == null) {
            this.installedLibraries.add(lib);
            return;
        }
        if (this.priorityComparator.compare(toReplace, lib) >= 0) {
            return;
        }
        this.installedLibraries.remove(toReplace);
        this.installedLibraries.add(lib);
    }

    public void setArchitecturePriority(String arch) {
        this.priorityComparator = new UserLibraryPriorityComparator(arch);
    }

    public void rescanLibraries() {
        this.installedLibraries.clear();
        if (this.index.getLibraries() == null) {
            return;
        }
        for (ContributedLibrary lib : this.index.getLibraries()) {
            lib.unsetInstalledUserLibrary();
        }
        for (UserLibraryFolder folderDesc : this.librariesFolders) {
            this.scanInstalledLibraries(folderDesc);
        }
        this.installedLibraries.stream().filter(l -> l.getTypes().contains("Contributed")).filter(l -> l.getLocation() == UserLibraryFolder.Location.CORE || l.getLocation() == UserLibraryFolder.Location.REFERENCED_CORE).forEach(l -> {
            File libFolder = l.getInstalledFolder();
            Optional<ContributedPlatform> platform = BaseNoGui.indexer.getPlatformByFolder(libFolder);
            if (platform.isPresent()) {
                l.setTypes(Collections.singletonList(platform.get().getCategory()));
            }
        });
    }

    private void scanInstalledLibraries(UserLibraryFolder folderDesc) {
        File[] list = folderDesc.folder.listFiles(OnlyDirs.ONLY_DIRS);
        if (list == null) {
            return;
        }
        for (File subfolder : list) {
            String subfolderName = subfolder.getName();
            if (!BaseNoGui.isSanitaryName(subfolderName)) {
                if (this.badLibNotified.contains(subfolderName)) continue;
                this.badLibNotified.add(subfolderName);
                String mess = I18n.format(I18n.tr("The library \"{0}\" cannot be used.\nLibrary folder names must start with a letter or number, followed by letters,\nnumbers, dashes, dots and underscores. Maximum length is 63 characters."), subfolderName);
                BaseNoGui.showMessage(I18n.tr("Ignoring library with bad name"), mess);
                continue;
            }
            try {
                this.scanLibrary(new UserLibraryFolder(subfolder, folderDesc.location));
            }
            catch (IOException e) {
                System.out.println(I18n.format(I18n.tr("Invalid library found in {0}: {1}"), subfolder, e.getMessage()));
            }
        }
    }

    private void scanLibrary(UserLibraryFolder folderDesc) throws IOException {
        ContributedLibrary foundLib;
        File check = new File(folderDesc.folder, "library.properties");
        if (!check.exists() || !check.isFile()) {
            LegacyUserLibrary lib = LegacyUserLibrary.create(folderDesc);
            String[] headers = BaseNoGui.headerListFromIncludePath(lib.getSrcFolder());
            if (headers.length == 0) {
                throw new IOException(I18n.format(I18n.tr("no headers files (.h) found in {0}"), lib.getSrcFolder()));
            }
            this.addToInstalledLibraries(lib);
            return;
        }
        UserLibrary lib = UserLibrary.create(folderDesc);
        String[] headers = BaseNoGui.headerListFromIncludePath(lib.getSrcFolder());
        if (headers.length == 0) {
            throw new IOException(I18n.format(I18n.tr("no headers files (.h) found in {0}"), lib.getSrcFolder()));
        }
        this.addToInstalledLibraries(lib);
        UserLibraryFolder.Location loc = lib.getLocation();
        if (loc != UserLibraryFolder.Location.CORE && loc != UserLibraryFolder.Location.REFERENCED_CORE && (foundLib = this.index.find(lib.getName(), lib.getVersion())) != null) {
            foundLib.setInstalledUserLibrary(lib);
            lib.setTypes(foundLib.getTypes());
        }
        if (lib.getTypes().isEmpty() && loc == UserLibraryFolder.Location.SKETCHBOOK) {
            lib.setTypes(lib.getDeclaredTypes());
        }
        if (lib.getTypes().isEmpty()) {
            lib.setTypes(Collections.singletonList("Contributed"));
        }
    }

    public LibrariesIndex getIndex() {
        return this.index;
    }

    public LibraryList getInstalledLibraries() {
        return new LibraryList(this.installedLibraries);
    }

    public File getStagingFolder() {
        return this.stagingFolder;
    }

    public File getIndexFile() {
        return this.indexFile;
    }
}

