/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.srtm;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.JOptionPane;
import tim.prune.App;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.UpdateMessageBroker;
import tim.prune.data.Altitude;
import tim.prune.data.DataPoint;
import tim.prune.data.Field;
import tim.prune.data.Track;
import tim.prune.data.UnitSetLibrary;
import tim.prune.function.srtm.Interpolator;
import tim.prune.function.srtm.SrtmAuthException;
import tim.prune.function.srtm.SrtmHighResSource;
import tim.prune.function.srtm.SrtmLowResSource;
import tim.prune.function.srtm.SrtmSource;
import tim.prune.function.srtm.SrtmTile;
import tim.prune.gui.ProgressDialog;
import tim.prune.undo.UndoLookupSrtm;

public class LookupSrtmFunction
extends GenericFunction
implements Runnable {
    private ProgressDialog _progress = null;
    private Track _track = null;
    private boolean _normalTrack = true;
    private boolean _hadToDownload = false;
    private int _numCached = 0;
    private boolean _running = false;

    public LookupSrtmFunction(App app) {
        super(app);
    }

    @Override
    public String getNameKey() {
        return "function.lookupsrtm";
    }

    @Override
    public void begin() {
        this.begin(this._app.getTrackInfo().getTrack(), true);
    }

    public void begin(Track track) {
        this.begin(track, false);
    }

    private void begin(Track track, boolean bl) {
        this._running = true;
        this._hadToDownload = false;
        if (this._progress == null) {
            this._progress = new ProgressDialog(this._parentFrame, this.getNameKey());
        }
        this._progress.show();
        this._track = track;
        this._normalTrack = bl;
        new Thread(this).start();
    }

    @Override
    public void run() {
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        while (n < this._track.getNumPoints()) {
            if (this._track.getPoint(n).hasAltitude()) {
                if (this._track.getPoint(n).getAltitude().getValue() == 0) {
                    bl = true;
                } else {
                    bl2 = true;
                }
            }
            n += 1;
        }
        int n2 = n = bl && !bl2 ? 1 : 0;
        if (bl2 && bl && JOptionPane.showConfirmDialog(this._parentFrame, I18nManager.getText("dialog.lookupsrtm.overwritezeros"), I18nManager.getText(this.getNameKey()), 0) == 0) {
            n = 1;
        }
        HashSet<SrtmTile> hashSet = new HashSet<SrtmTile>();
        int n3 = 0;
        while (n3 < this._track.getNumPoints()) {
            if (!this._track.getPoint(n3).hasAltitude() || n && this._track.getPoint(n3).getAltitude().getValue() == 0) {
                hashSet.add(new SrtmTile(this._track.getPoint(n3)));
            }
            ++n3;
        }
        CookieHandler cookieHandler = CookieHandler.getDefault();
        CookieHandler.setDefault(new CookieManager(null, CookiePolicy.ACCEPT_ALL));
        this.lookupValues(hashSet, n != 0);
        CookieHandler.setDefault(cookieHandler);
        this._running = false;
        if (this._hadToDownload) {
            this._app.showTip(2);
        } else if (this._numCached > 0) {
            this.showConfirmMessage(this._numCached);
        }
    }

    private void lookupValues(HashSet<SrtmTile> hashSet, boolean bl) {
        UndoLookupSrtm undoLookupSrtm = new UndoLookupSrtm(this._app.getTrackInfo());
        int n = 0;
        SrtmSource[] srtmSourceArray = new SrtmSource[]{new SrtmHighResSource(), new SrtmLowResSource()};
        String string = null;
        int n2 = hashSet.size();
        if (this._progress != null) {
            this._progress.setMaximum(n2);
            this._progress.setValue(0);
        }
        int n3 = 0;
        this._numCached = 0;
        for (SrtmTile srtmTile : hashSet) {
            this._progress.setValue(n3++);
            int[] nArray = null;
            SrtmSource[] srtmSourceArray2 = srtmSourceArray;
            int n4 = srtmSourceArray.length;
            int n5 = 0;
            while (n5 < n4) {
                SrtmSource srtmSource = srtmSourceArray2[n5];
                if (nArray == null) {
                    try {
                        nArray = this.getHeightsForTile(srtmTile, srtmSource);
                        n += this.applySrtmTileToWholeTrack(srtmTile, nArray, bl, srtmSource.getTilePixels());
                    }
                    catch (IOException iOException) {
                        string = String.valueOf(iOException.getClass().getName()) + " - " + iOException.getMessage();
                    }
                    catch (SrtmAuthException srtmAuthException) {
                        string = String.valueOf(I18nManager.getText("error.srtm.authenticationfailed")) + " - " + srtmAuthException.getMessage();
                    }
                }
                ++n5;
            }
        }
        this._progress.dispose();
        if (this._progress.isCancelled()) {
            return;
        }
        if (string != null) {
            this._app.showErrorMessageNoLookup(this.getNameKey(), string);
        }
        if (n > 0) {
            this._track.requestRescale();
            UpdateMessageBroker.informSubscribers((byte)1);
            if (this._normalTrack) {
                this._app.completeFunction(undoLookupSrtm, I18nManager.getTextWithNumber("confirm.lookupsrtm", n));
            }
        } else if (n2 > 0) {
            this._app.showErrorMessage(this.getNameKey(), "error.lookupsrtm.nonefound");
        } else {
            this._app.showErrorMessage(this.getNameKey(), "error.lookupsrtm.nonerequired");
        }
    }

    private int[] getHeightsForTile(SrtmTile srtmTile, SrtmSource srtmSource) throws IOException, SrtmAuthException {
        int[] nArray = null;
        ZipInputStream zipInputStream = this.getStreamToSrtmData(srtmTile, srtmSource);
        boolean bl = false;
        if (zipInputStream != null) {
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            boolean bl2 = bl = zipEntry != null && zipEntry.getSize() == srtmSource.getTileSizeBytes();
            if (bl) {
                int n = srtmSource.getTilePixels() * srtmSource.getTilePixels();
                nArray = new int[n];
                int n2 = 0;
                while (n2 < n) {
                    nArray[n2] = zipInputStream.read() * 256 + zipInputStream.read();
                    if (nArray[n2] >= 32768) {
                        int n3 = n2;
                        nArray[n3] = nArray[n3] - 65536;
                    }
                    ++n2;
                }
            }
            zipInputStream.close();
        }
        if (!bl) {
            nArray = null;
        }
        return nArray;
    }

    private ZipInputStream getStreamToSrtmData(SrtmTile srtmTile, SrtmSource srtmSource) throws IOException, SrtmAuthException {
        ZipInputStream zipInputStream = null;
        try {
            zipInputStream = this.getStreamToLocalHgtFile(srtmSource.getCacheDir(), srtmSource.getFilename(srtmTile));
        }
        catch (IOException iOException) {
            zipInputStream = null;
        }
        if (zipInputStream != null) {
            return zipInputStream;
        }
        SrtmSource.Result result = srtmSource.downloadTile(srtmTile);
        if (result == SrtmSource.Result.DOWNLOADED) {
            ++this._numCached;
            return this.getStreamToLocalHgtFile(srtmSource.getCacheDir(), srtmSource.getFilename(srtmTile));
        }
        if (result == SrtmSource.Result.NOT_ENABLED) {
            return null;
        }
        if (result != SrtmSource.Result.DOWNLOAD_FAILED) {
            this._hadToDownload = true;
            URL uRL = srtmSource.getUrl(srtmTile);
            if (uRL == null) {
                return null;
            }
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setRequestProperty("User-Agent", "GpsPrune v22.2");
            return new ZipInputStream(uRLConnection.getInputStream());
        }
        return null;
    }

    private ZipInputStream getStreamToLocalHgtFile(File file, String string) throws IOException {
        File file2;
        if (file != null && file.exists() && file.isDirectory() && file.canRead() && (file2 = new File(file, string)).exists() && file2.isFile() && file2.canRead() && file2.length() > 400L) {
            return new ZipInputStream(new FileInputStream(file2));
        }
        return null;
    }

    private int applySrtmTileToWholeTrack(SrtmTile srtmTile, int[] nArray, boolean bl, int n) {
        if (nArray == null) {
            return 0;
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < this._track.getNumPoints()) {
            double d;
            boolean bl2;
            DataPoint dataPoint = this._track.getPoint(n3);
            boolean bl3 = bl2 = !dataPoint.hasAltitude() || bl && dataPoint.getAltitude().getValue() == 0;
            if (bl2 && srtmTile.contains(dataPoint) && (d = Interpolator.calculateAltitude(dataPoint.getLongitude().getDouble(), dataPoint.getLatitude().getDouble(), nArray, this._normalTrack, n)) != -32768.0) {
                dataPoint.setFieldValue(Field.ALTITUDE, "" + d, false);
                dataPoint.getAltitude().reset(new Altitude((int)d, UnitSetLibrary.UNITS_METRES));
                ++n2;
            }
            ++n3;
        }
        return n2;
    }

    public boolean isRunning() {
        return this._running;
    }

    private void showConfirmMessage(int n) {
        if (n == 1) {
            JOptionPane.showMessageDialog(this._parentFrame, I18nManager.getTextWithNumber("confirm.downloadsrtm.1", n), I18nManager.getText(this.getNameKey()), 1);
        } else if (n > 1) {
            JOptionPane.showMessageDialog(this._parentFrame, I18nManager.getTextWithNumber("confirm.downloadsrtm", n), I18nManager.getText(this.getNameKey()), 1);
        }
    }
}

