/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.protobuf;

import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import org.openstreetmap.josm.data.protobuf.ProtobufParser;

public class ProtobufPacked {
    private final byte[] bytes;
    private final Number[] numbers;
    private int location = 0;

    public ProtobufPacked(byte[] bytes) {
        this.bytes = bytes;
        ArrayList<Number> numbersT = new ArrayList<Number>();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4);
        while (this.location < bytes.length) {
            numbersT.add(ProtobufParser.convertByteArray(this.nextVarInt(byteArrayOutputStream), (byte)7));
            byteArrayOutputStream.reset();
        }
        this.numbers = new Number[numbersT.size()];
        for (int i = 0; i < numbersT.size(); ++i) {
            this.numbers[i] = (Number)numbersT.get(i);
        }
    }

    public Number[] getArray() {
        return this.numbers;
    }

    private byte[] nextVarInt(ByteArrayOutputStream byteArrayOutputStream) {
        while ((this.bytes[this.location] & 0xFFFFFF80) == -128) {
            byteArrayOutputStream.write(this.bytes[this.location++] ^ 0xFFFFFF80);
        }
        byteArrayOutputStream.write(this.bytes[this.location++]);
        return byteArrayOutputStream.toByteArray();
    }
}

