/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.offroad.ui;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.util.List;
import net.osmand.PlatformUtil;
import net.osmand.data.LatLon;
import net.osmand.data.RotatedTileBox;
import net.osmand.plus.render.OsmandRenderer;
import net.osmand.plus.views.OsmandMapLayer;
import net.sourceforge.offroad.R;
import net.sourceforge.offroad.actions.DirectSearchAction;
import net.sourceforge.offroad.ui.OsmBitmapPanel;
import net.sourceforge.offroad.ui.Paint;
import org.apache.commons.logging.Log;

public class DirectSearchLayer
extends OsmandMapLayer
implements DirectSearchAction.DirectSearchReceiver {
    protected OsmBitmapPanel mView;
    protected Paint highlightYellow;
    protected DirectSearchAction.ISearchProvider mProvider;
    protected static final Log log = PlatformUtil.getLog(DirectSearchLayer.class);

    @Override
    public void initLayer(OsmBitmapPanel pView) {
        this.mView = pView;
        this.highlightYellow = new Paint();
        this.highlightYellow.setColor(R.color.poi_background);
        this.highlightYellow.setStyle(Paint.Style.STROKE);
        this.highlightYellow.setStrokeWidth(7.0f);
        this.highlightYellow.setAntiAlias(true);
    }

    @Override
    public void onDraw(Graphics2D pCanvas, RotatedTileBox pTileBox, OsmandMapLayer.DrawSettings pSettings) {
        if (this.mProvider == null || !this.mProvider.isValid()) {
            return;
        }
        List<OsmBitmapPanel.CalculateUnzoomedPicturesAction.ImageStorage> list = this.mView.getEffectivelyDrawnImages();
        int index = 0;
        for (OsmBitmapPanel.CalculateUnzoomedPicturesAction.ImageStorage imageStorage : list) {
            RotatedTileBox ctb = pTileBox.copy();
            RotatedTileBox rtb = imageStorage.mTileBox;
            if (ctb.getZoom() != rtb.getZoom()) continue;
            Graphics2D g2 = this.mView.createGraphics(pCanvas);
            this.highlightYellow.updateGraphics(g2);
            LatLon rtbLT = rtb.getLeftTopLatLon();
            LatLon rtbRB = rtb.getRightBottomLatLon();
            LatLon clalo = rtb.getCenterLatLon();
            double xc = ctb.getPixXFromLatLon(clalo.getLatitude(), clalo.getLongitude());
            double yc = ctb.getPixYFromLatLon(clalo.getLatitude(), clalo.getLongitude());
            float ctbRotate = ctb.getRotate();
            float theta = ctbRotate - rtb.getRotate();
            ctb.setRotate(rtb.getRotate());
            double x1 = ctb.getPixXFromLatLon(rtbLT.getLatitude(), rtbLT.getLongitude());
            double y1 = ctb.getPixYFromLatLon(rtbLT.getLatitude(), rtbLT.getLongitude());
            double x2 = ctb.getPixXFromLatLon(rtbRB.getLatitude(), rtbRB.getLongitude());
            double y2 = ctb.getPixYFromLatLon(rtbRB.getLatitude(), rtbRB.getLongitude());
            double thetaR = Math.toRadians(theta);
            g2.rotate(thetaR, xc, yc);
            AffineTransform t = new AffineTransform();
            double sx = (x2 - x1) / (double)imageStorage.mImage.getWidth();
            double sy = (y2 - y1) / (double)imageStorage.mImage.getHeight();
            t.translate(x1, y1);
            t.scale(sx, sy);
            g2.transform(t);
            for (OsmandRenderer.TextInfo to : imageStorage.mResult.effectiveTextObjects) {
                if (to.mText == null || !this.mProvider.matches(to.mText)) continue;
                if (++index > 10000) {
                    log.warn((Object)"Too many search results found. Rest skipped");
                    break;
                }
                g2.fill(to.path);
                g2.draw(to.path);
            }
            g2.dispose();
            ctb.setRotate(ctbRotate);
        }
    }

    @Override
    public void destroyLayer() {
    }

    @Override
    public boolean drawInScreenPixels() {
        return true;
    }

    @Override
    public void setSearchProvider(DirectSearchAction.ISearchProvider pProvider) {
        this.mProvider = pProvider;
    }
}

