//
// Copyright (c) ZeroC, Inc. All rights reserved.
//
//
// Ice version 3.7.9
//
// <auto-generated>
//
// Generated from file `Session.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

#ifndef __Glacier2_Session_h__
#define __Glacier2_Session_h__

#include <IceUtil/PushDisableWarnings.h>
#include <Ice/ProxyF.h>
#include <Ice/ObjectF.h>
#include <Ice/ValueF.h>
#include <Ice/Exception.h>
#include <Ice/LocalObject.h>
#include <Ice/StreamHelpers.h>
#include <Ice/Comparable.h>
#include <Ice/Proxy.h>
#include <Ice/Object.h>
#include <Ice/GCObject.h>
#include <Ice/Value.h>
#include <Ice/Incoming.h>
#include <Ice/FactoryTableInit.h>
#include <IceUtil/ScopedArray.h>
#include <Ice/Optional.h>
#include <Ice/ExceptionHelpers.h>
#include <Ice/SlicedDataF.h>
#include <Ice/BuiltinSequences.h>
#include <Ice/Identity.h>
#include <Glacier2/SSLInfo.h>
#include <IceUtil/UndefSysMacros.h>
#include <Glacier2/Config.h>

#ifndef ICE_IGNORE_VERSION
#   if ICE_INT_VERSION / 100 != 307
#       error Ice version mismatch!
#   endif
#   if ICE_INT_VERSION % 100 >= 50
#       error Beta header file detected
#   endif
#   if ICE_INT_VERSION % 100 < 9
#       error Ice patch level mismatch!
#   endif
#endif

#ifndef GLACIER2_API
#   if defined(ICE_STATIC_LIBS)
#       define GLACIER2_API /**/
#   elif defined(GLACIER2_API_EXPORTS)
#       define GLACIER2_API ICE_DECLSPEC_EXPORT
#   else
#       define GLACIER2_API ICE_DECLSPEC_IMPORT
#   endif
#endif

#ifdef ICE_CPP11_MAPPING // C++11 mapping

namespace Glacier2
{

class Session;
class SessionPrx;
class StringSet;
class StringSetPrx;
class IdentitySet;
class IdentitySetPrx;
class SessionControl;
class SessionControlPrx;
class SessionManager;
class SessionManagerPrx;
class SSLSessionManager;
class SSLSessionManagerPrx;

}

namespace Glacier2
{

/**
 * This exception is raised if an attempt to create a new session failed.
 * \headerfile Glacier2/Glacier2.h
 */
class ICE_CLASS(GLACIER2_API) CannotCreateSessionException : public ::Ice::UserExceptionHelper<CannotCreateSessionException, ::Ice::UserException>
{
public:

    ICE_MEMBER(GLACIER2_API) virtual ~CannotCreateSessionException();

    CannotCreateSessionException(const CannotCreateSessionException&) = default;

    CannotCreateSessionException() = default;

    /**
     * One-shot constructor to initialize all data members.
     * @param reason The reason why session creation has failed.
     */
    CannotCreateSessionException(const ::std::string& reason) :
        reason(reason)
    {
    }

    /**
     * Obtains a tuple containing all of the exception's data members.
     * @return The data members in a tuple.
     */
    std::tuple<const ::std::string&> ice_tuple() const
    {
        return std::tie(reason);
    }

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    ICE_MEMBER(GLACIER2_API) static const ::std::string& ice_staticId();

    /**
     * The reason why session creation has failed.
     */
    ::std::string reason;

    /**
     * Obtains the SlicedData object created when an unknown exception type was marshaled
     * in the sliced format and the Ice run time sliced it to a known type.
     * @return The SlicedData object, or nil if the exception was not sliced or was not
     * marshaled in the sliced format.
     */
    ICE_MEMBER(GLACIER2_API) virtual ::std::shared_ptr<::Ice::SlicedData> ice_getSlicedData() const override;

    /// \cond STREAM
    ICE_MEMBER(GLACIER2_API) virtual void _write(::Ice::OutputStream*) const override;
    ICE_MEMBER(GLACIER2_API) virtual void _read(::Ice::InputStream*) override;

    ::std::shared_ptr<::Ice::SlicedData> _slicedData;
    /// \endcond
};

/// \cond INTERNAL
static CannotCreateSessionException _iceS_CannotCreateSessionException_init;
/// \endcond

}

namespace Glacier2
{

/**
 * A client-visible session object, which is tied to the lifecycle of a {@link Router}.
 * @see Router
 * @see SessionManager
 * \headerfile Glacier2/Glacier2.h
 */
class GLACIER2_API Session : public virtual ::Ice::Object
{
public:

    using ProxyType = SessionPrx;

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(::std::string id, const ::Ice::Current& current) const override;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector<::std::string> ice_ids(const ::Ice::Current& current) const override;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual ::std::string ice_id(const ::Ice::Current& current) const override;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Destroy the session. This is called automatically when the router is destroyed.
     * @param current The Current object for the invocation.
     */
    virtual void destroy(const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_destroy(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&) override;
    /// \endcond
};

/**
 * An object for managing the set of identity constraints for specific
 * parts of object identity on a
 * {@link Session}.
 * @see Session
 * @see SessionControl
 * \headerfile Glacier2/Glacier2.h
 */
class GLACIER2_API StringSet : public virtual ::Ice::Object
{
public:

    using ProxyType = StringSetPrx;

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(::std::string id, const ::Ice::Current& current) const override;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector<::std::string> ice_ids(const ::Ice::Current& current) const override;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual ::std::string ice_id(const ::Ice::Current& current) const override;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Add a sequence of strings to this set of constraints. Order is
     * not preserved and duplicates are implicitly removed.
     * @param additions The sequence of strings to be added.
     * @param current The Current object for the invocation.
     */
    virtual void add(::Ice::StringSeq additions, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_add(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Remove a sequence of strings from this set of constraints. No
     * errors are returned if an entry is not found.
     * @param deletions The sequence of strings to be removed.
     * @param current The Current object for the invocation.
     */
    virtual void remove(::Ice::StringSeq deletions, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_remove(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Returns a sequence of strings describing the constraints in this
     * set.
     * @param current The Current object for the invocation.
     * @return The sequence of strings for this set.
     */
    virtual ::Ice::StringSeq get(const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_get(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&) override;
    /// \endcond
};

/**
 * An object for managing the set of object identity constraints on a
 * {@link Session}.
 * @see Session
 * @see SessionControl
 * \headerfile Glacier2/Glacier2.h
 */
class GLACIER2_API IdentitySet : public virtual ::Ice::Object
{
public:

    using ProxyType = IdentitySetPrx;

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(::std::string id, const ::Ice::Current& current) const override;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector<::std::string> ice_ids(const ::Ice::Current& current) const override;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual ::std::string ice_id(const ::Ice::Current& current) const override;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Add a sequence of Ice identities to this set of constraints. Order is
     * not preserved and duplicates are implicitly removed.
     * @param additions The sequence of Ice identities to be added.
     * @param current The Current object for the invocation.
     */
    virtual void add(::Ice::IdentitySeq additions, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_add(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Remove a sequence of identities from this set of constraints. No
     * errors are returned if an entry is not found.
     * @param deletions The sequence of Ice identities to be removed.
     * @param current The Current object for the invocation.
     */
    virtual void remove(::Ice::IdentitySeq deletions, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_remove(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Returns a sequence of identities describing the constraints in this
     * set.
     * @param current The Current object for the invocation.
     * @return The sequence of Ice identities for this set.
     */
    virtual ::Ice::IdentitySeq get(const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_get(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&) override;
    /// \endcond
};

/**
 * An administrative session control object, which is tied to the
 * lifecycle of a {@link Session}.
 * @see Session
 * \headerfile Glacier2/Glacier2.h
 */
class GLACIER2_API SessionControl : public virtual ::Ice::Object
{
public:

    using ProxyType = SessionControlPrx;

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(::std::string id, const ::Ice::Current& current) const override;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector<::std::string> ice_ids(const ::Ice::Current& current) const override;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual ::std::string ice_id(const ::Ice::Current& current) const override;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Access the object that manages the allowable categories
     * for object identities for this session.
     * @param current The Current object for the invocation.
     * @return A StringSet object.
     */
    virtual ::std::shared_ptr<StringSetPrx> categories(const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_categories(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Access the object that manages the allowable adapter identities
     * for objects for this session.
     * @param current The Current object for the invocation.
     * @return A StringSet object.
     */
    virtual ::std::shared_ptr<StringSetPrx> adapterIds(const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_adapterIds(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Access the object that manages the allowable object identities
     * for this session.
     * @param current The Current object for the invocation.
     * @return An IdentitySet object.
     */
    virtual ::std::shared_ptr<IdentitySetPrx> identities(const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_identities(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Get the session timeout.
     * @param current The Current object for the invocation.
     * @return The timeout.
     */
    virtual int getSessionTimeout(const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_getSessionTimeout(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Destroy the associated session.
     * @param current The Current object for the invocation.
     */
    virtual void destroy(const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_destroy(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&) override;
    /// \endcond
};

/**
 * The session manager for username/password authenticated users that
 * is responsible for managing {@link Session} objects. New session objects
 * are created by the {@link Router} object calling on an application-provided
 * session manager. If no session manager is provided by the application,
 * no client-visible sessions are passed to the client.
 * @see Router
 * @see Session
 * \headerfile Glacier2/Glacier2.h
 */
class GLACIER2_API SessionManager : public virtual ::Ice::Object
{
public:

    using ProxyType = SessionManagerPrx;

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(::std::string id, const ::Ice::Current& current) const override;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector<::std::string> ice_ids(const ::Ice::Current& current) const override;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual ::std::string ice_id(const ::Ice::Current& current) const override;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Create a new session.
     * @param userId The user id for the session.
     * @param control A proxy to the session control object.
     * @param current The Current object for the invocation.
     * @return A proxy to the newly created session.
     * @throws Glacier2::CannotCreateSessionException Raised if the session
     * cannot be created.
     */
    virtual ::std::shared_ptr<SessionPrx> create(::std::string userId, ::std::shared_ptr<SessionControlPrx> control, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_create(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&) override;
    /// \endcond
};

/**
 * The session manager for SSL authenticated users that is
 * responsible for managing {@link Session} objects. New session objects are
 * created by the {@link Router} object calling on an application-provided
 * session manager. If no session manager is provided by the
 * application, no client-visible sessions are passed to the client.
 * @see Router
 * @see Session
 * \headerfile Glacier2/Glacier2.h
 */
class GLACIER2_API SSLSessionManager : public virtual ::Ice::Object
{
public:

    using ProxyType = SSLSessionManagerPrx;

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(::std::string id, const ::Ice::Current& current) const override;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector<::std::string> ice_ids(const ::Ice::Current& current) const override;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual ::std::string ice_id(const ::Ice::Current& current) const override;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Create a new session.
     * @param info The SSL info.
     * @param control A proxy to the session control object.
     * @param current The Current object for the invocation.
     * @return A proxy to the newly created session.
     * @throws Glacier2::CannotCreateSessionException Raised if the session
     * cannot be created.
     */
    virtual ::std::shared_ptr<SessionPrx> create(SSLInfo info, ::std::shared_ptr<SessionControlPrx> control, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_create(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&) override;
    /// \endcond
};

}

namespace Glacier2
{

/**
 * A client-visible session object, which is tied to the lifecycle of a {@link Router}.
 * @see Router
 * @see SessionManager
 * \headerfile Glacier2/Glacier2.h
 */
class ICE_CLASS(GLACIER2_API) SessionPrx : public virtual ::Ice::Proxy<SessionPrx, ::Ice::ObjectPrx>
{
public:

    /**
     * Destroy the session. This is called automatically when the router is destroyed.
     * @param context The Context map to send with the invocation.
     */
    void destroy(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &SessionPrx::_iceI_destroy, context).get();
    }

    /**
     * Destroy the session. This is called automatically when the router is destroyed.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto destroyAsync(const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &SessionPrx::_iceI_destroy, context);
    }

    /**
     * Destroy the session. This is called automatically when the router is destroyed.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    destroyAsync(::std::function<void()> response,
                 ::std::function<void(::std::exception_ptr)> ex = nullptr,
                 ::std::function<void(bool)> sent = nullptr,
                 const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &Glacier2::SessionPrx::_iceI_destroy, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(GLACIER2_API) void _iceI_destroy(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Obtains the Slice type ID of this interface.
     * @return The fully-scoped type ID.
     */
    ICE_MEMBER(GLACIER2_API) static const ::std::string& ice_staticId();

protected:

    /// \cond INTERNAL
    SessionPrx() = default;
    friend ::std::shared_ptr<SessionPrx> IceInternal::createProxy<SessionPrx>();

    ICE_MEMBER(GLACIER2_API) virtual ::std::shared_ptr<::Ice::ObjectPrx> _newInstance() const override;
    /// \endcond
};

/**
 * An object for managing the set of identity constraints for specific
 * parts of object identity on a
 * {@link Session}.
 * @see Session
 * @see SessionControl
 * \headerfile Glacier2/Glacier2.h
 */
class ICE_CLASS(GLACIER2_API) StringSetPrx : public virtual ::Ice::Proxy<StringSetPrx, ::Ice::ObjectPrx>
{
public:

    /**
     * Add a sequence of strings to this set of constraints. Order is
     * not preserved and duplicates are implicitly removed.
     * @param additions The sequence of strings to be added.
     * @param context The Context map to send with the invocation.
     */
    void add(const ::Ice::StringSeq& additions, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &StringSetPrx::_iceI_add, additions, context).get();
    }

    /**
     * Add a sequence of strings to this set of constraints. Order is
     * not preserved and duplicates are implicitly removed.
     * @param additions The sequence of strings to be added.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto addAsync(const ::Ice::StringSeq& additions, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &StringSetPrx::_iceI_add, additions, context);
    }

    /**
     * Add a sequence of strings to this set of constraints. Order is
     * not preserved and duplicates are implicitly removed.
     * @param additions The sequence of strings to be added.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    addAsync(const ::Ice::StringSeq& additions,
             ::std::function<void()> response,
             ::std::function<void(::std::exception_ptr)> ex = nullptr,
             ::std::function<void(bool)> sent = nullptr,
             const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &Glacier2::StringSetPrx::_iceI_add, additions, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(GLACIER2_API) void _iceI_add(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::Ice::StringSeq&, const ::Ice::Context&);
    /// \endcond

    /**
     * Remove a sequence of strings from this set of constraints. No
     * errors are returned if an entry is not found.
     * @param deletions The sequence of strings to be removed.
     * @param context The Context map to send with the invocation.
     */
    void remove(const ::Ice::StringSeq& deletions, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &StringSetPrx::_iceI_remove, deletions, context).get();
    }

    /**
     * Remove a sequence of strings from this set of constraints. No
     * errors are returned if an entry is not found.
     * @param deletions The sequence of strings to be removed.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto removeAsync(const ::Ice::StringSeq& deletions, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &StringSetPrx::_iceI_remove, deletions, context);
    }

    /**
     * Remove a sequence of strings from this set of constraints. No
     * errors are returned if an entry is not found.
     * @param deletions The sequence of strings to be removed.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    removeAsync(const ::Ice::StringSeq& deletions,
                ::std::function<void()> response,
                ::std::function<void(::std::exception_ptr)> ex = nullptr,
                ::std::function<void(bool)> sent = nullptr,
                const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &Glacier2::StringSetPrx::_iceI_remove, deletions, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(GLACIER2_API) void _iceI_remove(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::Ice::StringSeq&, const ::Ice::Context&);
    /// \endcond

    /**
     * Returns a sequence of strings describing the constraints in this
     * set.
     * @param context The Context map to send with the invocation.
     * @return The sequence of strings for this set.
     */
    ::Ice::StringSeq get(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::Ice::StringSeq>(true, this, &StringSetPrx::_iceI_get, context).get();
    }

    /**
     * Returns a sequence of strings describing the constraints in this
     * set.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto getAsync(const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::Ice::StringSeq>>().get_future())
    {
        return _makePromiseOutgoing<::Ice::StringSeq, P>(false, this, &StringSetPrx::_iceI_get, context);
    }

    /**
     * Returns a sequence of strings describing the constraints in this
     * set.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    getAsync(::std::function<void(::Ice::StringSeq)> response,
             ::std::function<void(::std::exception_ptr)> ex = nullptr,
             ::std::function<void(bool)> sent = nullptr,
             const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::Ice::StringSeq>(std::move(response), std::move(ex), std::move(sent), this, &Glacier2::StringSetPrx::_iceI_get, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(GLACIER2_API) void _iceI_get(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::Ice::StringSeq>>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Obtains the Slice type ID of this interface.
     * @return The fully-scoped type ID.
     */
    ICE_MEMBER(GLACIER2_API) static const ::std::string& ice_staticId();

protected:

    /// \cond INTERNAL
    StringSetPrx() = default;
    friend ::std::shared_ptr<StringSetPrx> IceInternal::createProxy<StringSetPrx>();

    ICE_MEMBER(GLACIER2_API) virtual ::std::shared_ptr<::Ice::ObjectPrx> _newInstance() const override;
    /// \endcond
};

/**
 * An object for managing the set of object identity constraints on a
 * {@link Session}.
 * @see Session
 * @see SessionControl
 * \headerfile Glacier2/Glacier2.h
 */
class ICE_CLASS(GLACIER2_API) IdentitySetPrx : public virtual ::Ice::Proxy<IdentitySetPrx, ::Ice::ObjectPrx>
{
public:

    /**
     * Add a sequence of Ice identities to this set of constraints. Order is
     * not preserved and duplicates are implicitly removed.
     * @param additions The sequence of Ice identities to be added.
     * @param context The Context map to send with the invocation.
     */
    void add(const ::Ice::IdentitySeq& additions, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &IdentitySetPrx::_iceI_add, additions, context).get();
    }

    /**
     * Add a sequence of Ice identities to this set of constraints. Order is
     * not preserved and duplicates are implicitly removed.
     * @param additions The sequence of Ice identities to be added.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto addAsync(const ::Ice::IdentitySeq& additions, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &IdentitySetPrx::_iceI_add, additions, context);
    }

    /**
     * Add a sequence of Ice identities to this set of constraints. Order is
     * not preserved and duplicates are implicitly removed.
     * @param additions The sequence of Ice identities to be added.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    addAsync(const ::Ice::IdentitySeq& additions,
             ::std::function<void()> response,
             ::std::function<void(::std::exception_ptr)> ex = nullptr,
             ::std::function<void(bool)> sent = nullptr,
             const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &Glacier2::IdentitySetPrx::_iceI_add, additions, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(GLACIER2_API) void _iceI_add(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::Ice::IdentitySeq&, const ::Ice::Context&);
    /// \endcond

    /**
     * Remove a sequence of identities from this set of constraints. No
     * errors are returned if an entry is not found.
     * @param deletions The sequence of Ice identities to be removed.
     * @param context The Context map to send with the invocation.
     */
    void remove(const ::Ice::IdentitySeq& deletions, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &IdentitySetPrx::_iceI_remove, deletions, context).get();
    }

    /**
     * Remove a sequence of identities from this set of constraints. No
     * errors are returned if an entry is not found.
     * @param deletions The sequence of Ice identities to be removed.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto removeAsync(const ::Ice::IdentitySeq& deletions, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &IdentitySetPrx::_iceI_remove, deletions, context);
    }

    /**
     * Remove a sequence of identities from this set of constraints. No
     * errors are returned if an entry is not found.
     * @param deletions The sequence of Ice identities to be removed.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    removeAsync(const ::Ice::IdentitySeq& deletions,
                ::std::function<void()> response,
                ::std::function<void(::std::exception_ptr)> ex = nullptr,
                ::std::function<void(bool)> sent = nullptr,
                const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &Glacier2::IdentitySetPrx::_iceI_remove, deletions, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(GLACIER2_API) void _iceI_remove(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::Ice::IdentitySeq&, const ::Ice::Context&);
    /// \endcond

    /**
     * Returns a sequence of identities describing the constraints in this
     * set.
     * @param context The Context map to send with the invocation.
     * @return The sequence of Ice identities for this set.
     */
    ::Ice::IdentitySeq get(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::Ice::IdentitySeq>(true, this, &IdentitySetPrx::_iceI_get, context).get();
    }

    /**
     * Returns a sequence of identities describing the constraints in this
     * set.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto getAsync(const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::Ice::IdentitySeq>>().get_future())
    {
        return _makePromiseOutgoing<::Ice::IdentitySeq, P>(false, this, &IdentitySetPrx::_iceI_get, context);
    }

    /**
     * Returns a sequence of identities describing the constraints in this
     * set.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    getAsync(::std::function<void(::Ice::IdentitySeq)> response,
             ::std::function<void(::std::exception_ptr)> ex = nullptr,
             ::std::function<void(bool)> sent = nullptr,
             const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::Ice::IdentitySeq>(std::move(response), std::move(ex), std::move(sent), this, &Glacier2::IdentitySetPrx::_iceI_get, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(GLACIER2_API) void _iceI_get(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::Ice::IdentitySeq>>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Obtains the Slice type ID of this interface.
     * @return The fully-scoped type ID.
     */
    ICE_MEMBER(GLACIER2_API) static const ::std::string& ice_staticId();

protected:

    /// \cond INTERNAL
    IdentitySetPrx() = default;
    friend ::std::shared_ptr<IdentitySetPrx> IceInternal::createProxy<IdentitySetPrx>();

    ICE_MEMBER(GLACIER2_API) virtual ::std::shared_ptr<::Ice::ObjectPrx> _newInstance() const override;
    /// \endcond
};

/**
 * An administrative session control object, which is tied to the
 * lifecycle of a {@link Session}.
 * @see Session
 * \headerfile Glacier2/Glacier2.h
 */
class ICE_CLASS(GLACIER2_API) SessionControlPrx : public virtual ::Ice::Proxy<SessionControlPrx, ::Ice::ObjectPrx>
{
public:

    /**
     * Access the object that manages the allowable categories
     * for object identities for this session.
     * @param context The Context map to send with the invocation.
     * @return A StringSet object.
     */
    ::std::shared_ptr<StringSetPrx> categories(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::std::shared_ptr<::Glacier2::StringSetPrx>>(true, this, &SessionControlPrx::_iceI_categories, context).get();
    }

    /**
     * Access the object that manages the allowable categories
     * for object identities for this session.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto categoriesAsync(const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::std::shared_ptr<::Glacier2::StringSetPrx>>>().get_future())
    {
        return _makePromiseOutgoing<::std::shared_ptr<::Glacier2::StringSetPrx>, P>(false, this, &SessionControlPrx::_iceI_categories, context);
    }

    /**
     * Access the object that manages the allowable categories
     * for object identities for this session.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    categoriesAsync(::std::function<void(::std::shared_ptr<::Glacier2::StringSetPrx>)> response,
                    ::std::function<void(::std::exception_ptr)> ex = nullptr,
                    ::std::function<void(bool)> sent = nullptr,
                    const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::shared_ptr<::Glacier2::StringSetPrx>>(std::move(response), std::move(ex), std::move(sent), this, &Glacier2::SessionControlPrx::_iceI_categories, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(GLACIER2_API) void _iceI_categories(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::Glacier2::StringSetPrx>>>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Access the object that manages the allowable adapter identities
     * for objects for this session.
     * @param context The Context map to send with the invocation.
     * @return A StringSet object.
     */
    ::std::shared_ptr<StringSetPrx> adapterIds(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::std::shared_ptr<::Glacier2::StringSetPrx>>(true, this, &SessionControlPrx::_iceI_adapterIds, context).get();
    }

    /**
     * Access the object that manages the allowable adapter identities
     * for objects for this session.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto adapterIdsAsync(const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::std::shared_ptr<::Glacier2::StringSetPrx>>>().get_future())
    {
        return _makePromiseOutgoing<::std::shared_ptr<::Glacier2::StringSetPrx>, P>(false, this, &SessionControlPrx::_iceI_adapterIds, context);
    }

    /**
     * Access the object that manages the allowable adapter identities
     * for objects for this session.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    adapterIdsAsync(::std::function<void(::std::shared_ptr<::Glacier2::StringSetPrx>)> response,
                    ::std::function<void(::std::exception_ptr)> ex = nullptr,
                    ::std::function<void(bool)> sent = nullptr,
                    const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::shared_ptr<::Glacier2::StringSetPrx>>(std::move(response), std::move(ex), std::move(sent), this, &Glacier2::SessionControlPrx::_iceI_adapterIds, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(GLACIER2_API) void _iceI_adapterIds(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::Glacier2::StringSetPrx>>>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Access the object that manages the allowable object identities
     * for this session.
     * @param context The Context map to send with the invocation.
     * @return An IdentitySet object.
     */
    ::std::shared_ptr<IdentitySetPrx> identities(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::std::shared_ptr<::Glacier2::IdentitySetPrx>>(true, this, &SessionControlPrx::_iceI_identities, context).get();
    }

    /**
     * Access the object that manages the allowable object identities
     * for this session.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto identitiesAsync(const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::std::shared_ptr<::Glacier2::IdentitySetPrx>>>().get_future())
    {
        return _makePromiseOutgoing<::std::shared_ptr<::Glacier2::IdentitySetPrx>, P>(false, this, &SessionControlPrx::_iceI_identities, context);
    }

    /**
     * Access the object that manages the allowable object identities
     * for this session.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    identitiesAsync(::std::function<void(::std::shared_ptr<::Glacier2::IdentitySetPrx>)> response,
                    ::std::function<void(::std::exception_ptr)> ex = nullptr,
                    ::std::function<void(bool)> sent = nullptr,
                    const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::shared_ptr<::Glacier2::IdentitySetPrx>>(std::move(response), std::move(ex), std::move(sent), this, &Glacier2::SessionControlPrx::_iceI_identities, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(GLACIER2_API) void _iceI_identities(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::Glacier2::IdentitySetPrx>>>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Get the session timeout.
     * @param context The Context map to send with the invocation.
     * @return The timeout.
     */
    int getSessionTimeout(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<int>(true, this, &SessionControlPrx::_iceI_getSessionTimeout, context).get();
    }

    /**
     * Get the session timeout.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto getSessionTimeoutAsync(const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<int>>().get_future())
    {
        return _makePromiseOutgoing<int, P>(false, this, &SessionControlPrx::_iceI_getSessionTimeout, context);
    }

    /**
     * Get the session timeout.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    getSessionTimeoutAsync(::std::function<void(int)> response,
                           ::std::function<void(::std::exception_ptr)> ex = nullptr,
                           ::std::function<void(bool)> sent = nullptr,
                           const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<int>(std::move(response), std::move(ex), std::move(sent), this, &Glacier2::SessionControlPrx::_iceI_getSessionTimeout, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(GLACIER2_API) void _iceI_getSessionTimeout(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<int>>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Destroy the associated session.
     * @param context The Context map to send with the invocation.
     */
    void destroy(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &SessionControlPrx::_iceI_destroy, context).get();
    }

    /**
     * Destroy the associated session.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto destroyAsync(const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &SessionControlPrx::_iceI_destroy, context);
    }

    /**
     * Destroy the associated session.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    destroyAsync(::std::function<void()> response,
                 ::std::function<void(::std::exception_ptr)> ex = nullptr,
                 ::std::function<void(bool)> sent = nullptr,
                 const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &Glacier2::SessionControlPrx::_iceI_destroy, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(GLACIER2_API) void _iceI_destroy(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Obtains the Slice type ID of this interface.
     * @return The fully-scoped type ID.
     */
    ICE_MEMBER(GLACIER2_API) static const ::std::string& ice_staticId();

protected:

    /// \cond INTERNAL
    SessionControlPrx() = default;
    friend ::std::shared_ptr<SessionControlPrx> IceInternal::createProxy<SessionControlPrx>();

    ICE_MEMBER(GLACIER2_API) virtual ::std::shared_ptr<::Ice::ObjectPrx> _newInstance() const override;
    /// \endcond
};

/**
 * The session manager for username/password authenticated users that
 * is responsible for managing {@link Session} objects. New session objects
 * are created by the {@link Router} object calling on an application-provided
 * session manager. If no session manager is provided by the application,
 * no client-visible sessions are passed to the client.
 * @see Router
 * @see Session
 * \headerfile Glacier2/Glacier2.h
 */
class ICE_CLASS(GLACIER2_API) SessionManagerPrx : public virtual ::Ice::Proxy<SessionManagerPrx, ::Ice::ObjectPrx>
{
public:

    /**
     * Create a new session.
     * @param userId The user id for the session.
     * @param control A proxy to the session control object.
     * @param context The Context map to send with the invocation.
     * @return A proxy to the newly created session.
     * @throws Glacier2::CannotCreateSessionException Raised if the session
     * cannot be created.
     */
    ::std::shared_ptr<SessionPrx> create(const ::std::string& userId, const ::std::shared_ptr<SessionControlPrx>& control, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::std::shared_ptr<::Glacier2::SessionPrx>>(true, this, &SessionManagerPrx::_iceI_create, userId, control, context).get();
    }

    /**
     * Create a new session.
     * @param userId The user id for the session.
     * @param control A proxy to the session control object.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto createAsync(const ::std::string& userId, const ::std::shared_ptr<SessionControlPrx>& control, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::std::shared_ptr<::Glacier2::SessionPrx>>>().get_future())
    {
        return _makePromiseOutgoing<::std::shared_ptr<::Glacier2::SessionPrx>, P>(false, this, &SessionManagerPrx::_iceI_create, userId, control, context);
    }

    /**
     * Create a new session.
     * @param userId The user id for the session.
     * @param control A proxy to the session control object.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    createAsync(const ::std::string& userId, const ::std::shared_ptr<SessionControlPrx>& control,
                ::std::function<void(::std::shared_ptr<::Glacier2::SessionPrx>)> response,
                ::std::function<void(::std::exception_ptr)> ex = nullptr,
                ::std::function<void(bool)> sent = nullptr,
                const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::shared_ptr<::Glacier2::SessionPrx>>(std::move(response), std::move(ex), std::move(sent), this, &Glacier2::SessionManagerPrx::_iceI_create, userId, control, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(GLACIER2_API) void _iceI_create(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::Glacier2::SessionPrx>>>&, const ::std::string&, const ::std::shared_ptr<SessionControlPrx>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Obtains the Slice type ID of this interface.
     * @return The fully-scoped type ID.
     */
    ICE_MEMBER(GLACIER2_API) static const ::std::string& ice_staticId();

protected:

    /// \cond INTERNAL
    SessionManagerPrx() = default;
    friend ::std::shared_ptr<SessionManagerPrx> IceInternal::createProxy<SessionManagerPrx>();

    ICE_MEMBER(GLACIER2_API) virtual ::std::shared_ptr<::Ice::ObjectPrx> _newInstance() const override;
    /// \endcond
};

/**
 * The session manager for SSL authenticated users that is
 * responsible for managing {@link Session} objects. New session objects are
 * created by the {@link Router} object calling on an application-provided
 * session manager. If no session manager is provided by the
 * application, no client-visible sessions are passed to the client.
 * @see Router
 * @see Session
 * \headerfile Glacier2/Glacier2.h
 */
class ICE_CLASS(GLACIER2_API) SSLSessionManagerPrx : public virtual ::Ice::Proxy<SSLSessionManagerPrx, ::Ice::ObjectPrx>
{
public:

    /**
     * Create a new session.
     * @param info The SSL info.
     * @param control A proxy to the session control object.
     * @param context The Context map to send with the invocation.
     * @return A proxy to the newly created session.
     * @throws Glacier2::CannotCreateSessionException Raised if the session
     * cannot be created.
     */
    ::std::shared_ptr<SessionPrx> create(const SSLInfo& info, const ::std::shared_ptr<SessionControlPrx>& control, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::std::shared_ptr<::Glacier2::SessionPrx>>(true, this, &SSLSessionManagerPrx::_iceI_create, info, control, context).get();
    }

    /**
     * Create a new session.
     * @param info The SSL info.
     * @param control A proxy to the session control object.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto createAsync(const SSLInfo& info, const ::std::shared_ptr<SessionControlPrx>& control, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::std::shared_ptr<::Glacier2::SessionPrx>>>().get_future())
    {
        return _makePromiseOutgoing<::std::shared_ptr<::Glacier2::SessionPrx>, P>(false, this, &SSLSessionManagerPrx::_iceI_create, info, control, context);
    }

    /**
     * Create a new session.
     * @param info The SSL info.
     * @param control A proxy to the session control object.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    createAsync(const SSLInfo& info, const ::std::shared_ptr<SessionControlPrx>& control,
                ::std::function<void(::std::shared_ptr<::Glacier2::SessionPrx>)> response,
                ::std::function<void(::std::exception_ptr)> ex = nullptr,
                ::std::function<void(bool)> sent = nullptr,
                const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::shared_ptr<::Glacier2::SessionPrx>>(std::move(response), std::move(ex), std::move(sent), this, &Glacier2::SSLSessionManagerPrx::_iceI_create, info, control, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(GLACIER2_API) void _iceI_create(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::Glacier2::SessionPrx>>>&, const SSLInfo&, const ::std::shared_ptr<SessionControlPrx>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Obtains the Slice type ID of this interface.
     * @return The fully-scoped type ID.
     */
    ICE_MEMBER(GLACIER2_API) static const ::std::string& ice_staticId();

protected:

    /// \cond INTERNAL
    SSLSessionManagerPrx() = default;
    friend ::std::shared_ptr<SSLSessionManagerPrx> IceInternal::createProxy<SSLSessionManagerPrx>();

    ICE_MEMBER(GLACIER2_API) virtual ::std::shared_ptr<::Ice::ObjectPrx> _newInstance() const override;
    /// \endcond
};

}

/// \cond STREAM
namespace Ice
{

template<typename S>
struct StreamReader<::Glacier2::CannotCreateSessionException, S>
{
    static void read(S* istr, ::Glacier2::CannotCreateSessionException& v)
    {
        istr->readAll(v.reason);
    }
};

}
/// \endcond

/// \cond INTERNAL
namespace Glacier2
{

using SessionPtr = ::std::shared_ptr<Session>;
using SessionPrxPtr = ::std::shared_ptr<SessionPrx>;

using StringSetPtr = ::std::shared_ptr<StringSet>;
using StringSetPrxPtr = ::std::shared_ptr<StringSetPrx>;

using IdentitySetPtr = ::std::shared_ptr<IdentitySet>;
using IdentitySetPrxPtr = ::std::shared_ptr<IdentitySetPrx>;

using SessionControlPtr = ::std::shared_ptr<SessionControl>;
using SessionControlPrxPtr = ::std::shared_ptr<SessionControlPrx>;

using SessionManagerPtr = ::std::shared_ptr<SessionManager>;
using SessionManagerPrxPtr = ::std::shared_ptr<SessionManagerPrx>;

using SSLSessionManagerPtr = ::std::shared_ptr<SSLSessionManager>;
using SSLSessionManagerPrxPtr = ::std::shared_ptr<SSLSessionManagerPrx>;

}
/// \endcond

#else // C++98 mapping

namespace IceProxy
{

namespace Glacier2
{

class Session;
/// \cond INTERNAL
GLACIER2_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< Session>&);
GLACIER2_API ::IceProxy::Ice::Object* upCast(Session*);
/// \endcond

class StringSet;
/// \cond INTERNAL
GLACIER2_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< StringSet>&);
GLACIER2_API ::IceProxy::Ice::Object* upCast(StringSet*);
/// \endcond

class IdentitySet;
/// \cond INTERNAL
GLACIER2_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< IdentitySet>&);
GLACIER2_API ::IceProxy::Ice::Object* upCast(IdentitySet*);
/// \endcond

class SessionControl;
/// \cond INTERNAL
GLACIER2_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< SessionControl>&);
GLACIER2_API ::IceProxy::Ice::Object* upCast(SessionControl*);
/// \endcond

class SessionManager;
/// \cond INTERNAL
GLACIER2_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< SessionManager>&);
GLACIER2_API ::IceProxy::Ice::Object* upCast(SessionManager*);
/// \endcond

class SSLSessionManager;
/// \cond INTERNAL
GLACIER2_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< SSLSessionManager>&);
GLACIER2_API ::IceProxy::Ice::Object* upCast(SSLSessionManager*);
/// \endcond

}

}

namespace Glacier2
{

class Session;
/// \cond INTERNAL
GLACIER2_API ::Ice::Object* upCast(Session*);
/// \endcond
typedef ::IceInternal::Handle< Session> SessionPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::Glacier2::Session> SessionPrx;
typedef SessionPrx SessionPrxPtr;
/// \cond INTERNAL
GLACIER2_API void _icePatchObjectPtr(SessionPtr&, const ::Ice::ObjectPtr&);
/// \endcond

class StringSet;
/// \cond INTERNAL
GLACIER2_API ::Ice::Object* upCast(StringSet*);
/// \endcond
typedef ::IceInternal::Handle< StringSet> StringSetPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::Glacier2::StringSet> StringSetPrx;
typedef StringSetPrx StringSetPrxPtr;
/// \cond INTERNAL
GLACIER2_API void _icePatchObjectPtr(StringSetPtr&, const ::Ice::ObjectPtr&);
/// \endcond

class IdentitySet;
/// \cond INTERNAL
GLACIER2_API ::Ice::Object* upCast(IdentitySet*);
/// \endcond
typedef ::IceInternal::Handle< IdentitySet> IdentitySetPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::Glacier2::IdentitySet> IdentitySetPrx;
typedef IdentitySetPrx IdentitySetPrxPtr;
/// \cond INTERNAL
GLACIER2_API void _icePatchObjectPtr(IdentitySetPtr&, const ::Ice::ObjectPtr&);
/// \endcond

class SessionControl;
/// \cond INTERNAL
GLACIER2_API ::Ice::Object* upCast(SessionControl*);
/// \endcond
typedef ::IceInternal::Handle< SessionControl> SessionControlPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::Glacier2::SessionControl> SessionControlPrx;
typedef SessionControlPrx SessionControlPrxPtr;
/// \cond INTERNAL
GLACIER2_API void _icePatchObjectPtr(SessionControlPtr&, const ::Ice::ObjectPtr&);
/// \endcond

class SessionManager;
/// \cond INTERNAL
GLACIER2_API ::Ice::Object* upCast(SessionManager*);
/// \endcond
typedef ::IceInternal::Handle< SessionManager> SessionManagerPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::Glacier2::SessionManager> SessionManagerPrx;
typedef SessionManagerPrx SessionManagerPrxPtr;
/// \cond INTERNAL
GLACIER2_API void _icePatchObjectPtr(SessionManagerPtr&, const ::Ice::ObjectPtr&);
/// \endcond

class SSLSessionManager;
/// \cond INTERNAL
GLACIER2_API ::Ice::Object* upCast(SSLSessionManager*);
/// \endcond
typedef ::IceInternal::Handle< SSLSessionManager> SSLSessionManagerPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::Glacier2::SSLSessionManager> SSLSessionManagerPrx;
typedef SSLSessionManagerPrx SSLSessionManagerPrxPtr;
/// \cond INTERNAL
GLACIER2_API void _icePatchObjectPtr(SSLSessionManagerPtr&, const ::Ice::ObjectPtr&);
/// \endcond

}

namespace Glacier2
{

/**
 * This exception is raised if an attempt to create a new session failed.
 * \headerfile Glacier2/Glacier2.h
 */
class GLACIER2_API CannotCreateSessionException : public ::Ice::UserException
{
public:

    CannotCreateSessionException() {}
    /**
     * One-shot constructor to initialize all data members.
     * @param reason The reason why session creation has failed.
     */
    explicit CannotCreateSessionException(const ::std::string& reason);

#ifdef ICE_CPP11_COMPILER
    CannotCreateSessionException(const CannotCreateSessionException&) = default;
    virtual ~CannotCreateSessionException();
#else
    virtual ~CannotCreateSessionException() throw();
#endif

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    virtual ::std::string ice_id() const;
    /**
     * Polymorphically clones this exception.
     * @return A shallow copy of this exception.
     */
    virtual CannotCreateSessionException* ice_clone() const;
    /**
     * Throws this exception.
     */
    virtual void ice_throw() const;

    /**
     * The reason why session creation has failed.
     */
    ::std::string reason;

    /**
     * Obtains the SlicedData object created when an unknown exception type was marshaled
     * in the sliced format and the Ice run time sliced it to a known type.
     * @return The SlicedData object, or nil if the exception was not sliced or was not
     * marshaled in the sliced format.
     */
    virtual ::Ice::SlicedDataPtr ice_getSlicedData() const;

    /// \cond STREAM
    virtual void _write(::Ice::OutputStream*) const;
    virtual void _read(::Ice::InputStream*);
    using ::Ice::UserException::_write;
    using ::Ice::UserException::_read;
    /// \endcond

protected:

    /// \cond STREAM
    virtual void _writeImpl(::Ice::OutputStream*) const;
    virtual void _readImpl(::Ice::InputStream*);
    /// \endcond

    /// \cond STREAM
    ::Ice::SlicedDataPtr _slicedData;
    /// \endcond
};

/// \cond INTERNAL
static CannotCreateSessionException _iceS_CannotCreateSessionException_init;
/// \endcond

}

namespace Glacier2
{

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::Glacier2::Session::begin_destroy.
 * Create a wrapper instance by calling ::Glacier2::newCallback_Session_destroy.
 */
class Callback_Session_destroy_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Session_destroy_Base> Callback_Session_destroyPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::Glacier2::StringSet::begin_add.
 * Create a wrapper instance by calling ::Glacier2::newCallback_StringSet_add.
 */
class Callback_StringSet_add_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_StringSet_add_Base> Callback_StringSet_addPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::Glacier2::StringSet::begin_remove.
 * Create a wrapper instance by calling ::Glacier2::newCallback_StringSet_remove.
 */
class Callback_StringSet_remove_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_StringSet_remove_Base> Callback_StringSet_removePtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::Glacier2::StringSet::begin_get.
 * Create a wrapper instance by calling ::Glacier2::newCallback_StringSet_get.
 */
class Callback_StringSet_get_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_StringSet_get_Base> Callback_StringSet_getPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::Glacier2::IdentitySet::begin_add.
 * Create a wrapper instance by calling ::Glacier2::newCallback_IdentitySet_add.
 */
class Callback_IdentitySet_add_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_IdentitySet_add_Base> Callback_IdentitySet_addPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::Glacier2::IdentitySet::begin_remove.
 * Create a wrapper instance by calling ::Glacier2::newCallback_IdentitySet_remove.
 */
class Callback_IdentitySet_remove_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_IdentitySet_remove_Base> Callback_IdentitySet_removePtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::Glacier2::IdentitySet::begin_get.
 * Create a wrapper instance by calling ::Glacier2::newCallback_IdentitySet_get.
 */
class Callback_IdentitySet_get_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_IdentitySet_get_Base> Callback_IdentitySet_getPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::Glacier2::SessionControl::begin_categories.
 * Create a wrapper instance by calling ::Glacier2::newCallback_SessionControl_categories.
 */
class Callback_SessionControl_categories_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_SessionControl_categories_Base> Callback_SessionControl_categoriesPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::Glacier2::SessionControl::begin_adapterIds.
 * Create a wrapper instance by calling ::Glacier2::newCallback_SessionControl_adapterIds.
 */
class Callback_SessionControl_adapterIds_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_SessionControl_adapterIds_Base> Callback_SessionControl_adapterIdsPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::Glacier2::SessionControl::begin_identities.
 * Create a wrapper instance by calling ::Glacier2::newCallback_SessionControl_identities.
 */
class Callback_SessionControl_identities_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_SessionControl_identities_Base> Callback_SessionControl_identitiesPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::Glacier2::SessionControl::begin_getSessionTimeout.
 * Create a wrapper instance by calling ::Glacier2::newCallback_SessionControl_getSessionTimeout.
 */
class Callback_SessionControl_getSessionTimeout_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_SessionControl_getSessionTimeout_Base> Callback_SessionControl_getSessionTimeoutPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::Glacier2::SessionControl::begin_destroy.
 * Create a wrapper instance by calling ::Glacier2::newCallback_SessionControl_destroy.
 */
class Callback_SessionControl_destroy_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_SessionControl_destroy_Base> Callback_SessionControl_destroyPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::Glacier2::SessionManager::begin_create.
 * Create a wrapper instance by calling ::Glacier2::newCallback_SessionManager_create.
 */
class Callback_SessionManager_create_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_SessionManager_create_Base> Callback_SessionManager_createPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::Glacier2::SSLSessionManager::begin_create.
 * Create a wrapper instance by calling ::Glacier2::newCallback_SSLSessionManager_create.
 */
class Callback_SSLSessionManager_create_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_SSLSessionManager_create_Base> Callback_SSLSessionManager_createPtr;

}

namespace IceProxy
{

namespace Glacier2
{

class ICE_CLASS(GLACIER2_API) Session : public virtual ::Ice::Proxy<Session, ::IceProxy::Ice::Object>
{
public:

    /**
     * Destroy the session. This is called automatically when the router is destroyed.
     * @param context The Context map to send with the invocation.
     */
    ICE_MEMBER(GLACIER2_API) void destroy(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_destroy(_iceI_begin_destroy(context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Destroy the session. This is called automatically when the router is destroyed.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_destroy(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_destroy(context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Destroy the session. This is called automatically when the router is destroyed.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_destroy(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_destroy(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Destroy the session. This is called automatically when the router is destroyed.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_destroy(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_destroy(context, cb, cookie);
    }

    /**
     * Destroy the session. This is called automatically when the router is destroyed.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_destroy(const ::Glacier2::Callback_Session_destroyPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_destroy(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Destroy the session. This is called automatically when the router is destroyed.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_destroy(const ::Ice::Context& context, const ::Glacier2::Callback_Session_destroyPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_destroy(context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_destroy.
     * @param result The asynchronous result object for the invocation.
     */
    ICE_MEMBER(GLACIER2_API) void end_destroy(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(GLACIER2_API) ::Ice::AsyncResultPtr _iceI_begin_destroy(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Obtains the Slice type ID corresponding to this interface.
     * @return A fully-scoped type ID.
     */
    ICE_MEMBER(GLACIER2_API) static const ::std::string& ice_staticId();

protected:
    /// \cond INTERNAL

    ICE_MEMBER(GLACIER2_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
    /// \endcond
};

class ICE_CLASS(GLACIER2_API) StringSet : public virtual ::Ice::Proxy<StringSet, ::IceProxy::Ice::Object>
{
public:

    /**
     * Add a sequence of strings to this set of constraints. Order is
     * not preserved and duplicates are implicitly removed.
     * @param additions The sequence of strings to be added.
     * @param context The Context map to send with the invocation.
     */
    ICE_MEMBER(GLACIER2_API) void add(const ::Ice::StringSeq& additions, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_add(_iceI_begin_add(additions, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Add a sequence of strings to this set of constraints. Order is
     * not preserved and duplicates are implicitly removed.
     * @param additions The sequence of strings to be added.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_add(const ::Ice::StringSeq& additions, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_add(additions, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Add a sequence of strings to this set of constraints. Order is
     * not preserved and duplicates are implicitly removed.
     * @param additions The sequence of strings to be added.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_add(const ::Ice::StringSeq& additions, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_add(additions, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Add a sequence of strings to this set of constraints. Order is
     * not preserved and duplicates are implicitly removed.
     * @param additions The sequence of strings to be added.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_add(const ::Ice::StringSeq& additions, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_add(additions, context, cb, cookie);
    }

    /**
     * Add a sequence of strings to this set of constraints. Order is
     * not preserved and duplicates are implicitly removed.
     * @param additions The sequence of strings to be added.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_add(const ::Ice::StringSeq& additions, const ::Glacier2::Callback_StringSet_addPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_add(additions, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Add a sequence of strings to this set of constraints. Order is
     * not preserved and duplicates are implicitly removed.
     * @param additions The sequence of strings to be added.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_add(const ::Ice::StringSeq& additions, const ::Ice::Context& context, const ::Glacier2::Callback_StringSet_addPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_add(additions, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_add.
     * @param result The asynchronous result object for the invocation.
     */
    ICE_MEMBER(GLACIER2_API) void end_add(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(GLACIER2_API) ::Ice::AsyncResultPtr _iceI_begin_add(const ::Ice::StringSeq&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Remove a sequence of strings from this set of constraints. No
     * errors are returned if an entry is not found.
     * @param deletions The sequence of strings to be removed.
     * @param context The Context map to send with the invocation.
     */
    ICE_MEMBER(GLACIER2_API) void remove(const ::Ice::StringSeq& deletions, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_remove(_iceI_begin_remove(deletions, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Remove a sequence of strings from this set of constraints. No
     * errors are returned if an entry is not found.
     * @param deletions The sequence of strings to be removed.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_remove(const ::Ice::StringSeq& deletions, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_remove(deletions, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Remove a sequence of strings from this set of constraints. No
     * errors are returned if an entry is not found.
     * @param deletions The sequence of strings to be removed.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_remove(const ::Ice::StringSeq& deletions, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_remove(deletions, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Remove a sequence of strings from this set of constraints. No
     * errors are returned if an entry is not found.
     * @param deletions The sequence of strings to be removed.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_remove(const ::Ice::StringSeq& deletions, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_remove(deletions, context, cb, cookie);
    }

    /**
     * Remove a sequence of strings from this set of constraints. No
     * errors are returned if an entry is not found.
     * @param deletions The sequence of strings to be removed.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_remove(const ::Ice::StringSeq& deletions, const ::Glacier2::Callback_StringSet_removePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_remove(deletions, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Remove a sequence of strings from this set of constraints. No
     * errors are returned if an entry is not found.
     * @param deletions The sequence of strings to be removed.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_remove(const ::Ice::StringSeq& deletions, const ::Ice::Context& context, const ::Glacier2::Callback_StringSet_removePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_remove(deletions, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_remove.
     * @param result The asynchronous result object for the invocation.
     */
    ICE_MEMBER(GLACIER2_API) void end_remove(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(GLACIER2_API) ::Ice::AsyncResultPtr _iceI_begin_remove(const ::Ice::StringSeq&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Returns a sequence of strings describing the constraints in this
     * set.
     * @param context The Context map to send with the invocation.
     * @return The sequence of strings for this set.
     */
    ICE_MEMBER(GLACIER2_API) ::Ice::StringSeq get(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_get(_iceI_begin_get(context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Returns a sequence of strings describing the constraints in this
     * set.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_get(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_get(context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Returns a sequence of strings describing the constraints in this
     * set.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_get(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_get(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Returns a sequence of strings describing the constraints in this
     * set.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_get(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_get(context, cb, cookie);
    }

    /**
     * Returns a sequence of strings describing the constraints in this
     * set.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_get(const ::Glacier2::Callback_StringSet_getPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_get(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Returns a sequence of strings describing the constraints in this
     * set.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_get(const ::Ice::Context& context, const ::Glacier2::Callback_StringSet_getPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_get(context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_get.
     * @param result The asynchronous result object for the invocation.
     * @return The sequence of strings for this set.
     */
    ICE_MEMBER(GLACIER2_API) ::Ice::StringSeq end_get(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(GLACIER2_API) ::Ice::AsyncResultPtr _iceI_begin_get(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Obtains the Slice type ID corresponding to this interface.
     * @return A fully-scoped type ID.
     */
    ICE_MEMBER(GLACIER2_API) static const ::std::string& ice_staticId();

protected:
    /// \cond INTERNAL

    ICE_MEMBER(GLACIER2_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
    /// \endcond
};

class ICE_CLASS(GLACIER2_API) IdentitySet : public virtual ::Ice::Proxy<IdentitySet, ::IceProxy::Ice::Object>
{
public:

    /**
     * Add a sequence of Ice identities to this set of constraints. Order is
     * not preserved and duplicates are implicitly removed.
     * @param additions The sequence of Ice identities to be added.
     * @param context The Context map to send with the invocation.
     */
    ICE_MEMBER(GLACIER2_API) void add(const ::Ice::IdentitySeq& additions, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_add(_iceI_begin_add(additions, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Add a sequence of Ice identities to this set of constraints. Order is
     * not preserved and duplicates are implicitly removed.
     * @param additions The sequence of Ice identities to be added.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_add(const ::Ice::IdentitySeq& additions, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_add(additions, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Add a sequence of Ice identities to this set of constraints. Order is
     * not preserved and duplicates are implicitly removed.
     * @param additions The sequence of Ice identities to be added.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_add(const ::Ice::IdentitySeq& additions, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_add(additions, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Add a sequence of Ice identities to this set of constraints. Order is
     * not preserved and duplicates are implicitly removed.
     * @param additions The sequence of Ice identities to be added.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_add(const ::Ice::IdentitySeq& additions, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_add(additions, context, cb, cookie);
    }

    /**
     * Add a sequence of Ice identities to this set of constraints. Order is
     * not preserved and duplicates are implicitly removed.
     * @param additions The sequence of Ice identities to be added.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_add(const ::Ice::IdentitySeq& additions, const ::Glacier2::Callback_IdentitySet_addPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_add(additions, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Add a sequence of Ice identities to this set of constraints. Order is
     * not preserved and duplicates are implicitly removed.
     * @param additions The sequence of Ice identities to be added.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_add(const ::Ice::IdentitySeq& additions, const ::Ice::Context& context, const ::Glacier2::Callback_IdentitySet_addPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_add(additions, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_add.
     * @param result The asynchronous result object for the invocation.
     */
    ICE_MEMBER(GLACIER2_API) void end_add(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(GLACIER2_API) ::Ice::AsyncResultPtr _iceI_begin_add(const ::Ice::IdentitySeq&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Remove a sequence of identities from this set of constraints. No
     * errors are returned if an entry is not found.
     * @param deletions The sequence of Ice identities to be removed.
     * @param context The Context map to send with the invocation.
     */
    ICE_MEMBER(GLACIER2_API) void remove(const ::Ice::IdentitySeq& deletions, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_remove(_iceI_begin_remove(deletions, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Remove a sequence of identities from this set of constraints. No
     * errors are returned if an entry is not found.
     * @param deletions The sequence of Ice identities to be removed.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_remove(const ::Ice::IdentitySeq& deletions, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_remove(deletions, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Remove a sequence of identities from this set of constraints. No
     * errors are returned if an entry is not found.
     * @param deletions The sequence of Ice identities to be removed.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_remove(const ::Ice::IdentitySeq& deletions, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_remove(deletions, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Remove a sequence of identities from this set of constraints. No
     * errors are returned if an entry is not found.
     * @param deletions The sequence of Ice identities to be removed.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_remove(const ::Ice::IdentitySeq& deletions, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_remove(deletions, context, cb, cookie);
    }

    /**
     * Remove a sequence of identities from this set of constraints. No
     * errors are returned if an entry is not found.
     * @param deletions The sequence of Ice identities to be removed.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_remove(const ::Ice::IdentitySeq& deletions, const ::Glacier2::Callback_IdentitySet_removePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_remove(deletions, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Remove a sequence of identities from this set of constraints. No
     * errors are returned if an entry is not found.
     * @param deletions The sequence of Ice identities to be removed.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_remove(const ::Ice::IdentitySeq& deletions, const ::Ice::Context& context, const ::Glacier2::Callback_IdentitySet_removePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_remove(deletions, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_remove.
     * @param result The asynchronous result object for the invocation.
     */
    ICE_MEMBER(GLACIER2_API) void end_remove(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(GLACIER2_API) ::Ice::AsyncResultPtr _iceI_begin_remove(const ::Ice::IdentitySeq&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Returns a sequence of identities describing the constraints in this
     * set.
     * @param context The Context map to send with the invocation.
     * @return The sequence of Ice identities for this set.
     */
    ICE_MEMBER(GLACIER2_API) ::Ice::IdentitySeq get(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_get(_iceI_begin_get(context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Returns a sequence of identities describing the constraints in this
     * set.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_get(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_get(context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Returns a sequence of identities describing the constraints in this
     * set.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_get(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_get(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Returns a sequence of identities describing the constraints in this
     * set.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_get(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_get(context, cb, cookie);
    }

    /**
     * Returns a sequence of identities describing the constraints in this
     * set.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_get(const ::Glacier2::Callback_IdentitySet_getPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_get(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Returns a sequence of identities describing the constraints in this
     * set.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_get(const ::Ice::Context& context, const ::Glacier2::Callback_IdentitySet_getPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_get(context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_get.
     * @param result The asynchronous result object for the invocation.
     * @return The sequence of Ice identities for this set.
     */
    ICE_MEMBER(GLACIER2_API) ::Ice::IdentitySeq end_get(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(GLACIER2_API) ::Ice::AsyncResultPtr _iceI_begin_get(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Obtains the Slice type ID corresponding to this interface.
     * @return A fully-scoped type ID.
     */
    ICE_MEMBER(GLACIER2_API) static const ::std::string& ice_staticId();

protected:
    /// \cond INTERNAL

    ICE_MEMBER(GLACIER2_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
    /// \endcond
};

class ICE_CLASS(GLACIER2_API) SessionControl : public virtual ::Ice::Proxy<SessionControl, ::IceProxy::Ice::Object>
{
public:

    /**
     * Access the object that manages the allowable categories
     * for object identities for this session.
     * @param context The Context map to send with the invocation.
     * @return A StringSet object.
     */
    ICE_MEMBER(GLACIER2_API) ::Glacier2::StringSetPrx categories(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_categories(_iceI_begin_categories(context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Access the object that manages the allowable categories
     * for object identities for this session.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_categories(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_categories(context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Access the object that manages the allowable categories
     * for object identities for this session.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_categories(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_categories(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Access the object that manages the allowable categories
     * for object identities for this session.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_categories(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_categories(context, cb, cookie);
    }

    /**
     * Access the object that manages the allowable categories
     * for object identities for this session.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_categories(const ::Glacier2::Callback_SessionControl_categoriesPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_categories(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Access the object that manages the allowable categories
     * for object identities for this session.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_categories(const ::Ice::Context& context, const ::Glacier2::Callback_SessionControl_categoriesPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_categories(context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_categories.
     * @param result The asynchronous result object for the invocation.
     * @return A StringSet object.
     */
    ICE_MEMBER(GLACIER2_API) ::Glacier2::StringSetPrx end_categories(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(GLACIER2_API) ::Ice::AsyncResultPtr _iceI_begin_categories(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Access the object that manages the allowable adapter identities
     * for objects for this session.
     * @param context The Context map to send with the invocation.
     * @return A StringSet object.
     */
    ICE_MEMBER(GLACIER2_API) ::Glacier2::StringSetPrx adapterIds(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_adapterIds(_iceI_begin_adapterIds(context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Access the object that manages the allowable adapter identities
     * for objects for this session.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_adapterIds(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_adapterIds(context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Access the object that manages the allowable adapter identities
     * for objects for this session.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_adapterIds(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_adapterIds(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Access the object that manages the allowable adapter identities
     * for objects for this session.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_adapterIds(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_adapterIds(context, cb, cookie);
    }

    /**
     * Access the object that manages the allowable adapter identities
     * for objects for this session.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_adapterIds(const ::Glacier2::Callback_SessionControl_adapterIdsPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_adapterIds(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Access the object that manages the allowable adapter identities
     * for objects for this session.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_adapterIds(const ::Ice::Context& context, const ::Glacier2::Callback_SessionControl_adapterIdsPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_adapterIds(context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_adapterIds.
     * @param result The asynchronous result object for the invocation.
     * @return A StringSet object.
     */
    ICE_MEMBER(GLACIER2_API) ::Glacier2::StringSetPrx end_adapterIds(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(GLACIER2_API) ::Ice::AsyncResultPtr _iceI_begin_adapterIds(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Access the object that manages the allowable object identities
     * for this session.
     * @param context The Context map to send with the invocation.
     * @return An IdentitySet object.
     */
    ICE_MEMBER(GLACIER2_API) ::Glacier2::IdentitySetPrx identities(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_identities(_iceI_begin_identities(context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Access the object that manages the allowable object identities
     * for this session.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_identities(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_identities(context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Access the object that manages the allowable object identities
     * for this session.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_identities(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_identities(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Access the object that manages the allowable object identities
     * for this session.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_identities(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_identities(context, cb, cookie);
    }

    /**
     * Access the object that manages the allowable object identities
     * for this session.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_identities(const ::Glacier2::Callback_SessionControl_identitiesPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_identities(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Access the object that manages the allowable object identities
     * for this session.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_identities(const ::Ice::Context& context, const ::Glacier2::Callback_SessionControl_identitiesPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_identities(context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_identities.
     * @param result The asynchronous result object for the invocation.
     * @return An IdentitySet object.
     */
    ICE_MEMBER(GLACIER2_API) ::Glacier2::IdentitySetPrx end_identities(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(GLACIER2_API) ::Ice::AsyncResultPtr _iceI_begin_identities(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Get the session timeout.
     * @param context The Context map to send with the invocation.
     * @return The timeout.
     */
    ICE_MEMBER(GLACIER2_API) ::Ice::Int getSessionTimeout(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getSessionTimeout(_iceI_begin_getSessionTimeout(context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Get the session timeout.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getSessionTimeout(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getSessionTimeout(context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Get the session timeout.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getSessionTimeout(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getSessionTimeout(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get the session timeout.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getSessionTimeout(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getSessionTimeout(context, cb, cookie);
    }

    /**
     * Get the session timeout.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getSessionTimeout(const ::Glacier2::Callback_SessionControl_getSessionTimeoutPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getSessionTimeout(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get the session timeout.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getSessionTimeout(const ::Ice::Context& context, const ::Glacier2::Callback_SessionControl_getSessionTimeoutPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getSessionTimeout(context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getSessionTimeout.
     * @param result The asynchronous result object for the invocation.
     * @return The timeout.
     */
    ICE_MEMBER(GLACIER2_API) ::Ice::Int end_getSessionTimeout(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(GLACIER2_API) ::Ice::AsyncResultPtr _iceI_begin_getSessionTimeout(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Destroy the associated session.
     * @param context The Context map to send with the invocation.
     */
    ICE_MEMBER(GLACIER2_API) void destroy(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_destroy(_iceI_begin_destroy(context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Destroy the associated session.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_destroy(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_destroy(context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Destroy the associated session.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_destroy(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_destroy(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Destroy the associated session.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_destroy(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_destroy(context, cb, cookie);
    }

    /**
     * Destroy the associated session.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_destroy(const ::Glacier2::Callback_SessionControl_destroyPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_destroy(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Destroy the associated session.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_destroy(const ::Ice::Context& context, const ::Glacier2::Callback_SessionControl_destroyPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_destroy(context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_destroy.
     * @param result The asynchronous result object for the invocation.
     */
    ICE_MEMBER(GLACIER2_API) void end_destroy(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(GLACIER2_API) ::Ice::AsyncResultPtr _iceI_begin_destroy(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Obtains the Slice type ID corresponding to this interface.
     * @return A fully-scoped type ID.
     */
    ICE_MEMBER(GLACIER2_API) static const ::std::string& ice_staticId();

protected:
    /// \cond INTERNAL

    ICE_MEMBER(GLACIER2_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
    /// \endcond
};

class ICE_CLASS(GLACIER2_API) SessionManager : public virtual ::Ice::Proxy<SessionManager, ::IceProxy::Ice::Object>
{
public:

    /**
     * Create a new session.
     * @param userId The user id for the session.
     * @param control A proxy to the session control object.
     * @param context The Context map to send with the invocation.
     * @return A proxy to the newly created session.
     * @throws Glacier2::CannotCreateSessionException Raised if the session
     * cannot be created.
     */
    ICE_MEMBER(GLACIER2_API) ::Glacier2::SessionPrx create(const ::std::string& userId, const ::Glacier2::SessionControlPrx& control, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_create(_iceI_begin_create(userId, control, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Create a new session.
     * @param userId The user id for the session.
     * @param control A proxy to the session control object.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_create(const ::std::string& userId, const ::Glacier2::SessionControlPrx& control, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_create(userId, control, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Create a new session.
     * @param userId The user id for the session.
     * @param control A proxy to the session control object.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_create(const ::std::string& userId, const ::Glacier2::SessionControlPrx& control, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_create(userId, control, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Create a new session.
     * @param userId The user id for the session.
     * @param control A proxy to the session control object.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_create(const ::std::string& userId, const ::Glacier2::SessionControlPrx& control, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_create(userId, control, context, cb, cookie);
    }

    /**
     * Create a new session.
     * @param userId The user id for the session.
     * @param control A proxy to the session control object.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_create(const ::std::string& userId, const ::Glacier2::SessionControlPrx& control, const ::Glacier2::Callback_SessionManager_createPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_create(userId, control, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Create a new session.
     * @param userId The user id for the session.
     * @param control A proxy to the session control object.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_create(const ::std::string& userId, const ::Glacier2::SessionControlPrx& control, const ::Ice::Context& context, const ::Glacier2::Callback_SessionManager_createPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_create(userId, control, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_create.
     * @param result The asynchronous result object for the invocation.
     * @return A proxy to the newly created session.
     * @throws Glacier2::CannotCreateSessionException Raised if the session
     * cannot be created.
     */
    ICE_MEMBER(GLACIER2_API) ::Glacier2::SessionPrx end_create(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(GLACIER2_API) ::Ice::AsyncResultPtr _iceI_begin_create(const ::std::string&, const ::Glacier2::SessionControlPrx&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Obtains the Slice type ID corresponding to this interface.
     * @return A fully-scoped type ID.
     */
    ICE_MEMBER(GLACIER2_API) static const ::std::string& ice_staticId();

protected:
    /// \cond INTERNAL

    ICE_MEMBER(GLACIER2_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
    /// \endcond
};

class ICE_CLASS(GLACIER2_API) SSLSessionManager : public virtual ::Ice::Proxy<SSLSessionManager, ::IceProxy::Ice::Object>
{
public:

    /**
     * Create a new session.
     * @param info The SSL info.
     * @param control A proxy to the session control object.
     * @param context The Context map to send with the invocation.
     * @return A proxy to the newly created session.
     * @throws Glacier2::CannotCreateSessionException Raised if the session
     * cannot be created.
     */
    ICE_MEMBER(GLACIER2_API) ::Glacier2::SessionPrx create(const ::Glacier2::SSLInfo& info, const ::Glacier2::SessionControlPrx& control, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_create(_iceI_begin_create(info, control, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Create a new session.
     * @param info The SSL info.
     * @param control A proxy to the session control object.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_create(const ::Glacier2::SSLInfo& info, const ::Glacier2::SessionControlPrx& control, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_create(info, control, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Create a new session.
     * @param info The SSL info.
     * @param control A proxy to the session control object.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_create(const ::Glacier2::SSLInfo& info, const ::Glacier2::SessionControlPrx& control, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_create(info, control, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Create a new session.
     * @param info The SSL info.
     * @param control A proxy to the session control object.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_create(const ::Glacier2::SSLInfo& info, const ::Glacier2::SessionControlPrx& control, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_create(info, control, context, cb, cookie);
    }

    /**
     * Create a new session.
     * @param info The SSL info.
     * @param control A proxy to the session control object.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_create(const ::Glacier2::SSLInfo& info, const ::Glacier2::SessionControlPrx& control, const ::Glacier2::Callback_SSLSessionManager_createPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_create(info, control, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Create a new session.
     * @param info The SSL info.
     * @param control A proxy to the session control object.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_create(const ::Glacier2::SSLInfo& info, const ::Glacier2::SessionControlPrx& control, const ::Ice::Context& context, const ::Glacier2::Callback_SSLSessionManager_createPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_create(info, control, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_create.
     * @param result The asynchronous result object for the invocation.
     * @return A proxy to the newly created session.
     * @throws Glacier2::CannotCreateSessionException Raised if the session
     * cannot be created.
     */
    ICE_MEMBER(GLACIER2_API) ::Glacier2::SessionPrx end_create(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(GLACIER2_API) ::Ice::AsyncResultPtr _iceI_begin_create(const ::Glacier2::SSLInfo&, const ::Glacier2::SessionControlPrx&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Obtains the Slice type ID corresponding to this interface.
     * @return A fully-scoped type ID.
     */
    ICE_MEMBER(GLACIER2_API) static const ::std::string& ice_staticId();

protected:
    /// \cond INTERNAL

    ICE_MEMBER(GLACIER2_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
    /// \endcond
};

}

}

namespace Glacier2
{

/**
 * A client-visible session object, which is tied to the lifecycle of a {@link Router}.
 * @see Router
 * @see SessionManager
 * \headerfile Glacier2/Glacier2.h
 */
class GLACIER2_API Session : public virtual ::Ice::Object
{
public:

    typedef SessionPrx ProxyType;
    typedef SessionPtr PointerType;

    virtual ~Session();

#ifdef ICE_CPP11_COMPILER
    Session() = default;
    Session(const Session&) = default;
    Session& operator=(const Session&) = default;
#endif

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(const ::std::string& id, const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual const ::std::string& ice_id(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Destroy the session. This is called automatically when the router is destroyed.
     * @param current The Current object for the invocation.
     */
    virtual void destroy(const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_destroy(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

protected:

    /// \cond STREAM
    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
    /// \endcond
};

/// \cond INTERNAL
inline bool operator==(const Session& lhs, const Session& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const Session& lhs, const Session& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}
/// \endcond

/**
 * An object for managing the set of identity constraints for specific
 * parts of object identity on a
 * {@link Session}.
 * @see Session
 * @see SessionControl
 * \headerfile Glacier2/Glacier2.h
 */
class GLACIER2_API StringSet : public virtual ::Ice::Object
{
public:

    typedef StringSetPrx ProxyType;
    typedef StringSetPtr PointerType;

    virtual ~StringSet();

#ifdef ICE_CPP11_COMPILER
    StringSet() = default;
    StringSet(const StringSet&) = default;
    StringSet& operator=(const StringSet&) = default;
#endif

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(const ::std::string& id, const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual const ::std::string& ice_id(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Add a sequence of strings to this set of constraints. Order is
     * not preserved and duplicates are implicitly removed.
     * @param additions The sequence of strings to be added.
     * @param current The Current object for the invocation.
     */
    virtual void add(const ::Ice::StringSeq& additions, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_add(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Remove a sequence of strings from this set of constraints. No
     * errors are returned if an entry is not found.
     * @param deletions The sequence of strings to be removed.
     * @param current The Current object for the invocation.
     */
    virtual void remove(const ::Ice::StringSeq& deletions, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_remove(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Returns a sequence of strings describing the constraints in this
     * set.
     * @param current The Current object for the invocation.
     * @return The sequence of strings for this set.
     */
    virtual ::Ice::StringSeq get(const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_get(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

protected:

    /// \cond STREAM
    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
    /// \endcond
};

/// \cond INTERNAL
inline bool operator==(const StringSet& lhs, const StringSet& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const StringSet& lhs, const StringSet& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}
/// \endcond

/**
 * An object for managing the set of object identity constraints on a
 * {@link Session}.
 * @see Session
 * @see SessionControl
 * \headerfile Glacier2/Glacier2.h
 */
class GLACIER2_API IdentitySet : public virtual ::Ice::Object
{
public:

    typedef IdentitySetPrx ProxyType;
    typedef IdentitySetPtr PointerType;

    virtual ~IdentitySet();

#ifdef ICE_CPP11_COMPILER
    IdentitySet() = default;
    IdentitySet(const IdentitySet&) = default;
    IdentitySet& operator=(const IdentitySet&) = default;
#endif

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(const ::std::string& id, const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual const ::std::string& ice_id(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Add a sequence of Ice identities to this set of constraints. Order is
     * not preserved and duplicates are implicitly removed.
     * @param additions The sequence of Ice identities to be added.
     * @param current The Current object for the invocation.
     */
    virtual void add(const ::Ice::IdentitySeq& additions, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_add(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Remove a sequence of identities from this set of constraints. No
     * errors are returned if an entry is not found.
     * @param deletions The sequence of Ice identities to be removed.
     * @param current The Current object for the invocation.
     */
    virtual void remove(const ::Ice::IdentitySeq& deletions, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_remove(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Returns a sequence of identities describing the constraints in this
     * set.
     * @param current The Current object for the invocation.
     * @return The sequence of Ice identities for this set.
     */
    virtual ::Ice::IdentitySeq get(const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_get(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

protected:

    /// \cond STREAM
    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
    /// \endcond
};

/// \cond INTERNAL
inline bool operator==(const IdentitySet& lhs, const IdentitySet& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const IdentitySet& lhs, const IdentitySet& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}
/// \endcond

/**
 * An administrative session control object, which is tied to the
 * lifecycle of a {@link Session}.
 * @see Session
 * \headerfile Glacier2/Glacier2.h
 */
class GLACIER2_API SessionControl : public virtual ::Ice::Object
{
public:

    typedef SessionControlPrx ProxyType;
    typedef SessionControlPtr PointerType;

    virtual ~SessionControl();

#ifdef ICE_CPP11_COMPILER
    SessionControl() = default;
    SessionControl(const SessionControl&) = default;
    SessionControl& operator=(const SessionControl&) = default;
#endif

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(const ::std::string& id, const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual const ::std::string& ice_id(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Access the object that manages the allowable categories
     * for object identities for this session.
     * @param current The Current object for the invocation.
     * @return A StringSet object.
     */
    virtual StringSetPrx categories(const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_categories(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Access the object that manages the allowable adapter identities
     * for objects for this session.
     * @param current The Current object for the invocation.
     * @return A StringSet object.
     */
    virtual StringSetPrx adapterIds(const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_adapterIds(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Access the object that manages the allowable object identities
     * for this session.
     * @param current The Current object for the invocation.
     * @return An IdentitySet object.
     */
    virtual IdentitySetPrx identities(const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_identities(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Get the session timeout.
     * @param current The Current object for the invocation.
     * @return The timeout.
     */
    virtual ::Ice::Int getSessionTimeout(const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_getSessionTimeout(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Destroy the associated session.
     * @param current The Current object for the invocation.
     */
    virtual void destroy(const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_destroy(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

protected:

    /// \cond STREAM
    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
    /// \endcond
};

/// \cond INTERNAL
inline bool operator==(const SessionControl& lhs, const SessionControl& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const SessionControl& lhs, const SessionControl& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}
/// \endcond

/**
 * The session manager for username/password authenticated users that
 * is responsible for managing {@link Session} objects. New session objects
 * are created by the {@link Router} object calling on an application-provided
 * session manager. If no session manager is provided by the application,
 * no client-visible sessions are passed to the client.
 * @see Router
 * @see Session
 * \headerfile Glacier2/Glacier2.h
 */
class GLACIER2_API SessionManager : public virtual ::Ice::Object
{
public:

    typedef SessionManagerPrx ProxyType;
    typedef SessionManagerPtr PointerType;

    virtual ~SessionManager();

#ifdef ICE_CPP11_COMPILER
    SessionManager() = default;
    SessionManager(const SessionManager&) = default;
    SessionManager& operator=(const SessionManager&) = default;
#endif

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(const ::std::string& id, const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual const ::std::string& ice_id(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Create a new session.
     * @param userId The user id for the session.
     * @param control A proxy to the session control object.
     * @param current The Current object for the invocation.
     * @return A proxy to the newly created session.
     * @throws Glacier2::CannotCreateSessionException Raised if the session
     * cannot be created.
     */
    virtual SessionPrx create(const ::std::string& userId, const SessionControlPrx& control, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_create(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

protected:

    /// \cond STREAM
    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
    /// \endcond
};

/// \cond INTERNAL
inline bool operator==(const SessionManager& lhs, const SessionManager& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const SessionManager& lhs, const SessionManager& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}
/// \endcond

/**
 * The session manager for SSL authenticated users that is
 * responsible for managing {@link Session} objects. New session objects are
 * created by the {@link Router} object calling on an application-provided
 * session manager. If no session manager is provided by the
 * application, no client-visible sessions are passed to the client.
 * @see Router
 * @see Session
 * \headerfile Glacier2/Glacier2.h
 */
class GLACIER2_API SSLSessionManager : public virtual ::Ice::Object
{
public:

    typedef SSLSessionManagerPrx ProxyType;
    typedef SSLSessionManagerPtr PointerType;

    virtual ~SSLSessionManager();

#ifdef ICE_CPP11_COMPILER
    SSLSessionManager() = default;
    SSLSessionManager(const SSLSessionManager&) = default;
    SSLSessionManager& operator=(const SSLSessionManager&) = default;
#endif

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(const ::std::string& id, const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual const ::std::string& ice_id(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Create a new session.
     * @param info The SSL info.
     * @param control A proxy to the session control object.
     * @param current The Current object for the invocation.
     * @return A proxy to the newly created session.
     * @throws Glacier2::CannotCreateSessionException Raised if the session
     * cannot be created.
     */
    virtual SessionPrx create(const SSLInfo& info, const SessionControlPrx& control, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_create(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

protected:

    /// \cond STREAM
    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
    /// \endcond
};

/// \cond INTERNAL
inline bool operator==(const SSLSessionManager& lhs, const SSLSessionManager& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const SSLSessionManager& lhs, const SSLSessionManager& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}
/// \endcond

}

/// \cond STREAM
namespace Ice
{

template<>
struct StreamableTraits< ::Glacier2::CannotCreateSessionException>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

template<typename S>
struct StreamWriter< ::Glacier2::CannotCreateSessionException, S>
{
    static void write(S* ostr, const ::Glacier2::CannotCreateSessionException& v)
    {
        ostr->write(v.reason);
    }
};

template<typename S>
struct StreamReader< ::Glacier2::CannotCreateSessionException, S>
{
    static void read(S* istr, ::Glacier2::CannotCreateSessionException& v)
    {
        istr->read(v.reason);
    }
};

}
/// \endcond

namespace Glacier2
{

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::Glacier2::Session::begin_destroy.
 * Create a wrapper instance by calling ::Glacier2::newCallback_Session_destroy.
 */
template<class T>
class CallbackNC_Session_destroy : public Callback_Session_destroy_Base, public ::IceInternal::OnewayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_Session_destroy(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallbackNC<T>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::Session::begin_destroy.
 */
template<class T> Callback_Session_destroyPtr
newCallback_Session_destroy(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Session_destroy<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::Session::begin_destroy.
 */
template<class T> Callback_Session_destroyPtr
newCallback_Session_destroy(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Session_destroy<T>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::Session::begin_destroy.
 */
template<class T> Callback_Session_destroyPtr
newCallback_Session_destroy(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Session_destroy<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::Session::begin_destroy.
 */
template<class T> Callback_Session_destroyPtr
newCallback_Session_destroy(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Session_destroy<T>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::Glacier2::Session::begin_destroy.
 * Create a wrapper instance by calling ::Glacier2::newCallback_Session_destroy.
 */
template<class T, typename CT>
class Callback_Session_destroy : public Callback_Session_destroy_Base, public ::IceInternal::OnewayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_Session_destroy(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallback<T, CT>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::Session::begin_destroy.
 */
template<class T, typename CT> Callback_Session_destroyPtr
newCallback_Session_destroy(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Session_destroy<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::Session::begin_destroy.
 */
template<class T, typename CT> Callback_Session_destroyPtr
newCallback_Session_destroy(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Session_destroy<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::Session::begin_destroy.
 */
template<class T, typename CT> Callback_Session_destroyPtr
newCallback_Session_destroy(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Session_destroy<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::Session::begin_destroy.
 */
template<class T, typename CT> Callback_Session_destroyPtr
newCallback_Session_destroy(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Session_destroy<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::Glacier2::StringSet::begin_add.
 * Create a wrapper instance by calling ::Glacier2::newCallback_StringSet_add.
 */
template<class T>
class CallbackNC_StringSet_add : public Callback_StringSet_add_Base, public ::IceInternal::OnewayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_StringSet_add(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallbackNC<T>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::StringSet::begin_add.
 */
template<class T> Callback_StringSet_addPtr
newCallback_StringSet_add(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_StringSet_add<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::StringSet::begin_add.
 */
template<class T> Callback_StringSet_addPtr
newCallback_StringSet_add(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_StringSet_add<T>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::StringSet::begin_add.
 */
template<class T> Callback_StringSet_addPtr
newCallback_StringSet_add(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_StringSet_add<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::StringSet::begin_add.
 */
template<class T> Callback_StringSet_addPtr
newCallback_StringSet_add(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_StringSet_add<T>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::Glacier2::StringSet::begin_add.
 * Create a wrapper instance by calling ::Glacier2::newCallback_StringSet_add.
 */
template<class T, typename CT>
class Callback_StringSet_add : public Callback_StringSet_add_Base, public ::IceInternal::OnewayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_StringSet_add(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallback<T, CT>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::StringSet::begin_add.
 */
template<class T, typename CT> Callback_StringSet_addPtr
newCallback_StringSet_add(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_StringSet_add<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::StringSet::begin_add.
 */
template<class T, typename CT> Callback_StringSet_addPtr
newCallback_StringSet_add(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_StringSet_add<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::StringSet::begin_add.
 */
template<class T, typename CT> Callback_StringSet_addPtr
newCallback_StringSet_add(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_StringSet_add<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::StringSet::begin_add.
 */
template<class T, typename CT> Callback_StringSet_addPtr
newCallback_StringSet_add(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_StringSet_add<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::Glacier2::StringSet::begin_remove.
 * Create a wrapper instance by calling ::Glacier2::newCallback_StringSet_remove.
 */
template<class T>
class CallbackNC_StringSet_remove : public Callback_StringSet_remove_Base, public ::IceInternal::OnewayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_StringSet_remove(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallbackNC<T>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::StringSet::begin_remove.
 */
template<class T> Callback_StringSet_removePtr
newCallback_StringSet_remove(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_StringSet_remove<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::StringSet::begin_remove.
 */
template<class T> Callback_StringSet_removePtr
newCallback_StringSet_remove(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_StringSet_remove<T>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::StringSet::begin_remove.
 */
template<class T> Callback_StringSet_removePtr
newCallback_StringSet_remove(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_StringSet_remove<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::StringSet::begin_remove.
 */
template<class T> Callback_StringSet_removePtr
newCallback_StringSet_remove(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_StringSet_remove<T>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::Glacier2::StringSet::begin_remove.
 * Create a wrapper instance by calling ::Glacier2::newCallback_StringSet_remove.
 */
template<class T, typename CT>
class Callback_StringSet_remove : public Callback_StringSet_remove_Base, public ::IceInternal::OnewayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_StringSet_remove(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallback<T, CT>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::StringSet::begin_remove.
 */
template<class T, typename CT> Callback_StringSet_removePtr
newCallback_StringSet_remove(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_StringSet_remove<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::StringSet::begin_remove.
 */
template<class T, typename CT> Callback_StringSet_removePtr
newCallback_StringSet_remove(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_StringSet_remove<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::StringSet::begin_remove.
 */
template<class T, typename CT> Callback_StringSet_removePtr
newCallback_StringSet_remove(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_StringSet_remove<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::StringSet::begin_remove.
 */
template<class T, typename CT> Callback_StringSet_removePtr
newCallback_StringSet_remove(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_StringSet_remove<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::Glacier2::StringSet::begin_get.
 * Create a wrapper instance by calling ::Glacier2::newCallback_StringSet_get.
 */
template<class T>
class CallbackNC_StringSet_get : public Callback_StringSet_get_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::Ice::StringSeq&);

    CallbackNC_StringSet_get(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        StringSetPrx proxy = StringSetPrx::uncheckedCast(result->getProxy());
        ::Ice::StringSeq ret;
        try
        {
            ret = proxy->end_get(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::StringSet::begin_get.
 */
template<class T> Callback_StringSet_getPtr
newCallback_StringSet_get(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::StringSeq&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_StringSet_get<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::StringSet::begin_get.
 */
template<class T> Callback_StringSet_getPtr
newCallback_StringSet_get(T* instance, void (T::*cb)(const ::Ice::StringSeq&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_StringSet_get<T>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::Glacier2::StringSet::begin_get.
 * Create a wrapper instance by calling ::Glacier2::newCallback_StringSet_get.
 */
template<class T, typename CT>
class Callback_StringSet_get : public Callback_StringSet_get_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::Ice::StringSeq&, const CT&);

    Callback_StringSet_get(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        StringSetPrx proxy = StringSetPrx::uncheckedCast(result->getProxy());
        ::Ice::StringSeq ret;
        try
        {
            ret = proxy->end_get(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::StringSet::begin_get.
 */
template<class T, typename CT> Callback_StringSet_getPtr
newCallback_StringSet_get(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::StringSeq&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_StringSet_get<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::StringSet::begin_get.
 */
template<class T, typename CT> Callback_StringSet_getPtr
newCallback_StringSet_get(T* instance, void (T::*cb)(const ::Ice::StringSeq&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_StringSet_get<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::Glacier2::IdentitySet::begin_add.
 * Create a wrapper instance by calling ::Glacier2::newCallback_IdentitySet_add.
 */
template<class T>
class CallbackNC_IdentitySet_add : public Callback_IdentitySet_add_Base, public ::IceInternal::OnewayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_IdentitySet_add(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallbackNC<T>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::IdentitySet::begin_add.
 */
template<class T> Callback_IdentitySet_addPtr
newCallback_IdentitySet_add(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_IdentitySet_add<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::IdentitySet::begin_add.
 */
template<class T> Callback_IdentitySet_addPtr
newCallback_IdentitySet_add(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_IdentitySet_add<T>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::IdentitySet::begin_add.
 */
template<class T> Callback_IdentitySet_addPtr
newCallback_IdentitySet_add(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_IdentitySet_add<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::IdentitySet::begin_add.
 */
template<class T> Callback_IdentitySet_addPtr
newCallback_IdentitySet_add(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_IdentitySet_add<T>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::Glacier2::IdentitySet::begin_add.
 * Create a wrapper instance by calling ::Glacier2::newCallback_IdentitySet_add.
 */
template<class T, typename CT>
class Callback_IdentitySet_add : public Callback_IdentitySet_add_Base, public ::IceInternal::OnewayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_IdentitySet_add(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallback<T, CT>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::IdentitySet::begin_add.
 */
template<class T, typename CT> Callback_IdentitySet_addPtr
newCallback_IdentitySet_add(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_IdentitySet_add<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::IdentitySet::begin_add.
 */
template<class T, typename CT> Callback_IdentitySet_addPtr
newCallback_IdentitySet_add(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_IdentitySet_add<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::IdentitySet::begin_add.
 */
template<class T, typename CT> Callback_IdentitySet_addPtr
newCallback_IdentitySet_add(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_IdentitySet_add<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::IdentitySet::begin_add.
 */
template<class T, typename CT> Callback_IdentitySet_addPtr
newCallback_IdentitySet_add(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_IdentitySet_add<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::Glacier2::IdentitySet::begin_remove.
 * Create a wrapper instance by calling ::Glacier2::newCallback_IdentitySet_remove.
 */
template<class T>
class CallbackNC_IdentitySet_remove : public Callback_IdentitySet_remove_Base, public ::IceInternal::OnewayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_IdentitySet_remove(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallbackNC<T>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::IdentitySet::begin_remove.
 */
template<class T> Callback_IdentitySet_removePtr
newCallback_IdentitySet_remove(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_IdentitySet_remove<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::IdentitySet::begin_remove.
 */
template<class T> Callback_IdentitySet_removePtr
newCallback_IdentitySet_remove(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_IdentitySet_remove<T>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::IdentitySet::begin_remove.
 */
template<class T> Callback_IdentitySet_removePtr
newCallback_IdentitySet_remove(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_IdentitySet_remove<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::IdentitySet::begin_remove.
 */
template<class T> Callback_IdentitySet_removePtr
newCallback_IdentitySet_remove(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_IdentitySet_remove<T>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::Glacier2::IdentitySet::begin_remove.
 * Create a wrapper instance by calling ::Glacier2::newCallback_IdentitySet_remove.
 */
template<class T, typename CT>
class Callback_IdentitySet_remove : public Callback_IdentitySet_remove_Base, public ::IceInternal::OnewayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_IdentitySet_remove(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallback<T, CT>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::IdentitySet::begin_remove.
 */
template<class T, typename CT> Callback_IdentitySet_removePtr
newCallback_IdentitySet_remove(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_IdentitySet_remove<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::IdentitySet::begin_remove.
 */
template<class T, typename CT> Callback_IdentitySet_removePtr
newCallback_IdentitySet_remove(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_IdentitySet_remove<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::IdentitySet::begin_remove.
 */
template<class T, typename CT> Callback_IdentitySet_removePtr
newCallback_IdentitySet_remove(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_IdentitySet_remove<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::IdentitySet::begin_remove.
 */
template<class T, typename CT> Callback_IdentitySet_removePtr
newCallback_IdentitySet_remove(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_IdentitySet_remove<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::Glacier2::IdentitySet::begin_get.
 * Create a wrapper instance by calling ::Glacier2::newCallback_IdentitySet_get.
 */
template<class T>
class CallbackNC_IdentitySet_get : public Callback_IdentitySet_get_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::Ice::IdentitySeq&);

    CallbackNC_IdentitySet_get(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        IdentitySetPrx proxy = IdentitySetPrx::uncheckedCast(result->getProxy());
        ::Ice::IdentitySeq ret;
        try
        {
            ret = proxy->end_get(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::IdentitySet::begin_get.
 */
template<class T> Callback_IdentitySet_getPtr
newCallback_IdentitySet_get(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::IdentitySeq&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_IdentitySet_get<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::IdentitySet::begin_get.
 */
template<class T> Callback_IdentitySet_getPtr
newCallback_IdentitySet_get(T* instance, void (T::*cb)(const ::Ice::IdentitySeq&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_IdentitySet_get<T>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::Glacier2::IdentitySet::begin_get.
 * Create a wrapper instance by calling ::Glacier2::newCallback_IdentitySet_get.
 */
template<class T, typename CT>
class Callback_IdentitySet_get : public Callback_IdentitySet_get_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::Ice::IdentitySeq&, const CT&);

    Callback_IdentitySet_get(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        IdentitySetPrx proxy = IdentitySetPrx::uncheckedCast(result->getProxy());
        ::Ice::IdentitySeq ret;
        try
        {
            ret = proxy->end_get(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::IdentitySet::begin_get.
 */
template<class T, typename CT> Callback_IdentitySet_getPtr
newCallback_IdentitySet_get(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::IdentitySeq&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_IdentitySet_get<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::IdentitySet::begin_get.
 */
template<class T, typename CT> Callback_IdentitySet_getPtr
newCallback_IdentitySet_get(T* instance, void (T::*cb)(const ::Ice::IdentitySeq&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_IdentitySet_get<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::Glacier2::SessionControl::begin_categories.
 * Create a wrapper instance by calling ::Glacier2::newCallback_SessionControl_categories.
 */
template<class T>
class CallbackNC_SessionControl_categories : public Callback_SessionControl_categories_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const StringSetPrx&);

    CallbackNC_SessionControl_categories(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        SessionControlPrx proxy = SessionControlPrx::uncheckedCast(result->getProxy());
        StringSetPrx ret;
        try
        {
            ret = proxy->end_categories(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::SessionControl::begin_categories.
 */
template<class T> Callback_SessionControl_categoriesPtr
newCallback_SessionControl_categories(const IceUtil::Handle<T>& instance, void (T::*cb)(const StringSetPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_SessionControl_categories<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::SessionControl::begin_categories.
 */
template<class T> Callback_SessionControl_categoriesPtr
newCallback_SessionControl_categories(T* instance, void (T::*cb)(const StringSetPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_SessionControl_categories<T>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::Glacier2::SessionControl::begin_categories.
 * Create a wrapper instance by calling ::Glacier2::newCallback_SessionControl_categories.
 */
template<class T, typename CT>
class Callback_SessionControl_categories : public Callback_SessionControl_categories_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const StringSetPrx&, const CT&);

    Callback_SessionControl_categories(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        SessionControlPrx proxy = SessionControlPrx::uncheckedCast(result->getProxy());
        StringSetPrx ret;
        try
        {
            ret = proxy->end_categories(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::SessionControl::begin_categories.
 */
template<class T, typename CT> Callback_SessionControl_categoriesPtr
newCallback_SessionControl_categories(const IceUtil::Handle<T>& instance, void (T::*cb)(const StringSetPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_SessionControl_categories<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::SessionControl::begin_categories.
 */
template<class T, typename CT> Callback_SessionControl_categoriesPtr
newCallback_SessionControl_categories(T* instance, void (T::*cb)(const StringSetPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_SessionControl_categories<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::Glacier2::SessionControl::begin_adapterIds.
 * Create a wrapper instance by calling ::Glacier2::newCallback_SessionControl_adapterIds.
 */
template<class T>
class CallbackNC_SessionControl_adapterIds : public Callback_SessionControl_adapterIds_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const StringSetPrx&);

    CallbackNC_SessionControl_adapterIds(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        SessionControlPrx proxy = SessionControlPrx::uncheckedCast(result->getProxy());
        StringSetPrx ret;
        try
        {
            ret = proxy->end_adapterIds(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::SessionControl::begin_adapterIds.
 */
template<class T> Callback_SessionControl_adapterIdsPtr
newCallback_SessionControl_adapterIds(const IceUtil::Handle<T>& instance, void (T::*cb)(const StringSetPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_SessionControl_adapterIds<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::SessionControl::begin_adapterIds.
 */
template<class T> Callback_SessionControl_adapterIdsPtr
newCallback_SessionControl_adapterIds(T* instance, void (T::*cb)(const StringSetPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_SessionControl_adapterIds<T>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::Glacier2::SessionControl::begin_adapterIds.
 * Create a wrapper instance by calling ::Glacier2::newCallback_SessionControl_adapterIds.
 */
template<class T, typename CT>
class Callback_SessionControl_adapterIds : public Callback_SessionControl_adapterIds_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const StringSetPrx&, const CT&);

    Callback_SessionControl_adapterIds(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        SessionControlPrx proxy = SessionControlPrx::uncheckedCast(result->getProxy());
        StringSetPrx ret;
        try
        {
            ret = proxy->end_adapterIds(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::SessionControl::begin_adapterIds.
 */
template<class T, typename CT> Callback_SessionControl_adapterIdsPtr
newCallback_SessionControl_adapterIds(const IceUtil::Handle<T>& instance, void (T::*cb)(const StringSetPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_SessionControl_adapterIds<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::SessionControl::begin_adapterIds.
 */
template<class T, typename CT> Callback_SessionControl_adapterIdsPtr
newCallback_SessionControl_adapterIds(T* instance, void (T::*cb)(const StringSetPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_SessionControl_adapterIds<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::Glacier2::SessionControl::begin_identities.
 * Create a wrapper instance by calling ::Glacier2::newCallback_SessionControl_identities.
 */
template<class T>
class CallbackNC_SessionControl_identities : public Callback_SessionControl_identities_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const IdentitySetPrx&);

    CallbackNC_SessionControl_identities(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        SessionControlPrx proxy = SessionControlPrx::uncheckedCast(result->getProxy());
        IdentitySetPrx ret;
        try
        {
            ret = proxy->end_identities(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::SessionControl::begin_identities.
 */
template<class T> Callback_SessionControl_identitiesPtr
newCallback_SessionControl_identities(const IceUtil::Handle<T>& instance, void (T::*cb)(const IdentitySetPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_SessionControl_identities<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::SessionControl::begin_identities.
 */
template<class T> Callback_SessionControl_identitiesPtr
newCallback_SessionControl_identities(T* instance, void (T::*cb)(const IdentitySetPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_SessionControl_identities<T>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::Glacier2::SessionControl::begin_identities.
 * Create a wrapper instance by calling ::Glacier2::newCallback_SessionControl_identities.
 */
template<class T, typename CT>
class Callback_SessionControl_identities : public Callback_SessionControl_identities_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const IdentitySetPrx&, const CT&);

    Callback_SessionControl_identities(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        SessionControlPrx proxy = SessionControlPrx::uncheckedCast(result->getProxy());
        IdentitySetPrx ret;
        try
        {
            ret = proxy->end_identities(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::SessionControl::begin_identities.
 */
template<class T, typename CT> Callback_SessionControl_identitiesPtr
newCallback_SessionControl_identities(const IceUtil::Handle<T>& instance, void (T::*cb)(const IdentitySetPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_SessionControl_identities<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::SessionControl::begin_identities.
 */
template<class T, typename CT> Callback_SessionControl_identitiesPtr
newCallback_SessionControl_identities(T* instance, void (T::*cb)(const IdentitySetPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_SessionControl_identities<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::Glacier2::SessionControl::begin_getSessionTimeout.
 * Create a wrapper instance by calling ::Glacier2::newCallback_SessionControl_getSessionTimeout.
 */
template<class T>
class CallbackNC_SessionControl_getSessionTimeout : public Callback_SessionControl_getSessionTimeout_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(::Ice::Int);

    CallbackNC_SessionControl_getSessionTimeout(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        SessionControlPrx proxy = SessionControlPrx::uncheckedCast(result->getProxy());
        ::Ice::Int ret;
        try
        {
            ret = proxy->end_getSessionTimeout(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::SessionControl::begin_getSessionTimeout.
 */
template<class T> Callback_SessionControl_getSessionTimeoutPtr
newCallback_SessionControl_getSessionTimeout(const IceUtil::Handle<T>& instance, void (T::*cb)(::Ice::Int), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_SessionControl_getSessionTimeout<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::SessionControl::begin_getSessionTimeout.
 */
template<class T> Callback_SessionControl_getSessionTimeoutPtr
newCallback_SessionControl_getSessionTimeout(T* instance, void (T::*cb)(::Ice::Int), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_SessionControl_getSessionTimeout<T>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::Glacier2::SessionControl::begin_getSessionTimeout.
 * Create a wrapper instance by calling ::Glacier2::newCallback_SessionControl_getSessionTimeout.
 */
template<class T, typename CT>
class Callback_SessionControl_getSessionTimeout : public Callback_SessionControl_getSessionTimeout_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(::Ice::Int, const CT&);

    Callback_SessionControl_getSessionTimeout(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        SessionControlPrx proxy = SessionControlPrx::uncheckedCast(result->getProxy());
        ::Ice::Int ret;
        try
        {
            ret = proxy->end_getSessionTimeout(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::SessionControl::begin_getSessionTimeout.
 */
template<class T, typename CT> Callback_SessionControl_getSessionTimeoutPtr
newCallback_SessionControl_getSessionTimeout(const IceUtil::Handle<T>& instance, void (T::*cb)(::Ice::Int, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_SessionControl_getSessionTimeout<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::SessionControl::begin_getSessionTimeout.
 */
template<class T, typename CT> Callback_SessionControl_getSessionTimeoutPtr
newCallback_SessionControl_getSessionTimeout(T* instance, void (T::*cb)(::Ice::Int, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_SessionControl_getSessionTimeout<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::Glacier2::SessionControl::begin_destroy.
 * Create a wrapper instance by calling ::Glacier2::newCallback_SessionControl_destroy.
 */
template<class T>
class CallbackNC_SessionControl_destroy : public Callback_SessionControl_destroy_Base, public ::IceInternal::OnewayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_SessionControl_destroy(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallbackNC<T>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::SessionControl::begin_destroy.
 */
template<class T> Callback_SessionControl_destroyPtr
newCallback_SessionControl_destroy(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_SessionControl_destroy<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::SessionControl::begin_destroy.
 */
template<class T> Callback_SessionControl_destroyPtr
newCallback_SessionControl_destroy(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_SessionControl_destroy<T>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::SessionControl::begin_destroy.
 */
template<class T> Callback_SessionControl_destroyPtr
newCallback_SessionControl_destroy(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_SessionControl_destroy<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::SessionControl::begin_destroy.
 */
template<class T> Callback_SessionControl_destroyPtr
newCallback_SessionControl_destroy(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_SessionControl_destroy<T>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::Glacier2::SessionControl::begin_destroy.
 * Create a wrapper instance by calling ::Glacier2::newCallback_SessionControl_destroy.
 */
template<class T, typename CT>
class Callback_SessionControl_destroy : public Callback_SessionControl_destroy_Base, public ::IceInternal::OnewayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_SessionControl_destroy(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallback<T, CT>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::SessionControl::begin_destroy.
 */
template<class T, typename CT> Callback_SessionControl_destroyPtr
newCallback_SessionControl_destroy(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_SessionControl_destroy<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::SessionControl::begin_destroy.
 */
template<class T, typename CT> Callback_SessionControl_destroyPtr
newCallback_SessionControl_destroy(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_SessionControl_destroy<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::SessionControl::begin_destroy.
 */
template<class T, typename CT> Callback_SessionControl_destroyPtr
newCallback_SessionControl_destroy(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_SessionControl_destroy<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::SessionControl::begin_destroy.
 */
template<class T, typename CT> Callback_SessionControl_destroyPtr
newCallback_SessionControl_destroy(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_SessionControl_destroy<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::Glacier2::SessionManager::begin_create.
 * Create a wrapper instance by calling ::Glacier2::newCallback_SessionManager_create.
 */
template<class T>
class CallbackNC_SessionManager_create : public Callback_SessionManager_create_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const SessionPrx&);

    CallbackNC_SessionManager_create(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        SessionManagerPrx proxy = SessionManagerPrx::uncheckedCast(result->getProxy());
        SessionPrx ret;
        try
        {
            ret = proxy->end_create(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::SessionManager::begin_create.
 */
template<class T> Callback_SessionManager_createPtr
newCallback_SessionManager_create(const IceUtil::Handle<T>& instance, void (T::*cb)(const SessionPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_SessionManager_create<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::SessionManager::begin_create.
 */
template<class T> Callback_SessionManager_createPtr
newCallback_SessionManager_create(T* instance, void (T::*cb)(const SessionPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_SessionManager_create<T>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::Glacier2::SessionManager::begin_create.
 * Create a wrapper instance by calling ::Glacier2::newCallback_SessionManager_create.
 */
template<class T, typename CT>
class Callback_SessionManager_create : public Callback_SessionManager_create_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const SessionPrx&, const CT&);

    Callback_SessionManager_create(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        SessionManagerPrx proxy = SessionManagerPrx::uncheckedCast(result->getProxy());
        SessionPrx ret;
        try
        {
            ret = proxy->end_create(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::SessionManager::begin_create.
 */
template<class T, typename CT> Callback_SessionManager_createPtr
newCallback_SessionManager_create(const IceUtil::Handle<T>& instance, void (T::*cb)(const SessionPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_SessionManager_create<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::SessionManager::begin_create.
 */
template<class T, typename CT> Callback_SessionManager_createPtr
newCallback_SessionManager_create(T* instance, void (T::*cb)(const SessionPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_SessionManager_create<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::Glacier2::SSLSessionManager::begin_create.
 * Create a wrapper instance by calling ::Glacier2::newCallback_SSLSessionManager_create.
 */
template<class T>
class CallbackNC_SSLSessionManager_create : public Callback_SSLSessionManager_create_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const SessionPrx&);

    CallbackNC_SSLSessionManager_create(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        SSLSessionManagerPrx proxy = SSLSessionManagerPrx::uncheckedCast(result->getProxy());
        SessionPrx ret;
        try
        {
            ret = proxy->end_create(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::SSLSessionManager::begin_create.
 */
template<class T> Callback_SSLSessionManager_createPtr
newCallback_SSLSessionManager_create(const IceUtil::Handle<T>& instance, void (T::*cb)(const SessionPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_SSLSessionManager_create<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::SSLSessionManager::begin_create.
 */
template<class T> Callback_SSLSessionManager_createPtr
newCallback_SSLSessionManager_create(T* instance, void (T::*cb)(const SessionPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_SSLSessionManager_create<T>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::Glacier2::SSLSessionManager::begin_create.
 * Create a wrapper instance by calling ::Glacier2::newCallback_SSLSessionManager_create.
 */
template<class T, typename CT>
class Callback_SSLSessionManager_create : public Callback_SSLSessionManager_create_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const SessionPrx&, const CT&);

    Callback_SSLSessionManager_create(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        SSLSessionManagerPrx proxy = SSLSessionManagerPrx::uncheckedCast(result->getProxy());
        SessionPrx ret;
        try
        {
            ret = proxy->end_create(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::SSLSessionManager::begin_create.
 */
template<class T, typename CT> Callback_SSLSessionManager_createPtr
newCallback_SSLSessionManager_create(const IceUtil::Handle<T>& instance, void (T::*cb)(const SessionPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_SSLSessionManager_create<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::SSLSessionManager::begin_create.
 */
template<class T, typename CT> Callback_SSLSessionManager_createPtr
newCallback_SSLSessionManager_create(T* instance, void (T::*cb)(const SessionPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_SSLSessionManager_create<T, CT>(instance, cb, excb, sentcb);
}

}

#endif

#include <IceUtil/PopDisableWarnings.h>
#endif
