/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.valves;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.net.InetAddress;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpSession;
import org.apache.catalina.AccessLog;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Session;
import org.apache.catalina.connector.ClientAbortException;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.util.TLSUtil;
import org.apache.catalina.valves.ValveBase;
import org.apache.coyote.ActionCode;
import org.apache.coyote.RequestInfo;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.buf.HexUtils;
import org.apache.tomcat.util.collections.SynchronizedStack;
import org.apache.tomcat.util.net.IPv6Utils;

public abstract class AbstractAccessLogValve
extends ValveBase
implements AccessLog {
    private static final Log log = LogFactory.getLog(AbstractAccessLogValve.class);
    protected boolean enabled = true;
    private boolean ipv6Canonical = false;
    protected String pattern = null;
    private static final int globalCacheSize = 300;
    private static final int localCacheSize = 60;
    private static final DateFormatCache globalDateCache = new DateFormatCache(300, Locale.getDefault(), null);
    private static final ThreadLocal<DateFormatCache> localDateCache = ThreadLocal.withInitial(() -> new DateFormatCache(60, Locale.getDefault(), globalDateCache));
    private static final ThreadLocal<Date> localDate = ThreadLocal.withInitial(Date::new);
    protected String condition = null;
    protected String conditionIf = null;
    protected String localeName = Locale.getDefault().toString();
    protected Locale locale = Locale.getDefault();
    protected AccessLogElement[] logElements = null;
    protected CachedElement[] cachedElements = null;
    protected boolean requestAttributesEnabled = false;
    private SynchronizedStack<CharArrayWriter> charArrayWriters = new SynchronizedStack();
    private int maxLogMessageBufferSize = 256;
    private boolean tlsAttributeRequired = false;

    public AbstractAccessLogValve() {
        super(true);
    }

    public int getMaxLogMessageBufferSize() {
        return this.maxLogMessageBufferSize;
    }

    public void setMaxLogMessageBufferSize(int n) {
        this.maxLogMessageBufferSize = n;
    }

    public boolean getIpv6Canonical() {
        return this.ipv6Canonical;
    }

    public void setIpv6Canonical(boolean bl) {
        this.ipv6Canonical = bl;
    }

    @Override
    public void setRequestAttributesEnabled(boolean bl) {
        this.requestAttributesEnabled = bl;
    }

    @Override
    public boolean getRequestAttributesEnabled() {
        return this.requestAttributesEnabled;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String string) {
        this.pattern = string == null ? "" : (string.equals("common") ? "%h %l %u %t \"%r\" %s %b" : (string.equals("combined") ? "%h %l %u %t \"%r\" %s %b \"%{Referer}i\" \"%{User-Agent}i\"" : string));
        this.logElements = this.createLogElements();
        this.cachedElements = this.createCachedElements(this.logElements);
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String string) {
        this.condition = string;
    }

    public String getConditionUnless() {
        return this.getCondition();
    }

    public void setConditionUnless(String string) {
        this.setCondition(string);
    }

    public String getConditionIf() {
        return this.conditionIf;
    }

    public void setConditionIf(String string) {
        this.conditionIf = string;
    }

    public String getLocale() {
        return this.localeName;
    }

    public void setLocale(String string) {
        this.localeName = string;
        this.locale = AbstractAccessLogValve.findLocale(string, this.locale);
    }

    @Override
    public void invoke(Request request, Response response) throws IOException, ServletException {
        if (this.tlsAttributeRequired) {
            request.getAttribute("javax.servlet.request.X509Certificate");
        }
        if (this.cachedElements != null) {
            for (CachedElement cachedElement : this.cachedElements) {
                cachedElement.cache(request);
            }
        }
        this.getNext().invoke(request, response);
    }

    @Override
    public void log(Request request, Response response, long l) {
        if (!this.getState().isAvailable() || !this.getEnabled() || this.logElements == null || this.condition != null && null != request.getRequest().getAttribute(this.condition) || this.conditionIf != null && null == request.getRequest().getAttribute(this.conditionIf)) {
            return;
        }
        long l2 = request.getCoyoteRequest().getStartTime();
        Date date = AbstractAccessLogValve.getDate(l2 + l);
        CharArrayWriter charArrayWriter = (CharArrayWriter)this.charArrayWriters.pop();
        if (charArrayWriter == null) {
            charArrayWriter = new CharArrayWriter(128);
        }
        for (AccessLogElement accessLogElement : this.logElements) {
            accessLogElement.addElement(charArrayWriter, date, request, response, l);
        }
        this.log(charArrayWriter);
        if (charArrayWriter.size() <= this.maxLogMessageBufferSize) {
            charArrayWriter.reset();
            this.charArrayWriters.push((Object)charArrayWriter);
        }
    }

    protected abstract void log(CharArrayWriter var1);

    private static Date getDate(long l) {
        Date date = localDate.get();
        date.setTime(l);
        return date;
    }

    protected static Locale findLocale(String string, Locale locale) {
        if (string == null || string.isEmpty()) {
            return Locale.getDefault();
        }
        for (Locale locale2 : Locale.getAvailableLocales()) {
            if (!string.equals(locale2.toString())) continue;
            return locale2;
        }
        log.error((Object)sm.getString("accessLogValve.invalidLocale", new Object[]{string}));
        return locale;
    }

    @Override
    protected synchronized void startInternal() throws LifecycleException {
        this.setState(LifecycleState.STARTING);
    }

    @Override
    protected synchronized void stopInternal() throws LifecycleException {
        this.setState(LifecycleState.STOPPING);
    }

    protected AccessLogElement[] createLogElements() {
        ArrayList<AccessLogElement> arrayList = new ArrayList<AccessLogElement>();
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.pattern.length(); ++i) {
            char c = this.pattern.charAt(i);
            if (bl) {
                if ('{' == c) {
                    int n;
                    StringBuilder stringBuilder2 = new StringBuilder();
                    for (n = i + 1; n < this.pattern.length() && '}' != this.pattern.charAt(n); ++n) {
                        stringBuilder2.append(this.pattern.charAt(n));
                    }
                    if (n + 1 < this.pattern.length()) {
                        arrayList.add(this.createAccessLogElement(stringBuilder2.toString(), this.pattern.charAt(++n)));
                        i = n;
                    } else {
                        arrayList.add(this.createAccessLogElement(c));
                    }
                } else {
                    arrayList.add(this.createAccessLogElement(c));
                }
                bl = false;
                continue;
            }
            if (c == '%') {
                bl = true;
                arrayList.add(new StringElement(stringBuilder.toString()));
                stringBuilder = new StringBuilder();
                continue;
            }
            stringBuilder.append(c);
        }
        if (stringBuilder.length() > 0) {
            arrayList.add(new StringElement(stringBuilder.toString()));
        }
        return arrayList.toArray(new AccessLogElement[0]);
    }

    private CachedElement[] createCachedElements(AccessLogElement[] accessLogElementArray) {
        ArrayList<CachedElement> arrayList = new ArrayList<CachedElement>();
        for (AccessLogElement accessLogElement : accessLogElementArray) {
            if (!(accessLogElement instanceof CachedElement)) continue;
            arrayList.add((CachedElement)((Object)accessLogElement));
        }
        return arrayList.toArray(new CachedElement[0]);
    }

    protected AccessLogElement createAccessLogElement(String string, char c) {
        switch (c) {
            case 'i': {
                return new HeaderElement(string);
            }
            case 'c': {
                return new CookieElement(string);
            }
            case 'o': {
                return new ResponseHeaderElement(string);
            }
            case 'a': {
                return new RemoteAddrElement(string);
            }
            case 'p': {
                return new PortElement(string);
            }
            case 'r': {
                if (TLSUtil.isTLSRequestAttribute(string)) {
                    this.tlsAttributeRequired = true;
                }
                return new RequestAttributeElement(string);
            }
            case 's': {
                return new SessionAttributeElement(string);
            }
            case 't': {
                return new DateAndTimeElement(string);
            }
        }
        return new StringElement("???");
    }

    protected AccessLogElement createAccessLogElement(char c) {
        switch (c) {
            case 'a': {
                return new RemoteAddrElement();
            }
            case 'A': {
                return new LocalAddrElement(this.ipv6Canonical);
            }
            case 'b': {
                return new ByteSentElement(true);
            }
            case 'B': {
                return new ByteSentElement(false);
            }
            case 'D': {
                return new ElapsedTimeElement(true);
            }
            case 'F': {
                return new FirstByteTimeElement();
            }
            case 'h': {
                return new HostElement();
            }
            case 'H': {
                return new ProtocolElement();
            }
            case 'l': {
                return new LogicalUserNameElement();
            }
            case 'm': {
                return new MethodElement();
            }
            case 'p': {
                return new PortElement();
            }
            case 'q': {
                return new QueryElement();
            }
            case 'r': {
                return new RequestElement();
            }
            case 's': {
                return new HttpStatusCodeElement();
            }
            case 'S': {
                return new SessionIdElement();
            }
            case 't': {
                return new DateAndTimeElement();
            }
            case 'T': {
                return new ElapsedTimeElement(false);
            }
            case 'u': {
                return new UserElement();
            }
            case 'U': {
                return new RequestURIElement();
            }
            case 'v': {
                return new LocalServerNameElement();
            }
            case 'I': {
                return new ThreadNameElement();
            }
            case 'X': {
                return new ConnectionStatusElement();
            }
        }
        return new StringElement("???" + c + "???");
    }

    protected static void escapeAndAppend(String string, CharArrayWriter charArrayWriter) {
        if (string == null || string.isEmpty()) {
            charArrayWriter.append('-');
            return;
        }
        int n = string.length();
        int n2 = 0;
        block10: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c >= ' ' && c < '\u007f') {
                switch (c) {
                    case '\\': {
                        if (i > n2) {
                            charArrayWriter.write(string, n2, i - n2);
                        }
                        n2 = i + 1;
                        charArrayWriter.append("\\\\");
                        break;
                    }
                    case '\"': {
                        if (i > n2) {
                            charArrayWriter.write(string, n2, i - n2);
                        }
                        n2 = i + 1;
                        charArrayWriter.append("\\\"");
                        break;
                    }
                }
                continue;
            }
            if (i > n2) {
                charArrayWriter.write(string, n2, i - n2);
            }
            n2 = i + 1;
            switch (c) {
                case '\f': {
                    charArrayWriter.append("\\f");
                    continue block10;
                }
                case '\n': {
                    charArrayWriter.append("\\n");
                    continue block10;
                }
                case '\r': {
                    charArrayWriter.append("\\r");
                    continue block10;
                }
                case '\t': {
                    charArrayWriter.append("\\t");
                    continue block10;
                }
                default: {
                    charArrayWriter.append("\\u");
                    charArrayWriter.append(HexUtils.toHexString((char)c));
                }
            }
        }
        if (n > n2) {
            charArrayWriter.write(string, n2, n - n2);
        }
    }

    protected static class ConnectionStatusElement
    implements AccessLogElement {
        protected ConnectionStatusElement() {
        }

        @Override
        public void addElement(CharArrayWriter charArrayWriter, Date date, Request request, Response response, long l) {
            if (response != null && request != null) {
                Object object;
                boolean bl = false;
                AtomicBoolean atomicBoolean = new AtomicBoolean(false);
                request.getCoyoteRequest().action(ActionCode.IS_IO_ALLOWED, (Object)atomicBoolean);
                if (!atomicBoolean.get()) {
                    charArrayWriter.append('X');
                    bl = true;
                } else if (response.isError() && (object = (Throwable)request.getAttribute("javax.servlet.error.exception")) instanceof ClientAbortException) {
                    charArrayWriter.append('X');
                    bl = true;
                }
                if (!bl) {
                    object = response.getHeader("Connection");
                    if ("close".equalsIgnoreCase((String)object)) {
                        charArrayWriter.append('-');
                    } else {
                        charArrayWriter.append('+');
                    }
                }
            } else {
                charArrayWriter.append('?');
            }
        }
    }

    protected static class SessionAttributeElement
    implements AccessLogElement {
        private final String attribute;

        public SessionAttributeElement(String string) {
            this.attribute = string;
        }

        @Override
        public void addElement(CharArrayWriter charArrayWriter, Date date, Request request, Response response, long l) {
            Object object = null;
            if (null != request) {
                HttpSession httpSession = request.getSession(false);
                if (null != httpSession) {
                    object = httpSession.getAttribute(this.attribute);
                }
            } else {
                object = "??";
            }
            if (object != null) {
                if (object instanceof String) {
                    AbstractAccessLogValve.escapeAndAppend((String)object, charArrayWriter);
                } else {
                    AbstractAccessLogValve.escapeAndAppend(object.toString(), charArrayWriter);
                }
            } else {
                charArrayWriter.append('-');
            }
        }
    }

    protected static class RequestAttributeElement
    implements AccessLogElement {
        private final String attribute;

        public RequestAttributeElement(String string) {
            this.attribute = string;
        }

        @Override
        public void addElement(CharArrayWriter charArrayWriter, Date date, Request request, Response response, long l) {
            Object object = null;
            object = request != null ? request.getAttribute(this.attribute) : "??";
            if (object != null) {
                if (object instanceof String) {
                    AbstractAccessLogValve.escapeAndAppend((String)object, charArrayWriter);
                } else {
                    AbstractAccessLogValve.escapeAndAppend(object.toString(), charArrayWriter);
                }
            } else {
                charArrayWriter.append('-');
            }
        }
    }

    protected static class ResponseHeaderElement
    implements AccessLogElement {
        private final String header;

        public ResponseHeaderElement(String string) {
            this.header = string;
        }

        @Override
        public void addElement(CharArrayWriter charArrayWriter, Date date, Request request, Response response, long l) {
            Iterator<String> iterator;
            if (null != response && (iterator = response.getHeaders(this.header).iterator()).hasNext()) {
                AbstractAccessLogValve.escapeAndAppend(iterator.next(), charArrayWriter);
                while (iterator.hasNext()) {
                    charArrayWriter.append(',');
                    AbstractAccessLogValve.escapeAndAppend(iterator.next(), charArrayWriter);
                }
                return;
            }
            charArrayWriter.append('-');
        }
    }

    protected static class CookieElement
    implements AccessLogElement {
        private final String cookieNameToLog;

        public CookieElement(String string) {
            this.cookieNameToLog = string;
        }

        @Override
        public void addElement(CharArrayWriter charArrayWriter, Date date, Request request, Response response, long l) {
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = true;
            Cookie[] cookieArray = request.getCookies();
            if (cookieArray != null) {
                for (Cookie cookie : cookieArray) {
                    if (!this.cookieNameToLog.equals(cookie.getName())) continue;
                    if (bl) {
                        bl = false;
                    } else {
                        stringBuilder.append(',');
                    }
                    stringBuilder.append(cookie.getValue());
                }
            }
            if (stringBuilder.length() == 0) {
                charArrayWriter.append('-');
            } else {
                AbstractAccessLogValve.escapeAndAppend(stringBuilder.toString(), charArrayWriter);
            }
        }
    }

    protected static class HeaderElement
    implements AccessLogElement {
        private final String header;

        public HeaderElement(String string) {
            this.header = string;
        }

        @Override
        public void addElement(CharArrayWriter charArrayWriter, Date date, Request request, Response response, long l) {
            Enumeration<String> enumeration = request.getHeaders(this.header);
            if (enumeration.hasMoreElements()) {
                AbstractAccessLogValve.escapeAndAppend(enumeration.nextElement(), charArrayWriter);
                while (enumeration.hasMoreElements()) {
                    charArrayWriter.append(',');
                    AbstractAccessLogValve.escapeAndAppend(enumeration.nextElement(), charArrayWriter);
                }
                return;
            }
            charArrayWriter.append('-');
        }
    }

    protected static class StringElement
    implements AccessLogElement {
        private final String str;

        public StringElement(String string) {
            this.str = string;
        }

        @Override
        public void addElement(CharArrayWriter charArrayWriter, Date date, Request request, Response response, long l) {
            charArrayWriter.append(this.str);
        }
    }

    protected class LocalServerNameElement
    implements AccessLogElement {
        protected LocalServerNameElement() {
        }

        @Override
        public void addElement(CharArrayWriter charArrayWriter, Date date, Request request, Response response, long l) {
            Object object;
            String string = null;
            if (AbstractAccessLogValve.this.requestAttributesEnabled && (object = request.getAttribute("org.apache.catalina.AccessLog.ServerName")) != null) {
                string = object.toString();
            }
            if (string == null || string.length() == 0) {
                string = request.getServerName();
            }
            if (string == null || string.length() == 0) {
                string = "-";
            }
            if (AbstractAccessLogValve.this.ipv6Canonical) {
                string = IPv6Utils.canonize((String)string);
            }
            charArrayWriter.append(string);
        }
    }

    protected static class RequestURIElement
    implements AccessLogElement {
        protected RequestURIElement() {
        }

        @Override
        public void addElement(CharArrayWriter charArrayWriter, Date date, Request request, Response response, long l) {
            if (request != null) {
                charArrayWriter.append(request.getRequestURI());
            } else {
                charArrayWriter.append('-');
            }
        }
    }

    protected static class SessionIdElement
    implements AccessLogElement {
        protected SessionIdElement() {
        }

        @Override
        public void addElement(CharArrayWriter charArrayWriter, Date date, Request request, Response response, long l) {
            if (request == null) {
                charArrayWriter.append('-');
            } else {
                Session session = request.getSessionInternal(false);
                if (session == null) {
                    charArrayWriter.append('-');
                } else {
                    charArrayWriter.append(session.getIdInternal());
                }
            }
        }
    }

    protected static class QueryElement
    implements AccessLogElement {
        protected QueryElement() {
        }

        @Override
        public void addElement(CharArrayWriter charArrayWriter, Date date, Request request, Response response, long l) {
            String string = null;
            if (request != null) {
                string = request.getQueryString();
            }
            if (string != null) {
                charArrayWriter.append('?');
                charArrayWriter.append(string);
            }
        }
    }

    protected static class FirstByteTimeElement
    implements AccessLogElement {
        protected FirstByteTimeElement() {
        }

        @Override
        public void addElement(CharArrayWriter charArrayWriter, Date date, Request request, Response response, long l) {
            long l2 = response.getCoyoteResponse().getCommitTime();
            if (l2 == -1L) {
                charArrayWriter.append('-');
            } else {
                long l3 = l2 - request.getCoyoteRequest().getStartTime();
                charArrayWriter.append(Long.toString(l3));
            }
        }
    }

    protected static class ElapsedTimeElement
    implements AccessLogElement {
        private final boolean millis;

        public ElapsedTimeElement(boolean bl) {
            this.millis = bl;
        }

        @Override
        public void addElement(CharArrayWriter charArrayWriter, Date date, Request request, Response response, long l) {
            if (this.millis) {
                charArrayWriter.append(Long.toString(l));
            } else {
                charArrayWriter.append(Long.toString(l / 1000L));
                charArrayWriter.append('.');
                int n = (int)(l % 1000L);
                charArrayWriter.append(Long.toString(n / 100));
                charArrayWriter.append(Long.toString((n %= 100) / 10));
                charArrayWriter.append(Long.toString(n % 10));
            }
        }
    }

    protected static class MethodElement
    implements AccessLogElement {
        protected MethodElement() {
        }

        @Override
        public void addElement(CharArrayWriter charArrayWriter, Date date, Request request, Response response, long l) {
            if (request != null) {
                charArrayWriter.append(request.getMethod());
            }
        }
    }

    protected static class ByteSentElement
    implements AccessLogElement {
        private final boolean conversion;

        public ByteSentElement(boolean bl) {
            this.conversion = bl;
        }

        @Override
        public void addElement(CharArrayWriter charArrayWriter, Date date, Request request, Response response, long l) {
            Object object;
            Object object2;
            long l2 = response.getBytesWritten(false);
            if (l2 <= 0L && (object2 = request.getAttribute("org.apache.tomcat.sendfile.start")) instanceof Long && (object = request.getAttribute("org.apache.tomcat.sendfile.end")) instanceof Long) {
                l2 = (Long)object - (Long)object2;
            }
            if (l2 <= 0L && this.conversion) {
                charArrayWriter.append('-');
            } else {
                charArrayWriter.append(Long.toString(l2));
            }
        }
    }

    protected class PortElement
    implements AccessLogElement,
    CachedElement {
        private static final String localPort = "local";
        private static final String remotePort = "remote";
        private final PortType portType;

        public PortElement() {
            this.portType = PortType.LOCAL;
        }

        public PortElement(String string) {
            switch (string) {
                case "remote": {
                    this.portType = PortType.REMOTE;
                    break;
                }
                case "local": {
                    this.portType = PortType.LOCAL;
                    break;
                }
                default: {
                    log.error((Object)ValveBase.sm.getString("accessLogValve.invalidPortType", new Object[]{string}));
                    this.portType = PortType.LOCAL;
                }
            }
        }

        @Override
        public void addElement(CharArrayWriter charArrayWriter, Date date, Request request, Response response, long l) {
            if (AbstractAccessLogValve.this.requestAttributesEnabled && this.portType == PortType.LOCAL) {
                Object object = request.getAttribute("org.apache.catalina.AccessLog.ServerPort");
                if (object == null) {
                    charArrayWriter.append(Integer.toString(request.getServerPort()));
                } else {
                    charArrayWriter.append(object.toString());
                }
            } else if (this.portType == PortType.LOCAL) {
                charArrayWriter.append(Integer.toString(request.getServerPort()));
            } else {
                charArrayWriter.append(Integer.toString(request.getRemotePort()));
            }
        }

        @Override
        public void cache(Request request) {
            if (this.portType == PortType.REMOTE) {
                request.getRemotePort();
            }
        }
    }

    protected static class HttpStatusCodeElement
    implements AccessLogElement {
        protected HttpStatusCodeElement() {
        }

        @Override
        public void addElement(CharArrayWriter charArrayWriter, Date date, Request request, Response response, long l) {
            if (response != null) {
                int n = response.getStatus();
                if (100 <= n && n < 1000) {
                    charArrayWriter.append((char)(48 + n / 100)).append((char)(48 + n / 10 % 10)).append((char)(48 + n % 10));
                } else {
                    charArrayWriter.append(Integer.toString(n));
                }
            } else {
                charArrayWriter.append('-');
            }
        }
    }

    protected static class RequestElement
    implements AccessLogElement {
        protected RequestElement() {
        }

        @Override
        public void addElement(CharArrayWriter charArrayWriter, Date date, Request request, Response response, long l) {
            if (request != null) {
                String string = request.getMethod();
                if (string == null) {
                    charArrayWriter.append('-');
                } else {
                    charArrayWriter.append(request.getMethod());
                    charArrayWriter.append(' ');
                    charArrayWriter.append(request.getRequestURI());
                    if (request.getQueryString() != null) {
                        charArrayWriter.append('?');
                        charArrayWriter.append(request.getQueryString());
                    }
                    charArrayWriter.append(' ');
                    charArrayWriter.append(request.getProtocol());
                }
            } else {
                charArrayWriter.append('-');
            }
        }
    }

    protected class DateAndTimeElement
    implements AccessLogElement {
        private static final String requestStartPrefix = "begin";
        private static final String responseEndPrefix = "end";
        private static final String prefixSeparator = ":";
        private static final String secFormat = "sec";
        private static final String msecFormat = "msec";
        private static final String msecFractionFormat = "msec_frac";
        private static final String msecPattern = "{#}";
        private static final String tripleMsecPattern = "{#}{#}{#}";
        private final String format;
        private final boolean needsEscaping;
        private final boolean usesBegin;
        private final FormatType type;
        private boolean usesMsecs = false;

        protected DateAndTimeElement() {
            this(null);
        }

        private String tidyFormat(String string) {
            boolean bl = false;
            StringBuilder stringBuilder = new StringBuilder();
            int n = string.length();
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if (bl || c != 'S') {
                    stringBuilder.append(c);
                } else {
                    stringBuilder.append(msecPattern);
                    this.usesMsecs = true;
                }
                if (c != '\'') continue;
                bl = !bl;
            }
            return stringBuilder.toString();
        }

        protected DateAndTimeElement(String string) {
            Object object;
            String string2 = string;
            boolean bl = false;
            if (string != null) {
                CharArrayWriter charArrayWriter = new CharArrayWriter();
                AbstractAccessLogValve.escapeAndAppend(string, charArrayWriter);
                object = charArrayWriter.toString();
                if (!((String)object).equals(string)) {
                    bl = true;
                }
            }
            this.needsEscaping = bl;
            boolean bl2 = false;
            object = FormatType.CLF;
            if (string2 != null) {
                if (string2.equals(requestStartPrefix)) {
                    bl2 = true;
                    string2 = "";
                } else if (string2.startsWith("begin:")) {
                    bl2 = true;
                    string2 = string2.substring(6);
                } else if (string2.equals(responseEndPrefix)) {
                    bl2 = false;
                    string2 = "";
                } else if (string2.startsWith("end:")) {
                    bl2 = false;
                    string2 = string2.substring(4);
                }
                if (string2.length() == 0) {
                    object = FormatType.CLF;
                } else if (string2.equals(secFormat)) {
                    object = FormatType.SEC;
                } else if (string2.equals(msecFormat)) {
                    object = FormatType.MSEC;
                } else if (string2.equals(msecFractionFormat)) {
                    object = FormatType.MSEC_FRAC;
                } else {
                    object = FormatType.SDF;
                    string2 = this.tidyFormat(string2);
                }
            }
            this.format = string2;
            this.usesBegin = bl2;
            this.type = object;
        }

        @Override
        public void addElement(CharArrayWriter charArrayWriter, Date date, Request request, Response response, long l) {
            long l2 = date.getTime();
            if (this.usesBegin) {
                l2 -= l;
            }
            if (this.type == FormatType.CLF) {
                charArrayWriter.append(((DateFormatCache)localDateCache.get()).getFormat(l2));
            } else if (this.type == FormatType.SEC) {
                charArrayWriter.append(Long.toString(l2 / 1000L));
            } else if (this.type == FormatType.MSEC) {
                charArrayWriter.append(Long.toString(l2));
            } else if (this.type == FormatType.MSEC_FRAC) {
                long l3 = l2 % 1000L;
                if (l3 < 100L) {
                    if (l3 < 10L) {
                        charArrayWriter.append('0');
                        charArrayWriter.append('0');
                    } else {
                        charArrayWriter.append('0');
                    }
                }
                charArrayWriter.append(Long.toString(l3));
            } else {
                String string = ((DateFormatCache)localDateCache.get()).getFormat(this.format, AbstractAccessLogValve.this.locale, l2);
                if (this.usesMsecs) {
                    long l4 = l2 % 1000L;
                    StringBuilder stringBuilder = new StringBuilder(4);
                    if (l4 < 100L) {
                        if (l4 < 10L) {
                            stringBuilder.append('0');
                            stringBuilder.append('0');
                        } else {
                            stringBuilder.append('0');
                        }
                    }
                    stringBuilder.append(l4);
                    string = string.replace(tripleMsecPattern, stringBuilder);
                    string = string.replace(msecPattern, Long.toString(l4));
                }
                if (this.needsEscaping) {
                    AbstractAccessLogValve.escapeAndAppend(string, charArrayWriter);
                } else {
                    charArrayWriter.append(string);
                }
            }
        }
    }

    protected static class UserElement
    implements AccessLogElement {
        protected UserElement() {
        }

        @Override
        public void addElement(CharArrayWriter charArrayWriter, Date date, Request request, Response response, long l) {
            if (request != null) {
                String string = request.getRemoteUser();
                if (string != null) {
                    AbstractAccessLogValve.escapeAndAppend(string, charArrayWriter);
                } else {
                    charArrayWriter.append('-');
                }
            } else {
                charArrayWriter.append('-');
            }
        }
    }

    protected class ProtocolElement
    implements AccessLogElement {
        protected ProtocolElement() {
        }

        @Override
        public void addElement(CharArrayWriter charArrayWriter, Date date, Request request, Response response, long l) {
            if (AbstractAccessLogValve.this.requestAttributesEnabled) {
                Object object = request.getAttribute("org.apache.catalina.AccessLog.Protocol");
                if (object == null) {
                    charArrayWriter.append(request.getProtocol());
                } else {
                    charArrayWriter.append(object.toString());
                }
            } else {
                charArrayWriter.append(request.getProtocol());
            }
        }
    }

    protected static class LogicalUserNameElement
    implements AccessLogElement {
        protected LogicalUserNameElement() {
        }

        @Override
        public void addElement(CharArrayWriter charArrayWriter, Date date, Request request, Response response, long l) {
            charArrayWriter.append('-');
        }
    }

    protected class HostElement
    implements AccessLogElement,
    CachedElement {
        protected HostElement() {
        }

        @Override
        public void addElement(CharArrayWriter charArrayWriter, Date date, Request request, Response response, long l) {
            Object object;
            String string = null;
            if (AbstractAccessLogValve.this.requestAttributesEnabled && (object = request.getAttribute("org.apache.catalina.AccessLog.RemoteHost")) != null) {
                string = object.toString();
            }
            if (string == null || string.length() == 0) {
                string = request.getRemoteHost();
            }
            if (string == null || string.length() == 0) {
                string = "-";
            }
            if (AbstractAccessLogValve.this.ipv6Canonical) {
                string = IPv6Utils.canonize((String)string);
            }
            charArrayWriter.append(string);
        }

        @Override
        public void cache(Request request) {
            if (!AbstractAccessLogValve.this.requestAttributesEnabled) {
                request.getRemoteHost();
            }
        }
    }

    protected class RemoteAddrElement
    implements AccessLogElement,
    CachedElement {
        private static final String remoteAddress = "remote";
        private static final String peerAddress = "peer";
        private final RemoteAddressType remoteAddressType;

        public RemoteAddrElement() {
            this.remoteAddressType = RemoteAddressType.REMOTE;
        }

        public RemoteAddrElement(String string) {
            switch (string) {
                case "remote": {
                    this.remoteAddressType = RemoteAddressType.REMOTE;
                    break;
                }
                case "peer": {
                    this.remoteAddressType = RemoteAddressType.PEER;
                    break;
                }
                default: {
                    log.error((Object)ValveBase.sm.getString("accessLogValve.invalidRemoteAddressType", new Object[]{string}));
                    this.remoteAddressType = RemoteAddressType.REMOTE;
                }
            }
        }

        @Override
        public void addElement(CharArrayWriter charArrayWriter, Date date, Request request, Response response, long l) {
            Object object;
            String string = null;
            string = this.remoteAddressType == RemoteAddressType.PEER ? request.getPeerAddr() : (AbstractAccessLogValve.this.requestAttributesEnabled ? ((object = request.getAttribute("org.apache.catalina.AccessLog.RemoteAddr")) == null ? request.getRemoteAddr() : object.toString()) : request.getRemoteAddr());
            if (AbstractAccessLogValve.this.ipv6Canonical) {
                string = IPv6Utils.canonize((String)string);
            }
            charArrayWriter.append(string);
        }

        @Override
        public void cache(Request request) {
            if (!AbstractAccessLogValve.this.requestAttributesEnabled) {
                if (this.remoteAddressType == RemoteAddressType.PEER) {
                    request.getPeerAddr();
                } else {
                    request.getRemoteAddr();
                }
            }
        }
    }

    protected static class LocalAddrElement
    implements AccessLogElement {
        private final String localAddrValue;

        public LocalAddrElement(boolean bl) {
            String string;
            try {
                string = InetAddress.getLocalHost().getHostAddress();
            }
            catch (Throwable throwable) {
                ExceptionUtils.handleThrowable((Throwable)throwable);
                string = "127.0.0.1";
            }
            this.localAddrValue = bl ? IPv6Utils.canonize((String)string) : string;
        }

        @Override
        public void addElement(CharArrayWriter charArrayWriter, Date date, Request request, Response response, long l) {
            charArrayWriter.append(this.localAddrValue);
        }
    }

    protected static class ThreadNameElement
    implements AccessLogElement {
        protected ThreadNameElement() {
        }

        @Override
        public void addElement(CharArrayWriter charArrayWriter, Date date, Request request, Response response, long l) {
            RequestInfo requestInfo = request.getCoyoteRequest().getRequestProcessor();
            if (requestInfo != null) {
                charArrayWriter.append(requestInfo.getWorkerThreadName());
            } else {
                charArrayWriter.append('-');
            }
        }
    }

    protected static interface CachedElement {
        public void cache(Request var1);
    }

    protected static interface AccessLogElement {
        public void addElement(CharArrayWriter var1, Date var2, Request var3, Response var4, long var5);
    }

    protected static class DateFormatCache {
        private int cacheSize = 0;
        private final Locale cacheDefaultLocale;
        private final DateFormatCache parent;
        protected final Cache cLFCache;
        private final Map<String, Cache> formatCache = new HashMap<String, Cache>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected DateFormatCache(int n, Locale locale, DateFormatCache dateFormatCache) {
            this.cacheSize = n;
            this.cacheDefaultLocale = locale;
            this.parent = dateFormatCache;
            Cache cache = null;
            if (dateFormatCache != null) {
                DateFormatCache dateFormatCache2 = dateFormatCache;
                synchronized (dateFormatCache2) {
                    cache = dateFormatCache.getCache(null, null);
                }
            }
            this.cLFCache = new Cache(cache);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Cache getCache(String string, Locale locale) {
            Cache cache;
            if (string == null) {
                cache = this.cLFCache;
            } else {
                cache = this.formatCache.get(string);
                if (cache == null) {
                    Cache cache2 = null;
                    if (this.parent != null) {
                        DateFormatCache dateFormatCache = this.parent;
                        synchronized (dateFormatCache) {
                            cache2 = this.parent.getCache(string, locale);
                        }
                    }
                    cache = new Cache(string, locale, cache2);
                    this.formatCache.put(string, cache);
                }
            }
            return cache;
        }

        public String getFormat(long l) {
            return this.cLFCache.getFormatInternal(l);
        }

        public String getFormat(String string, Locale locale, long l) {
            return this.getCache(string, locale).getFormatInternal(l);
        }

        protected class Cache {
            private static final String cLFFormat = "dd/MMM/yyyy:HH:mm:ss Z";
            private long previousSeconds = Long.MIN_VALUE;
            private String previousFormat = "";
            private long first = Long.MIN_VALUE;
            private long last = Long.MIN_VALUE;
            private int offset = 0;
            private final Date currentDate = new Date();
            protected final String[] cache;
            private SimpleDateFormat formatter;
            private boolean isCLF = false;
            private Cache parent = null;

            private Cache(Cache cache) {
                this(null, cache);
            }

            private Cache(String string, Cache cache) {
                this(string, null, cache);
            }

            private Cache(String string, Locale locale, Cache cache) {
                this.cache = new String[DateFormatCache.this.cacheSize];
                for (int i = 0; i < DateFormatCache.this.cacheSize; ++i) {
                    this.cache[i] = null;
                }
                if (locale == null) {
                    locale = DateFormatCache.this.cacheDefaultLocale;
                }
                if (string == null) {
                    this.isCLF = true;
                    string = cLFFormat;
                    this.formatter = new SimpleDateFormat(string, Locale.US);
                } else {
                    this.formatter = new SimpleDateFormat(string, locale);
                }
                this.formatter.setTimeZone(TimeZone.getDefault());
                this.parent = cache;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private String getFormatInternal(long l) {
                int n;
                long l2 = l / 1000L;
                if (l2 == this.previousSeconds) {
                    return this.previousFormat;
                }
                this.previousSeconds = l2;
                int n2 = (this.offset + (int)(l2 - this.first)) % DateFormatCache.this.cacheSize;
                if (n2 < 0) {
                    n2 += DateFormatCache.this.cacheSize;
                }
                if (l2 >= this.first && l2 <= this.last) {
                    if (this.cache[n2] != null) {
                        this.previousFormat = this.cache[n2];
                        return this.previousFormat;
                    }
                } else if (l2 >= this.last + (long)DateFormatCache.this.cacheSize || l2 <= this.first - (long)DateFormatCache.this.cacheSize) {
                    this.first = l2;
                    this.last = this.first + (long)DateFormatCache.this.cacheSize - 1L;
                    n2 = 0;
                    this.offset = 0;
                    for (n = 1; n < DateFormatCache.this.cacheSize; ++n) {
                        this.cache[n] = null;
                    }
                } else if (l2 > this.last) {
                    n = 1;
                    while ((long)n < l2 - this.last) {
                        this.cache[(n2 + ((DateFormatCache)DateFormatCache.this).cacheSize - n) % ((DateFormatCache)DateFormatCache.this).cacheSize] = null;
                        ++n;
                    }
                    this.first = l2 - (long)(DateFormatCache.this.cacheSize - 1);
                    this.last = l2;
                    this.offset = (n2 + 1) % DateFormatCache.this.cacheSize;
                } else if (l2 < this.first) {
                    n = 1;
                    while ((long)n < this.first - l2) {
                        this.cache[(n2 + n) % ((DateFormatCache)DateFormatCache.this).cacheSize] = null;
                        ++n;
                    }
                    this.first = l2;
                    this.last = l2 + (long)(DateFormatCache.this.cacheSize - 1);
                    this.offset = n2;
                }
                if (this.parent != null) {
                    Cache cache = this.parent;
                    synchronized (cache) {
                        this.previousFormat = this.parent.getFormatInternal(l);
                    }
                } else {
                    this.currentDate.setTime(l);
                    this.previousFormat = this.formatter.format(this.currentDate);
                    if (this.isCLF) {
                        StringBuilder stringBuilder = new StringBuilder(32);
                        stringBuilder.append('[');
                        stringBuilder.append(this.previousFormat);
                        stringBuilder.append(']');
                        this.previousFormat = stringBuilder.toString();
                    }
                }
                this.cache[n2] = this.previousFormat;
                return this.previousFormat;
            }
        }
    }

    private static enum RemoteAddressType {
        REMOTE,
        PEER;

    }

    private static enum PortType {
        LOCAL,
        REMOTE;

    }

    private static enum FormatType {
        CLF,
        SEC,
        MSEC,
        MSEC_FRAC,
        SDF;

    }
}

