/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net;

import java.io.EOFException;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.CompletionHandler;
import java.nio.channels.InterruptedByTimeoutException;
import java.nio.channels.ReadPendingException;
import java.nio.channels.WritePendingException;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.ApplicationBufferHandler;
import org.apache.tomcat.util.net.SSLSupport;
import org.apache.tomcat.util.net.SendfileDataBase;
import org.apache.tomcat.util.net.SendfileState;
import org.apache.tomcat.util.net.SocketBufferHandler;
import org.apache.tomcat.util.net.SocketEvent;
import org.apache.tomcat.util.net.WriteBuffer;
import org.apache.tomcat.util.res.StringManager;

public abstract class SocketWrapperBase<E> {
    private static final Log log = LogFactory.getLog(SocketWrapperBase.class);
    protected static final StringManager sm = StringManager.getManager(SocketWrapperBase.class);
    private E socket;
    private final AbstractEndpoint<E, ?> endpoint;
    private final Lock lock = new ReentrantLock();
    protected final AtomicBoolean closed = new AtomicBoolean(false);
    private volatile long readTimeout = -1L;
    private volatile long writeTimeout = -1L;
    protected volatile IOException previousIOException = null;
    private volatile int keepAliveLeft = 100;
    private volatile boolean upgraded = false;
    private boolean secure = false;
    private String negotiatedProtocol = null;
    protected String localAddr = null;
    protected String localName = null;
    protected int localPort = -1;
    protected String remoteAddr = null;
    protected String remoteHost = null;
    protected int remotePort = -1;
    private volatile IOException error = null;
    protected volatile SocketBufferHandler socketBufferHandler = null;
    protected int bufferedWriteSize = 65536;
    protected final WriteBuffer nonBlockingWriteBuffer = new WriteBuffer(this.bufferedWriteSize);
    protected final Semaphore readPending;
    protected volatile OperationState<?> readOperation = null;
    protected final Semaphore writePending;
    protected volatile OperationState<?> writeOperation = null;
    private final AtomicReference<Object> currentProcessor = new AtomicReference();
    public static final CompletionCheck COMPLETE_WRITE = new CompletionCheck(){

        @Override
        public CompletionHandlerCall callHandler(CompletionState completionState, ByteBuffer[] byteBufferArray, int n, int n2) {
            for (int i = 0; i < n2; ++i) {
                if (!byteBufferArray[n + i].hasRemaining()) continue;
                return CompletionHandlerCall.CONTINUE;
            }
            return completionState == CompletionState.DONE ? CompletionHandlerCall.DONE : CompletionHandlerCall.NONE;
        }
    };
    public static final CompletionCheck COMPLETE_WRITE_WITH_COMPLETION = new CompletionCheck(){

        @Override
        public CompletionHandlerCall callHandler(CompletionState completionState, ByteBuffer[] byteBufferArray, int n, int n2) {
            for (int i = 0; i < n2; ++i) {
                if (!byteBufferArray[n + i].hasRemaining()) continue;
                return CompletionHandlerCall.CONTINUE;
            }
            return CompletionHandlerCall.DONE;
        }
    };
    public static final CompletionCheck READ_DATA = new CompletionCheck(){

        @Override
        public CompletionHandlerCall callHandler(CompletionState completionState, ByteBuffer[] byteBufferArray, int n, int n2) {
            return completionState == CompletionState.DONE ? CompletionHandlerCall.DONE : CompletionHandlerCall.NONE;
        }
    };
    public static final CompletionCheck COMPLETE_READ_WITH_COMPLETION = COMPLETE_WRITE_WITH_COMPLETION;
    public static final CompletionCheck COMPLETE_READ = COMPLETE_WRITE;

    public SocketWrapperBase(E e, AbstractEndpoint<E, ?> abstractEndpoint) {
        this.socket = e;
        this.endpoint = abstractEndpoint;
        if (abstractEndpoint.getUseAsyncIO() || this.needSemaphores()) {
            this.readPending = new Semaphore(1);
            this.writePending = new Semaphore(1);
        } else {
            this.readPending = null;
            this.writePending = null;
        }
    }

    public E getSocket() {
        return this.socket;
    }

    protected void reset(E e) {
        this.socket = e;
    }

    protected AbstractEndpoint<E, ?> getEndpoint() {
        return this.endpoint;
    }

    public Lock getLock() {
        return this.lock;
    }

    public Object getCurrentProcessor() {
        return this.currentProcessor.get();
    }

    public void setCurrentProcessor(Object object) {
        this.currentProcessor.set(object);
    }

    public Object takeCurrentProcessor() {
        return this.currentProcessor.getAndSet(null);
    }

    public void execute(Runnable runnable) {
        Executor executor = this.endpoint.getExecutor();
        if (!this.endpoint.isRunning() || executor == null) {
            throw new RejectedExecutionException();
        }
        executor.execute(runnable);
    }

    public IOException getError() {
        return this.error;
    }

    public void setError(IOException iOException) {
        if (this.error != null) {
            return;
        }
        this.error = iOException;
    }

    public void checkError() throws IOException {
        if (this.error != null) {
            throw this.error;
        }
    }

    @Deprecated
    public boolean isUpgraded() {
        return this.upgraded;
    }

    @Deprecated
    public void setUpgraded(boolean bl) {
        this.upgraded = bl;
    }

    @Deprecated
    public boolean isSecure() {
        return this.secure;
    }

    @Deprecated
    public void setSecure(boolean bl) {
        this.secure = bl;
    }

    public String getNegotiatedProtocol() {
        return this.negotiatedProtocol;
    }

    public void setNegotiatedProtocol(String string) {
        this.negotiatedProtocol = string;
    }

    public void setReadTimeout(long l) {
        this.readTimeout = l > 0L ? l : -1L;
    }

    public long getReadTimeout() {
        return this.readTimeout;
    }

    public void setWriteTimeout(long l) {
        this.writeTimeout = l > 0L ? l : -1L;
    }

    public long getWriteTimeout() {
        return this.writeTimeout;
    }

    public void setKeepAliveLeft(int n) {
        this.keepAliveLeft = n;
    }

    public int decrementKeepAlive() {
        return --this.keepAliveLeft;
    }

    public String getRemoteHost() {
        if (this.remoteHost == null) {
            this.populateRemoteHost();
        }
        return this.remoteHost;
    }

    protected abstract void populateRemoteHost();

    public String getRemoteAddr() {
        if (this.remoteAddr == null) {
            this.populateRemoteAddr();
        }
        return this.remoteAddr;
    }

    protected abstract void populateRemoteAddr();

    public int getRemotePort() {
        if (this.remotePort == -1) {
            this.populateRemotePort();
        }
        return this.remotePort;
    }

    protected abstract void populateRemotePort();

    public String getLocalName() {
        if (this.localName == null) {
            this.populateLocalName();
        }
        return this.localName;
    }

    protected abstract void populateLocalName();

    public String getLocalAddr() {
        if (this.localAddr == null) {
            this.populateLocalAddr();
        }
        return this.localAddr;
    }

    protected abstract void populateLocalAddr();

    public int getLocalPort() {
        if (this.localPort == -1) {
            this.populateLocalPort();
        }
        return this.localPort;
    }

    protected abstract void populateLocalPort();

    public SocketBufferHandler getSocketBufferHandler() {
        return this.socketBufferHandler;
    }

    public boolean hasDataToRead() {
        return true;
    }

    public boolean hasDataToWrite() {
        return !this.socketBufferHandler.isWriteBufferEmpty() || !this.nonBlockingWriteBuffer.isEmpty();
    }

    public boolean isReadyForWrite() {
        boolean bl = this.canWrite();
        if (!bl) {
            this.registerWriteInterest();
        }
        return bl;
    }

    public boolean canWrite() {
        if (this.socketBufferHandler == null) {
            throw new IllegalStateException(sm.getString("socket.closed"));
        }
        return this.socketBufferHandler.isWriteBufferWritable() && this.nonBlockingWriteBuffer.isEmpty();
    }

    public String toString() {
        return super.toString() + ":" + String.valueOf(this.socket);
    }

    public abstract int read(boolean var1, byte[] var2, int var3, int var4) throws IOException;

    public abstract int read(boolean var1, ByteBuffer var2) throws IOException;

    public abstract boolean isReadyForRead() throws IOException;

    public abstract void setAppReadBufHandler(ApplicationBufferHandler var1);

    protected int populateReadBuffer(byte[] byArray, int n, int n2) {
        this.socketBufferHandler.configureReadBufferForRead();
        ByteBuffer byteBuffer = this.socketBufferHandler.getReadBuffer();
        int n3 = byteBuffer.remaining();
        if (n3 > 0) {
            n3 = Math.min(n3, n2);
            byteBuffer.get(byArray, n, n3);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Socket: [" + this + "], Read from buffer: [" + n3 + "]"));
            }
        }
        return n3;
    }

    protected int populateReadBuffer(ByteBuffer byteBuffer) {
        this.socketBufferHandler.configureReadBufferForRead();
        int n = SocketWrapperBase.transfer(this.socketBufferHandler.getReadBuffer(), byteBuffer);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Socket: [" + this + "], Read from buffer: [" + n + "]"));
        }
        return n;
    }

    public void unRead(ByteBuffer byteBuffer) {
        if (byteBuffer != null) {
            this.socketBufferHandler.unReadReadBuffer(byteBuffer);
        }
    }

    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            try {
                this.getEndpoint().getHandler().release(this);
            }
            catch (Throwable throwable) {
                ExceptionUtils.handleThrowable((Throwable)throwable);
                if (log.isDebugEnabled()) {
                    log.error((Object)sm.getString("endpoint.debug.handlerRelease"), throwable);
                }
            }
            finally {
                this.getEndpoint().countDownConnection();
                this.doClose();
            }
        }
    }

    protected abstract void doClose();

    public boolean isClosed() {
        return this.closed.get();
    }

    public final void write(boolean bl, byte[] byArray, int n, int n2) throws IOException {
        if (n2 == 0 || byArray == null) {
            return;
        }
        if (bl) {
            this.writeBlocking(byArray, n, n2);
        } else {
            this.writeNonBlocking(byArray, n, n2);
        }
    }

    public final void write(boolean bl, ByteBuffer byteBuffer) throws IOException {
        if (byteBuffer == null || byteBuffer.remaining() == 0) {
            return;
        }
        if (bl) {
            this.writeBlocking(byteBuffer);
        } else {
            this.writeNonBlocking(byteBuffer);
        }
    }

    protected void writeBlocking(byte[] byArray, int n, int n2) throws IOException {
        if (n2 > 0) {
            this.socketBufferHandler.configureWriteBufferForWrite();
            int n3 = SocketWrapperBase.transfer(byArray, n, n2, this.socketBufferHandler.getWriteBuffer());
            n2 -= n3;
            while (n2 > 0) {
                this.doWrite(true);
                this.socketBufferHandler.configureWriteBufferForWrite();
                n3 = SocketWrapperBase.transfer(byArray, n += n3, n2, this.socketBufferHandler.getWriteBuffer());
                n2 -= n3;
            }
        }
    }

    protected void writeBlocking(ByteBuffer byteBuffer) throws IOException {
        if (byteBuffer.hasRemaining()) {
            this.socketBufferHandler.configureWriteBufferForWrite();
            SocketWrapperBase.transfer(byteBuffer, this.socketBufferHandler.getWriteBuffer());
            while (byteBuffer.hasRemaining()) {
                this.doWrite(true);
                this.socketBufferHandler.configureWriteBufferForWrite();
                SocketWrapperBase.transfer(byteBuffer, this.socketBufferHandler.getWriteBuffer());
            }
        }
    }

    protected void writeNonBlocking(byte[] byArray, int n, int n2) throws IOException {
        if (n2 > 0 && this.nonBlockingWriteBuffer.isEmpty() && this.socketBufferHandler.isWriteBufferWritable()) {
            this.socketBufferHandler.configureWriteBufferForWrite();
            int n3 = SocketWrapperBase.transfer(byArray, n, n2, this.socketBufferHandler.getWriteBuffer());
            n2 -= n3;
            while (n2 > 0) {
                n += n3;
                this.doWrite(false);
                if (n2 <= 0 || !this.socketBufferHandler.isWriteBufferWritable()) break;
                this.socketBufferHandler.configureWriteBufferForWrite();
                n3 = SocketWrapperBase.transfer(byArray, n, n2, this.socketBufferHandler.getWriteBuffer());
                n2 -= n3;
            }
        }
        if (n2 > 0) {
            this.nonBlockingWriteBuffer.add(byArray, n, n2);
        }
    }

    protected void writeNonBlocking(ByteBuffer byteBuffer) throws IOException {
        if (byteBuffer.hasRemaining() && this.nonBlockingWriteBuffer.isEmpty() && this.socketBufferHandler.isWriteBufferWritable()) {
            this.writeNonBlockingInternal(byteBuffer);
        }
        if (byteBuffer.hasRemaining()) {
            this.nonBlockingWriteBuffer.add(byteBuffer);
        }
    }

    protected void writeNonBlockingInternal(ByteBuffer byteBuffer) throws IOException {
        this.socketBufferHandler.configureWriteBufferForWrite();
        SocketWrapperBase.transfer(byteBuffer, this.socketBufferHandler.getWriteBuffer());
        while (byteBuffer.hasRemaining()) {
            this.doWrite(false);
            if (!this.socketBufferHandler.isWriteBufferWritable()) break;
            this.socketBufferHandler.configureWriteBufferForWrite();
            SocketWrapperBase.transfer(byteBuffer, this.socketBufferHandler.getWriteBuffer());
        }
    }

    public boolean flush(boolean bl) throws IOException {
        boolean bl2 = false;
        if (bl) {
            this.flushBlocking();
        } else {
            bl2 = this.flushNonBlocking();
        }
        return bl2;
    }

    protected void flushBlocking() throws IOException {
        this.doWrite(true);
        if (!this.nonBlockingWriteBuffer.isEmpty()) {
            this.nonBlockingWriteBuffer.write(this, true);
            if (!this.socketBufferHandler.isWriteBufferEmpty()) {
                this.doWrite(true);
            }
        }
    }

    protected abstract boolean flushNonBlocking() throws IOException;

    protected void doWrite(boolean bl) throws IOException {
        this.socketBufferHandler.configureWriteBufferForRead();
        this.doWrite(bl, this.socketBufferHandler.getWriteBuffer());
    }

    protected abstract void doWrite(boolean var1, ByteBuffer var2) throws IOException;

    public void processSocket(SocketEvent socketEvent, boolean bl) {
        this.endpoint.processSocket(this, socketEvent, bl);
    }

    public abstract void registerReadInterest();

    public abstract void registerWriteInterest();

    public abstract SendfileDataBase createSendfileData(String var1, long var2, long var4);

    public abstract SendfileState processSendfile(SendfileDataBase var1);

    public abstract void doClientAuth(SSLSupport var1) throws IOException;

    @Deprecated
    public SSLSupport getSslSupport(String string) {
        return this.getSslSupport();
    }

    public abstract SSLSupport getSslSupport();

    public boolean hasAsyncIO() {
        return this.readPending != null;
    }

    public boolean needSemaphores() {
        return false;
    }

    public boolean hasPerOperationTimeout() {
        return false;
    }

    public boolean isReadPending() {
        return false;
    }

    public boolean isWritePending() {
        return false;
    }

    @Deprecated
    public boolean awaitReadComplete(long l, TimeUnit timeUnit) {
        return true;
    }

    @Deprecated
    public boolean awaitWriteComplete(long l, TimeUnit timeUnit) {
        return true;
    }

    public final <A> CompletionState read(long l, TimeUnit timeUnit, A a, CompletionHandler<Long, ? super A> completionHandler, ByteBuffer ... byteBufferArray) {
        if (byteBufferArray == null) {
            throw new IllegalArgumentException();
        }
        return this.read(byteBufferArray, 0, byteBufferArray.length, BlockingMode.CLASSIC, l, timeUnit, a, null, completionHandler);
    }

    public final <A> CompletionState read(BlockingMode blockingMode, long l, TimeUnit timeUnit, A a, CompletionCheck completionCheck, CompletionHandler<Long, ? super A> completionHandler, ByteBuffer ... byteBufferArray) {
        if (byteBufferArray == null) {
            throw new IllegalArgumentException();
        }
        return this.read(byteBufferArray, 0, byteBufferArray.length, blockingMode, l, timeUnit, a, completionCheck, completionHandler);
    }

    public final <A> CompletionState read(ByteBuffer[] byteBufferArray, int n, int n2, BlockingMode blockingMode, long l, TimeUnit timeUnit, A a, CompletionCheck completionCheck, CompletionHandler<Long, ? super A> completionHandler) {
        return this.vectoredOperation(true, byteBufferArray, n, n2, blockingMode, l, timeUnit, a, completionCheck, completionHandler);
    }

    public final <A> CompletionState write(long l, TimeUnit timeUnit, A a, CompletionHandler<Long, ? super A> completionHandler, ByteBuffer ... byteBufferArray) {
        if (byteBufferArray == null) {
            throw new IllegalArgumentException();
        }
        return this.write(byteBufferArray, 0, byteBufferArray.length, BlockingMode.CLASSIC, l, timeUnit, a, null, completionHandler);
    }

    public final <A> CompletionState write(BlockingMode blockingMode, long l, TimeUnit timeUnit, A a, CompletionCheck completionCheck, CompletionHandler<Long, ? super A> completionHandler, ByteBuffer ... byteBufferArray) {
        if (byteBufferArray == null) {
            throw new IllegalArgumentException();
        }
        return this.write(byteBufferArray, 0, byteBufferArray.length, blockingMode, l, timeUnit, a, completionCheck, completionHandler);
    }

    public final <A> CompletionState write(ByteBuffer[] byteBufferArray, int n, int n2, BlockingMode blockingMode, long l, TimeUnit timeUnit, A a, CompletionCheck completionCheck, CompletionHandler<Long, ? super A> completionHandler) {
        return this.vectoredOperation(false, byteBufferArray, n, n2, blockingMode, l, timeUnit, a, completionCheck, completionHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final <A> CompletionState vectoredOperation(boolean bl, ByteBuffer[] byteBufferArray, int n, int n2, BlockingMode blockingMode, long l, TimeUnit timeUnit, A a, CompletionCheck completionCheck, CompletionHandler<Long, ? super A> completionHandler) {
        block24: {
            IOException iOException = this.getError();
            if (iOException != null) {
                completionHandler.failed(iOException, a);
                return CompletionState.ERROR;
            }
            if (l == -1L) {
                l = AbstractEndpoint.toTimeout(bl ? this.getReadTimeout() : this.getWriteTimeout());
                timeUnit = TimeUnit.MILLISECONDS;
            } else if (!this.hasPerOperationTimeout() && timeUnit.toMillis(l) != (bl ? this.getReadTimeout() : this.getWriteTimeout())) {
                if (bl) {
                    this.setReadTimeout(timeUnit.toMillis(l));
                } else {
                    this.setWriteTimeout(timeUnit.toMillis(l));
                }
            }
            if (blockingMode == BlockingMode.BLOCK || blockingMode == BlockingMode.SEMI_BLOCK) {
                try {
                    if (bl ? !this.readPending.tryAcquire(l, timeUnit) : !this.writePending.tryAcquire(l, timeUnit)) {
                        completionHandler.failed(new SocketTimeoutException(), a);
                        return CompletionState.ERROR;
                    }
                    break block24;
                }
                catch (InterruptedException interruptedException) {
                    completionHandler.failed(interruptedException, a);
                    return CompletionState.ERROR;
                }
            }
            if (bl ? !this.readPending.tryAcquire() : !this.writePending.tryAcquire()) {
                if (blockingMode == BlockingMode.NON_BLOCK) {
                    return CompletionState.NOT_DONE;
                }
                completionHandler.failed(bl ? new ReadPendingException() : new WritePendingException(), a);
                return CompletionState.ERROR;
            }
        }
        VectoredIOCompletionHandler vectoredIOCompletionHandler = new VectoredIOCompletionHandler();
        OperationState<A> operationState = this.newOperationState(bl, byteBufferArray, n, n2, blockingMode, l, timeUnit, a, completionCheck, completionHandler, bl ? this.readPending : this.writePending, vectoredIOCompletionHandler);
        if (bl) {
            this.readOperation = operationState;
        } else {
            this.writeOperation = operationState;
        }
        operationState.start();
        if (blockingMode == BlockingMode.BLOCK) {
            OperationState<A> operationState2 = operationState;
            synchronized (operationState2) {
                if (operationState.state == CompletionState.PENDING) {
                    try {
                        operationState.wait(timeUnit.toMillis(l));
                        if (operationState.state == CompletionState.PENDING) {
                            if (completionHandler != null && operationState.callHandler.compareAndSet(true, false)) {
                                completionHandler.failed(new SocketTimeoutException(this.getTimeoutMsg(bl)), a);
                            }
                            return CompletionState.ERROR;
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        if (completionHandler != null && operationState.callHandler.compareAndSet(true, false)) {
                            completionHandler.failed(new SocketTimeoutException(this.getTimeoutMsg(bl)), a);
                        }
                        return CompletionState.ERROR;
                    }
                }
            }
        }
        return operationState.state;
    }

    private String getTimeoutMsg(boolean bl) {
        if (bl) {
            return sm.getString("socketWrapper.readTimeout");
        }
        return sm.getString("socketWrapper.writeTimeout");
    }

    protected abstract <A> OperationState<A> newOperationState(boolean var1, ByteBuffer[] var2, int var3, int var4, BlockingMode var5, long var6, TimeUnit var8, A var9, CompletionCheck var10, CompletionHandler<Long, ? super A> var11, Semaphore var12, VectoredIOCompletionHandler<A> var13);

    protected static int transfer(byte[] byArray, int n, int n2, ByteBuffer byteBuffer) {
        int n3 = Math.min(n2, byteBuffer.remaining());
        if (n3 > 0) {
            byteBuffer.put(byArray, n, n3);
        }
        return n3;
    }

    protected static int transfer(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        int n = Math.min(byteBuffer.remaining(), byteBuffer2.remaining());
        if (n > 0) {
            int n2 = byteBuffer.limit();
            byteBuffer.limit(byteBuffer.position() + n);
            byteBuffer2.put(byteBuffer);
            byteBuffer.limit(n2);
        }
        return n;
    }

    protected static boolean buffersArrayHasRemaining(ByteBuffer[] byteBufferArray, int n, int n2) {
        for (int i = n; i < n + n2; ++i) {
            if (!byteBufferArray[i].hasRemaining()) continue;
            return true;
        }
        return false;
    }

    protected class VectoredIOCompletionHandler<A>
    implements CompletionHandler<Long, OperationState<A>> {
        protected VectoredIOCompletionHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void completed(Long l, OperationState<A> operationState) {
            if (l < 0L) {
                this.failed((Throwable)new EOFException(), operationState);
            } else {
                Object object;
                operationState.nBytes += l.longValue();
                CompletionState completionState = operationState.isInline() ? CompletionState.INLINE : CompletionState.DONE;
                boolean bl = true;
                boolean bl2 = true;
                if (operationState.check != null) {
                    object = operationState.check.callHandler(completionState, operationState.buffers, operationState.offset, operationState.length);
                    if (object == CompletionHandlerCall.CONTINUE || !operationState.read && operationState.hasOutboundRemaining()) {
                        bl = false;
                    } else if (object == CompletionHandlerCall.NONE) {
                        bl2 = false;
                    }
                }
                if (bl) {
                    boolean bl3 = false;
                    if (operationState.read) {
                        SocketWrapperBase.this.readOperation = null;
                    } else {
                        SocketWrapperBase.this.writeOperation = null;
                    }
                    operationState.semaphore.release();
                    if (operationState.block == BlockingMode.BLOCK && completionState != CompletionState.INLINE) {
                        bl3 = true;
                    } else {
                        operationState.state = completionState;
                    }
                    operationState.end();
                    if (bl2 && operationState.handler != null && operationState.callHandler.compareAndSet(true, false)) {
                        operationState.handler.completed(operationState.nBytes, operationState.attachment);
                    }
                    OperationState<A> operationState2 = operationState;
                    synchronized (operationState2) {
                        operationState.completionDone = true;
                        if (bl3) {
                            operationState.state = completionState;
                            operationState.notify();
                        }
                    }
                }
                object = operationState;
                synchronized (object) {
                    operationState.completionDone = true;
                }
                operationState.run();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void failed(Throwable throwable, OperationState<A> operationState) {
            IOException iOException = null;
            if (throwable instanceof InterruptedByTimeoutException) {
                iOException = new SocketTimeoutException();
                throwable = iOException;
            } else if (throwable instanceof IOException) {
                iOException = (IOException)throwable;
            }
            SocketWrapperBase.this.setError(iOException);
            boolean bl = false;
            if (operationState.read) {
                SocketWrapperBase.this.readOperation = null;
            } else {
                SocketWrapperBase.this.writeOperation = null;
            }
            operationState.semaphore.release();
            if (operationState.block == BlockingMode.BLOCK) {
                bl = true;
            } else {
                operationState.state = operationState.isInline() ? CompletionState.ERROR : CompletionState.DONE;
            }
            operationState.end();
            if (operationState.handler != null && operationState.callHandler.compareAndSet(true, false)) {
                operationState.handler.failed(throwable, operationState.attachment);
            }
            OperationState<A> operationState2 = operationState;
            synchronized (operationState2) {
                operationState.completionDone = true;
                if (bl) {
                    operationState.state = operationState.isInline() ? CompletionState.ERROR : CompletionState.DONE;
                    operationState.notify();
                }
            }
        }
    }

    protected abstract class OperationState<A>
    implements Runnable {
        protected final boolean read;
        protected final ByteBuffer[] buffers;
        protected final int offset;
        protected final int length;
        protected final A attachment;
        protected final long timeout;
        protected final TimeUnit unit;
        protected final BlockingMode block;
        protected final CompletionCheck check;
        protected final CompletionHandler<Long, ? super A> handler;
        protected final Semaphore semaphore;
        protected final VectoredIOCompletionHandler<A> completion;
        protected final AtomicBoolean callHandler;
        protected volatile long nBytes = 0L;
        protected volatile CompletionState state = CompletionState.PENDING;
        protected boolean completionDone = true;

        protected OperationState(boolean bl, ByteBuffer[] byteBufferArray, int n, int n2, BlockingMode blockingMode, long l, TimeUnit timeUnit, A a, CompletionCheck completionCheck, CompletionHandler<Long, ? super A> completionHandler, Semaphore semaphore, VectoredIOCompletionHandler<A> vectoredIOCompletionHandler) {
            this.read = bl;
            this.buffers = byteBufferArray;
            this.offset = n;
            this.length = n2;
            this.block = blockingMode;
            this.timeout = l;
            this.unit = timeUnit;
            this.attachment = a;
            this.check = completionCheck;
            this.handler = completionHandler;
            this.semaphore = semaphore;
            this.completion = vectoredIOCompletionHandler;
            this.callHandler = completionHandler != null ? new AtomicBoolean(true) : null;
        }

        protected abstract boolean isInline();

        protected boolean hasOutboundRemaining() {
            return false;
        }

        protected boolean process() {
            try {
                SocketWrapperBase.this.getEndpoint().getExecutor().execute(this);
                return true;
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                log.warn((Object)sm.getString("endpoint.executor.fail", new Object[]{SocketWrapperBase.this}), (Throwable)rejectedExecutionException);
            }
            catch (Throwable throwable) {
                ExceptionUtils.handleThrowable((Throwable)throwable);
                log.error((Object)sm.getString("endpoint.process.fail"), throwable);
            }
            return false;
        }

        protected void start() {
            this.run();
        }

        protected void end() {
        }
    }

    public static interface CompletionCheck {
        public CompletionHandlerCall callHandler(CompletionState var1, ByteBuffer[] var2, int var3, int var4);
    }

    public static enum CompletionHandlerCall {
        CONTINUE,
        NONE,
        DONE;

    }

    public static enum CompletionState {
        PENDING,
        NOT_DONE,
        INLINE,
        ERROR,
        DONE;

    }

    public static enum BlockingMode {
        CLASSIC,
        NON_BLOCK,
        SEMI_BLOCK,
        BLOCK;

    }
}

