/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.truffle;

import java.text.Format;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.swing.SortOrder;
import org.graalvm.visualvm.heapviewer.HeapContext;
import org.graalvm.visualvm.heapviewer.java.InstanceNode;
import org.graalvm.visualvm.heapviewer.model.DataType;
import org.graalvm.visualvm.heapviewer.model.ErrorNode;
import org.graalvm.visualvm.heapviewer.model.HeapViewerNode;
import org.graalvm.visualvm.heapviewer.model.HeapViewerNodeFilter;
import org.graalvm.visualvm.heapviewer.model.HeapViewerNodeWrapper;
import org.graalvm.visualvm.heapviewer.model.Progress;
import org.graalvm.visualvm.heapviewer.model.RootNode;
import org.graalvm.visualvm.heapviewer.truffle.Bundle;
import org.graalvm.visualvm.heapviewer.truffle.TruffleLanguage;
import org.graalvm.visualvm.heapviewer.truffle.TruffleObject;
import org.graalvm.visualvm.heapviewer.truffle.TruffleObjectsWrapper;
import org.graalvm.visualvm.heapviewer.truffle.dynamicobject.DynamicObject;
import org.graalvm.visualvm.heapviewer.truffle.dynamicobject.DynamicObjectNode;
import org.graalvm.visualvm.heapviewer.ui.HeapViewerRenderer;
import org.graalvm.visualvm.heapviewer.ui.HeapViewerRendererWrapper;
import org.graalvm.visualvm.heapviewer.ui.UIThresholds;
import org.graalvm.visualvm.heapviewer.utils.ExcludingIterator;
import org.graalvm.visualvm.heapviewer.utils.HeapUtils;
import org.graalvm.visualvm.heapviewer.utils.InterruptibleIterator;
import org.graalvm.visualvm.heapviewer.utils.NodesComputer;
import org.graalvm.visualvm.heapviewer.utils.ProgressIterator;
import org.graalvm.visualvm.heapviewer.utils.counters.InstanceCounter;
import org.graalvm.visualvm.lib.jfluid.heap.Field;
import org.graalvm.visualvm.lib.jfluid.heap.FieldValue;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.jfluid.heap.ObjectFieldValue;
import org.graalvm.visualvm.lib.profiler.api.icons.Icons;
import org.graalvm.visualvm.lib.ui.swing.renderer.NormalBoldGrayRenderer;

abstract class TruffleObjectMergedFields<O extends TruffleObject> {
    private final Heap heap;
    private final TruffleObjectsWrapper<O> objects;

    TruffleObjectMergedFields(TruffleObjectsWrapper<O> objects, Heap heap) {
        this.objects = objects;
        this.heap = heap;
    }

    protected abstract String getMoreNodesString(String var1);

    protected abstract String getSamplesContainerString(String var1);

    protected abstract String getNodesContainerString(String var1, String var2);

    protected abstract TruffleLanguage getLanguage();

    protected abstract boolean filtersFields();

    protected abstract boolean includeField(FieldValue var1);

    protected abstract Collection<FieldValue> getFields(O var1) throws InterruptedException;

    private int objectsCount() {
        return this.objects.getObjectsCount();
    }

    private Iterator<O> objectsIterator() {
        return new InterruptibleIterator(this.objects.getObjectsIterator());
    }

    private HeapViewerNode createObjectNode(O object) {
        return (HeapViewerNode)this.getLanguage().createObjectNode(object, ((TruffleObject)object).getType());
    }

    HeapViewerNode[] getNodes(HeapViewerNode parent, String viewID, HeapViewerNodeFilter viewFilter, List<DataType> dataTypes, List<SortOrder> sortOrders, Progress progress) throws InterruptedException {
        try {
            final Set<FieldDescriptor> fields = this.getAllObjectsFields(progress);
            NodesComputer<FieldDescriptor> computer = new NodesComputer<FieldDescriptor>(fields.size(), UIThresholds.MAX_INSTANCE_FIELDS){

                protected boolean sorts(DataType dataType) {
                    return true;
                }

                protected HeapViewerNode createNode(FieldDescriptor field) {
                    return new MergedObjectFieldNode(field);
                }

                protected ProgressIterator<FieldDescriptor> objectsIterator(int index, Progress progress) {
                    Iterator iterator = fields.iterator();
                    return new ProgressIterator(iterator, index, true, progress);
                }

                protected String getMoreNodesString(String moreNodesCount) {
                    return TruffleObjectMergedFields.this.getMoreNodesString(moreNodesCount);
                }

                protected String getSamplesContainerString(String objectsCount) {
                    return TruffleObjectMergedFields.this.getSamplesContainerString(objectsCount);
                }

                protected String getNodesContainerString(String firstNodeIdx, String lastNodeIdx) {
                    return TruffleObjectMergedFields.this.getNodesContainerString(firstNodeIdx, lastNodeIdx);
                }
            };
            return computer.computeNodes(parent, this.heap, viewID, null, dataTypes, sortOrders, progress);
        }
        catch (OutOfMemoryError e) {
            System.err.println("Out of memory in TruffleObjectMergedFields: " + e.getMessage());
            HeapUtils.handleOOME((boolean)true, (OutOfMemoryError)e);
            return new HeapViewerNode[]{new ErrorNode.OOME()};
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<FieldDescriptor> getAllObjectsFields(Progress progress) throws InterruptedException {
        boolean filtersProperties = this.filtersFields();
        HashSet<FieldDescriptor> allFields = new HashSet<FieldDescriptor>();
        Iterator<O> objectsI = this.objectsIterator();
        try {
            progress.setupKnownSteps((long)this.objects.getObjectsCount());
            while (objectsI.hasNext()) {
                progress.step();
                Collection<FieldValue> fields = this.getFields((TruffleObject)objectsI.next());
                if (fields == null) continue;
                for (FieldValue field : fields) {
                    if (filtersProperties && !this.includeField(field)) continue;
                    Field f = field.getField();
                    String fname = f.isStatic() ? "static " + f.getName() : f.getName();
                    int ftype = field instanceof ObjectFieldValue ? 0 : -1;
                    allFields.add(new FieldDescriptor(fname, ftype));
                }
            }
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
        }
        finally {
            progress.finish();
        }
        return allFields;
    }

    private FieldValue getValueOfField(O object, String name) {
        try {
            Collection<FieldValue> fieldValues = this.getFields(object);
            if (fieldValues == null) {
                return null;
            }
            ArrayList<Object> fieldValuesArr = fieldValues instanceof ArrayList ? (ArrayList<Object>)fieldValues : new ArrayList<FieldValue>(fieldValues);
            for (int i = fieldValuesArr.size() - 1; i >= 0; --i) {
                FieldValue fv = (FieldValue)fieldValuesArr.get(i);
                Field field = fv.getField();
                String fieldN = field.getName();
                if (field.isStatic()) {
                    fieldN = "static " + fieldN;
                }
                if (!fieldN.equals(name)) continue;
                return fv;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return null;
    }

    public static class MergedFieldsNodeRendererProvider
    extends HeapViewerRenderer.Provider {
        public boolean supportsView(HeapContext context, String viewID) {
            return true;
        }

        public void registerRenderers(Map<Class<? extends HeapViewerNode>, HeapViewerRenderer> renderers, HeapContext context) {
            renderers.put(MergedObjectFieldNode.class, new MergedObjectFieldNodeRenderer());
            renderers.put(ObjectFieldValueNode.class, (HeapViewerRenderer)new ObjectFieldValueNodeRenderer());
            renderers.put(PrimitiveFieldValueNode.class, new PrimitiveFieldValueNodeRenderer());
        }
    }

    private static class FieldDescriptor {
        final String name;
        final int type;

        FieldDescriptor(String name, int type) {
            this.name = name;
            this.type = type;
        }

        public int hashCode() {
            return 31 * this.type + this.name.hashCode();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FieldDescriptor)) {
                return false;
            }
            FieldDescriptor fd = (FieldDescriptor)o;
            return this.type == fd.type && Objects.equals(this.name, fd.name);
        }
    }

    private static class PrimitiveFieldValueNodeRenderer
    extends NormalBoldGrayRenderer
    implements HeapViewerRenderer {
        private PrimitiveFieldValueNodeRenderer() {
        }

        public void setValue(Object value, int row) {
            PrimitiveFieldValueNode n = (PrimitiveFieldValueNode)((Object)value);
            if (n != null) {
                this.setNormalValue(n.getType() + " ");
                this.setBoldValue(n.getValue());
            } else {
                this.setNormalValue("");
                this.setBoldValue("");
            }
            this.setIcon(Icons.getIcon((String)"LanguageIcons.Primitive"));
        }

        public String getShortName() {
            return this.getBoldValue();
        }
    }

    private static class ObjectFieldValueNodeRenderer
    extends HeapViewerRendererWrapper {
        private ObjectFieldValueNodeRenderer() {
        }

        protected HeapViewerRenderer getRenderer(Object value, int row) {
            ObjectFieldValueNode vnode = (ObjectFieldValueNode)((Object)value);
            HeapViewerNode node = vnode.getNode();
            HeapViewerRenderer renderer = RootNode.get((HeapViewerNode)vnode).resolveRenderer(node);
            renderer.setValue((Object)node, row);
            return renderer;
        }
    }

    private static class MergedObjectFieldNodeRenderer
    extends NormalBoldGrayRenderer
    implements HeapViewerRenderer {
        private static final Format VALUES_COUNT_FORMAT = NumberFormat.getInstance();

        private MergedObjectFieldNodeRenderer() {
        }

        public void setValue(Object value, int row) {
            MergedObjectFieldNode n = (MergedObjectFieldNode)((Object)value);
            if (n != null) {
                String name = n.getFieldName();
                if (name.startsWith("static ")) {
                    this.setNormalValue("static ");
                    this.setBoldValue(name.substring("static ".length()));
                } else {
                    this.setNormalValue("");
                    this.setBoldValue(name);
                }
                this.setGrayValue(n.getValuesCount() == -1 ? "" : " " + Bundle.TruffleObjectPropertyProvider_ValuesCountHint(VALUES_COUNT_FORMAT.format(n.getValuesCount())));
            } else {
                this.setBoldValue("");
                this.setGrayValue("");
            }
            this.setIcon(Icons.getIcon((String)"ProfilerIcons.NodeForward"));
        }

        public String getShortName() {
            return this.getBoldValue();
        }
    }

    private abstract class PrimitiveFieldValueNode
    extends HeapViewerNode {
        private final String fieldValue;
        private final String fieldType;
        private final int valuesCount;

        PrimitiveFieldValueNode(String fieldValue, String fieldType, int valuesCount) {
            this.fieldValue = fieldValue;
            this.fieldType = fieldType;
            this.valuesCount = valuesCount;
        }

        public String getType() {
            return this.fieldType;
        }

        public String getValue() {
            return this.fieldValue;
        }

        public int getValuesCount() {
            return this.valuesCount;
        }

        abstract String fieldName();

        public String getName() {
            return this.getType() + " " + this.getValue();
        }

        public String toString() {
            return this.getName();
        }

        protected Object getValue(DataType type, Heap heap) {
            if (type == DataType.NAME) {
                return this.getName();
            }
            if (type == DataType.COUNT) {
                return this.getValuesCount();
            }
            return super.getValue(type, heap);
        }

        protected HeapViewerNode[] lazilyComputeChildren(Heap heap, String viewID, HeapViewerNodeFilter viewFilter, List<DataType> dataTypes, List<SortOrder> sortOrders, Progress progress) throws InterruptedException {
            final String fieldName = this.fieldName();
            NodesComputer computer = new NodesComputer<O>(this.valuesCount, UIThresholds.MAX_MERGED_OBJECTS){

                protected boolean sorts(DataType dataType) {
                    return true;
                }

                protected HeapViewerNode createNode(O object) {
                    return TruffleObjectMergedFields.this.createObjectNode(object);
                }

                protected ProgressIterator<O> objectsIterator(int index, final Progress progress) {
                    progress.setupUnknownSteps();
                    ExcludingIterator fieldInstanceIterator = new ExcludingIterator<O>((Iterator)new InterruptibleIterator(TruffleObjectMergedFields.this.objectsIterator())){

                        protected boolean exclude(O object) {
                            progress.step();
                            FieldValue value = TruffleObjectMergedFields.this.getValueOfField(object, fieldName);
                            if (value == null || value instanceof ObjectFieldValue) {
                                return true;
                            }
                            return !Objects.equals(PrimitiveFieldValueNode.this.fieldValue, value.getValue());
                        }
                    };
                    return new ProgressIterator((Iterator)fieldInstanceIterator, index, true, progress);
                }

                protected String getMoreNodesString(String moreNodesCount) {
                    return Bundle.TruffleObjectPropertyProvider_IMoreNodes(moreNodesCount);
                }

                protected String getSamplesContainerString(String objectsCount) {
                    return Bundle.TruffleObjectPropertyProvider_ISamplesContainer(objectsCount);
                }

                protected String getNodesContainerString(String firstNodeIdx, String lastNodeIdx) {
                    return Bundle.TruffleObjectPropertyProvider_INodesContainer(firstNodeIdx, lastNodeIdx);
                }
            };
            HeapViewerNode[] result = computer.computeNodes((HeapViewerNode)this, heap, viewID, null, dataTypes, sortOrders, progress);
            return result;
        }
    }

    private abstract class ObjectFieldValueNode
    extends HeapViewerNodeWrapper {
        private final int valuesCount;

        ObjectFieldValueNode(HeapViewerNode node, int valuesCount) {
            super(node);
            this.valuesCount = valuesCount;
        }

        public int getValuesCount() {
            return this.valuesCount;
        }

        abstract String fieldName();

        protected Object getValue(DataType type, Heap heap) {
            if (type == DataType.COUNT) {
                return this.getValuesCount();
            }
            return super.getValue(type, heap);
        }

        protected HeapViewerNode[] lazilyComputeChildren(final Heap heap, String viewID, HeapViewerNodeFilter viewFilter, List<DataType> dataTypes, List<SortOrder> sortOrders, Progress progress) throws InterruptedException {
            final String fieldName = this.fieldName();
            NodesComputer computer = new NodesComputer<O>(this.valuesCount, UIThresholds.MAX_MERGED_OBJECTS){

                protected boolean sorts(DataType dataType) {
                    return true;
                }

                protected HeapViewerNode createNode(O object) {
                    return TruffleObjectMergedFields.this.createObjectNode(object);
                }

                protected ProgressIterator<O> objectsIterator(int index, final Progress progress) {
                    final Instance _instance = (Instance)HeapViewerNode.getValue((HeapViewerNode)ObjectFieldValueNode.this.getNode(), (DataType)DataType.INSTANCE, (Heap)heap);
                    progress.setupUnknownSteps();
                    ExcludingIterator fieldInstanceIterator = new ExcludingIterator<O>((Iterator)new InterruptibleIterator(TruffleObjectMergedFields.this.objectsIterator())){

                        protected boolean exclude(O object) {
                            progress.step();
                            FieldValue value = TruffleObjectMergedFields.this.getValueOfField(object, fieldName);
                            if (!(value instanceof ObjectFieldValue)) {
                                return true;
                            }
                            return !Objects.equals(_instance, ((ObjectFieldValue)value).getInstance());
                        }
                    };
                    return new ProgressIterator((Iterator)fieldInstanceIterator, index, true, progress);
                }

                protected String getMoreNodesString(String moreNodesCount) {
                    return Bundle.TruffleObjectPropertyProvider_IMoreNodes(moreNodesCount);
                }

                protected String getSamplesContainerString(String objectsCount) {
                    return Bundle.TruffleObjectPropertyProvider_ISamplesContainer(objectsCount);
                }

                protected String getNodesContainerString(String firstNodeIdx, String lastNodeIdx) {
                    return Bundle.TruffleObjectPropertyProvider_INodesContainer(firstNodeIdx, lastNodeIdx);
                }
            };
            HeapViewerNode[] result = computer.computeNodes((HeapViewerNode)this, heap, viewID, null, dataTypes, sortOrders, progress);
            return result;
        }
    }

    private class MergedObjectFieldNode
    extends HeapViewerNode {
        private final String fieldName;
        private final int fieldType;
        private int valuesCount = -1;

        MergedObjectFieldNode(FieldDescriptor fieldDescriptor) {
            this.fieldName = fieldDescriptor.name;
            this.fieldType = fieldDescriptor.type;
        }

        String getFieldName() {
            return this.fieldName;
        }

        int getValuesCount() {
            return this.valuesCount;
        }

        private String getName() {
            return this.valuesCount == -1 ? this.fieldName : this.fieldName + " " + Bundle.TruffleObjectPropertyProvider_ValuesCountHint(this.valuesCount);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected HeapViewerNode[] lazilyComputeChildren(final Heap heap, String viewID, HeapViewerNodeFilter viewFilter, List<DataType> dataTypes, List<SortOrder> sortOrders, Progress progress) throws InterruptedException {
            if (this.fieldType == 0) {
                final InstanceCounter values = new InstanceCounter(TruffleObjectMergedFields.this.objectsCount());
                Iterator objects = TruffleObjectMergedFields.this.objectsIterator();
                try {
                    progress.setupKnownSteps((long)TruffleObjectMergedFields.this.objectsCount());
                    while (objects.hasNext()) {
                        TruffleObject o = (TruffleObject)objects.next();
                        progress.step();
                        FieldValue value = TruffleObjectMergedFields.this.getValueOfField(o, this.fieldName);
                        if (!(value instanceof ObjectFieldValue)) continue;
                        values.count(((ObjectFieldValue)value).getInstance());
                    }
                    if (Thread.currentThread().isInterrupted()) {
                        throw new InterruptedException();
                    }
                }
                catch (OutOfMemoryError e) {
                    System.err.println("Out of memory in TruffleObjectMergedFields: " + e.getMessage());
                    HeapUtils.handleOOME((boolean)true, (OutOfMemoryError)e);
                    HeapViewerNode[] value = new HeapViewerNode[]{new ErrorNode.OOME()};
                    return value;
                }
                finally {
                    progress.finish();
                }
                this.valuesCount = values.size();
                final TruffleLanguage language = TruffleObjectMergedFields.this.getLanguage();
                NodesComputer<InstanceCounter.Record> computer = new NodesComputer<InstanceCounter.Record>(this.valuesCount, UIThresholds.MAX_MERGED_OBJECTS){

                    protected boolean sorts(DataType dataType) {
                        return true;
                    }

                    protected HeapViewerNode createNode(InstanceCounter.Record record) {
                        Object node;
                        Instance instance = record.getInstance(heap);
                        if (language.isLanguageObject(instance)) {
                            Object object = language.createObject(instance);
                            node = (HeapViewerNode)language.createObjectNode(object, ((TruffleObject)object).getType());
                        } else if (DynamicObject.isDynamicObject(instance)) {
                            DynamicObject pbject = new DynamicObject(instance);
                            node = new DynamicObjectNode<DynamicObject>(pbject, pbject.getType());
                        } else {
                            node = new InstanceNode.IncludingNull(instance);
                        }
                        return new ObjectFieldValueNode((HeapViewerNode)node, record.getCount()){

                            @Override
                            String fieldName() {
                                return MergedObjectFieldNode.this.fieldName;
                            }
                        };
                    }

                    protected ProgressIterator<InstanceCounter.Record> objectsIterator(int index, Progress progress) {
                        InstanceCounter.Iterator iterator = values.iterator();
                        return new ProgressIterator((Iterator)iterator, index, true, progress);
                    }

                    protected String getMoreNodesString(String moreNodesCount) {
                        return Bundle.TruffleObjectPropertyProvider_FieldHistogramMoreNodes(moreNodesCount);
                    }

                    protected String getSamplesContainerString(String objectsCount) {
                        return Bundle.TruffleObjectPropertyProvider_FieldHistogramSamplesContainer(objectsCount);
                    }

                    protected String getNodesContainerString(String firstNodeIdx, String lastNodeIdx) {
                        return Bundle.TruffleObjectPropertyProvider_FieldHistogramNodesContainer(firstNodeIdx, lastNodeIdx);
                    }
                };
                return computer.computeNodes((HeapViewerNode)this, heap, viewID, null, dataTypes, sortOrders, progress);
            }
            final HashMap<String, Integer> values = new HashMap<String, Integer>();
            Iterator objects = TruffleObjectMergedFields.this.objectsIterator();
            try {
                progress.setupKnownSteps((long)TruffleObjectMergedFields.this.objectsCount());
                while (objects.hasNext()) {
                    TruffleObject o = (TruffleObject)objects.next();
                    progress.step();
                    FieldValue value = TruffleObjectMergedFields.this.getValueOfField(o, this.fieldName);
                    if (value == null) continue;
                    String val = value.getValue();
                    Integer count = (Integer)values.get(val);
                    if (count == null) {
                        count = 0;
                    }
                    count = count + 1;
                    values.put(val, count);
                }
                if (Thread.currentThread().isInterrupted()) {
                    throw new InterruptedException();
                }
            }
            catch (OutOfMemoryError e) {
                System.err.println("Out of memory in TruffleObjectMergedFields: " + e.getMessage());
                HeapUtils.handleOOME((boolean)true, (OutOfMemoryError)e);
                HeapViewerNode[] heapViewerNodeArray = new HeapViewerNode[]{new ErrorNode.OOME()};
                return heapViewerNodeArray;
            }
            finally {
                progress.finish();
            }
            this.valuesCount = values.size();
            NodesComputer<Map.Entry<String, Integer>> computer = new NodesComputer<Map.Entry<String, Integer>>(this.valuesCount, UIThresholds.MAX_MERGED_OBJECTS){

                protected boolean sorts(DataType dataType) {
                    return true;
                }

                protected HeapViewerNode createNode(Map.Entry<String, Integer> record) {
                    return new PrimitiveFieldValueNode(record.getKey(), "object", (int)record.getValue()){

                        @Override
                        String fieldName() {
                            return MergedObjectFieldNode.this.fieldName;
                        }
                    };
                }

                protected ProgressIterator<Map.Entry<String, Integer>> objectsIterator(int index, Progress progress) {
                    Iterator iterator = values.entrySet().iterator();
                    return new ProgressIterator(iterator, index, true, progress);
                }

                protected String getMoreNodesString(String moreNodesCount) {
                    return Bundle.TruffleObjectPropertyProvider_FieldHistogramMoreNodes(moreNodesCount);
                }

                protected String getSamplesContainerString(String objectsCount) {
                    return Bundle.TruffleObjectPropertyProvider_FieldHistogramSamplesContainer(objectsCount);
                }

                protected String getNodesContainerString(String firstNodeIdx, String lastNodeIdx) {
                    return Bundle.TruffleObjectPropertyProvider_FieldHistogramNodesContainer(firstNodeIdx, lastNodeIdx);
                }
            };
            return computer.computeNodes((HeapViewerNode)this, heap, viewID, null, dataTypes, sortOrders, progress);
        }

        protected Object getValue(DataType type, Heap heap) {
            if (type == DataType.NAME) {
                return this.getName();
            }
            return super.getValue(type, heap);
        }

        public String toString() {
            return this.getName();
        }
    }
}

