/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Vector;
import sun.awt.X11.XlibWrapper;
import sun.misc.Unsafe;

class Native {
    private static Unsafe unsafe = XlibWrapper.unsafe;
    static int longSize;
    static int dataModel;

    Native() {
    }

    static boolean getBool(long l) {
        return Native.getInt(l) != 0;
    }

    static boolean getBool(long l, int n) {
        return Native.getInt(l, n) != 0;
    }

    static void putBool(long l, boolean bl) {
        Native.putInt(l, bl ? 1 : 0);
    }

    static void putBool(long l, int n, boolean bl) {
        Native.putInt(l, n, bl ? 1 : 0);
    }

    static int getByteSize() {
        return 1;
    }

    static byte getByte(long l) {
        return unsafe.getByte(l);
    }

    static byte getByte(long l, int n) {
        return Native.getByte(l + (long)n);
    }

    static void putByte(long l, byte by) {
        unsafe.putByte(l, by);
    }

    static void putByte(long l, int n, byte by) {
        Native.putByte(l + (long)n, by);
    }

    static byte[] toBytes(long l, int n) {
        if (l == 0L) {
            return null;
        }
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            byArray[n2] = Native.getByte(l);
            ++n2;
            ++l;
        }
        return byArray;
    }

    static long toData(byte[] byArray) {
        if (byArray == null) {
            return 0L;
        }
        long l = XlibWrapper.unsafe.allocateMemory(byArray.length);
        for (int i = 0; i < byArray.length; ++i) {
            Native.putByte(l + (long)i, byArray[i]);
        }
        return l;
    }

    static int getUByteSize() {
        return 1;
    }

    static short getUByte(long l) {
        return (short)(0xFF & unsafe.getByte(l));
    }

    static short getUByte(long l, int n) {
        return Native.getUByte(l + (long)n);
    }

    static void putUByte(long l, short s) {
        unsafe.putByte(l, (byte)s);
    }

    static void putUByte(long l, int n, short s) {
        Native.putUByte(l + (long)n, s);
    }

    static short[] toUBytes(long l, int n) {
        if (l == 0L) {
            return null;
        }
        short[] sArray = new short[n];
        int n2 = 0;
        while (n2 < n) {
            sArray[n2] = Native.getUByte(l);
            ++n2;
            ++l;
        }
        return sArray;
    }

    static long toUData(short[] sArray) {
        if (sArray == null) {
            return 0L;
        }
        long l = XlibWrapper.unsafe.allocateMemory(sArray.length);
        for (int i = 0; i < sArray.length; ++i) {
            Native.putUByte(l + (long)i, sArray[i]);
        }
        return l;
    }

    static int getShortSize() {
        return 2;
    }

    static short getShort(long l) {
        return unsafe.getShort(l);
    }

    static void putShort(long l, short s) {
        unsafe.putShort(l, s);
    }

    static void putShort(long l, int n, short s) {
        Native.putShort(l + (long)(n * Native.getShortSize()), s);
    }

    static long toData(short[] sArray) {
        if (sArray == null) {
            return 0L;
        }
        long l = XlibWrapper.unsafe.allocateMemory(sArray.length * Native.getShortSize());
        for (int i = 0; i < sArray.length; ++i) {
            Native.putShort(l, i, sArray[i]);
        }
        return l;
    }

    static int getUShortSize() {
        return 2;
    }

    static int getUShort(long l) {
        return 0xFFFF & unsafe.getShort(l);
    }

    static void putUShort(long l, int n) {
        unsafe.putShort(l, (short)n);
    }

    static void putUShort(long l, int n, int n2) {
        Native.putUShort(l + (long)(n * Native.getShortSize()), n2);
    }

    static long toUData(int[] nArray) {
        if (nArray == null) {
            return 0L;
        }
        long l = XlibWrapper.unsafe.allocateMemory(nArray.length * Native.getShortSize());
        for (int i = 0; i < nArray.length; ++i) {
            Native.putUShort(l, i, nArray[i]);
        }
        return l;
    }

    static int getIntSize() {
        return 4;
    }

    static int getInt(long l) {
        return unsafe.getInt(l);
    }

    static int getInt(long l, int n) {
        return Native.getInt(l + (long)(Native.getIntSize() * n));
    }

    static void putInt(long l, int n) {
        unsafe.putInt(l, n);
    }

    static void putInt(long l, int n, int n2) {
        Native.putInt(l + (long)(n * Native.getIntSize()), n2);
    }

    static long toData(int[] nArray) {
        if (nArray == null) {
            return 0L;
        }
        long l = XlibWrapper.unsafe.allocateMemory(nArray.length * Native.getIntSize());
        for (int i = 0; i < nArray.length; ++i) {
            Native.putInt(l, i, nArray[i]);
        }
        return l;
    }

    static int getUIntSize() {
        return 4;
    }

    static long getUInt(long l) {
        return 0xFFFFFFFFL & (long)unsafe.getInt(l);
    }

    static long getUInt(long l, int n) {
        return Native.getUInt(l + (long)(Native.getIntSize() * n));
    }

    static void putUInt(long l, long l2) {
        unsafe.putInt(l, (int)l2);
    }

    static void putUInt(long l, int n, long l2) {
        Native.putUInt(l + (long)(n * Native.getIntSize()), l2);
    }

    static long toUData(long[] lArray) {
        if (lArray == null) {
            return 0L;
        }
        long l = XlibWrapper.unsafe.allocateMemory(lArray.length * Native.getIntSize());
        for (int i = 0; i < lArray.length; ++i) {
            Native.putUInt(l, i, lArray[i]);
        }
        return l;
    }

    static int getLongSize() {
        return longSize;
    }

    static long getLong(long l) {
        if (XlibWrapper.dataModel == 32) {
            return unsafe.getInt(l);
        }
        return unsafe.getLong(l);
    }

    static void putLong(long l, long l2) {
        if (XlibWrapper.dataModel == 32) {
            unsafe.putInt(l, (int)l2);
        } else {
            unsafe.putLong(l, l2);
        }
    }

    static void putLong(long l, int n, long l2) {
        Native.putLong(l + (long)(n * Native.getLongSize()), l2);
    }

    static long getLong(long l, int n) {
        return Native.getLong(l + (long)(n * Native.getLongSize()));
    }

    static void put(long l, long[] lArray) {
        int n = 0;
        while (n < lArray.length) {
            Native.putLong(l, lArray[n]);
            ++n;
            l += (long)Native.getLongSize();
        }
    }

    static void putLong(long l, Vector vector) {
        int n = 0;
        while (n < vector.size()) {
            Native.putLong(l, (Long)vector.elementAt(n));
            ++n;
            l += (long)Native.getLongSize();
        }
    }

    static void putLongReverse(long l, Vector vector) {
        int n = vector.size() - 1;
        while (n >= 0) {
            Native.putLong(l, (Long)vector.elementAt(n));
            --n;
            l += (long)Native.getLongSize();
        }
    }

    static long[] toLongs(long l, int n) {
        if (l == 0L) {
            return null;
        }
        long[] lArray = new long[n];
        int n2 = 0;
        while (n2 < n) {
            lArray[n2] = Native.getLong(l);
            ++n2;
            l += (long)Native.getLongSize();
        }
        return lArray;
    }

    static long toData(long[] lArray) {
        if (lArray == null) {
            return 0L;
        }
        long l = XlibWrapper.unsafe.allocateMemory(lArray.length * Native.getLongSize());
        for (int i = 0; i < lArray.length; ++i) {
            Native.putLong(l, i, lArray[i]);
        }
        return l;
    }

    static long getULong(long l) {
        if (XlibWrapper.dataModel == 32) {
            return (long)unsafe.getInt(l) & 0xFFFFFFFFL;
        }
        return unsafe.getLong(l);
    }

    static void putULong(long l, long l2) {
        Native.putLong(l, l2);
    }

    static long allocateLongArray(int n) {
        return unsafe.allocateMemory(Native.getLongSize() * n);
    }

    static long getWindow(long l) {
        return Native.getLong(l);
    }

    static long getWindow(long l, int n) {
        return Native.getLong(l + (long)(Native.getWindowSize() * n));
    }

    static void putWindow(long l, long l2) {
        Native.putLong(l, l2);
    }

    static void putWindow(long l, int n, long l2) {
        Native.putLong(l, n, l2);
    }

    static int getWindowSize() {
        return Native.getLongSize();
    }

    static long getCard32(long l) {
        return Native.getLong(l);
    }

    static void putCard32(long l, long l2) {
        Native.putLong(l, l2);
    }

    static long getCard32(long l, int n) {
        return Native.getLong(l, n);
    }

    static void putCard32(long l, int n, long l2) {
        Native.putLong(l, n, l2);
    }

    static int getCard32Size() {
        return Native.getLongSize();
    }

    static long[] card32ToArray(long l, int n) {
        return Native.toLongs(l, n);
    }

    static long card32ToData(long[] lArray) {
        return Native.toData(lArray);
    }

    static {
        String string = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("sun.arch.data.model");
            }
        });
        try {
            dataModel = Integer.parseInt(string);
        }
        catch (Exception exception) {
            dataModel = 32;
        }
        longSize = dataModel == 32 ? 4 : 8;
    }
}

