/*
 * Decompiled with CFR 0.152.
 */
package sun.management.jdp;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import sun.management.jdp.JdpException;
import sun.management.jdp.JdpGenericPacket;
import sun.management.jdp.JdpPacket;
import sun.management.jdp.JdpPacketReader;
import sun.management.jdp.JdpPacketWriter;

public final class JdpJmxPacket
extends JdpGenericPacket
implements JdpPacket {
    public static final String UUID_KEY = "DISCOVERABLE_SESSION_UUID";
    public static final String MAIN_CLASS_KEY = "MAIN_CLASS";
    public static final String JMX_SERVICE_URL_KEY = "JMX_SERVICE_URL";
    public static final String INSTANCE_NAME_KEY = "INSTANCE_NAME";
    public static final String PROCESS_ID_KEY = "PROCESS_ID";
    public static final String RMI_HOSTNAME_KEY = "RMI_HOSTNAME";
    public static final String BROADCAST_INTERVAL_KEY = "BROADCAST_INTERVAL";
    private UUID id;
    private String mainClass;
    private String jmxServiceUrl;
    private String instanceName;
    private String processId;
    private String rmiHostname;
    private String broadcastInterval;

    public JdpJmxPacket(UUID uUID, String string) {
        this.id = uUID;
        this.jmxServiceUrl = string;
    }

    public JdpJmxPacket(byte[] byArray) throws JdpException {
        JdpPacketReader jdpPacketReader = new JdpPacketReader(byArray);
        Map<String, String> map = jdpPacketReader.getDiscoveryDataAsMap();
        String string = map.get(UUID_KEY);
        this.id = string == null ? null : UUID.fromString(string);
        this.jmxServiceUrl = map.get(JMX_SERVICE_URL_KEY);
        this.mainClass = map.get(MAIN_CLASS_KEY);
        this.instanceName = map.get(INSTANCE_NAME_KEY);
        this.processId = map.get(PROCESS_ID_KEY);
        this.rmiHostname = map.get(RMI_HOSTNAME_KEY);
        this.broadcastInterval = map.get(BROADCAST_INTERVAL_KEY);
    }

    public void setMainClass(String string) {
        this.mainClass = string;
    }

    public void setInstanceName(String string) {
        this.instanceName = string;
    }

    public UUID getId() {
        return this.id;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public String getJmxServiceUrl() {
        return this.jmxServiceUrl;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public String getProcessId() {
        return this.processId;
    }

    public void setProcessId(String string) {
        this.processId = string;
    }

    public String getRmiHostname() {
        return this.rmiHostname;
    }

    public void setRmiHostname(String string) {
        this.rmiHostname = string;
    }

    public String getBroadcastInterval() {
        return this.broadcastInterval;
    }

    public void setBroadcastInterval(String string) {
        this.broadcastInterval = string;
    }

    @Override
    public byte[] getPacketData() throws IOException {
        JdpPacketWriter jdpPacketWriter = new JdpPacketWriter();
        jdpPacketWriter.addEntry(UUID_KEY, this.id == null ? null : this.id.toString());
        jdpPacketWriter.addEntry(MAIN_CLASS_KEY, this.mainClass);
        jdpPacketWriter.addEntry(JMX_SERVICE_URL_KEY, this.jmxServiceUrl);
        jdpPacketWriter.addEntry(INSTANCE_NAME_KEY, this.instanceName);
        jdpPacketWriter.addEntry(PROCESS_ID_KEY, this.processId);
        jdpPacketWriter.addEntry(RMI_HOSTNAME_KEY, this.rmiHostname);
        jdpPacketWriter.addEntry(BROADCAST_INTERVAL_KEY, this.broadcastInterval);
        return jdpPacketWriter.getPacketBytes();
    }

    public int hashCode() {
        int n = 1;
        n = n * 31 + this.id.hashCode();
        n = n * 31 + this.jmxServiceUrl.hashCode();
        return n;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof JdpJmxPacket)) {
            return false;
        }
        JdpJmxPacket jdpJmxPacket = (JdpJmxPacket)object;
        return Objects.equals(this.id, jdpJmxPacket.getId()) && Objects.equals(this.jmxServiceUrl, jdpJmxPacket.getJmxServiceUrl());
    }
}

