/*
 * Copyright (c) 2012, 2023, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_mzn extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_SK = "\u0627\u0633\u0644\u0648\u0627\u06a9\u06cc";
        final String metaValue_ar = "\u0639\u0631\u0628\u06cc";
        final String metaValue_hy = "\u0627\u0631\u0645\u0646\u06cc";
        final String metaValue_bn = "\u0628\u0646\u06af\u0627\u0644\u06cc";
        final String metaValue_ka = "\u06af\u0631\u062c\u06cc";
        final String metaValue_el = "\u06cc\u0648\u0646\u0627\u0646\u06cc";
        final String metaValue_gu = "\u06af\u062c\u0631\u0627\u062a\u06cc";
        final String metaValue_he = "\u0639\u0628\u0631\u06cc";
        final String metaValue_ja = "\u062c\u0627\u067e\u0648\u0646\u06cc";
        final String metaValue_MD = "\u0645\u0648\u0644\u062f\u0627\u0648\u06cc";
        final Object[][] data = new Object[][] {
            { "001", "\u062c\u0647\u0648\u0646" },
            { "002", "\u0622\u0641\u0631\u06cc\u0642\u0627" },
            { "003", "\u0634\u0645\u0627\u0644\u06cc \u0622\u0645\u0631\u06cc\u06a9\u0627" },
            { "005", "\u062c\u0646\u0648\u0628\u06cc \u0622\u0645\u0631\u06cc\u06a9\u0627" },
            { "009", "\u0627\u0648\u0642\u06cc\u0627\u0646\u0648\u0633\u06cc\u0647" },
            { "011", "\u063a\u0631\u0628\u06cc \u0622\u0641\u0631\u06cc\u0642\u0627" },
            { "013", "\u0645\u06cc\u0648\u0646\u06cc \u0622\u0645\u0631\u06cc\u06a9\u0627" },
            { "014", "\u0634\u0631\u0642\u06cc \u0622\u0641\u0631\u06cc\u0642\u0627" },
            { "015", "\u0634\u0645\u0627\u0644\u06cc \u06c0\u0641\u0631\u06cc\u0642\u0627" },
            { "017", "\u0645\u06cc\u0648\u0646\u06cc \u0622\u0641\u0631\u06cc\u0642\u0627" },
            { "018", "\u062c\u0646\u0648\u0628\u06cc \u0622\u0641\u0631\u06cc\u0642\u0627" },
            { "019", "\u0622\u0645\u0631\u06cc\u06a9\u0627" },
            { "021", "\u0634\u0645\u0627\u0644\u06cc \u0627\u0645\u0631\u06cc\u06a9\u0627" },
            { "029", "\u06a9\u0627\u0631\u0627\u06cc\u06cc\u0628" },
            { "030", "\u0634\u0631\u0642\u06cc \u0622\u0633\u06cc\u0627" },
            { "034", "\u062c\u0646\u0648\u0628\u06cc \u0622\u0633\u06cc\u0627" },
            { "035", "\u0622\u0633\u06cc\u0627\u06cc \u0650\u062c\u0646\u0648\u0628\u200c\u0634\u0631\u0642\u06cc\u200c\u0648\u064e\u0631" },
            { "039", "\u062c\u0646\u0648\u0628\u06cc \u0627\u0631\u0648\u067e\u0627" },
            { "053", "\u0627\u0648\u0633\u062a\u0631\u0627\u0644\u0632\u06cc" },
            { "054", "\u0645\u0644\u0627\u0646\u0632\u06cc" },
            { "057", "\u0645\u06cc\u06a9\u0631\u0648\u0646\u0632\u06cc \u0645\u0646\u0642\u0637\u0647" },
            { "061", "\u067e\u0648\u0644\u06cc\u200c\u0646\u0632\u06cc" },
            { "142", "\u0622\u0633\u06cc\u0627" },
            { "143", "\u0645\u06cc\u0648\u0646\u06cc \u0622\u0633\u06cc\u0627" },
            { "145", "\u063a\u0631\u0628\u06cc \u0622\u0633\u06cc\u0627" },
            { "150", "\u0627\u0631\u0648\u067e\u0627" },
            { "151", "\u0634\u0631\u0642\u06cc \u0627\u0631\u0648\u067e\u0627" },
            { "154", "\u0634\u0645\u0627\u0644\u06cc \u0627\u0631\u0648\u067e\u0627" },
            { "155", "\u063a\u0631\u0628\u06cc \u0627\u0631\u0648\u067e\u0627" },
            { "419", "\u0644\u0627\u062a\u06cc\u0646 \u0622\u0645\u0631\u06cc\u06a9\u0627" },
            { "AC", "\u0622\u0633\u0646\u0633\u06cc\u0648\u0646 \u062c\u0632\u06cc\u0631\u0647" },
            { "AD", "\u0622\u0646\u062f\u0648\u0631\u0627" },
            { "AE", "\u0645\u062a\u062d\u062f\u0647 \u0639\u0631\u0628\u06cc \u0627\u0645\u0627\u0631\u0627\u062a" },
            { "AF", "\u0627\u0641\u063a\u0627\u0646\u0633\u062a\u0648\u0646" },
            { "AG", "\u0622\u0646\u062a\u06cc\u06af\u0648\u0627 \u0648 \u0628\u0627\u0631\u0628\u0648\u062f\u0627" },
            { "AI", "\u0622\u0646\u06af\u0648\u06cc\u0644\u0627" },
            { "AL", "\u0622\u0644\u0628\u0627\u0646\u06cc" },
            { "AM", "\u0627\u0631\u0645\u0646\u0633\u062a\u0648\u0646" },
            { "AO", "\u0622\u0646\u06af\u0648\u0644\u0627" },
            { "AQ", "\u062c\u0646\u0648\u0628\u06cc \u06cc\u062e\u200c\u0628\u0632\u0647 \u0642\u0637\u0628" },
            { "AR", "\u0622\u0631\u0698\u0627\u0646\u062a\u06cc\u0646" },
            { "AS", "\u0622\u0645\u0631\u06cc\u06a9\u0627\u06cc \u0650\u0633\u0627\u0645\u0648\u0622" },
            { "AT", "\u0627\u062a\u0631\u06cc\u0634" },
            { "AU", "\u0627\u0633\u062a\u0631\u0627\u0644\u06cc\u0627" },
            { "AW", "\u0622\u0631\u0648\u0628\u0627" },
            { "AX", "\u0622\u0644\u0646\u062f \u062c\u0632\u06cc\u0631\u0647" },
            { "AZ", "\u0622\u0630\u0631\u0628\u0627\u06cc\u062c\u0648\u0646" },
            { "BA", "\u0628\u0648\u0633\u0646\u06cc \u0648 \u0647\u0631\u0632\u06af\u0648\u06cc\u0646" },
            { "BB", "\u0628\u0627\u0631\u0628\u0627\u062f\u0648\u0633" },
            { "BD", "\u0628\u0646\u06af\u0644\u0627\u062f\u0634" },
            { "BE", "\u0628\u0644\u0698\u06cc\u06a9" },
            { "BF", "\u0628\u0648\u0631\u06a9\u06cc\u0646\u0627 \u0641\u0627\u0633\u0648" },
            { "BG", "\u0628\u0644\u063a\u0627\u0631\u0633\u062a\u0648\u0646" },
            { "BH", "\u0628\u062d\u0631\u06cc\u0646" },
            { "BI", "\u0628\u0648\u0631\u0648\u0646\u062f\u06cc" },
            { "BJ", "\u0628\u0646\u06cc\u0646" },
            { "BL", "\u0633\u0646\u062a \u0628\u0627\u0631\u062a\u0644\u0645\u06cc" },
            { "BM", "\u0628\u0631\u0645\u0648\u062f\u0627" },
            { "BN", "\u0628\u0631\u0648\u0646\u0626\u06cc" },
            { "BO", "\u0628\u0648\u0644\u06cc\u0648\u06cc" },
            { "BQ", "\u0647\u0644\u0646\u062f \u0650\u06a9\u0627\u0631\u0627\u06cc\u06cc\u0628\u06cc \u062c\u0632\u0627\u06cc\u0631" },
            { "BR", "\u0628\u0631\u0632\u06cc\u0644" },
            { "BS", "\u0628\u0627\u0647\u0627\u0645\u0627" },
            { "BT", "\u0628\u0648\u062a\u0627\u0646" },
            { "BV", "\u0628\u0648\u0648\u062a \u062c\u0632\u06cc\u0631\u0647" },
            { "BW", "\u0628\u0648\u062a\u0633\u0627\u0648\u0627\u0646\u0627" },
            { "BY", "\u0628\u0644\u0627\u0631\u0648\u0633" },
            { "BZ", "\u0628\u0644\u06cc\u0632" },
            { "CA", "\u06a9\u0627\u0646\u0627\u062f\u0627" },
            { "CC", "\u06a9\u0648\u06a9 (\u06a9\u06cc\u0644\u06cc\u0646\u06af) \u062c\u0632\u0627\u06cc\u0631" },
            { "CD", "\u06a9\u0646\u06af\u0648 \u06a9\u06cc\u0646\u0634\u0627\u0633\u0627" },
            { "CF", "\u0645\u0631\u06a9\u0632\u06cc \u0622\u0641\u0631\u06cc\u0642\u0627\u06cc \u062c\u0645\u0647\u0648\u0631\u06cc" },
            { "CG", "\u06a9\u0646\u06af\u0648 \u0628\u0631\u0627\u0632\u0627\u0648\u06cc\u0644" },
            { "CH", "\u0633\u0648\u06cc\u06cc\u0633" },
            { "CI", "\u0639\u0627\u062c \u0650\u0633\u0627\u062d\u0644" },
            { "CK", "\u06a9\u0648\u06a9 \u062c\u0632\u0627\u06cc\u0631" },
            { "CL", "\u0634\u06cc\u0644\u06cc" },
            { "CM", "\u06a9\u0627\u0645\u0631\u0648\u0646" },
            { "CN", "\u0686\u06cc\u0646" },
            { "CO", "\u06a9\u0644\u0645\u0628\u06cc\u0627" },
            { "CP", "\u06a9\u0644\u06cc\u067e\u0631\u062a\u0648\u0646 \u062c\u0632\u06cc\u0631\u0647" },
            { "CR", "\u06a9\u0627\u0633\u062a\u0627\u0631\u06cc\u06a9\u0627" },
            { "CU", "\u06a9\u0648\u0628\u0627" },
            { "CV", "\u06a9\u06cc\u067e \u0648\u0631\u062f" },
            { "CW", "\u06a9\u0648\u0631\u0627\u0633\u0627\u0626\u0648" },
            { "CX", "\u06a9\u0631\u06cc\u0633\u0645\u0633 \u062c\u0632\u06cc\u0631\u0647" },
            { "CY", "\u0642\u0628\u0631\u0633" },
            { "CZ", "\u0686\u06a9 \u062c\u0645\u0647\u0648\u0631\u06cc" },
            { "DE", "\u0622\u0644\u0645\u0627\u0646" },
            { "DG", "\u062f\u06cc\u06af\u0648 \u06af\u0627\u0631\u0633\u06cc\u0627" },
            { "DJ", "\u062c\u06cc\u0628\u0648\u062a\u06cc" },
            { "DK", "\u062f\u0627\u0646\u0645\u0627\u0631\u06a9" },
            { "DM", "\u062f\u0648\u0645\u0646\u06cc\u06a9\u0627" },
            { "DO", "\u062f\u0648\u0645\u0646\u06cc\u06a9\u0646 \u062c\u0645\u0647\u0648\u0631\u06cc" },
            { "DZ", "\u0627\u0644\u062c\u0632\u06cc\u0631\u0647" },
            { "EA", "\u0633\u0648\u062a\u0627 \u0648 \u0645\u0644\u06cc\u0644\u0647" },
            { "EC", "\u0627\u06a9\u0648\u0627\u062f\u0631" },
            { "EE", "\u0627\u0633\u062a\u0648\u0646\u06cc" },
            { "EG", "\u0645\u0635\u0631" },
            { "EH", "\u063a\u0631\u0628\u06cc \u0635\u062d\u0631\u0627" },
            { "ER", "\u0627\u0631\u06cc\u062a\u0631\u0647" },
            { "ES", "\u0627\u06cc\u0633\u067e\u0627\u0646\u06cc\u0627" },
            { "ET", "\u0627\u062a\u06cc\u0648\u067e\u06cc" },
            { "EU", "\u0627\u0631\u0648\u067e\u0627 \u0627\u062a\u062d\u0627\u062f\u06cc\u0647" },
            { "FI", "\u0641\u0646\u0644\u0627\u0646\u062f" },
            { "FJ", "\u0641\u06cc\u062c\u06cc" },
            { "FK", "\u0641\u0627\u0644\u06a9\u0644\u0646\u062f \u062c\u0632\u06cc\u0631\u0647\u200c\u0626\u0648\u0646" },
            { "FM", "\u0645\u06cc\u06a9\u0631\u0648\u0646\u0632\u06cc" },
            { "FO", "\u0641\u0627\u0631\u0648 \u062c\u0632\u0627\u06cc\u0631" },
            { "FR", "\u0641\u0631\u0627\u0646\u0633\u0647" },
            { "GA", "\u06af\u0627\u0628\u0648\u0646" },
            { "GB", "\u0628\u0631\u06cc\u062a\u0627\u0646\u06cc\u0627" },
            { "GD", "\u06af\u0631\u0627\u0646\u0627\u062f\u0627" },
            { "GE", "\u06af\u0631\u062c\u0633\u062a\u0648\u0646" },
            { "GF", "\u0641\u0631\u0627\u0646\u0633\u0647\u200c\u06cc \u0650\u06af\u0648\u06cc\u0627\u0646" },
            { "GG", "\u06af\u0631\u0646\u0632\u06cc" },
            { "GH", "\u063a\u0646\u0627" },
            { "GI", "\u062c\u0628\u0644 \u0637\u0627\u0631\u0642" },
            { "GL", "\u06af\u0631\u06cc\u0646\u0644\u0646\u062f" },
            { "GM", "\u06af\u0627\u0645\u0628\u06cc\u0627" },
            { "GN", "\u06af\u06cc\u0646\u0647" },
            { "GP", "\u06af\u0648\u0627\u062f\u0644\u0648\u067e" },
            { "GQ", "\u0627\u0633\u062a\u0648\u0627\u06cc\u06cc \u06af\u06cc\u0646\u0647" },
            { "GR", "\u06cc\u0648\u0646\u0627\u0646" },
            { "GS", "\u062c\u0646\u0648\u0628\u06cc \u062c\u0648\u0631\u062c\u06cc\u0627 \u0648 \u062c\u0646\u0648\u0628\u06cc \u0633\u0627\u0646\u062f\u0648\u06cc\u0686 \u062c\u0632\u0627\u06cc\u0631" },
            { "GT", "\u06af\u0648\u0627\u062a\u0645\u0627\u0644\u0627" },
            { "GU", "\u06af\u0648\u0626\u0627\u0645" },
            { "GW", "\u06af\u06cc\u0646\u0647 \u0628\u06cc\u0633\u0627\u0626\u0648" },
            { "GY", "\u06af\u0648\u06cc\u0627\u0646" },
            { "HK", "\u0647\u0646\u06af \u06a9\u0646\u06af" },
            { "HM", "\u0647\u0627\u0631\u062f \u0648 \u0645\u06a9\u200c\u062f\u0648\u0646\u0627\u0644\u062f \u062c\u0632\u0627\u06cc\u0631" },
            { "HN", "\u0647\u0646\u062f\u0648\u0631\u0627\u0633" },
            { "HR", "\u06a9\u0631\u0648\u0627\u0633\u06cc" },
            { "HT", "\u0647\u0627\u06cc\u06cc\u062a\u06cc" },
            { "HU", "\u0645\u062c\u0627\u0631\u0633\u062a\u0648\u0646" },
            { "IC", "\u0642\u0646\u0627\u0631\u06cc \u062c\u0632\u0627\u06cc\u0631" },
            { "ID", "\u0627\u0646\u062f\u0648\u0646\u0632\u06cc" },
            { "IE", "\u0627\u06cc\u0631\u0644\u0646\u062f" },
            { "IL", "\u0627\u06cc\u0633\u0631\u0627\u06cc\u06cc\u0644" },
            { "IM", "\u0645\u0646 \u0650\u062c\u0632\u06cc\u0631\u0647" },
            { "IN", "\u0647\u0646\u062f" },
            { "IO", "\u0628\u0631\u06cc\u062a\u0627\u0646\u06cc\u0627\u06cc \u0647\u0646\u062f \u0650\u0627\u0648\u0642\u06cc\u0627\u0646\u0648\u0633 \u0650\u0645\u0646\u0627\u0637\u0642" },
            { "IQ", "\u0639\u0631\u0627\u0642" },
            { "IR", "\u0627\u06cc\u0631\u0627\u0646" },
            { "IS", "\u0627\u06cc\u0633\u0644\u0646\u062f" },
            { "IT", "\u0627\u06cc\u062a\u0627\u0644\u06cc\u0627" },
            { "JE", "\u062c\u0631\u0633\u06cc" },
            { "JM", "\u062c\u0627\u0645\u0627\u06cc\u06cc\u06a9\u0627" },
            { "JO", "\u0627\u0631\u062f\u0646" },
            { "JP", "\u062c\u0627\u067e\u0648\u0646" },
            { "KE", "\u06a9\u0646\u06cc\u0627" },
            { "KG", "\u0642\u0631\u0642\u06cc\u0632\u0633\u062a\u0648\u0646" },
            { "KH", "\u06a9\u0627\u0645\u0628\u0648\u062c" },
            { "KI", "\u06a9\u06cc\u0631\u06cc\u0628\u0627\u062a\u06cc" },
            { "KM", "\u06a9\u0648\u0645\u0648\u0631" },
            { "KN", "\u0633\u0646\u062a \u06a9\u06cc\u062a\u0633 \u0648 \u0646\u0648\u06cc\u0633" },
            { "KP", "\u0634\u0645\u0627\u0644\u06cc \u06a9\u064f\u0631\u0647" },
            { "KR", "\u062c\u0646\u0648\u0628\u06cc \u06a9\u064f\u0631\u0647" },
            { "KW", "\u06a9\u0648\u06cc\u062a" },
            { "KY", "\u06a9\u06cc\u0645\u0646 \u062c\u0632\u06cc\u0631\u0647\u200c\u0626\u0648\u0646" },
            { "KZ", "\u0642\u0632\u0627\u0642\u0633\u062a\u0648\u0646" },
            { "LA", "\u0644\u0627\u0626\u0648\u0633" },
            { "LB", "\u0644\u0628\u0646\u0627\u0646" },
            { "LC", "\u0633\u0646\u062a \u0644\u0648\u0633\u06cc\u0627" },
            { "LI", "\u0644\u06cc\u062e\u062a\u0646 \u0627\u0634\u062a\u0627\u06cc\u0646" },
            { "LK", "\u0633\u0631\u06cc\u0644\u0627\u0646\u06a9\u0627" },
            { "LR", "\u0644\u06cc\u0628\u0631\u06cc\u0627" },
            { "LS", "\u0644\u0633\u0648\u062a\u0648" },
            { "LT", "\u0644\u062a\u0648\u0646\u06cc" },
            { "LU", "\u0644\u0648\u06a9\u0632\u0627\u0645\u0628\u0648\u0631\u06af" },
            { "LV", "\u0644\u0627\u062a\u0648\u06cc\u0627" },
            { "LY", "\u0644\u06cc\u0628\u06cc" },
            { "MA", "\u0645\u0631\u0627\u06a9\u0634" },
            { "MC", "\u0645\u0648\u0646\u0627\u06a9\u0648" },
            { "MD", metaValue_MD },
            { "ME", "\u0645\u0648\u0646\u062a\u0647\u200c\u0646\u06af\u0631\u0648" },
            { "MF", "\u0633\u0646\u062a \u0645\u0627\u0631\u062a\u06cc\u0646" },
            { "MG", "\u0645\u0627\u062f\u0627\u06af\u0627\u0633\u06a9\u0627\u0631" },
            { "MH", "\u0645\u0627\u0631\u0634\u0627\u0644 \u062c\u0632\u0627\u06cc\u0631" },
            { "ML", "\u0645\u0627\u0644\u06cc" },
            { "MM", "\u0645\u06cc\u0627\u0646\u0645\u0627\u0631" },
            { "MN", "\u0645\u063a\u0648\u0644\u0633\u062a\u0648\u0646" },
            { "MO", "\u0645\u0627\u06a9\u0627\u0626\u0648 (\u0686\u06cc\u0646 \u062f\u0644\u0647)" },
            { "MP", "\u0634\u0645\u0627\u0644\u06cc \u0645\u0627\u0631\u06cc\u0627\u0646\u0627 \u062c\u0632\u0627\u06cc\u0631" },
            { "MQ", "\u0645\u0627\u0631\u062a\u06cc\u0646\u06cc\u06a9 \u062c\u0632\u06cc\u0631\u0647\u200c\u0626\u0648\u0646" },
            { "MR", "\u0645\u0648\u0631\u06cc\u062a\u0627\u0646\u06cc" },
            { "MS", "\u0645\u0648\u0646\u062a\u0633\u0631\u0627\u062a" },
            { "MT", "\u0645\u0627\u0644\u062a" },
            { "MU", "\u0645\u0648\u0631\u0649 \u062a\u064a\u0648\u0633" },
            { "MV", "\u0645\u0627\u0644\u062f\u06cc\u0648" },
            { "MW", "\u0645\u0627\u0644\u0627\u0648\u06cc" },
            { "MX", "\u0645\u06a9\u0632\u06cc\u06a9" },
            { "MY", "\u0645\u0627\u0644\u0632\u06cc" },
            { "MZ", "\u0645\u0648\u0632\u0627\u0645\u0628\u06cc\u06a9" },
            { "NA", "\u0646\u0627\u0645\u0628\u06cc\u0627" },
            { "NC", "\u0646\u06cc\u0648 \u06a9\u0627\u0644\u06cc\u062f\u0648\u0646\u06cc\u0627" },
            { "NE", "\u0646\u06cc\u062c\u0631" },
            { "NF", "\u0646\u0648\u0631\u0641\u0648\u0644\u06a9 \u062c\u0632\u06cc\u0631\u0647" },
            { "NG", "\u0646\u06cc\u062c\u0631\u06cc\u0647" },
            { "NI", "\u0646\u06cc\u06a9\u0627\u0631\u0627\u06af\u0648\u0626\u0647" },
            { "NL", "\u0647\u0644\u0646\u062f" },
            { "NO", "\u0646\u0631\u0648\u0698" },
            { "NP", "\u0646\u067e\u0627\u0644" },
            { "NR", "\u0646\u0627\u0626\u0648\u0631\u0648" },
            { "NU", "\u0646\u06cc\u0626\u0648" },
            { "NZ", "\u0646\u06cc\u0648\u0632\u0644\u0646\u062f" },
            { "OM", "\u0639\u0645\u0627\u0646" },
            { "PA", "\u067e\u0627\u0646\u0627\u0645\u0627" },
            { "PE", "\u067e\u0631\u0648" },
            { "PF", "\u0641\u0631\u0627\u0646\u0633\u0647\u200c\u06cc \u067e\u0648\u0644\u06cc\u200c\u0646\u0632\u06cc" },
            { "PG", "\u067e\u0627\u067e\u0648\u0627 \u0646\u0648 \u06af\u06cc\u0646\u0647" },
            { "PH", "\u0641\u06cc\u0644\u06cc\u067e\u06cc\u0646" },
            { "PK", "\u067e\u0627\u06a9\u0633\u062a\u0648\u0646" },
            { "PL", "\u0644\u0647\u0633\u062a\u0648\u0646" },
            { "PM", "\u0633\u0646 \u067e\u06cc\u06cc\u0631 \u0648 \u0645\u06cc\u06a9\u0644\u0646" },
            { "PN", "\u067e\u06cc\u062a\u06a9\u0627\u0631\u06cc\u0646 \u062c\u0632\u0627\u06cc\u0631" },
            { "PR", "\u067e\u0648\u0631\u062a\u0648\u0631\u06cc\u06a9\u0648" },
            { "PS", "\u0641\u0644\u0633\u0637\u06cc\u0646 \u0650\u0633\u0631\u0632\u0645\u06cc\u0646" },
            { "PT", "\u067e\u0631\u062a\u063a\u0627\u0644" },
            { "PW", "\u067e\u0627\u0644\u0627\u0626\u0648" },
            { "PY", "\u067e\u0627\u0631\u0627\u06af\u0648\u0626\u0647" },
            { "QA", "\u0642\u0637\u0631" },
            { "QO", "\u0627\u0648\u0642\u06cc\u0627\u0646\u0648\u0633\u06cc\u0647\u200c\u06cc \u0650\u067e\u0631\u062a \u0650\u062c\u0627\u0626\u0648\u0646" },
            { "RE", "\u0631\u0626\u0648\u0646\u06cc\u0648\u0646" },
            { "RO", "\u0631\u0648\u0645\u0627\u0646\u06cc" },
            { "RS", "\u0635\u0631\u0628\u0633\u062a\u0648\u0646" },
            { "RU", "\u0631\u0648\u0633\u06cc\u0647" },
            { "RW", "\u0631\u0648\u0622\u0646\u062f\u0627" },
            { "SA", "\u0639\u0631\u0628\u0633\u062a\u0648\u0646" },
            { "SB", "\u0633\u0644\u06cc\u0645\u0648\u0646 \u062c\u0632\u06cc\u0631\u0647" },
            { "SC", "\u0633\u06cc\u0634\u0644" },
            { "SD", "\u0633\u0648\u062f\u0627\u0646" },
            { "SE", "\u0633\u0648\u0626\u062f" },
            { "SG", "\u0633\u0646\u06af\u0627\u067e\u0648\u0631" },
            { "SH", "\u0633\u0646\u062a \u0647\u0644\u0646\u0627" },
            { "SI", "\u0627\u0633\u0644\u0648\u0648\u0646\u06cc" },
            { "SJ", "\u0633\u0648\u0627\u0644\u0628\u0627\u0631\u062f \u0648 \u064a\u0627\u0646 \u0645\u0627\u064a\u0646" },
            { "SK", metaValue_SK },
            { "SL", "\u0633\u06cc\u0631\u0627\u0644\u0626\u0648\u0646" },
            { "SM", "\u0633\u0646 \u0645\u0627\u0631\u06cc\u0646\u0648" },
            { "SN", "\u0633\u0646\u06af\u0627\u0644" },
            { "SO", "\u0633\u0648\u0645\u0627\u0644\u06cc" },
            { "SR", "\u0633\u0648\u0631\u06cc\u0646\u0627\u0645" },
            { "SS", "\u062c\u0646\u0648\u0628\u06cc \u0633\u0648\u062f\u0627\u0646" },
            { "ST", "\u0633\u0627\u0626\u0648\u062a\u0648\u0645\u0647 \u0648 \u067e\u0631\u06cc\u0646\u0633\u06cc\u067e" },
            { "SV", "\u0627\u0644\u0633\u0627\u0644\u0648\u0627\u062f\u0648\u0631" },
            { "SX", "\u0633\u0646\u062a \u0645\u0627\u0631\u062a\u0646" },
            { "SY", "\u0633\u0648\u0631\u06cc\u0647" },
            { "SZ", "\u0633\u0648\u0627\u0632\u06cc\u0644\u0646\u062f" },
            { "TA", "\u062a\u0631\u06cc\u0633\u062a\u0627\u0646 \u062f\u0627 \u062c\u0648\u0646\u0647\u0627" },
            { "TC", "\u062a\u0648\u0631\u06a9\u0633 \u0648 \u06a9\u0627\u06cc\u06a9\u0648\u0633 \u062c\u0632\u0627\u06cc\u0631" },
            { "TD", "\u0686\u0627\u062f" },
            { "TF", "\u0641\u0631\u0627\u0646\u0633\u0647\u200c\u06cc \u062c\u0646\u0648\u0628\u06cc \u0645\u0646\u0627\u0637\u0642" },
            { "TG", "\u062a\u0648\u06af\u0648" },
            { "TH", "\u062a\u0627\u06cc\u0644\u0646\u062f" },
            { "TJ", "\u062a\u0627\u062c\u06cc\u06a9\u0633\u062a\u0648\u0646" },
            { "TK", "\u062a\u0648\u06a9\u0644\u0627\u0626\u0648" },
            { "TL", "\u062a\u06cc\u0645\u0648\u0631 \u0634\u0631\u0642\u06cc" },
            { "TM", "\u062a\u0631\u06a9\u0645\u0648\u0646\u0633\u062a\u0648\u0646" },
            { "TN", "\u062a\u0648\u0646\u0633" },
            { "TO", "\u062a\u0648\u0646\u06af\u0627" },
            { "TR", "\u062a\u0631\u06a9\u06cc\u0647" },
            { "TT", "\u062a\u0631\u06cc\u0646\u06cc\u062f\u0627\u062f \u0648 \u062a\u0648\u0628\u0627\u06af\u0648" },
            { "TV", "\u062a\u0648\u0648\u0627\u0644\u0648" },
            { "TW", "\u062a\u0627\u06cc\u0648\u0627\u0646" },
            { "TZ", "\u062a\u0627\u0646\u0632\u0627\u0646\u06cc\u0627" },
            { "UA", "\u0627\u0648\u06a9\u0631\u0627\u06cc\u0646" },
            { "UG", "\u0627\u0648\u06af\u0627\u0646\u062f\u0627" },
            { "UM", "\u0622\u0645\u0631\u06cc\u06a9\u0627\u06cc \u067e\u064e\u0631\u062a\u0650\u200c\u067e\u0650\u0644\u0627 \u062c\u0632\u06cc\u0631\u0647\u200c\u0626\u0648\u0646" },
            { "US", "\u0645\u062a\u062d\u062f\u0647 \u0627\u06cc\u0627\u0644\u0627\u062a" },
            { "UY", "\u0627\u0631\u0648\u06af\u0648\u0626\u0647" },
            { "UZ", "\u0627\u0632\u0628\u06a9\u0633\u062a\u0648\u0646" },
            { "VA", "\u0648\u0627\u062a\u06cc\u06a9\u0627\u0646" },
            { "VC", "\u0633\u0646\u062a \u0648\u06cc\u0646\u0633\u0646\u062a \u0648 \u06af\u0631\u0646\u0627\u062f\u06cc\u0646" },
            { "VE", "\u0648\u0646\u0632\u0648\u0626\u0644\u0627" },
            { "VG", "\u0628\u0631\u06cc\u062a\u0627\u0646\u06cc\u0627\u06cc \u0648\u06cc\u0631\u062c\u06cc\u0646" },
            { "VI", "\u0622\u0645\u0631\u06cc\u06a9\u0627\u06cc \u0648\u06cc\u0631\u062c\u06cc\u0646" },
            { "VN", "\u0648\u06cc\u062a\u0646\u0627\u0645" },
            { "VU", "\u0648\u0627\u0646\u0648\u0627\u062a\u0648" },
            { "WF", "\u0648\u0627\u0644\u06cc\u0633 \u0648 \u0641\u0648\u062a\u0648\u0646\u0627" },
            { "WS", "\u0633\u0627\u0645\u0648\u0622" },
            { "XK", "\u06a9\u0648\u0632\u0648\u0648" },
            { "YE", "\u06cc\u0645\u0646" },
            { "YT", "\u0645\u0627\u06cc\u0648\u062a" },
            { "ZA", "\u062c\u0646\u0648\u0628\u06cc \u0627\u0641\u0631\u06cc\u0642\u0627" },
            { "ZM", "\u0632\u0627\u0645\u0628\u06cc\u0627" },
            { "ZW", "\u0632\u06cc\u0645\u0628\u0627\u0628\u0648\u0647" },
            { "ZZ", "\u0646\u0627\u0645\u064e\u06cc\u0650\u0651\u0646 \u0645\u0646\u0637\u0642\u0647" },
            { "ab", "\u0622\u0628\u062e\u0627\u0632\u06cc" },
            { "af", "\u0622\u0641\u0631\u06cc\u06a9\u0627\u0646\u0633" },
            { "ak", "\u0622\u06a9\u0627\u0646" },
            { "am", "\u0627\u0645\u0647\u0631\u06cc" },
            { "ar", metaValue_ar },
            { "as", "\u0622\u0633\u0627\u0645\u06cc" },
            { "az", "\u0622\u0630\u0631\u06cc \u0650\u062a\u0631\u06a9\u06cc" },
            { "ba", "\u0628\u0627\u0634\u0642\u06cc\u0631\u06cc" },
            { "be", "\u0628\u0644\u0627\u0631\u0648\u0633\u06cc" },
            { "bg", "\u0628\u0644\u063a\u0627\u0631\u06cc" },
            { "bm", "\u0628\u0627\u0645\u0628\u0627\u0631\u0627\u06cc\u06cc" },
            { "bn", metaValue_bn },
            { "bo", "\u062a\u0628\u062a\u06cc" },
            { "br", "\u0628\u0631\u0650\u062a\u0648\u0646\u06cc" },
            { "bs", "\u0628\u0648\u0633\u0646\u06cc\u0627\u06cc\u06cc" },
            { "ca", "\u06a9\u0627\u062a\u0627\u0644\u0648\u0646\u06cc" },
            { "ce", "\u0686\u0686\u0646\u06cc" },
            { "co", "\u06a9\u0648\u0631\u0633\u06cc\u06a9\u0627\u0646" },
            { "cs", "\u0686\u06a9\u06cc" },
            { "cv", "\u0686\u0648\u0648\u0627\u0634\u06cc" },
            { "cy", "\u0648\u0644\u0632\u06cc" },
            { "da", "\u062f\u0627\u0646\u0645\u0627\u0631\u06a9\u06cc" },
            { "de", "\u0622\u0644\u0645\u0627\u0646\u06cc" },
            { "dz", "\u062f\u0632\u0648\u0646\u06af\u062e\u0627" },
            { "ee", "\u0627\u0648\u0647\u200c\u06cc\u06cc" },
            { "el", metaValue_el },
            { "en", "\u0627\u0646\u06af\u0644\u06cc\u0633\u06cc" },
            { "eo", "\u0627\u0633\u067e\u0631\u0627\u0646\u062a\u0648" },
            { "es", "\u0627\u06cc\u0633\u067e\u0627\u0646\u06cc\u0648\u0644\u06cc" },
            { "et", "\u0627\u0633\u062a\u0648\u0646\u06cc\u0627\u06cc\u06cc" },
            { "eu", "\u0628\u0627\u0633\u06a9\u06cc" },
            { "fa", "\u0641\u0627\u0631\u0633\u06cc" },
            { "fi", "\u0641\u06cc\u0646\u06cc\u0634" },
            { "fj", "\u0641\u06cc\u062c\u06cc\u0627\u06cc\u06cc" },
            { "fo", "\u0641\u0627\u0631\u0648\u06cc\u06cc" },
            { "fr", "\u0641\u0631\u0627\u0646\u0633\u0648\u06cc" },
            { "fy", "\u063a\u0631\u0628\u06cc \u0641\u06cc\u0631\u06cc\u0632\u06cc" },
            { "ga", "\u0627\u06cc\u0631\u06cc\u0634" },
            { "gl", "\u06af\u0627\u0644\u06cc\u06a9" },
            { "gn", "\u06af\u0648\u0631\u0627\u0646\u06cc" },
            { "gu", metaValue_gu },
            { "gv", "\u0645\u0627\u0646\u06a9\u0633" },
            { "ha", "\u0647\u0648\u0633\u0627" },
            { "he", metaValue_he },
            { "hi", "\u0647\u0646\u062f\u06cc" },
            { "hr", "\u06a9\u0631\u0648\u0627\u062a\u06cc" },
            { "ht", "\u0647\u0627\u0626\u062a\u06cc\u0627\u06cc\u06cc" },
            { "hu", "\u0645\u062c\u0627\u0631\u06cc" },
            { "hy", metaValue_hy },
            { "id", "\u0627\u0646\u062f\u0648\u0646\u0632\u06cc\u0627\u06cc\u06cc" },
            { "ig", "\u0627\u06cc\u06af\u0628\u0648" },
            { "ii", "\u0633\u06cc\u0686\u0648\u0626\u0627\u0646 \u06cc\u06cc" },
            { "is", "\u0627\u06cc\u0633\u0644\u0646\u062f\u06cc" },
            { "it", "\u0627\u06cc\u062a\u0627\u0644\u06cc\u0627\u06cc\u06cc" },
            { "iu", "\u0627\u0646\u0648\u06a9\u062a\u06cc\u062a\u0648\u062a" },
            { "ja", metaValue_ja },
            { "jv", "\u062c\u0627\u0648\u0627\u06cc\u06cc" },
            { "ka", metaValue_ka },
            { "ki", "\u06a9\u06cc\u06a9\u0648\u06cc\u0648" },
            { "kk", "\u0642\u0632\u0627\u0642\u06cc" },
            { "kl", "\u06a9\u0627\u0644\u0627\u0626\u0644\u06cc\u0633\u0648\u062a" },
            { "km", "\u062e\u0645\u0631\u06cc" },
            { "kn", "\u06a9\u0627\u0646\u0651\u0627\u062f\u0627" },
            { "ko", "\u06a9\u064f\u0631\u0647\u200c\u06cc\u06cc" },
            { "ks", "\u06a9\u0634\u0645\u06cc\u0631\u06cc" },
            { "ku", "\u06a9\u0648\u0631\u062f\u06cc" },
            { "kw", "\u06a9\u0648\u0631\u0646\u06cc\u0634" },
            { "ky", "\u0642\u0631\u0642\u06cc\u0632\u06cc" },
            { "la", "\u0644\u0627\u062a\u06cc\u0646" },
            { "lb", "\u0644\u0648\u06a9\u0632\u0627\u0645\u0628\u0648\u0631\u06af\u06cc" },
            { "lg", "\u06af\u0627\u0646\u062f\u0627" },
            { "ln", "\u0644\u06cc\u0646\u06af\u0627\u0644\u0627" },
            { "lo", "\u0644\u0627\u0626\u0648\u06cc\u06cc" },
            { "lt", "\u0644\u062a\u0648\u0646\u06cc\u0627\u06cc\u06cc" },
            { "lu", "\u0644\u0648\u0628\u0627-\u06a9\u0627\u062a\u0627\u0646\u06af\u0627" },
            { "lv", "\u0644\u0627\u062a\u0648\u06cc\u0627\u06cc\u06cc" },
            { "mg", "\u0645\u0627\u0644\u0627\u06af\u0627\u0633\u06cc" },
            { "mi", "\u0645\u0627\u0626\u0648\u0631\u06cc" },
            { "mk", "\u0645\u0642\u062f\u0648\u0646\u06cc" },
            { "ml", "\u0645\u0627\u0644\u0627\u06cc\u0627\u0644\u0627\u0645" },
            { "mn", "\u0645\u063a\u0648\u0644\u06cc" },
            { "mr", "\u0645\u0627\u0631\u0627\u062a\u06cc" },
            { "ms", "\u0645\u0627\u0644\u0627\u06cc\u06cc" },
            { "mt", "\u0645\u0627\u0644\u062a\u06cc" },
            { "my", "\u0628\u0631\u0645\u0647\u200c\u06cc\u06cc" },
            { "nb", "\u0646\u0631\u0648\u0698\u06cc \u0628\u0648\u06a9\u0645\u0627\u0644" },
            { "nd", "\u0634\u0645\u0627\u0644\u06cc \u0646\u062f\u0628\u0644\u0647" },
            { "ne", "\u0646\u067e\u0627\u0644\u06cc" },
            { "nl", "\u0647\u0644\u0646\u062f\u06cc" },
            { "nn", "\u0646\u0631\u0648\u0698\u06cc \u0646\u06cc\u0646\u0648\u0631\u0633\u06a9" },
            { "om", "\u0627\u0648\u0631\u0648\u0645\u0648" },
            { "or", "\u0627\u0648\u0631\u06cc\u0627" },
            { "pa", "\u067e\u0646\u062c\u0627\u0628\u06cc" },
            { "pl", "\u0644\u0647\u0633\u062a\u0648\u0646\u06cc" },
            { "ps", "\u067e\u0634\u062a\u0648" },
            { "pt", "\u067e\u0631\u062a\u063a\u0627\u0644\u06cc" },
            { "qu", "\u0642\u0648\u0626\u0686\u0648\u0626\u0627" },
            { "rm", "\u0631\u0648\u0645\u0627\u0646\u0634" },
            { "rn", "\u0631\u0648\u0646\u062f\u06cc" },
            { "ro", "\u0631\u0648\u0645\u0627\u0646\u06cc\u0627\u06cc\u06cc" },
            { "ru", "\u0631\u0648\u0633\u06cc" },
            { "rw", "\u06a9\u0646\u06cc\u0627\u0631\u0648\u0622\u0646\u062f\u0627\u06cc\u06cc" },
            { "sa", "\u0633\u0627\u0646\u0633\u06a9\u0631\u06cc\u062a" },
            { "sd", "\u0633\u0646\u062f\u06cc" },
            { "se", "\u0634\u0645\u0627\u0644\u06cc \u0633\u0627\u0645\u06cc" },
            { "sg", "\u0633\u0627\u0646\u06af\u0648" },
            { "si", "\u0633\u06cc\u0646\u0647\u0627\u0644\u0627" },
            { "sk", metaValue_SK },
            { "sl", "\u0627\u0633\u0644\u0648\u0648\u0646\u06cc\u0627\u06cc\u06cc" },
            { "sn", "\u0634\u0648\u0646\u0627" },
            { "so", "\u0633\u0648\u0645\u0627\u0644\u06cc\u0627\u06cc\u06cc" },
            { "sq", "\u0622\u0644\u0628\u0627\u0646\u06cc\u0627\u06cc\u06cc" },
            { "sr", "\u0635\u0631\u0628\u06cc" },
            { "su", "\u0633\u0648\u0646\u062f\u0627\u0646\u0633\u06cc" },
            { "sv", "\u0633\u0648\u0626\u062f\u06cc" },
            { "sw", "\u0633\u0648\u0627\u062d\u06cc\u0644\u06cc" },
            { "ta", "\u062a\u0627\u0645\u06cc\u0644\u06cc" },
            { "te", "\u062a\u0644\u0648\u06af\u0648\u06cc\u06cc" },
            { "tg", "\u062a\u0627\u062c\u06cc\u06a9\u06cc" },
            { "th", "\u062a\u0627\u06cc\u06cc" },
            { "ti", "\u062a\u06cc\u06af\u0631\u06cc\u0646\u06cc\u0627\u06cc\u06cc" },
            { "tk", "\u062a\u0631\u06a9\u0645\u0648\u0646\u06cc" },
            { "to", "\u062a\u0648\u0646\u06af\u0627\u0646\u06cc" },
            { "tr", "\u062a\u0631\u06a9\u06cc" },
            { "tt", "\u062a\u0627\u062a\u0627\u0631\u06cc" },
            { "ug", "\u0626\u0648\u063a\u0648\u0631\u06cc" },
            { "uk", "\u0627\u0648\u06a9\u0631\u0627\u06cc\u0646\u06cc" },
            { "ur", "\u0627\u0631\u062f\u0648" },
            { "uz", "\u0627\u0632\u0628\u06a9\u06cc" },
            { "vi", "\u0648\u06cc\u062a\u0646\u0627\u0645\u06cc" },
            { "wo", "\u0648\u0648\u0644\u0641\u06cc" },
            { "xh", "\u062e\u0648\u0633\u0627" },
            { "yo", "\u06cc\u0648\u0631\u0648\u0628\u0627" },
            { "zh", "\u0686\u06cc\u0646\u06cc" },
            { "zu", "\u0632\u0648\u0644\u0648" },
            { "agq", "\u0622\u0642\u0645" },
            { "arn", "\u0645\u0627\u067e\u0648\u0686\u0647" },
            { "asa", "\u0622\u0633\u0648" },
            { "bem", "\u0628\u0645\u0628\u0627\u06cc\u06cc" },
            { "bez", "\u0628\u0646\u0627\u06cc\u06cc" },
            { "bgn", "\u063a\u0631\u0628\u06cc \u0628\u0644\u0648\u0686\u06cc" },
            { "brx", "\u0628\u062f\u0648\u06cc\u06cc" },
            { "cgg", "\u0686\u06cc\u06af\u0627" },
            { "chr", "\u0686\u0631\u0648\u06a9\u06cc\u0627\u06cc\u06cc" },
            { "ckb", "\u0645\u06cc\u0648\u0646\u06cc \u06a9\u0648\u0631\u062f\u06cc" },
            { "dav", "\u062a\u0627\u06cc\u062a\u0627" },
            { "dje", "\u0632\u0627\u0631\u0645\u0627\u06cc\u06cc" },
            { "dsb", "\u067e\u0627\u06cc\u06cc\u0646 \u0635\u0631\u0628\u06cc" },
            { "dua", "\u062f\u0648\u0626\u0627\u0644\u0627\u06cc\u06cc" },
            { "dyo", "\u062c\u0648\u0644\u0627-\u0641\u0648\u0646\u06cc" },
            { "ebu", "\u0627\u0645\u0628\u0648" },
            { "fil", "\u0641\u06cc\u0644\u06cc\u067e\u06cc\u0646\u0648" },
            { "gag", "\u06af\u0627\u06af\u0627\u0626\u0648\u0632\u06cc" },
            { "gsw", "\u0633\u0648\u06cc\u06cc\u0633 \u0622\u0644\u0645\u0627\u0646\u06cc" },
            { "guz", "\u06af\u0648\u0633\u06cc" },
            { "haw", "\u0647\u0627\u0648\u0627\u06cc\u06cc\u0627\u06cc\u06cc" },
            { "hsb", "\u0628\u0627\u0644\u0627\u06cc\u06cc \u0635\u0631\u0628\u06cc" },
            { "jgo", "\u0646\u06af\u0648\u0645\u0628\u0627" },
            { "jmc", "\u0645\u0627\u0686\u0627\u0645\u0647" },
            { "kab", "\u0642\u0628\u0627\u06cc\u0644\u06cc" },
            { "kam", "\u06a9\u0627\u0645\u0628\u0627\u06cc\u06cc" },
            { "kde", "\u0645\u0627\u06a9\u0648\u0646\u062f\u0647" },
            { "kea", "\u06a9\u06cc\u067e \u0648\u064f\u0631\u062f\u06cc" },
            { "khq", "\u06a9\u0648\u06cc\u0631\u0627 \u0686\u06cc\u06cc\u0646\u06cc" },
            { "kln", "\u06a9\u0627\u0644\u0646\u062c\u06cc\u0646" },
            { "koi", "\u06a9\u0648\u0645\u06cc-\u067e\u0631\u0645\u06cc\u0627\u06a9" },
            { "kok", "\u06a9\u0648\u0646\u06a9\u0627\u0646\u06cc" },
            { "ksb", "\u0634\u0627\u0645\u0628\u0627\u0644\u0627" },
            { "ksf", "\u0628\u0627\u0641\u06cc\u0627\u06cc\u06cc" },
            { "lag", "\u0644\u0627\u0646\u06af\u06cc" },
            { "lkt", "\u0644\u0627\u06a9\u0648\u062a\u0627" },
            { "lrc", "\u0634\u0645\u0627\u0644\u06cc \u0644\u064f\u0631\u06cc" },
            { "luo", "\u0644\u0648\u0626\u0648" },
            { "luy", "\u0644\u0648\u06cc\u06cc\u0627" },
            { "mas", "\u0645\u0627\u0633\u0627\u06cc\u06cc" },
            { "mer", "\u0645\u0650\u0631\u0648\u06cc\u06cc" },
            { "mfe", "\u0645\u0648\u0631\u06cc\u0633\u06cc\u0646" },
            { "mgh", "\u0645\u0627\u062e\u0648\u0626\u0627-\u0645\u06cc\u062a\u0648" },
            { "mgo", "\u0645\u0650\u062a\u0627\u0621" },
            { "moh", "\u0645\u0648\u0647\u0627\u06a9" },
            { "mua", "\u0645\u0648\u0646\u062f\u0627\u0646\u06af" },
            { "mzn", "\u0645\u0627\u0632\u0631\u0648\u0646\u06cc" },
            { "naq", "\u0646\u0627\u0645\u0627" },
            { "nds", "\u067e\u0627\u06cc\u06cc\u0646 \u0622\u0644\u0645\u0627\u0646\u06cc" },
            { "nmg", "\u06a9\u0648\u0626\u0627\u0633\u06cc\u0648" },
            { "nqo", "\u0646\u0626\u06a9\u0648" },
            { "nus", "\u0646\u0648\u0626\u0631" },
            { "nyn", "\u0646\u06cc\u0627\u0646\u06a9\u0648\u0644\u0647" },
            { "quc", "\u06a9\u0626\u06cc\u0686\u0647\u200c\u0626\u06cc" },
            { "rof", "\u0631\u0648\u0645\u0628\u0648" },
            { "rwk", "\u0631\u0648\u0622\u06cc\u06cc" },
            { "saq", "\u0633\u0627\u0645\u0628\u0648\u0631\u0648" },
            { "sbp", "\u0633\u0627\u0646\u06af\u0648\u0648" },
            { "sdh", "\u062c\u0646\u0648\u0628\u06cc \u06a9\u0631\u062f\u06cc" },
            { "seh", "\u0633\u0650\u0646\u0627\u06cc\u06cc" },
            { "ses", "\u06a9\u0648\u06cc\u0631\u0627\u0628\u0648\u0631\u0627 \u0633\u0646\u06cc" },
            { "shi", "\u062a\u0627\u0686\u0644\u0647\u06cc\u062a" },
            { "sma", "\u062c\u0646\u0648\u0628\u06cc \u0633\u0627\u0645\u06cc" },
            { "smj", "\u0644\u0648\u0644\u0647 \u0633\u0627\u0645\u06cc" },
            { "smn", "\u0627\u06cc\u0646\u0627\u0631\u06cc \u0633\u0627\u0645\u06cc" },
            { "sms", "\u0633\u06a9\u0648\u0644\u062a \u0633\u0627\u0645\u06cc" },
            { "teo", "\u062a\u0633\u0648\u06cc\u06cc" },
            { "twq", "\u062a\u0627\u0633\u0627\u0648\u0627\u0642\u06cc" },
            { "tzm", "\u0645\u06cc\u0648\u0646\u06cc \u0627\u0637\u0644\u0633 \u062a\u0627\u0645\u0632\u06cc\u0642\u06cc" },
            { "und", "\u0646\u0634\u0646\u0627\u0633\u06cc\u200c\u06cc\u0647 \u0632\u0648\u0648\u0646" },
            { "vai", "\u0648\u0627\u06cc\u06cc" },
            { "vun", "\u0648\u0648\u0646\u062c\u0648\u06cc\u06cc" },
            { "wbp", "\u0648\u0627\u0644\u0631\u067e\u06cc\u0631\u06cc" },
            { "xog", "\u0633\u0648\u06af\u0627" },
            { "zgh", "\u0645\u0631\u0627\u06a9\u0634 \u0650\u0627\u0633\u062a\u0627\u0646\u062f\u0627\u0631\u062f \u0650\u062a\u0627\u0645\u0627\u0632\u06cc\u0642\u062a\u06cc" },
            { "zxx", "\u0627\u06cc\u0646 \u0632\u0648\u0648\u0646 \u0628\u0634\u0646\u0627\u0633\u06cc\u200c\u06cc\u0647 \u0646\u06cc\u0651\u0647" },
            { "Arab", metaValue_ar },
            { "Armn", metaValue_hy },
            { "Beng", metaValue_bn },
            { "Bopo", "\u0628\u0648\u067e\u0648\u0645\u0648\u0641\u0648" },
            { "Cyrl", "\u0633\u06cc\u0631\u06cc\u0644\u06cc\u06a9" },
            { "Deva", "\u062f\u06cc\u0648\u0627\u0646\u0627\u0646\u06af\u0631\u06cc" },
            { "Ethi", "\u0627\u062a\u06cc\u0648\u067e\u06cc\u0627\u06cc\u06cc" },
            { "Geor", metaValue_ka },
            { "Grek", metaValue_el },
            { "Gujr", metaValue_gu },
            { "Guru", "\u06af\u0648\u0631\u0645\u0648\u062e\u06cc" },
            { "Hang", "\u0647\u0627\u0646\u06af\u0648\u0644" },
            { "Hani", "\u0647\u0627\u0646" },
            { "Hans", "\u0633\u0627\u062f\u0647\u200c\u0628\u064e\u06cc\u06cc \u0647\u0627\u0646" },
            { "Hant", "\u0633\u0646\u062a\u06cc \u0647\u0627\u0646\u062a" },
            { "Hebr", metaValue_he },
            { "Hira", "\u0647\u06cc\u0631\u0627\u06af\u0627\u0646\u0627" },
            { "Jpan", metaValue_ja },
            { "Kana", "\u06a9\u0627\u062a\u0627\u06a9\u0627\u0646\u0627" },
            { "de_AT", "\u0627\u062a\u0631\u06cc\u0634 \u0650\u0622\u0644\u0645\u0627\u0646\u06cc" },
            { "de_CH", "\u0633\u0648\u06cc\u06cc\u0633 \u0650\u0622\u0644\u0645\u0627\u0646\u06cc" },
            { "en_AU", "\u0627\u0633\u062a\u0631\u0627\u0644\u06cc\u0627\u06cc \u0650\u0627\u0646\u06af\u0644\u06cc\u0633\u06cc" },
            { "en_CA", "\u06a9\u0627\u0646\u0627\u062f\u0627\u06cc \u0650\u0627\u0646\u06af\u0644\u06cc\u0633\u06cc" },
            { "en_GB", "\u0628\u0631\u06cc\u062a\u06cc\u0634 \u0627\u0646\u06af\u0644\u06cc\u0633\u06cc" },
            { "en_US", "\u0627\u0645\u0631\u06cc\u06a9\u0646 \u0627\u0646\u06af\u0644\u06cc\u0633\u06cc" },
            { "es_ES", "\u0627\u0631\u0648\u067e\u0627\u06cc \u0650\u0627\u06cc\u0633\u067e\u0627\u0646\u06cc\u0648\u0644\u06cc" },
            { "es_MX", "\u0645\u06a9\u0632\u06cc\u06a9 \u0650\u0627\u06cc\u0633\u067e\u0627\u0646\u06cc\u0648\u0644\u06cc" },
            { "fr_CA", "\u06a9\u0627\u0646\u0627\u062f\u0627\u06cc \u0650\u0641\u0631\u0627\u0646\u0633\u0648\u06cc" },
            { "fr_CH", "\u0633\u0648\u06cc\u06cc\u0633 \u0650\u0641\u0631\u0627\u0646\u0633\u0648\u06cc" },
            { "nl_BE", "\u0641\u0644\u0645\u06cc\u0634" },
            { "pt_BR", "\u0628\u0631\u0632\u06cc\u0644 \u0650\u067e\u0631\u062a\u063a\u0627\u0644\u06cc" },
            { "pt_PT", "\u0627\u0631\u0648\u067e\u0627\u06cc \u0650\u067e\u0631\u062a\u063a\u0627\u0644\u06cc" },
            { "ro_MD", metaValue_MD },
            { "sw_CD", "\u06a9\u0646\u06af\u0648 \u0633\u0648\u0627\u062d\u06cc\u0644\u06cc" },
            { "ar_001", "\u0645\u062f\u0631\u0646 \u0627\u0633\u062a\u0627\u0646\u062f\u0627\u0631\u062f \u0639\u0631\u0628\u06cc" },
            { "es_419", "\u062c\u0646\u0648\u0628\u06cc \u0622\u0645\u0631\u06cc\u06a9\u0627\u06cc \u0650\u0627\u06cc\u0633\u067e\u0627\u0646\u06cc\u0648\u0644\u06cc" },
            { "nds_NL", "\u067e\u0627\u06cc\u06cc\u0646 \u0633\u0627\u06a9\u0633\u0648\u0646\u06cc" },
            { "az_Arab", "\u062c\u0646\u0648\u0628\u06cc \u0622\u0630\u0631\u06cc \u062a\u0631\u06a9\u06cc" },
            { "zh_Hans", "\u0633\u0627\u062f\u0647 \u0686\u06cc\u0646\u06cc" },
            { "zh_Hant", "\u0633\u0646\u062a\u06cc \u0686\u06cc\u0646\u06cc" },
        };
        return data;
    }
}
