/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.pool2.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.time.Duration;
import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import org.apache.tomcat.dbcp.pool2.impl.InterruptibleReentrantLock;
import org.apache.tomcat.dbcp.pool2.impl.PoolImplUtils;

class LinkedBlockingDeque<E>
extends AbstractQueue<E>
implements Deque<E>,
Serializable {
    private static final long serialVersionUID = -387911632671998426L;
    private transient Node<E> first;
    private transient Node<E> last;
    private transient int count;
    private final int capacity;
    private final InterruptibleReentrantLock lock;
    private final Condition notEmpty;
    private final Condition notFull;

    LinkedBlockingDeque() {
        this(Integer.MAX_VALUE);
    }

    LinkedBlockingDeque(boolean bl) {
        this(Integer.MAX_VALUE, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LinkedBlockingDeque(Collection<? extends E> collection) {
        this(Integer.MAX_VALUE);
        this.lock.lock();
        try {
            for (E e : collection) {
                Objects.requireNonNull(e);
                if (this.linkLast(e)) continue;
                throw new IllegalStateException("Deque full");
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    LinkedBlockingDeque(int n) {
        this(n, false);
    }

    LinkedBlockingDeque(int n, boolean bl) {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        this.capacity = n;
        this.lock = new InterruptibleReentrantLock(bl);
        this.notEmpty = this.lock.newCondition();
        this.notFull = this.lock.newCondition();
    }

    @Override
    public boolean add(E e) {
        this.addLast(e);
        return true;
    }

    @Override
    public void addFirst(E e) {
        if (!this.offerFirst(e)) {
            throw new IllegalStateException("Deque full");
        }
    }

    @Override
    public void addLast(E e) {
        if (!this.offerLast(e)) {
            throw new IllegalStateException("Deque full");
        }
    }

    @Override
    public void clear() {
        this.lock.lock();
        try {
            Node<E> node = this.first;
            while (node != null) {
                node.item = null;
                Node node2 = node.next;
                node.prev = null;
                node.next = null;
                node = node2;
            }
            this.last = null;
            this.first = null;
            this.count = 0;
            this.notFull.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object object) {
        if (object == null) {
            return false;
        }
        this.lock.lock();
        try {
            Node<E> node = this.first;
            while (node != null) {
                if (object.equals(node.item)) {
                    boolean bl = true;
                    return bl;
                }
                node = node.next;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Iterator<E> descendingIterator() {
        return new DescendingItr();
    }

    public int drainTo(Collection<? super E> collection) {
        return this.drainTo(collection, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int drainTo(Collection<? super E> collection, int n) {
        Objects.requireNonNull(collection, "c");
        if (collection == this) {
            throw new IllegalArgumentException();
        }
        this.lock.lock();
        try {
            int n2;
            int n3 = Math.min(n, this.count);
            for (n2 = 0; n2 < n3; ++n2) {
                collection.add(this.first.item);
                this.unlinkFirst();
            }
            n2 = n3;
            return n2;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public E element() {
        return this.getFirst();
    }

    @Override
    public E getFirst() {
        E e = this.peekFirst();
        if (e == null) {
            throw new NoSuchElementException();
        }
        return e;
    }

    @Override
    public E getLast() {
        E e = this.peekLast();
        if (e == null) {
            throw new NoSuchElementException();
        }
        return e;
    }

    public int getTakeQueueLength() {
        this.lock.lock();
        try {
            int n = this.lock.getWaitQueueLength(this.notEmpty);
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean hasTakeWaiters() {
        this.lock.lock();
        try {
            boolean bl = this.lock.hasWaiters(this.notEmpty);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void interuptTakeWaiters() {
        this.lock.lock();
        try {
            this.lock.interruptWaiters(this.notEmpty);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Iterator<E> iterator() {
        return new Itr();
    }

    private boolean linkFirst(E e) {
        if (this.count >= this.capacity) {
            return false;
        }
        Node<E> node = this.first;
        Node<E> node2 = new Node<E>(e, null, node);
        this.first = node2;
        if (this.last == null) {
            this.last = node2;
        } else {
            node.prev = node2;
        }
        ++this.count;
        this.notEmpty.signal();
        return true;
    }

    private boolean linkLast(E e) {
        if (this.count >= this.capacity) {
            return false;
        }
        Node<E> node = this.last;
        Node<E> node2 = new Node<E>(e, node, null);
        this.last = node2;
        if (this.first == null) {
            this.first = node2;
        } else {
            node.next = node2;
        }
        ++this.count;
        this.notEmpty.signal();
        return true;
    }

    @Override
    public boolean offer(E e) {
        return this.offerLast(e);
    }

    boolean offer(E e, Duration duration) throws InterruptedException {
        return this.offerLast(e, duration);
    }

    public boolean offer(E e, long l, TimeUnit timeUnit) throws InterruptedException {
        return this.offerLast(e, l, timeUnit);
    }

    @Override
    public boolean offerFirst(E e) {
        Objects.requireNonNull(e, "e");
        this.lock.lock();
        try {
            boolean bl = this.linkFirst(e);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean offerFirst(E e, Duration duration) throws InterruptedException {
        Objects.requireNonNull(e, "e");
        long l = duration.toNanos();
        this.lock.lockInterruptibly();
        try {
            while (!this.linkFirst(e)) {
                if (l <= 0L) {
                    boolean bl = false;
                    return bl;
                }
                l = this.notFull.awaitNanos(l);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean offerFirst(E e, long l, TimeUnit timeUnit) throws InterruptedException {
        return this.offerFirst(e, PoolImplUtils.toDuration(l, timeUnit));
    }

    @Override
    public boolean offerLast(E e) {
        Objects.requireNonNull(e, "e");
        this.lock.lock();
        try {
            boolean bl = this.linkLast(e);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean offerLast(E e, Duration duration) throws InterruptedException {
        Objects.requireNonNull(e, "e");
        long l = duration.toNanos();
        this.lock.lockInterruptibly();
        try {
            while (!this.linkLast(e)) {
                if (l <= 0L) {
                    boolean bl = false;
                    return bl;
                }
                l = this.notFull.awaitNanos(l);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean offerLast(E e, long l, TimeUnit timeUnit) throws InterruptedException {
        return this.offerLast(e, PoolImplUtils.toDuration(l, timeUnit));
    }

    @Override
    public E peek() {
        return this.peekFirst();
    }

    @Override
    public E peekFirst() {
        this.lock.lock();
        try {
            E e = this.first == null ? null : (E)this.first.item;
            return e;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public E peekLast() {
        this.lock.lock();
        try {
            E e = this.last == null ? null : (E)this.last.item;
            return e;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public E poll() {
        return this.pollFirst();
    }

    E poll(Duration duration) throws InterruptedException {
        return this.pollFirst(duration);
    }

    public E poll(long l, TimeUnit timeUnit) throws InterruptedException {
        return this.pollFirst(l, timeUnit);
    }

    @Override
    public E pollFirst() {
        this.lock.lock();
        try {
            E e = this.unlinkFirst();
            return e;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    E pollFirst(Duration duration) throws InterruptedException {
        long l = duration.toNanos();
        this.lock.lockInterruptibly();
        try {
            E e;
            while ((e = this.unlinkFirst()) == null) {
                if (l <= 0L) {
                    E e2 = null;
                    return e2;
                }
                l = this.notEmpty.awaitNanos(l);
            }
            E e3 = e;
            return e3;
        }
        finally {
            this.lock.unlock();
        }
    }

    public E pollFirst(long l, TimeUnit timeUnit) throws InterruptedException {
        return this.pollFirst(PoolImplUtils.toDuration(l, timeUnit));
    }

    @Override
    public E pollLast() {
        this.lock.lock();
        try {
            E e = this.unlinkLast();
            return e;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E pollLast(Duration duration) throws InterruptedException {
        long l = duration.toNanos();
        this.lock.lockInterruptibly();
        try {
            E e;
            while ((e = this.unlinkLast()) == null) {
                if (l <= 0L) {
                    E e2 = null;
                    return e2;
                }
                l = this.notEmpty.awaitNanos(l);
            }
            E e3 = e;
            return e3;
        }
        finally {
            this.lock.unlock();
        }
    }

    public E pollLast(long l, TimeUnit timeUnit) throws InterruptedException {
        return this.pollLast(PoolImplUtils.toDuration(l, timeUnit));
    }

    @Override
    public E pop() {
        return this.removeFirst();
    }

    @Override
    public void push(E e) {
        this.addFirst(e);
    }

    public void put(E e) throws InterruptedException {
        this.putLast(e);
    }

    public void putFirst(E e) throws InterruptedException {
        Objects.requireNonNull(e, "e");
        this.lock.lock();
        try {
            while (!this.linkFirst(e)) {
                this.notFull.await();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void putLast(E e) throws InterruptedException {
        Objects.requireNonNull(e, "e");
        this.lock.lock();
        try {
            while (!this.linkLast(e)) {
                this.notFull.await();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Object object;
        objectInputStream.defaultReadObject();
        this.count = 0;
        this.first = null;
        this.last = null;
        while ((object = objectInputStream.readObject()) != null) {
            this.add(object);
        }
    }

    public int remainingCapacity() {
        this.lock.lock();
        try {
            int n = this.capacity - this.count;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public E remove() {
        return this.removeFirst();
    }

    @Override
    public boolean remove(Object object) {
        return this.removeFirstOccurrence(object);
    }

    @Override
    public E removeFirst() {
        E e = this.pollFirst();
        if (e == null) {
            throw new NoSuchElementException();
        }
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeFirstOccurrence(Object object) {
        if (object == null) {
            return false;
        }
        this.lock.lock();
        try {
            Node<E> node = this.first;
            while (node != null) {
                if (object.equals(node.item)) {
                    this.unlink(node);
                    boolean bl = true;
                    return bl;
                }
                node = node.next;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public E removeLast() {
        E e = this.pollLast();
        if (e == null) {
            throw new NoSuchElementException();
        }
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeLastOccurrence(Object object) {
        if (object == null) {
            return false;
        }
        this.lock.lock();
        try {
            Node<E> node = this.last;
            while (node != null) {
                if (object.equals(node.item)) {
                    this.unlink(node);
                    boolean bl = true;
                    return bl;
                }
                node = node.prev;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int size() {
        this.lock.lock();
        try {
            int n = this.count;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public E take() throws InterruptedException {
        return this.takeFirst();
    }

    public E takeFirst() throws InterruptedException {
        this.lock.lock();
        try {
            E e;
            while ((e = this.unlinkFirst()) == null) {
                this.notEmpty.await();
            }
            E e2 = e;
            return e2;
        }
        finally {
            this.lock.unlock();
        }
    }

    public E takeLast() throws InterruptedException {
        this.lock.lock();
        try {
            E e;
            while ((e = this.unlinkLast()) == null) {
                this.notEmpty.await();
            }
            E e2 = e;
            return e2;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] toArray() {
        this.lock.lock();
        try {
            Object[] objectArray = new Object[this.count];
            int n = 0;
            Object object = this.first;
            while (object != null) {
                objectArray[n++] = object.item;
                object = object.next;
            }
            object = objectArray;
            return object;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T[] toArray(T[] objectArray) {
        this.lock.lock();
        try {
            if (objectArray.length < this.count) {
                objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), this.count);
            }
            int n = 0;
            Object object = this.first;
            while (object != null) {
                objectArray[n++] = object.item;
                object = object.next;
            }
            if (objectArray.length > n) {
                objectArray[n] = null;
            }
            object = objectArray;
            return object;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public String toString() {
        this.lock.lock();
        try {
            String string = super.toString();
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void unlink(Node<E> node) {
        Node node2 = node.prev;
        Node node3 = node.next;
        if (node2 == null) {
            this.unlinkFirst();
        } else if (node3 == null) {
            this.unlinkLast();
        } else {
            node2.next = node3;
            node3.prev = node2;
            node.item = null;
            --this.count;
            this.notFull.signal();
        }
    }

    private E unlinkFirst() {
        Node<E> node = this.first;
        if (node == null) {
            return null;
        }
        Node node2 = node.next;
        Object e = node.item;
        node.item = null;
        node.next = node;
        this.first = node2;
        if (node2 == null) {
            this.last = null;
        } else {
            node2.prev = null;
        }
        --this.count;
        this.notFull.signal();
        return e;
    }

    private E unlinkLast() {
        Node<E> node = this.last;
        if (node == null) {
            return null;
        }
        Node node2 = node.prev;
        Object e = node.item;
        node.item = null;
        node.prev = node;
        this.last = node2;
        if (node2 == null) {
            this.first = null;
        } else {
            node2.next = null;
        }
        --this.count;
        this.notFull.signal();
        return e;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.lock.lock();
        try {
            objectOutputStream.defaultWriteObject();
            Node<E> node = this.first;
            while (node != null) {
                objectOutputStream.writeObject(node.item);
                node = node.next;
            }
            objectOutputStream.writeObject(null);
        }
        finally {
            this.lock.unlock();
        }
    }

    private static final class Node<E> {
        E item;
        Node<E> prev;
        Node<E> next;

        Node(E e, Node<E> node, Node<E> node2) {
            this.item = e;
            this.prev = node;
            this.next = node2;
        }
    }

    private class Itr
    extends AbstractItr {
        private Itr() {
        }

        @Override
        Node<E> firstNode() {
            return LinkedBlockingDeque.this.first;
        }

        @Override
        Node<E> nextNode(Node<E> node) {
            return node.next;
        }
    }

    private class DescendingItr
    extends AbstractItr {
        private DescendingItr() {
        }

        @Override
        Node<E> firstNode() {
            return LinkedBlockingDeque.this.last;
        }

        @Override
        Node<E> nextNode(Node<E> node) {
            return node.prev;
        }
    }

    private abstract class AbstractItr
    implements Iterator<E> {
        Node<E> next;
        E nextItem;
        private Node<E> lastRet;

        AbstractItr() {
            LinkedBlockingDeque.this.lock.lock();
            try {
                this.next = this.firstNode();
                this.nextItem = this.next == null ? null : this.next.item;
            }
            finally {
                LinkedBlockingDeque.this.lock.unlock();
            }
        }

        void advance() {
            LinkedBlockingDeque.this.lock.lock();
            try {
                this.next = this.succ(this.next);
                this.nextItem = this.next == null ? null : this.next.item;
            }
            finally {
                LinkedBlockingDeque.this.lock.unlock();
            }
        }

        abstract Node<E> firstNode();

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public E next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            this.lastRet = this.next;
            Object e = this.nextItem;
            this.advance();
            return e;
        }

        abstract Node<E> nextNode(Node<E> var1);

        @Override
        public void remove() {
            Node node = this.lastRet;
            if (node == null) {
                throw new IllegalStateException();
            }
            this.lastRet = null;
            LinkedBlockingDeque.this.lock.lock();
            try {
                if (node.item != null) {
                    LinkedBlockingDeque.this.unlink(node);
                }
            }
            finally {
                LinkedBlockingDeque.this.lock.unlock();
            }
        }

        private Node<E> succ(Node<E> node) {
            Node node2;
            while ((node2 = this.nextNode(node)) != null) {
                if (node2.item != null) {
                    return node2;
                }
                if (node2 == node) {
                    return this.firstNode();
                }
                node = node2;
            }
            return null;
        }
    }
}

