/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.manager;

import jakarta.servlet.http.HttpServletResponse;
import java.io.PrintWriter;
import java.lang.invoke.CallSite;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.apache.catalina.manager.Constants;
import org.apache.tomcat.util.security.Escape;

public class StatusTransformer {
    public static void setContentType(HttpServletResponse httpServletResponse, int n) {
        if (n == 0) {
            httpServletResponse.setContentType("text/html;charset=utf-8");
        } else if (n == 1) {
            httpServletResponse.setContentType("text/xml;charset=utf-8");
        }
    }

    public static void writeHeader(PrintWriter printWriter, Object[] objectArray, int n) {
        if (n == 0) {
            printWriter.print(MessageFormat.format(Constants.HTML_HEADER_SECTION, objectArray));
        } else if (n == 1) {
            printWriter.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
            printWriter.print(MessageFormat.format("<?xml-stylesheet type=\"text/xsl\" href=\"{0}/xform.xsl\" ?>\n", objectArray));
            printWriter.write("<status>");
        }
    }

    public static void writeBody(PrintWriter printWriter, Object[] objectArray, int n) {
        if (n == 0) {
            printWriter.print(MessageFormat.format(Constants.BODY_HEADER_SECTION, objectArray));
        }
    }

    public static void writeManager(PrintWriter printWriter, Object[] objectArray, int n) {
        if (n == 0) {
            printWriter.print(MessageFormat.format(Constants.MANAGER_SECTION, objectArray));
        }
    }

    public static void writePageHeading(PrintWriter printWriter, Object[] objectArray, int n) {
        if (n == 0) {
            printWriter.print(MessageFormat.format(Constants.SERVER_HEADER_SECTION, objectArray));
        }
    }

    public static void writeServerInfo(PrintWriter printWriter, Object[] objectArray, int n) {
        if (n == 0) {
            printWriter.print(MessageFormat.format(Constants.SERVER_ROW_SECTION, objectArray));
        }
    }

    public static void writeFooter(PrintWriter printWriter, int n) {
        if (n == 0) {
            printWriter.print(Constants.HTML_TAIL_SECTION);
        } else if (n == 1) {
            printWriter.write("</status>");
        }
    }

    public static void writeVMState(PrintWriter printWriter, int n, Object[] objectArray) throws Exception {
        Object object;
        TreeMap<CallSite, MemoryPoolMXBean> treeMap = new TreeMap<CallSite, MemoryPoolMXBean>();
        for (MemoryPoolMXBean memoryPoolMXBean : ManagementFactory.getMemoryPoolMXBeans()) {
            object = memoryPoolMXBean.getType() + ":" + memoryPoolMXBean.getName();
            treeMap.put((CallSite)object, memoryPoolMXBean);
        }
        if (n == 0) {
            printWriter.print("<h1>JVM</h1>");
            printWriter.print("<p>");
            printWriter.print(objectArray[0]);
            printWriter.print(' ');
            printWriter.print(StatusTransformer.formatSize(Runtime.getRuntime().freeMemory(), true));
            printWriter.print(' ');
            printWriter.print(objectArray[1]);
            printWriter.print(' ');
            printWriter.print(StatusTransformer.formatSize(Runtime.getRuntime().totalMemory(), true));
            printWriter.print(' ');
            printWriter.print(objectArray[2]);
            printWriter.print(' ');
            printWriter.print(StatusTransformer.formatSize(Runtime.getRuntime().maxMemory(), true));
            printWriter.print("</p>");
            printWriter.write("<table border=\"0\"><thead><tr><th>" + objectArray[3] + "</th><th>" + objectArray[4] + "</th><th>" + objectArray[5] + "</th><th>" + objectArray[6] + "</th><th>" + objectArray[7] + "</th><th>" + objectArray[8] + "</th></tr></thead><tbody>");
            for (MemoryPoolMXBean memoryPoolMXBean : treeMap.values()) {
                object = memoryPoolMXBean.getUsage();
                printWriter.write("<tr><td>");
                printWriter.print(memoryPoolMXBean.getName());
                printWriter.write("</td><td>");
                printWriter.print((Object)memoryPoolMXBean.getType());
                printWriter.write("</td><td>");
                printWriter.print(StatusTransformer.formatSize(((MemoryUsage)object).getInit(), true));
                printWriter.write("</td><td>");
                printWriter.print(StatusTransformer.formatSize(((MemoryUsage)object).getCommitted(), true));
                printWriter.write("</td><td>");
                printWriter.print(StatusTransformer.formatSize(((MemoryUsage)object).getMax(), true));
                printWriter.write("</td><td>");
                printWriter.print(StatusTransformer.formatSize(((MemoryUsage)object).getUsed(), true));
                if (((MemoryUsage)object).getMax() > 0L) {
                    printWriter.write(" (" + ((MemoryUsage)object).getUsed() * 100L / ((MemoryUsage)object).getMax() + "%)");
                }
                printWriter.write("</td></tr>");
            }
            printWriter.write("</tbody></table>");
        } else if (n == 1) {
            printWriter.write("<jvm>");
            printWriter.write("<memory");
            printWriter.write(" free='" + Runtime.getRuntime().freeMemory() + "'");
            printWriter.write(" total='" + Runtime.getRuntime().totalMemory() + "'");
            printWriter.write(" max='" + Runtime.getRuntime().maxMemory() + "'/>");
            for (MemoryPoolMXBean memoryPoolMXBean : treeMap.values()) {
                object = memoryPoolMXBean.getUsage();
                printWriter.write("<memorypool");
                printWriter.write(" name='" + Escape.xml((String)"", (String)memoryPoolMXBean.getName()) + "'");
                printWriter.write(" type='" + memoryPoolMXBean.getType() + "'");
                printWriter.write(" usageInit='" + ((MemoryUsage)object).getInit() + "'");
                printWriter.write(" usageCommitted='" + ((MemoryUsage)object).getCommitted() + "'");
                printWriter.write(" usageMax='" + ((MemoryUsage)object).getMax() + "'");
                printWriter.write(" usageUsed='" + ((MemoryUsage)object).getUsed() + "'/>");
            }
            printWriter.write("</jvm>");
        }
    }

    public static void writeConnectorState(PrintWriter printWriter, ObjectName objectName, String string, MBeanServer mBeanServer, List<ObjectName> list, List<ObjectName> list2, int n, Object[] objectArray) throws Exception {
        if (n == 0) {
            printWriter.print("<h1>");
            printWriter.print(string);
            printWriter.print("</h1>");
            printWriter.print("<p>");
            printWriter.print(objectArray[0]);
            printWriter.print(' ');
            printWriter.print(mBeanServer.getAttribute(objectName, "maxThreads"));
            printWriter.print(' ');
            printWriter.print(objectArray[1]);
            printWriter.print(' ');
            printWriter.print(mBeanServer.getAttribute(objectName, "currentThreadCount"));
            printWriter.print(' ');
            printWriter.print(objectArray[2]);
            printWriter.print(' ');
            printWriter.print(mBeanServer.getAttribute(objectName, "currentThreadsBusy"));
            printWriter.print(' ');
            printWriter.print(objectArray[3]);
            printWriter.print(' ');
            printWriter.print(mBeanServer.getAttribute(objectName, "keepAliveCount"));
            printWriter.print("<br>");
            ObjectName objectName2 = null;
            for (ObjectName objectName3 : list) {
                if (!string.equals(objectName3.getKeyProperty("name")) || objectName3.getKeyProperty("Upgrade") != null) continue;
                objectName2 = objectName3;
            }
            if (objectName2 == null) {
                return;
            }
            printWriter.print(objectArray[4]);
            printWriter.print(' ');
            printWriter.print(StatusTransformer.formatTime(mBeanServer.getAttribute(objectName2, "maxTime"), false));
            printWriter.print(' ');
            printWriter.print(objectArray[5]);
            printWriter.print(' ');
            printWriter.print(StatusTransformer.formatTime(mBeanServer.getAttribute(objectName2, "processingTime"), true));
            printWriter.print(' ');
            printWriter.print(objectArray[6]);
            printWriter.print(' ');
            printWriter.print(mBeanServer.getAttribute(objectName2, "requestCount"));
            printWriter.print(' ');
            printWriter.print(objectArray[7]);
            printWriter.print(' ');
            printWriter.print(mBeanServer.getAttribute(objectName2, "errorCount"));
            printWriter.print(' ');
            printWriter.print(objectArray[8]);
            printWriter.print(' ');
            printWriter.print(StatusTransformer.formatSize(mBeanServer.getAttribute(objectName2, "bytesReceived"), true));
            printWriter.print(' ');
            printWriter.print(objectArray[9]);
            printWriter.print(' ');
            printWriter.print(StatusTransformer.formatSize(mBeanServer.getAttribute(objectName2, "bytesSent"), true));
            printWriter.print("</p>");
            printWriter.print("<table border=\"0\"><tr><th>" + objectArray[10] + "</th><th>" + objectArray[11] + "</th><th>" + objectArray[12] + "</th><th>" + objectArray[13] + "</th><th>" + objectArray[14] + "</th><th>" + objectArray[15] + "</th><th>" + objectArray[16] + "</th><th>" + objectArray[17] + "</th></tr>");
            for (ObjectName objectName3 : list2) {
                if (!string.equals(objectName3.getKeyProperty("worker"))) continue;
                printWriter.print("<tr>");
                StatusTransformer.writeProcessorState(printWriter, objectName3, mBeanServer, n);
                printWriter.print("</tr>");
            }
            printWriter.print("</table>");
            printWriter.print("<p>");
            printWriter.print(objectArray[18]);
            printWriter.print("</p>");
        } else if (n == 1) {
            printWriter.write("<connector name='" + string + "'>");
            printWriter.write("<threadInfo ");
            printWriter.write(" maxThreads=\"" + mBeanServer.getAttribute(objectName, "maxThreads") + "\"");
            printWriter.write(" currentThreadCount=\"" + mBeanServer.getAttribute(objectName, "currentThreadCount") + "\"");
            printWriter.write(" currentThreadsBusy=\"" + mBeanServer.getAttribute(objectName, "currentThreadsBusy") + "\"");
            printWriter.write(" />");
            ObjectName objectName4 = null;
            for (ObjectName objectName5 : list) {
                if (!string.equals(objectName5.getKeyProperty("name")) || objectName5.getKeyProperty("Upgrade") != null) continue;
                objectName4 = objectName5;
            }
            if (objectName4 != null) {
                printWriter.write("<requestInfo ");
                printWriter.write(" maxTime=\"" + mBeanServer.getAttribute(objectName4, "maxTime") + "\"");
                printWriter.write(" processingTime=\"" + mBeanServer.getAttribute(objectName4, "processingTime") + "\"");
                printWriter.write(" requestCount=\"" + mBeanServer.getAttribute(objectName4, "requestCount") + "\"");
                printWriter.write(" errorCount=\"" + mBeanServer.getAttribute(objectName4, "errorCount") + "\"");
                printWriter.write(" bytesReceived=\"" + mBeanServer.getAttribute(objectName4, "bytesReceived") + "\"");
                printWriter.write(" bytesSent=\"" + mBeanServer.getAttribute(objectName4, "bytesSent") + "\"");
                printWriter.write(" />");
                printWriter.write("<workers>");
                for (ObjectName objectName5 : list2) {
                    if (!string.equals(objectName5.getKeyProperty("worker"))) continue;
                    StatusTransformer.writeProcessorState(printWriter, objectName5, mBeanServer, n);
                }
                printWriter.write("</workers>");
            }
            printWriter.write("</connector>");
        }
    }

    protected static void writeProcessorState(PrintWriter printWriter, ObjectName objectName, MBeanServer mBeanServer, int n) throws Exception {
        Integer n2 = (Integer)mBeanServer.getAttribute(objectName, "stage");
        int n3 = n2;
        boolean bl = true;
        boolean bl2 = true;
        String string = null;
        switch (n3) {
            case 1: {
                string = "P";
                bl = false;
                break;
            }
            case 2: {
                string = "P";
                bl = false;
                break;
            }
            case 3: {
                string = "S";
                break;
            }
            case 4: {
                string = "F";
                break;
            }
            case 5: {
                string = "F";
                break;
            }
            case 7: {
                string = "R";
                bl = false;
                break;
            }
            case 6: {
                string = "K";
                bl = true;
                bl2 = false;
                break;
            }
            case 0: {
                string = "R";
                bl = false;
                break;
            }
            default: {
                string = "?";
                bl = false;
            }
        }
        if (n == 0) {
            printWriter.write("<td><strong>");
            printWriter.write(string);
            printWriter.write("</strong></td>");
            if (bl) {
                printWriter.write("<td>");
                printWriter.print(StatusTransformer.formatTime(mBeanServer.getAttribute(objectName, "requestProcessingTime"), false));
                printWriter.write("</td>");
                printWriter.write("<td>");
                if (bl2) {
                    printWriter.print(StatusTransformer.formatSize(mBeanServer.getAttribute(objectName, "requestBytesSent"), false));
                } else {
                    printWriter.write("?");
                }
                printWriter.write("</td>");
                printWriter.write("<td>");
                if (bl2) {
                    printWriter.print(StatusTransformer.formatSize(mBeanServer.getAttribute(objectName, "requestBytesReceived"), false));
                } else {
                    printWriter.write("?");
                }
                printWriter.write("</td>");
                printWriter.write("<td>");
                printWriter.print(Escape.htmlElementContent((Object)mBeanServer.getAttribute(objectName, "remoteAddrForwarded")));
                printWriter.write("</td>");
                printWriter.write("<td>");
                printWriter.print(Escape.htmlElementContent((Object)mBeanServer.getAttribute(objectName, "remoteAddr")));
                printWriter.write("</td>");
                printWriter.write("<td nowrap>");
                printWriter.write(Escape.htmlElementContent((Object)mBeanServer.getAttribute(objectName, "virtualHost")));
                printWriter.write("</td>");
                printWriter.write("<td nowrap class=\"row-left\">");
                if (bl2) {
                    printWriter.write(Escape.htmlElementContent((Object)mBeanServer.getAttribute(objectName, "method")));
                    printWriter.write(32);
                    printWriter.write(Escape.htmlElementContent((Object)mBeanServer.getAttribute(objectName, "currentUri")));
                    String string2 = (String)mBeanServer.getAttribute(objectName, "currentQueryString");
                    if (string2 != null && !string2.equals("")) {
                        printWriter.write("?");
                        printWriter.print(Escape.htmlElementContent((String)string2));
                    }
                    printWriter.write(32);
                    printWriter.write(Escape.htmlElementContent((Object)mBeanServer.getAttribute(objectName, "protocol")));
                } else {
                    printWriter.write("?");
                }
                printWriter.write("</td>");
            } else {
                printWriter.write("<td>?</td><td>?</td><td>?</td><td>?</td><td>?</td><td>?</td>");
            }
        } else if (n == 1) {
            printWriter.write("<worker ");
            printWriter.write(" stage=\"" + string + "\"");
            if (bl) {
                printWriter.write(" requestProcessingTime=\"" + mBeanServer.getAttribute(objectName, "requestProcessingTime") + "\"");
                printWriter.write(" requestBytesSent=\"");
                if (bl2) {
                    printWriter.write("" + mBeanServer.getAttribute(objectName, "requestBytesSent"));
                } else {
                    printWriter.write("0");
                }
                printWriter.write("\"");
                printWriter.write(" requestBytesReceived=\"");
                if (bl2) {
                    printWriter.write("" + mBeanServer.getAttribute(objectName, "requestBytesReceived"));
                } else {
                    printWriter.write("0");
                }
                printWriter.write("\"");
                printWriter.write(" remoteAddr=\"" + Escape.htmlElementContent((Object)mBeanServer.getAttribute(objectName, "remoteAddr")) + "\"");
                printWriter.write(" virtualHost=\"" + Escape.htmlElementContent((Object)mBeanServer.getAttribute(objectName, "virtualHost")) + "\"");
                if (bl2) {
                    printWriter.write(" method=\"" + Escape.htmlElementContent((Object)mBeanServer.getAttribute(objectName, "method")) + "\"");
                    printWriter.write(" currentUri=\"" + Escape.htmlElementContent((Object)mBeanServer.getAttribute(objectName, "currentUri")) + "\"");
                    String string3 = (String)mBeanServer.getAttribute(objectName, "currentQueryString");
                    if (string3 != null && !string3.equals("")) {
                        printWriter.write(" currentQueryString=\"" + Escape.htmlElementContent((String)string3) + "\"");
                    } else {
                        printWriter.write(" currentQueryString=\"&#63;\"");
                    }
                    printWriter.write(" protocol=\"" + Escape.htmlElementContent((Object)mBeanServer.getAttribute(objectName, "protocol")) + "\"");
                } else {
                    printWriter.write(" method=\"&#63;\"");
                    printWriter.write(" currentUri=\"&#63;\"");
                    printWriter.write(" currentQueryString=\"&#63;\"");
                    printWriter.write(" protocol=\"&#63;\"");
                }
            } else {
                printWriter.write(" requestProcessingTime=\"0\"");
                printWriter.write(" requestBytesSent=\"0\"");
                printWriter.write(" requestBytesReceived=\"0\"");
                printWriter.write(" remoteAddr=\"&#63;\"");
                printWriter.write(" virtualHost=\"&#63;\"");
                printWriter.write(" method=\"&#63;\"");
                printWriter.write(" currentUri=\"&#63;\"");
                printWriter.write(" currentQueryString=\"&#63;\"");
                printWriter.write(" protocol=\"&#63;\"");
            }
            printWriter.write(" />");
        }
    }

    public static void writeDetailedState(PrintWriter printWriter, MBeanServer mBeanServer, int n) throws Exception {
        if (n == 0) {
            ObjectName objectName = new ObjectName("*:j2eeType=WebModule,*");
            Set<ObjectName> set = mBeanServer.queryNames(objectName, null);
            printWriter.print("<h1>");
            printWriter.print("Application list");
            printWriter.print("</h1>");
            printWriter.print("<p>");
            int n2 = 0;
            Iterator<ObjectName> iterator = set.iterator();
            while (iterator.hasNext()) {
                int n3;
                ObjectName objectName2 = iterator.next();
                String string = objectName2.getKeyProperty("name");
                if (string.startsWith("//")) {
                    string = string.substring(2);
                }
                if ((n3 = string.indexOf(47)) == -1) {
                    ++n2;
                    continue;
                }
                printWriter.print("<a href=\"#" + n2++ + ".0\">");
                printWriter.print(Escape.htmlElementContent((String)string));
                printWriter.print("</a>");
                if (!iterator.hasNext()) continue;
                printWriter.print("<br>");
            }
            printWriter.print("</p>");
            n2 = 0;
            for (ObjectName objectName2 : set) {
                printWriter.print("<a class=\"A.name\" name=\"" + n2++ + ".0\">");
                StatusTransformer.writeContext(printWriter, objectName2, mBeanServer, n);
            }
        } else if (n == 1) {
            // empty if block
        }
    }

    protected static void writeContext(PrintWriter printWriter, ObjectName objectName, MBeanServer mBeanServer, int n) throws Exception {
        if (n == 0) {
            int n2;
            String string = objectName.getKeyProperty("name");
            String string2 = string;
            if (string2 == null) {
                return;
            }
            String string3 = null;
            String string4 = null;
            if (string2.startsWith("//")) {
                string2 = string2.substring(2);
            }
            if ((n2 = string2.indexOf(47)) == -1) {
                return;
            }
            string3 = string2.substring(0, n2);
            string4 = string2.substring(n2);
            ObjectName objectName2 = new ObjectName(objectName.getDomain() + ":type=Manager,context=" + string4 + ",host=" + string3 + ",*");
            Set<ObjectName> set = mBeanServer.queryNames(objectName2, null);
            ObjectName objectName3 = null;
            Object objectName4 = set.iterator();
            while (objectName4.hasNext()) {
                ObjectName object2;
                objectName3 = object2 = objectName4.next();
            }
            objectName4 = new ObjectName(objectName.getDomain() + ":type=JspMonitor,WebModule=" + string + ",*");
            Set<ObjectName> set2 = mBeanServer.queryNames((ObjectName)objectName4, null);
            if (string4.equals("/")) {
                string4 = "";
            }
            printWriter.print("<h1>");
            printWriter.print(Escape.htmlElementContent((String)string2));
            printWriter.print("</h1>");
            printWriter.print("</a>");
            printWriter.print("<p>");
            Object object = mBeanServer.getAttribute(objectName, "startTime");
            printWriter.print(" Start time: " + new Date((Long)object));
            printWriter.print(" Startup time: ");
            printWriter.print(StatusTransformer.formatTime(mBeanServer.getAttribute(objectName, "startupTime"), false));
            printWriter.print(" TLD scan time: ");
            printWriter.print(StatusTransformer.formatTime(mBeanServer.getAttribute(objectName, "tldScanTime"), false));
            if (objectName3 != null) {
                StatusTransformer.writeManager(printWriter, objectName3, mBeanServer, n);
            }
            if (set2 != null) {
                StatusTransformer.writeJspMonitor(printWriter, set2, mBeanServer, n);
            }
            printWriter.print("</p>");
            String string5 = objectName.getDomain() + ":j2eeType=Servlet,WebModule=" + string + ",*";
            ObjectName objectName5 = new ObjectName(string5);
            Set<ObjectInstance> set3 = mBeanServer.queryMBeans(objectName5, null);
            for (ObjectInstance objectInstance : set3) {
                StatusTransformer.writeWrapper(printWriter, objectInstance.getObjectName(), mBeanServer, n);
            }
        } else if (n == 1) {
            // empty if block
        }
    }

    public static void writeManager(PrintWriter printWriter, ObjectName objectName, MBeanServer mBeanServer, int n) throws Exception {
        if (n == 0) {
            printWriter.print("<br>");
            printWriter.print(" Active sessions: ");
            printWriter.print(mBeanServer.getAttribute(objectName, "activeSessions"));
            printWriter.print(" Session count: ");
            printWriter.print(mBeanServer.getAttribute(objectName, "sessionCounter"));
            printWriter.print(" Max active sessions: ");
            printWriter.print(mBeanServer.getAttribute(objectName, "maxActive"));
            printWriter.print(" Rejected session creations: ");
            printWriter.print(mBeanServer.getAttribute(objectName, "rejectedSessions"));
            printWriter.print(" Expired sessions: ");
            printWriter.print(mBeanServer.getAttribute(objectName, "expiredSessions"));
            printWriter.print(" Longest session alive time: ");
            printWriter.print(StatusTransformer.formatSeconds(mBeanServer.getAttribute(objectName, "sessionMaxAliveTime")));
            printWriter.print(" Average session alive time: ");
            printWriter.print(StatusTransformer.formatSeconds(mBeanServer.getAttribute(objectName, "sessionAverageAliveTime")));
            printWriter.print(" Processing time: ");
            printWriter.print(StatusTransformer.formatTime(mBeanServer.getAttribute(objectName, "processingTime"), false));
        } else if (n == 1) {
            // empty if block
        }
    }

    public static void writeJspMonitor(PrintWriter printWriter, Set<ObjectName> set, MBeanServer mBeanServer, int n) throws Exception {
        int n2 = 0;
        int n3 = 0;
        for (ObjectName objectName : set) {
            Object object = mBeanServer.getAttribute(objectName, "jspCount");
            n2 += ((Integer)object).intValue();
            object = mBeanServer.getAttribute(objectName, "jspReloadCount");
            n3 += ((Integer)object).intValue();
        }
        if (n == 0) {
            printWriter.print("<br>");
            printWriter.print(" JSPs loaded: ");
            printWriter.print(n2);
            printWriter.print(" JSPs reloaded: ");
            printWriter.print(n3);
        } else if (n == 1) {
            // empty if block
        }
    }

    public static void writeWrapper(PrintWriter printWriter, ObjectName objectName, MBeanServer mBeanServer, int n) throws Exception {
        if (n == 0) {
            String string = objectName.getKeyProperty("name");
            String[] stringArray = (String[])mBeanServer.invoke(objectName, "findMappings", null, null);
            printWriter.print("<h2>");
            printWriter.print(Escape.htmlElementContent((String)string));
            if (stringArray != null && stringArray.length > 0) {
                printWriter.print(" [ ");
                for (int i = 0; i < stringArray.length; ++i) {
                    printWriter.print(Escape.htmlElementContent((String)stringArray[i]));
                    if (i >= stringArray.length - 1) continue;
                    printWriter.print(" , ");
                }
                printWriter.print(" ] ");
            }
            printWriter.print("</h2>");
            printWriter.print("<p>");
            printWriter.print(" Processing time: ");
            printWriter.print(StatusTransformer.formatTime(mBeanServer.getAttribute(objectName, "processingTime"), true));
            printWriter.print(" Max time: ");
            printWriter.print(StatusTransformer.formatTime(mBeanServer.getAttribute(objectName, "maxTime"), false));
            printWriter.print(" Request count: ");
            printWriter.print(mBeanServer.getAttribute(objectName, "requestCount"));
            printWriter.print(" Error count: ");
            printWriter.print(mBeanServer.getAttribute(objectName, "errorCount"));
            printWriter.print(" Load time: ");
            printWriter.print(StatusTransformer.formatTime(mBeanServer.getAttribute(objectName, "loadTime"), false));
            printWriter.print(" Classloading time: ");
            printWriter.print(StatusTransformer.formatTime(mBeanServer.getAttribute(objectName, "classLoadTime"), false));
            printWriter.print("</p>");
        } else if (n == 1) {
            // empty if block
        }
    }

    public static String formatSize(Object object, boolean bl) {
        long l = -1L;
        if (object instanceof Long) {
            l = (Long)object;
        } else if (object instanceof Integer) {
            l = ((Integer)object).intValue();
        }
        if (bl) {
            StringBuilder stringBuilder = new StringBuilder();
            if (l < 0L) {
                stringBuilder.append('-');
                l = -l;
            }
            long l2 = l / 0x100000L;
            long l3 = (l - l2 * 0x100000L) * 100L / 0x100000L;
            stringBuilder.append(l2).append('.');
            if (l3 < 10L) {
                stringBuilder.append('0');
            }
            stringBuilder.append(l3).append(" MB");
            return stringBuilder.toString();
        }
        return l / 1024L + " KB";
    }

    public static String formatTime(Object object, boolean bl) {
        long l = -1L;
        if (object instanceof Long) {
            l = (Long)object;
        } else if (object instanceof Integer) {
            l = ((Integer)object).intValue();
        }
        if (bl) {
            return (float)l / 1000.0f + " s";
        }
        return l + " ms";
    }

    public static String formatSeconds(Object object) {
        long l = -1L;
        if (object instanceof Long) {
            l = (Long)object;
        } else if (object instanceof Integer) {
            l = ((Integer)object).intValue();
        }
        return l + " s";
    }
}

