/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.comp.Calc.NLPSolver;

import com.sun.star.comp.Calc.NLPSolver.BaseEvolutionarySolver;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.lang.XSingleComponentFactory;
import com.sun.star.lib.uno.helper.Factory;
import com.sun.star.registry.XRegistryKey;
import com.sun.star.uno.XComponentContext;
import net.adaptivebox.global.IUpdateCycleEngine;
import net.adaptivebox.knowledge.Library;
import net.adaptivebox.knowledge.SearchPoint;
import net.adaptivebox.sco.SCAgent;

public final class SCOSolverImpl
extends BaseEvolutionarySolver
implements XServiceInfo {
    private static final String m_implementationName = SCOSolverImpl.class.getName();
    private static final String[] m_serviceNames = new String[]{"com.sun.star.sheet.Solver", "com.sun.star.beans.PropertySet"};

    public SCOSolverImpl(XComponentContext context) {
        super(context, "SCO Evolutionary Algorithm");
        this.registerProperty(this.m_librarySize);
    }

    public static XSingleComponentFactory __getComponentFactory(String sImplementationName) {
        XSingleComponentFactory xFactory = null;
        if (sImplementationName.equals(m_implementationName)) {
            xFactory = Factory.createComponentFactory(SCOSolverImpl.class, (String[])m_serviceNames);
        }
        return xFactory;
    }

    public static boolean __writeRegistryServiceInfo(XRegistryKey xRegistryKey) {
        return Factory.writeRegistryServiceInfo((String)m_implementationName, (String[])m_serviceNames, (XRegistryKey)xRegistryKey);
    }

    public String getImplementationName() {
        return m_implementationName;
    }

    public boolean supportsService(String sService) {
        int len = m_serviceNames.length;
        for (int i = 0; i < len; ++i) {
            if (!sService.equals(m_serviceNames[i])) continue;
            return true;
        }
        return false;
    }

    public String[] getSupportedServiceNames() {
        return m_serviceNames;
    }

    public void solve() {
        this.initializeSolve();
        if (this.m_problemEncoder == null) {
            return;
        }
        int swarmSize = (Integer)this.m_swarmSize.getValue();
        SCAgent[] agents = new SCAgent[swarmSize];
        for (int i = 0; i < swarmSize; ++i) {
            agents[i] = new SCAgent();
            agents[i].setProblemEncoder(this.m_problemEncoder);
            agents[i].setSpecComparator(this.m_specCompareEngine);
            agents[i].setExternalLib(this.m_library);
        }
        this.m_solverStatusDialog.setVisible(true);
        int learningCycles = (Integer)this.m_learningCycles.getValue();
        this.m_solverStatusDialog.setMaxIterations(learningCycles);
        this.m_solverStatusDialog.setMaxStagnation((Integer)this.m_required.getValue());
        int learningCycle = 1;
        long runtime = 0L;
        do {
            long startTime = System.nanoTime();
            if (learningCycle >= (Integer)this.m_learningCycles.getValue()) {
                learningCycle = 1;
            }
            if (this.m_solverStatusDialog.getUserState() == 2) {
                this.lockDocument();
            }
            this.m_toleratedCount = 0;
            this.m_toleratedMin = -1.0 * (Double)this.m_tolerance.getValue();
            this.m_toleratedMax = (Double)this.m_tolerance.getValue();
            while (learningCycle <= learningCycles && this.m_toleratedCount < (Integer)this.m_required.getValue() && this.m_solverStatusDialog.getUserState() != 3) {
                int i;
                for (i = 0; i < swarmSize; ++i) {
                    boolean inRange;
                    SearchPoint point = agents[i].generatePoint();
                    boolean bl = inRange = point.getObjectiveValue() >= this.m_toleratedMin && point.getObjectiveValue() <= this.m_toleratedMax;
                    if (!Library.replace(this.m_envCompareEngine, point, this.m_totalBestPoint)) continue;
                    this.m_solverStatusDialog.setBestSolution(this.m_totalBestPoint.getObjectiveValue(), this.m_totalBestPoint.isFeasible());
                    if (inRange) continue;
                    this.m_toleratedMin = point.getObjectiveValue() - (Double)this.m_tolerance.getValue();
                    this.m_toleratedMax = point.getObjectiveValue() + (Double)this.m_tolerance.getValue();
                    this.m_toleratedCount = 0;
                }
                for (i = 0; i < swarmSize; ++i) {
                    agents[i].updateInfo();
                }
                if (this.m_specCompareEngine instanceof IUpdateCycleEngine) {
                    ((IUpdateCycleEngine)((Object)this.m_specCompareEngine)).updateCycle(learningCycle);
                }
                this.m_solverStatusDialog.setIteration(learningCycle);
                this.m_solverStatusDialog.setStagnation(this.m_toleratedCount);
                this.m_solverStatusDialog.setRuntime(runtime + (System.nanoTime() - startTime));
                this.m_xReschedule.reschedule();
                ++learningCycle;
            }
            this.applySolution();
            this.unlockDocument();
            this.m_solverStatusDialog.setRuntime(runtime += System.nanoTime() - startTime);
        } while (this.m_solverStatusDialog.waitForUser() == 2);
        this.lockDocument();
        this.finalizeSolve();
    }
}

