/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.generate;

import javax.swing.JPanel;
import org.gephi.io.generator.api.GeneratorController;
import org.gephi.io.generator.spi.Generator;
import org.gephi.io.generator.spi.GeneratorUI;
import org.gephi.io.importer.api.Container;
import org.gephi.io.importer.api.ContainerUnloader;
import org.gephi.io.importer.api.Report;
import org.gephi.io.processor.plugin.DefaultProcessor;
import org.gephi.lib.validation.DialogDescriptorWithValidation;
import org.gephi.utils.longtask.api.LongTaskErrorHandler;
import org.gephi.utils.longtask.api.LongTaskExecutor;
import org.gephi.utils.longtask.spi.LongTask;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class DesktopGeneratorController
implements GeneratorController {
    private final LongTaskExecutor executor = new LongTaskExecutor(true, "Generator");

    public Generator[] getGenerators() {
        return Lookup.getDefault().lookupAll(Generator.class).toArray(new Generator[0]);
    }

    public void generate(final Generator generator) {
        String title = generator.getName();
        GeneratorUI ui = generator.getUI();
        if (ui != null) {
            ui.setup(generator);
            JPanel panel = ui.getPanel();
            DialogDescriptor dd = DialogDescriptorWithValidation.dialog((Object)panel, (String)title);
            Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
            if (result != NotifyDescriptor.OK_OPTION) {
                return;
            }
            ui.unsetup();
        }
        final Container container = ((Container.Factory)Lookup.getDefault().lookup(Container.Factory.class)).newContainer();
        container.setSource(generator.getName());
        container.setReport(new Report());
        String taskname = NbBundle.getMessage(DesktopGeneratorController.class, (String)"DesktopGeneratorController.taskname", (Object)generator.getName());
        LongTaskErrorHandler errorHandler = new LongTaskErrorHandler(){

            public void fatalError(Throwable t) {
                Exceptions.printStackTrace((Throwable)t);
            }
        };
        this.executor.execute((LongTask)generator, new Runnable(){

            @Override
            public void run() {
                generator.generate(container.getLoader());
                DesktopGeneratorController.this.finishGenerate(container);
            }
        }, taskname, errorHandler);
    }

    private void finishGenerate(Container container) {
        container.closeLoader();
        DefaultProcessor defaultProcessor = new DefaultProcessor();
        defaultProcessor.setContainers(new ContainerUnloader[]{container.getUnloader()});
        defaultProcessor.process();
    }
}

