/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.serialization.compiler.fir.checkers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.config.KotlinCompilerVersion;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.diagnostics.AbstractSourceElementPositioningStrategy;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory2;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory3;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportContextHelpersKt;
import org.jetbrains.kotlin.diagnostics.SourceElementPositioningStrategies;
import org.jetbrains.kotlin.fir.FirModuleDataKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousObject;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.utils.DeclarationAttributesKt;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirArrayOfCall;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirConstExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirGetClassCall;
import org.jetbrains.kotlin.fir.expressions.FirPropertyAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirVarargArgumentsExpression;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.resolve.ScopeUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirAnonymousObjectSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirEnumEntrySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeProjectionKt;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.jvm.annotations.JvmAnnotationUtilKt;
import org.jetbrains.kotlin.types.AbstractTypeChecker;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import org.jetbrains.kotlin.types.model.TypeCheckerProviderContext;
import org.jetbrains.kotlinx.serialization.compiler.diagnostic.RuntimeVersions;
import org.jetbrains.kotlinx.serialization.compiler.fir.AnnotationParameterNames;
import org.jetbrains.kotlinx.serialization.compiler.fir.FirSerializableProperties;
import org.jetbrains.kotlinx.serialization.compiler.fir.FirSerializableProperty;
import org.jetbrains.kotlinx.serialization.compiler.fir.SerializationFirUtilsKt;
import org.jetbrains.kotlinx.serialization.compiler.fir.checkers.FirSerializationErrors;
import org.jetbrains.kotlinx.serialization.compiler.fir.checkers.SerializationFirCheckerUtilsKt;
import org.jetbrains.kotlinx.serialization.compiler.fir.services.ContextualSerializersProviderKt;
import org.jetbrains.kotlinx.serialization.compiler.fir.services.DependencySerializationInfoProviderKt;
import org.jetbrains.kotlinx.serialization.compiler.fir.services.FirSerializablePropertiesProviderKt;
import org.jetbrains.kotlinx.serialization.compiler.fir.services.FirVersionReaderKt;
import org.jetbrains.kotlinx.serialization.compiler.resolve.SerializationAnnotations;
import org.jetbrains.kotlinx.serialization.compiler.resolve.SerializersClassIds;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J6\u0010\u0017\u001a\u00020\u00182\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\r2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u00020\u000e\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001fJ*\u0010 \u001a\u0004\u0018\u00010!2\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u00020\u000e\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\"J(\u0010#\u001a\u00020\f2\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u00020\u000e\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010$J\u0014\u0010%\u001a\u00020\fH\u0002R\u00020\u000e\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010&J \u0010'\u001a\u00020\u00182\u0006\u0010(\u001a\u00020\u00022\u0006\u0010)\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J(\u0010*\u001a\u00020\u00182\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u00020\u000e\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010+J(\u0010,\u001a\u00020\u00182\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u00020\u000e\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010+J6\u0010-\u001a\u00020\u00182\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\r2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u00020\u000e\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001fJ:\u0010.\u001a\u00020\u00182\b\u0010/\u001a\u0004\u0018\u0001002\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u00101\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u00020\u000e\u00f8\u0001\u0000\u00a2\u0006\u0002\u00102JB\u00103\u001a\u00020\u00182\n\u00104\u001a\u0006\u0012\u0002\b\u00030\r2\b\u0010/\u001a\u0004\u0018\u0001002\u0006\u00105\u001a\u00020\u00132\u0006\u00101\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u00020\u000e\u00f8\u0001\u0000\u00a2\u0006\u0002\u00106J(\u00107\u001a\u00020\u00182\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u00020\u000e\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010+J(\u00108\u001a\u00020\u00182\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u00020\u000e\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010+J.\u00109\u001a\u00020\u00182\u0006\u0010:\u001a\u00020\u00132\b\u0010/\u001a\u0004\u0018\u0001002\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u00020\u000e\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010;J(\u0010<\u001a\u00020\u00182\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u00020\u000e\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010+J,\u0010=\u001a\u00020\u00182\u000e\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\r2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u00020\u000e\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010+J6\u0010>\u001a\u00020\u00182\u0006\u0010?\u001a\u00020\u00132\u0006\u00101\u001a\u00020\u00132\b\u0010/\u001a\u0004\u0018\u0001002\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u00020\u000e\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010@J(\u0010A\u001a\u00020\u00182\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u00020\u000e\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010+J.\u0010B\u001a\u00020\u00182\u0006\u0010C\u001a\u00020\u00132\b\u0010/\u001a\u0004\u0018\u0001002\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u00020\u000e\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010;J.\u0010D\u001a\u00020\u00182\u0006\u0010C\u001a\u00020\u00132\b\u0010/\u001a\u0004\u0018\u0001002\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u00020\u000e\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010;J(\u0010E\u001a\u00020\u00182\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u00020\u000e\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010+J\u0010\u0010F\u001a\u00020\f2\u0006\u0010G\u001a\u00020HH\u0002J \u0010I\u001a\u00020\f*\u00020J2\u0006\u0010K\u001a\u00020JH\u0002R\u00020\u000e\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010LJ \u0010M\u001a\u00020\f*\u00020N2\u0006\u0010K\u001a\u00020NH\u0002R\u00020\u000e\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010OR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R)\u0010\u000b\u001a\u00020\f*\u0006\u0012\u0002\b\u00030\r8BX\u0082\u0004b\u00020\u000e\u00f8\u0001\u0000\u00a2\u0006\f\u0012\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u000b\u0010\u0011R%\u0010\u0012\u001a\u00020\f*\u00020\u00138BX\u0082\u0004b\u00020\u000e\u00f8\u0001\u0000\u00a2\u0006\f\u0012\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0012\u0010\u0016\u0082\u0002\u0007\n\u0005\b\u00b1\u00140\u0001\u00a8\u0006P"}, d2={"Lorg/jetbrains/kotlinx/serialization/compiler/fir/checkers/FirSerializationPluginClassChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirClassChecker;", "()V", "JAVA_SERIALIZABLE_ID", "Lorg/jetbrains/kotlin/name/ClassId;", "NA", "", "TOO_LOW", "UNKNOWN", "isAnonymousObjectOrInsideIt", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "isAnonymousObjectOrInsideIt$annotations", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;)V", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;)Z", "isUnsupportedInlineType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "isUnsupportedInlineType$annotations", "(Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;)V", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;)Z", "analyzePropertiesSerializers", "", "classSymbol", "properties", "", "Lorg/jetbrains/kotlinx/serialization/compiler/fir/FirSerializableProperty;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;Ljava/util/List;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;)V", "buildSerializableProperties", "Lorg/jetbrains/kotlinx/serialization/compiler/fir/FirSerializableProperties;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;)Lorg/jetbrains/kotlinx/serialization/compiler/fir/FirSerializableProperties;", "canBeSerializedInternally", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;)Z", "canSupportInlineClasses", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;)Z", "check", "declaration", "context", "checkClassWithCustomSerializer", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;)V", "checkCompanionSerializerDependency", "checkCorrectTransientAnnotationIsUsed", "checkCustomSerializerIsNotLocal", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "serializerType", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/KtSourceElement;Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;)V", "checkCustomSerializerMatch", "containingClassSymbol", "declarationType", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;Lorg/jetbrains/kotlin/KtSourceElement;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;)V", "checkEnum", "checkExternalSerializer", "checkGenericArrayType", "propertyType", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;Lorg/jetbrains/kotlin/KtSourceElement;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;)V", "checkInheritedAnnotations", "checkMetaSerializableApplicable", "checkSerializerNullability", "classType", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;Lorg/jetbrains/kotlin/KtSourceElement;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;)V", "checkTransients", "checkType", "type", "checkTypeArguments", "checkVersions", "declarationHasInitializer", "propertySymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "hasSameArguments", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;", "other", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;)Z", "isEqualTo", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/expressions/FirExpression;Lorg/jetbrains/kotlin/fir/expressions/FirExpression;)Z", "kotlinx-serialization-compiler-plugin.k2"})
@SourceDebugExtension(value={"SMAP\nFirSerializationPluginClassChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirSerializationPluginClassChecker.kt\norg/jetbrains/kotlinx/serialization/compiler/fir/checkers/FirSerializationPluginClassChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 6 ClassKind.kt\norg/jetbrains/kotlin/descriptors/ClassKindKt\n*L\n1#1,578:1\n1#2:579\n1#2:624\n46#3:580\n46#3:581\n1726#4,3:582\n1747#4,3:585\n288#4,2:592\n1747#4,3:594\n800#4,11:599\n766#4:611\n857#4,2:612\n1603#4,9:614\n1855#4:623\n1856#4:625\n1612#4:626\n64#5:588\n66#5:589\n129#5:590\n129#5:597\n42#5:610\n37#6:591\n37#6:598\n*S KotlinDebug\n*F\n+ 1 FirSerializationPluginClassChecker.kt\norg/jetbrains/kotlinx/serialization/compiler/fir/checkers/FirSerializationPluginClassChecker\n*L\n96#1:624\n150#1:580\n155#1:581\n159#1:582,3\n195#1:585,3\n263#1:592,2\n338#1:594,3\n396#1:599,11\n95#1:611\n95#1:612,2\n96#1:614,9\n96#1:623\n96#1:625\n96#1:626\n230#1:588\n235#1:589\n259#1:590\n344#1:597\n397#1:610\n259#1:591\n344#1:598\n*E\n"})
public final class FirSerializationPluginClassChecker
extends FirDeclarationChecker<FirClass> {
    @NotNull
    public static final FirSerializationPluginClassChecker INSTANCE = new FirSerializationPluginClassChecker();
    @NotNull
    private static final ClassId JAVA_SERIALIZABLE_ID;
    @NotNull
    private static final String TOO_LOW = "too low";
    @NotNull
    private static final String UNKNOWN = "unknown";
    @NotNull
    private static final String NA = "N/A";

    private FirSerializationPluginClassChecker() {
    }

    public void check(@NotNull FirClass declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        CheckerContext $this$check_u24lambda_u240 = context;
        boolean bl = false;
        FirClassSymbol classSymbol = declaration.getSymbol();
        INSTANCE.checkMetaSerializableApplicable($this$check_u24lambda_u240, (FirClassSymbol<? extends FirClass>)classSymbol, reporter);
        INSTANCE.checkEnum($this$check_u24lambda_u240, classSymbol, reporter);
        INSTANCE.checkExternalSerializer($this$check_u24lambda_u240, classSymbol, reporter);
        if (!INSTANCE.canBeSerializedInternally($this$check_u24lambda_u240, classSymbol, reporter)) {
            return;
        }
        if (!(classSymbol instanceof FirRegularClassSymbol)) {
            return;
        }
        FirSerializableProperties firSerializableProperties = INSTANCE.buildSerializableProperties($this$check_u24lambda_u240, classSymbol, reporter);
        if (firSerializableProperties == null) {
            return;
        }
        FirSerializableProperties properties = firSerializableProperties;
        INSTANCE.checkCorrectTransientAnnotationIsUsed($this$check_u24lambda_u240, classSymbol, properties.getSerializableProperties(), reporter);
        INSTANCE.checkTransients($this$check_u24lambda_u240, classSymbol, reporter);
        INSTANCE.analyzePropertiesSerializers($this$check_u24lambda_u240, classSymbol, properties.getSerializableProperties(), reporter);
        INSTANCE.checkInheritedAnnotations($this$check_u24lambda_u240, classSymbol, reporter);
        INSTANCE.checkVersions($this$check_u24lambda_u240, classSymbol, reporter);
    }

    private final void checkMetaSerializableApplicable(CheckerContext _context_receiver_0, FirClassSymbol<? extends FirClass> classSymbol, DiagnosticReporter reporter) {
        Object v0;
        block4: {
            if (classSymbol.getClassKind() != ClassKind.ANNOTATION_CLASS) {
                return;
            }
            if (!classSymbol.getClassId().isNestedClass()) {
                return;
            }
            Iterable iterable = classSymbol.getResolvedAnnotationsWithClassIds();
            for (Object t : iterable) {
                FirAnnotation it = (FirAnnotation)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)FirAnnotationUtilsKt.toAnnotationClassId((FirAnnotation)it, (FirSession)_context_receiver_0.getSession()), (Object)SerializationAnnotations.INSTANCE.getMetaSerializableAnnotationClassId())) continue;
                v0 = t;
                break block4;
            }
            v0 = null;
        }
        FirAnnotation firAnnotation = v0;
        if (firAnnotation == null) {
            return;
        }
        FirAnnotation anno = firAnnotation;
        KtDiagnosticReportContextHelpersKt.reportOn$default((DiagnosticContext)((DiagnosticContext)_context_receiver_0), (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)anno.getSource()), (KtDiagnosticFactory0)FirSerializationErrors.INSTANCE.getMETA_SERIALIZABLE_NOT_APPLICABLE(), null, (int)8, null);
    }

    private final void checkExternalSerializer(CheckerContext _context_receiver_0, FirClassSymbol<?> classSymbol, DiagnosticReporter reporter) {
        ConeKotlinType coneKotlinType = SerializationFirUtilsKt.getSerializerForClass(classSymbol, _context_receiver_0.getSession());
        if (coneKotlinType == null) {
            return;
        }
        ConeKotlinType serializableKType = coneKotlinType;
        FirRegularClassSymbol firRegularClassSymbol = TypeUtilsKt.toRegularClassSymbol((ConeKotlinType)serializableKType, (FirSession)_context_receiver_0.getSession());
        if (firRegularClassSymbol == null) {
            return;
        }
        FirRegularClassSymbol serializableClassSymbol = firRegularClassSymbol;
        FirSerializableProperties properties = FirSerializablePropertiesProviderKt.getSerializablePropertiesProvider(_context_receiver_0.getSession()).getSerializablePropertiesForClass((FirClassSymbol)serializableClassSymbol);
        if (!properties.isExternallySerializable()) {
            FirAnnotation firAnnotation = SerializationFirUtilsKt.getSerializerAnnotation(classSymbol, _context_receiver_0.getSession());
            if (firAnnotation == null || (firAnnotation = firAnnotation.getSource()) == null) {
                firAnnotation = classSymbol.getSource();
            }
            FirAnnotation source = firAnnotation;
            KtDiagnosticFactory2<FirClassSymbol<?>, ConeKotlinType> error = Intrinsics.areEqual((Object)serializableClassSymbol.getModuleData(), (Object)FirModuleDataKt.getModuleData((FirSession)_context_receiver_0.getSession())) ? FirSerializationErrors.INSTANCE.getEXTERNAL_CLASS_NOT_SERIALIZABLE() : FirSerializationErrors.INSTANCE.getEXTERNAL_CLASS_IN_ANOTHER_MODULE();
            KtDiagnosticReportContextHelpersKt.reportOn$default((DiagnosticContext)((DiagnosticContext)_context_receiver_0), (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)source), error, (Object)serializableClassSymbol, (Object)serializableKType, null, (int)32, null);
        }
    }

    private final void checkInheritedAnnotations(CheckerContext _context_receiver_0, FirClassSymbol<?> classSymbol, DiagnosticReporter reporter) {
        Map map = MapsKt.createMapBuilder();
        Map $this$checkInheritedAnnotations_u24lambda_u245 = map;
        boolean bl = false;
        MapsKt.putAll((Map)$this$checkInheritedAnnotations_u24lambda_u245, (Iterable)FirSerializationPluginClassChecker.checkInheritedAnnotations$annotationsFilter(_context_receiver_0, classSymbol.getResolvedAnnotationsWithClassIds()));
        Map annotationByClassId = MapsKt.build((Map)map);
        for (ConeKotlinType superType : classSymbol.getResolvedSuperTypes()) {
            FirRegularClassSymbol superSymbol;
            if (TypeUtilsKt.toRegularClassSymbol((ConeKotlinType)superType, (FirSession)_context_receiver_0.getSession()) == null) continue;
            List<Pair<ClassId, FirAnnotation>> superAnnotations = FirSerializationPluginClassChecker.checkInheritedAnnotations$annotationsFilter(_context_receiver_0, superSymbol.getResolvedAnnotationsWithClassIds());
            for (Pair<ClassId, FirAnnotation> pair : superAnnotations) {
                FirAnnotation existingAnnotation;
                ClassId classId = (ClassId)pair.component1();
                FirAnnotation superAnnotation = (FirAnnotation)pair.component2();
                if ((FirAnnotation)annotationByClassId.get(classId) == null || this.hasSameArguments(_context_receiver_0, existingAnnotation, superAnnotation)) continue;
                KtDiagnosticReportContextHelpersKt.reportOn$default((DiagnosticContext)((DiagnosticContext)_context_receiver_0), (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)existingAnnotation.getSource()), FirSerializationErrors.INSTANCE.getINCONSISTENT_INHERITABLE_SERIALINFO(), (Object)FirTypeUtilsKt.getConeType((FirTypeRef)existingAnnotation.getAnnotationTypeRef()), (Object)ScopeUtilsKt.defaultType(classSymbol), null, (int)32, null);
            }
        }
    }

    private final boolean hasSameArguments(CheckerContext _context_receiver_0, FirAnnotation $this$hasSameArguments, FirAnnotation other) {
        Map m1 = $this$hasSameArguments.getArgumentMapping().getMapping();
        Map m2 = other.getArgumentMapping().getMapping();
        if (!Intrinsics.areEqual(m1.keySet(), m2.keySet())) {
            return false;
        }
        for (Map.Entry entry : m1.entrySet()) {
            FirExpression v2;
            Name key = (Name)entry.getKey();
            FirExpression v1 = (FirExpression)entry.getValue();
            if (this.isEqualTo(_context_receiver_0, v1, v2 = (FirExpression)MapsKt.getValue((Map)m2, (Object)key))) continue;
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isEqualTo(CheckerContext _context_receiver_0, FirExpression $this$isEqualTo, FirExpression other) {
        boolean bl;
        if ($this$isEqualTo instanceof FirConstExpression && other instanceof FirConstExpression) {
            if (!Intrinsics.areEqual((Object)((FirConstExpression)$this$isEqualTo).getKind(), (Object)((FirConstExpression)other).getKind())) return false;
            if (!Intrinsics.areEqual((Object)((FirConstExpression)$this$isEqualTo).getValue(), (Object)((FirConstExpression)other).getValue())) return false;
            return true;
        }
        if ($this$isEqualTo instanceof FirGetClassCall && other instanceof FirGetClassCall) {
            bl = AbstractTypeChecker.equalTypes$default((AbstractTypeChecker)AbstractTypeChecker.INSTANCE, (TypeCheckerProviderContext)((TypeCheckerProviderContext)TypeComponentsKt.getTypeContext((FirSession)_context_receiver_0.getSession())), (KotlinTypeMarker)((KotlinTypeMarker)FirTypeUtilsKt.getConeType((FirTypeRef)$this$isEqualTo.getTypeRef())), (KotlinTypeMarker)((KotlinTypeMarker)FirTypeUtilsKt.getConeType((FirTypeRef)other.getTypeRef())), (boolean)false, (int)8, null);
            return bl;
        } else if ($this$isEqualTo instanceof FirPropertyAccessExpression && other instanceof FirPropertyAccessExpression) {
            FirResolvedNamedReference firResolvedNamedReference = FirExpressionUtilKt.toResolvedCallableReference((FirExpression)$this$isEqualTo);
            FirResolvedNamedReference firResolvedNamedReference2 = FirExpressionUtilKt.toResolvedCallableReference((FirExpression)other);
            bl = Intrinsics.areEqual((Object)(firResolvedNamedReference != null ? firResolvedNamedReference.getResolvedSymbol() : null), (Object)(firResolvedNamedReference2 != null ? firResolvedNamedReference2.getResolvedSymbol() : null));
            return bl;
        } else {
            FirExpression b;
            Pair pair;
            FirExpression a;
            List list;
            List list2;
            FirExpression firExpression = $this$isEqualTo;
            if (firExpression instanceof FirVarargArgumentsExpression) {
                list2 = ((FirVarargArgumentsExpression)$this$isEqualTo).getArguments();
            } else {
                if (!(firExpression instanceof FirArrayOfCall)) return false;
                FirCall firCall = (FirCall)$this$isEqualTo;
                boolean $i$f$getArguments = false;
                list2 = firCall.getArgumentList().getArguments();
            }
            List argumentsIfArray1 = list2;
            FirExpression firExpression2 = other;
            if (firExpression2 instanceof FirVarargArgumentsExpression) {
                list = ((FirVarargArgumentsExpression)other).getArguments();
            } else {
                if (!(firExpression2 instanceof FirArrayOfCall)) return false;
                FirCall $this$arguments$iv = (FirCall)other;
                boolean $i$f$getArguments = false;
                list = $this$arguments$iv.getArgumentList().getArguments();
            }
            List argumentsIfArray2 = list;
            if (argumentsIfArray1.size() != argumentsIfArray2.size()) return false;
            Iterable iterable = CollectionsKt.zip((Iterable)argumentsIfArray1, (Iterable)argumentsIfArray2);
            boolean $i$f$all = false;
            if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
                return true;
            }
            Iterator iterator = iterable.iterator();
            do {
                if (!iterator.hasNext()) return true;
                Object element$iv = iterator.next();
                pair = (Pair)element$iv;
                boolean bl2 = false;
            } while (INSTANCE.isEqualTo(_context_receiver_0, a = (FirExpression)pair.component1(), b = (FirExpression)pair.component2()));
            return false;
        }
    }

    private final void checkVersions(CheckerContext _context_receiver_0, FirClassSymbol<?> classSymbol, DiagnosticReporter reporter) {
        RuntimeVersions runtimeVersions2 = FirVersionReaderKt.getVersionReader(_context_receiver_0.getSession()).getRuntimeVersions();
        if (runtimeVersions2 == null) {
            return;
        }
        RuntimeVersions currentVersions = runtimeVersions2;
        if (!currentVersions.implementationVersionMatchSupported()) {
            Object object;
            DiagnosticContext diagnosticContext = (DiagnosticContext)_context_receiver_0;
            AbstractKtSourceElement abstractKtSourceElement = (AbstractKtSourceElement)SerializationFirCheckerUtilsKt.getSerializableOrMetaAnnotationSource(_context_receiver_0, classSymbol);
            KtDiagnosticFactory3<String, String, String> ktDiagnosticFactory3 = FirSerializationErrors.INSTANCE.getPROVIDED_RUNTIME_TOO_LOW();
            String string = KotlinCompilerVersion.getVersion();
            if (string == null) {
                string = TOO_LOW;
            }
            if ((object = currentVersions.getImplementationVersion()) == null || (object = object.toString()) == null) {
                object = UNKNOWN;
            }
            KtDiagnosticReportContextHelpersKt.reportOn$default((DiagnosticContext)diagnosticContext, (DiagnosticReporter)reporter, (AbstractKtSourceElement)abstractKtSourceElement, ktDiagnosticFactory3, (Object)string, (Object)object, (Object)RuntimeVersions.Companion.getMINIMAL_SUPPORTED_VERSION().toString(), null, (int)64, null);
        }
        if (!currentVersions.currentCompilerMatchRequired()) {
            Object object;
            Object object2;
            DiagnosticContext diagnosticContext = (DiagnosticContext)_context_receiver_0;
            AbstractKtSourceElement abstractKtSourceElement = (AbstractKtSourceElement)SerializationFirCheckerUtilsKt.getSerializableOrMetaAnnotationSource(_context_receiver_0, classSymbol);
            KtDiagnosticFactory3<String, String, String> ktDiagnosticFactory3 = FirSerializationErrors.INSTANCE.getREQUIRED_KOTLIN_TOO_HIGH();
            String string = KotlinCompilerVersion.getVersion();
            if (string == null) {
                string = TOO_LOW;
            }
            if ((object2 = currentVersions.getImplementationVersion()) == null || (object2 = object2.toString()) == null) {
                object2 = UNKNOWN;
            }
            if ((object = currentVersions.getRequireKotlinVersion()) == null || (object = object.toString()) == null) {
                object = NA;
            }
            KtDiagnosticReportContextHelpersKt.reportOn$default((DiagnosticContext)diagnosticContext, (DiagnosticReporter)reporter, (AbstractKtSourceElement)abstractKtSourceElement, ktDiagnosticFactory3, (Object)string, (Object)object2, (Object)object, null, (int)64, null);
        }
    }

    private final void checkCorrectTransientAnnotationIsUsed(CheckerContext _context_receiver_0, FirClassSymbol<?> classSymbol, List<FirSerializableProperty> properties, DiagnosticReporter reporter) {
        boolean bl;
        block6: {
            Iterable $this$any$iv = classSymbol.getResolvedSuperTypes();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ConeKotlinType it = (ConeKotlinType)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)ConeTypeUtilsKt.getClassId((ConeKotlinType)it), (Object)JAVA_SERIALIZABLE_ID)) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        if (bl) {
            return;
        }
        for (FirSerializableProperty property2 : properties) {
            FirAnnotation incorrectTransient;
            if (property2.getTransient() || (incorrectTransient = FirAnnotationUtilsKt.getAnnotationByClassId((List)property2.getPropertySymbol().getAnnotations(), (ClassId)JvmAnnotationUtilKt.TRANSIENT_ANNOTATION_CLASS_ID, (FirSession)_context_receiver_0.getSession())) == null) continue;
            DiagnosticContext diagnosticContext = (DiagnosticContext)_context_receiver_0;
            KtSourceElement ktSourceElement = incorrectTransient.getSource();
            if (ktSourceElement == null) {
                ktSourceElement = property2.getPropertySymbol().getSource();
            }
            KtDiagnosticReportContextHelpersKt.reportOn$default((DiagnosticContext)diagnosticContext, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)ktSourceElement), (KtDiagnosticFactory0)FirSerializationErrors.INSTANCE.getINCORRECT_TRANSIENT(), null, (int)8, null);
        }
    }

    private final boolean canBeSerializedInternally(CheckerContext _context_receiver_0, FirClassSymbol<?> classSymbol, DiagnosticReporter reporter) {
        if (DependencySerializationInfoProviderKt.getDependencySerializationInfoProvider(_context_receiver_0.getSession()).getUseGeneratedEnumSerializer() && SerializationFirCheckerUtilsKt.isSerializableEnumWithMissingSerializer(_context_receiver_0, classSymbol)) {
            KtDiagnosticReportContextHelpersKt.reportOn((DiagnosticContext)((DiagnosticContext)_context_receiver_0), (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)classSymbol.getSource()), (KtDiagnosticFactory0)FirSerializationErrors.INSTANCE.getEXPLICIT_SERIALIZABLE_IS_REQUIRED(), (AbstractSourceElementPositioningStrategy)((AbstractSourceElementPositioningStrategy)SourceElementPositioningStrategies.INSTANCE.getENUM_MODIFIER()));
            return false;
        }
        this.checkCompanionSerializerDependency(_context_receiver_0, classSymbol, reporter);
        FirSession $this$canBeSerializedInternally_u24lambda_u248 = _context_receiver_0.getSession();
        boolean bl = false;
        if (!SerializationFirUtilsKt.getHasSerializableOrMetaAnnotation($this$canBeSerializedInternally_u24lambda_u248, classSymbol)) {
            return false;
        }
        if (this.isAnonymousObjectOrInsideIt(_context_receiver_0, classSymbol)) {
            KtDiagnosticReportContextHelpersKt.reportOn$default((DiagnosticContext)((DiagnosticContext)_context_receiver_0), (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)SerializationFirCheckerUtilsKt.getSerializableOrMetaAnnotationSource(_context_receiver_0, classSymbol)), (KtDiagnosticFactory0)FirSerializationErrors.INSTANCE.getANONYMOUS_OBJECTS_NOT_SUPPORTED(), null, (int)8, null);
            return false;
        }
        FirClassSymbol<?> $this$isInner$iv = classSymbol;
        boolean $i$f$isInner = false;
        if ($this$isInner$iv.getRawStatus().isInner()) {
            KtDiagnosticReportContextHelpersKt.reportOn$default((DiagnosticContext)((DiagnosticContext)_context_receiver_0), (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)SerializationFirCheckerUtilsKt.getSerializableOrMetaAnnotationSource(_context_receiver_0, classSymbol)), (KtDiagnosticFactory0)FirSerializationErrors.INSTANCE.getINNER_CLASSES_NOT_SUPPORTED(), null, (int)8, null);
            return false;
        }
        FirClassSymbol<?> $this$isInline$iv = classSymbol;
        boolean $i$f$isInline = false;
        if ($this$isInline$iv.getRawStatus().isInline() && !FirVersionReaderKt.getVersionReader(_context_receiver_0.getSession()).getCanSupportInlineClasses()) {
            RuntimeVersions runtimeVersions2 = FirVersionReaderKt.getVersionReader(_context_receiver_0.getSession()).getRuntimeVersions();
            KtDiagnosticReportContextHelpersKt.reportOn$default((DiagnosticContext)((DiagnosticContext)_context_receiver_0), (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)SerializationFirCheckerUtilsKt.getSerializableOrMetaAnnotationSource(_context_receiver_0, classSymbol)), FirSerializationErrors.INSTANCE.getINLINE_CLASSES_NOT_SUPPORTED(), (Object)RuntimeVersions.Companion.getMINIMAL_VERSION_FOR_INLINE_CLASSES().toString(), (Object)String.valueOf(runtimeVersions2 != null ? runtimeVersions2.getImplementationVersion() : null), null, (int)32, null);
            return false;
        }
        FirSession $this$canBeSerializedInternally_u24lambda_u249 = _context_receiver_0.getSession();
        boolean bl2 = false;
        if (!SerializationFirUtilsKt.getHasSerializableOrMetaAnnotationWithoutArgs($this$canBeSerializedInternally_u24lambda_u249, classSymbol)) {
            this.checkClassWithCustomSerializer(_context_receiver_0, classSymbol, reporter);
            return false;
        }
        FirSession $this$canBeSerializedInternally_u24lambda_u2410 = _context_receiver_0.getSession();
        boolean bl3 = false;
        if (SerializationFirCheckerUtilsKt.getSerializableAnnotationIsUseless($this$canBeSerializedInternally_u24lambda_u2410, classSymbol)) {
            KtSourceElement ktSourceElement = SerializationFirCheckerUtilsKt.getSerializableOrMetaAnnotationSource(_context_receiver_0, classSymbol);
            if (ktSourceElement != null) {
                KtSourceElement it = ktSourceElement;
                boolean bl4 = false;
                KtDiagnosticReportContextHelpersKt.reportOn$default((DiagnosticContext)((DiagnosticContext)_context_receiver_0), (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)it), (KtDiagnosticFactory0)FirSerializationErrors.INSTANCE.getSERIALIZABLE_ANNOTATION_IGNORED(), null, (int)8, null);
            }
            return false;
        }
        FirClassSymbol<?> $this$isEnumClass$iv = classSymbol;
        boolean $i$f$isEnumClass = false;
        ClassKind $this$isEnumClass$iv$iv = $this$isEnumClass$iv.getClassKind();
        boolean $i$f$isEnumClass2 = false;
        if (!($this$isEnumClass$iv$iv == ClassKind.ENUM_CLASS)) {
            FirRegularClassSymbol superClassSymbol = SerializationFirCheckerUtilsKt.getSuperClassOrAny(classSymbol, _context_receiver_0.getSession());
            FirSession $this$canBeSerializedInternally_u24lambda_u2412 = _context_receiver_0.getSession();
            boolean bl5 = false;
            boolean bl6 = !SerializationFirUtilsKt.isInternalSerializable($this$canBeSerializedInternally_u24lambda_u2412, (FirClassSymbol)superClassSymbol);
            if (bl6) {
                Object v3;
                block12: {
                    Iterable $this$firstOrNull$iv = superClassSymbol.getDeclarationSymbols();
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        FirBasedSymbol it = (FirBasedSymbol)element$iv;
                        boolean bl7 = false;
                        if (!(it instanceof FirConstructorSymbol && ((FirConstructorSymbol)it).getValueParameterSymbols().isEmpty())) continue;
                        v3 = element$iv;
                        break block12;
                    }
                    v3 = null;
                }
                FirBasedSymbol noArgConstructorSymbol = v3;
                if (noArgConstructorSymbol == null) {
                    KtDiagnosticReportContextHelpersKt.reportOn$default((DiagnosticContext)((DiagnosticContext)_context_receiver_0), (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)SerializationFirCheckerUtilsKt.getSerializableOrMetaAnnotationSource(_context_receiver_0, classSymbol)), (KtDiagnosticFactory0)FirSerializationErrors.INSTANCE.getNON_SERIALIZABLE_PARENT_MUST_HAVE_NOARG_CTOR(), null, (int)8, null);
                    return false;
                }
            }
        }
        return true;
    }

    private final void checkCompanionSerializerDependency(CheckerContext _context_receiver_0, FirClassSymbol<?> classSymbol, DiagnosticReporter reporter) {
        FirSession $this$checkCompanionSerializerDependency_u24lambda_u2414 = _context_receiver_0.getSession();
        boolean bl = false;
        if (!(classSymbol instanceof FirRegularClassSymbol)) {
            return;
        }
        FirRegularClassSymbol firRegularClassSymbol = ((FirRegularClassSymbol)classSymbol).getCompanionObjectSymbol();
        if (firRegularClassSymbol == null) {
            return;
        }
        FirRegularClassSymbol companionObjectSymbol = firRegularClassSymbol;
        ConeKotlinType coneKotlinType = SerializationFirUtilsKt.getSerializerForClass((FirClassSymbol)companionObjectSymbol, _context_receiver_0.getSession());
        if (coneKotlinType == null || (coneKotlinType = TypeUtilsKt.toRegularClassSymbol((ConeKotlinType)coneKotlinType, (FirSession)_context_receiver_0.getSession())) == null) {
            return;
        }
        ConeKotlinType serializerForInCompanion = coneKotlinType;
        ConeKotlinType serializableWith = SerializationFirUtilsKt.getSerializableWith((FirBasedSymbol)classSymbol, _context_receiver_0.getSession());
        if (SerializationFirUtilsKt.getHasSerializableOrMetaAnnotationWithoutArgs($this$checkCompanionSerializerDependency_u24lambda_u2414, classSymbol)) {
            if (Intrinsics.areEqual((Object)serializerForInCompanion.getClassId(), (Object)classSymbol.getClassId())) {
                KtDiagnosticReportContextHelpersKt.reportOn$default((DiagnosticContext)((DiagnosticContext)_context_receiver_0), (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)SerializationFirCheckerUtilsKt.getSerializableOrMetaAnnotationSource(_context_receiver_0, classSymbol)), FirSerializationErrors.INSTANCE.getCOMPANION_OBJECT_AS_CUSTOM_SERIALIZER_DEPRECATED(), classSymbol, null, (int)16, null);
            } else {
                FirAnnotation firAnnotation = SerializationFirUtilsKt.getSerializerAnnotation((FirClassSymbol)companionObjectSymbol, _context_receiver_0.getSession());
                KtSourceElement source = firAnnotation != null ? firAnnotation.getSource() : null;
                KtDiagnosticReportContextHelpersKt.reportOn$default((DiagnosticContext)((DiagnosticContext)_context_receiver_0), (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)source), FirSerializationErrors.INSTANCE.getCOMPANION_OBJECT_SERIALIZER_INSIDE_OTHER_SERIALIZABLE_CLASS(), (Object)ScopeUtilsKt.defaultType(classSymbol), (Object)ScopeUtilsKt.defaultType((FirClassSymbol)((FirClassSymbol)serializerForInCompanion)), null, (int)32, null);
            }
        } else if (serializableWith != null) {
            if (!Intrinsics.areEqual((Object)ConeTypeUtilsKt.getClassId((ConeKotlinType)serializableWith), (Object)companionObjectSymbol.getClassId()) || !Intrinsics.areEqual((Object)serializerForInCompanion.getClassId(), (Object)classSymbol.getClassId())) {
                FirAnnotation firAnnotation = SerializationFirUtilsKt.getSerializerAnnotation((FirClassSymbol)companionObjectSymbol, _context_receiver_0.getSession());
                KtDiagnosticReportContextHelpersKt.reportOn$default((DiagnosticContext)((DiagnosticContext)_context_receiver_0), (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)(firAnnotation != null ? firAnnotation.getSource() : null)), FirSerializationErrors.INSTANCE.getCOMPANION_OBJECT_SERIALIZER_INSIDE_OTHER_SERIALIZABLE_CLASS(), (Object)ScopeUtilsKt.defaultType(classSymbol), (Object)ScopeUtilsKt.defaultType((FirClassSymbol)((FirClassSymbol)serializerForInCompanion)), null, (int)32, null);
            }
        } else {
            FirAnnotation firAnnotation = SerializationFirUtilsKt.getSerializerAnnotation((FirClassSymbol)companionObjectSymbol, _context_receiver_0.getSession());
            KtDiagnosticReportContextHelpersKt.reportOn$default((DiagnosticContext)((DiagnosticContext)_context_receiver_0), (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)(firAnnotation != null ? firAnnotation.getSource() : null)), FirSerializationErrors.INSTANCE.getCOMPANION_OBJECT_SERIALIZER_INSIDE_NON_SERIALIZABLE_CLASS(), (Object)ScopeUtilsKt.defaultType(classSymbol), (Object)ScopeUtilsKt.defaultType((FirClassSymbol)((FirClassSymbol)serializerForInCompanion)), null, (int)32, null);
        }
    }

    private final void checkClassWithCustomSerializer(CheckerContext _context_receiver_0, FirClassSymbol<?> classSymbol, DiagnosticReporter reporter) {
        ConeKotlinType coneKotlinType = SerializationFirUtilsKt.getSerializableWith((FirBasedSymbol)classSymbol, _context_receiver_0.getSession());
        if (coneKotlinType == null || (coneKotlinType = TypeExpansionUtilsKt.fullyExpandedType((ConeKotlinType)coneKotlinType, (FirSession)_context_receiver_0.getSession())) == null) {
            return;
        }
        ConeKotlinType serializerType = coneKotlinType;
        this.checkCustomSerializerMatch(_context_receiver_0, classSymbol, null, (ConeKotlinType)ScopeUtilsKt.defaultType(classSymbol), serializerType, reporter);
        this.checkCustomSerializerIsNotLocal(_context_receiver_0, null, classSymbol, serializerType, reporter);
    }

    private final boolean isAnonymousObjectOrInsideIt(CheckerContext _context_receiver_0, FirClassSymbol<?> $this$isAnonymousObjectOrInsideIt) {
        boolean bl;
        block4: {
            if ($this$isAnonymousObjectOrInsideIt instanceof FirAnonymousObjectSymbol) {
                return true;
            }
            Iterable $this$any$iv = _context_receiver_0.getContainingDeclarations();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FirDeclaration it = (FirDeclaration)element$iv;
                    boolean bl2 = false;
                    if (!(it instanceof FirAnonymousObject)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static /* synthetic */ void isAnonymousObjectOrInsideIt$annotations(FirClassSymbol firClassSymbol) {
    }

    private final void checkEnum(CheckerContext _context_receiver_0, FirClassSymbol<?> classSymbol, DiagnosticReporter reporter) {
        FirClassSymbol<?> $this$isEnumClass$iv = classSymbol;
        boolean $i$f$isEnumClass = false;
        ClassKind $this$isEnumClass$iv$iv = $this$isEnumClass$iv.getClassKind();
        boolean $i$f$isEnumClass2 = false;
        if (!($this$isEnumClass$iv$iv == ClassKind.ENUM_CLASS)) {
            return;
        }
        Map entryBySerialName = new LinkedHashMap();
        for (FirEnumEntrySymbol enumEntrySymbol : DeclarationUtilsKt.collectEnumEntries(classSymbol)) {
            Object serialName;
            FirEnumEntrySymbol firstEntry;
            FirAnnotation serialNameAnnotation = SerializationFirUtilsKt.getSerialNameAnnotation((FirBasedSymbol)enumEntrySymbol, _context_receiver_0.getSession());
            Object object = serialNameAnnotation;
            if (object == null || (object = FirAnnotationUtilsKt.getStringArgument((FirAnnotation)object, (Name)AnnotationParameterNames.INSTANCE.getVALUE())) == null) {
                String string = enumEntrySymbol.getName().asString();
                object = string;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"enumEntrySymbol.name.asString()");
            }
            if ((firstEntry = (FirEnumEntrySymbol)entryBySerialName.get(serialName = object)) != null) {
                DiagnosticContext diagnosticContext = (DiagnosticContext)_context_receiver_0;
                Object object2 = serialNameAnnotation;
                if (object2 == null || (object2 = object2.getSource()) == null) {
                    FirAnnotation firAnnotation = SerializationFirUtilsKt.getSerialNameAnnotation((FirBasedSymbol)firstEntry, _context_receiver_0.getSession());
                    object2 = firAnnotation != null ? firAnnotation.getSource() : null;
                    if (object2 == null) {
                        object2 = enumEntrySymbol.getSource();
                    }
                }
                AbstractKtSourceElement abstractKtSourceElement = (AbstractKtSourceElement)object2;
                KtDiagnosticFactory3<FirClassSymbol<?>, String, String> ktDiagnosticFactory3 = FirSerializationErrors.INSTANCE.getDUPLICATE_SERIAL_NAME_ENUM();
                String string = enumEntrySymbol.getName().asString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"enumEntrySymbol.name.asString()");
                KtDiagnosticReportContextHelpersKt.reportOn$default((DiagnosticContext)diagnosticContext, (DiagnosticReporter)reporter, (AbstractKtSourceElement)abstractKtSourceElement, ktDiagnosticFactory3, classSymbol, (Object)serialName, (Object)string, null, (int)64, null);
                continue;
            }
            entryBySerialName.put(serialName, enumEntrySymbol);
        }
    }

    private final FirSerializableProperties buildSerializableProperties(CheckerContext _context_receiver_0, FirClassSymbol<?> classSymbol, DiagnosticReporter reporter) {
        FirSession $this$buildSerializableProperties_u24lambda_u2416 = _context_receiver_0.getSession();
        boolean bl = false;
        if (!SerializationFirUtilsKt.getHasSerializableOrMetaAnnotation($this$buildSerializableProperties_u24lambda_u2416, classSymbol)) {
            return null;
        }
        if (!SerializationFirUtilsKt.isInternalSerializable($this$buildSerializableProperties_u24lambda_u2416, classSymbol)) {
            return null;
        }
        if (SerializationFirUtilsKt.isInternallySerializableObject($this$buildSerializableProperties_u24lambda_u2416, classSymbol)) {
            return null;
        }
        FirSerializableProperties properties = FirSerializablePropertiesProviderKt.getSerializablePropertiesProvider(_context_receiver_0.getSession()).getSerializablePropertiesForClass(classSymbol);
        if (!properties.isExternallySerializable()) {
            KtDiagnosticReportContextHelpersKt.reportOn$default((DiagnosticContext)((DiagnosticContext)_context_receiver_0), (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)SerializationFirCheckerUtilsKt.getSerializableOrMetaAnnotationSource(_context_receiver_0, classSymbol)), (KtDiagnosticFactory0)FirSerializationErrors.INSTANCE.getPRIMARY_CONSTRUCTOR_PARAMETER_IS_NOT_A_PROPERTY(), null, (int)8, null);
        }
        Set namesSet = new LinkedHashSet();
        for (FirSerializableProperty property2 : properties.getSerializableProperties()) {
            String name = property2.getName();
            if (namesSet.add(name)) continue;
            KtDiagnosticReportContextHelpersKt.reportOn$default((DiagnosticContext)((DiagnosticContext)_context_receiver_0), (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)SerializationFirCheckerUtilsKt.getSerializableOrMetaAnnotationSource(_context_receiver_0, classSymbol)), FirSerializationErrors.INSTANCE.getDUPLICATE_SERIAL_NAME(), (Object)name, null, (int)16, null);
        }
        return properties;
    }

    /*
     * WARNING - void declaration
     */
    private final void checkTransients(CheckerContext _context_receiver_0, FirClassSymbol<?> classSymbol, DiagnosticReporter reporter) {
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = classSymbol.getDeclarationSymbols();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof FirPropertySymbol)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (FirPropertySymbol propertySymbol : (List)destination$iv$iv) {
            boolean isInitialized;
            FirCallableSymbol $this$isLateInit$iv = (FirCallableSymbol)propertySymbol;
            boolean $i$f$isLateInit = false;
            boolean bl = isInitialized = $this$isLateInit$iv.getRawStatus().isLateInit() || this.declarationHasInitializer(propertySymbol);
            if (SerializationFirUtilsKt.getSerialTransientAnnotation((FirBasedSymbol)propertySymbol, _context_receiver_0.getSession()) == null) continue;
            boolean hasBackingField = DeclarationAttributesKt.getHasBackingField((FirPropertySymbol)propertySymbol);
            if (!hasBackingField) {
                FirAnnotation transientAnnotation;
                DiagnosticContext diagnosticContext = (DiagnosticContext)_context_receiver_0;
                KtSourceElement ktSourceElement = transientAnnotation.getSource();
                if (ktSourceElement == null) {
                    ktSourceElement = propertySymbol.getSource();
                }
                KtDiagnosticReportContextHelpersKt.reportOn$default((DiagnosticContext)diagnosticContext, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)ktSourceElement), (KtDiagnosticFactory0)FirSerializationErrors.INSTANCE.getTRANSIENT_IS_REDUNDANT(), null, (int)8, null);
                continue;
            }
            if (isInitialized) continue;
            KtDiagnosticReportContextHelpersKt.reportOn$default((DiagnosticContext)((DiagnosticContext)_context_receiver_0), (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)propertySymbol.getSource()), (KtDiagnosticFactory0)FirSerializationErrors.INSTANCE.getTRANSIENT_MISSING_INITIALIZER(), null, (int)8, null);
        }
    }

    private final boolean declarationHasInitializer(FirPropertySymbol propertySymbol) {
        boolean bl;
        if (DeclarationAttributesKt.getFromPrimaryConstructor((FirPropertySymbol)propertySymbol)) {
            FirValueParameterSymbol firValueParameterSymbol = DeclarationAttributesKt.getCorrespondingValueParameterFromPrimaryConstructor((FirPropertySymbol)propertySymbol);
            bl = firValueParameterSymbol != null ? firValueParameterSymbol.getHasDefaultValue() : false;
        } else {
            bl = propertySymbol.getHasInitializer() || propertySymbol.getHasDelegate();
        }
        return bl;
    }

    private final void analyzePropertiesSerializers(CheckerContext _context_receiver_0, FirClassSymbol<?> classSymbol, List<FirSerializableProperty> properties, DiagnosticReporter reporter) {
        for (FirSerializableProperty property2 : properties) {
            KtSourceElement source;
            ConeKotlinType customSerializerType;
            ConeKotlinType coneKotlinType = customSerializerType = property2.getSerializableWith();
            FirRegularClassSymbol serializerSymbol = coneKotlinType != null ? TypeUtilsKt.toRegularClassSymbol((ConeKotlinType)coneKotlinType, (FirSession)_context_receiver_0.getSession()) : null;
            FirPropertySymbol propertySymbol = property2.getPropertySymbol();
            FirResolvedTypeRef typeRef = propertySymbol.getResolvedReturnTypeRef();
            ConeKotlinType propertyType = FirTypeUtilsKt.getConeType((FirTypeRef)((FirTypeRef)typeRef));
            KtSourceElement ktSourceElement = typeRef.getSource();
            if (ktSourceElement == null) {
                ktSourceElement = source = propertySymbol.getSource();
            }
            if (customSerializerType != null && serializerSymbol != null) {
                if (CollectionsKt.contains((Iterable)SerializersClassIds.INSTANCE.getSetOfSpecialSerializers(), (Object)ConeTypeUtilsKt.getClassId((ConeKotlinType)customSerializerType))) {
                    return;
                }
                KtSourceElement ktSourceElement2 = typeRef.getSource();
                if (ktSourceElement2 == null) {
                    ktSourceElement2 = propertySymbol.getSource();
                }
                this.checkCustomSerializerMatch(_context_receiver_0, classSymbol, ktSourceElement2, propertyType, customSerializerType, reporter);
                FirAnnotation firAnnotation = SerializationFirUtilsKt.serializableAnnotation((FirBasedSymbol)propertySymbol, false, _context_receiver_0.getSession());
                this.checkCustomSerializerIsNotLocal(_context_receiver_0, (KtSourceElement)(firAnnotation != null ? firAnnotation.getSource() : null), classSymbol, customSerializerType, reporter);
                this.checkSerializerNullability(_context_receiver_0, propertyType, customSerializerType, source, reporter);
                continue;
            }
            this.checkType(_context_receiver_0, propertyType, source, reporter);
            this.checkGenericArrayType(_context_receiver_0, propertyType, source, reporter);
        }
    }

    private final void checkGenericArrayType(CheckerContext _context_receiver_0, ConeKotlinType propertyType, KtSourceElement source, DiagnosticReporter reporter) {
        if (ConeBuiltinTypeUtilsKt.isNonPrimitiveArray((ConeKotlinType)propertyType)) {
            ConeKotlinType coneKotlinType = ConeTypeProjectionKt.getType((ConeTypeProjection)((ConeTypeProjection)ArraysKt.first((Object[])propertyType.getTypeArguments())));
            boolean bl = coneKotlinType != null ? SerializationFirUtilsKt.isTypeParameter(coneKotlinType) : false;
            if (bl) {
                KtDiagnosticReportContextHelpersKt.reportOn$default((DiagnosticContext)((DiagnosticContext)_context_receiver_0), (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)source), (KtDiagnosticFactory0)FirSerializationErrors.INSTANCE.getGENERIC_ARRAY_ELEMENT_NOT_SUPPORTED(), null, (int)8, null);
            }
        }
    }

    private final void checkTypeArguments(CheckerContext _context_receiver_0, ConeKotlinType type, KtSourceElement source, DiagnosticReporter reporter) {
        for (ConeTypeProjection typeArgument : type.getTypeArguments()) {
            ConeKotlinType coneKotlinType = ConeTypeProjectionKt.getType((ConeTypeProjection)typeArgument);
            if (coneKotlinType == null) continue;
            this.checkType(_context_receiver_0, coneKotlinType, source, reporter);
        }
    }

    private final boolean canSupportInlineClasses(CheckerContext _context_receiver_0) {
        return FirVersionReaderKt.getVersionReader(_context_receiver_0.getSession()).getCanSupportInlineClasses();
    }

    private final boolean isUnsupportedInlineType(CheckerContext _context_receiver_0, ConeKotlinType $this$isUnsupportedInlineType) {
        return FirHelpersKt.isSingleFieldValueClass((ConeKotlinType)$this$isUnsupportedInlineType, (FirSession)_context_receiver_0.getSession()) && !ConeBuiltinTypeUtilsKt.isPrimitiveOrNullablePrimitive((ConeKotlinType)$this$isUnsupportedInlineType);
    }

    private static /* synthetic */ void isUnsupportedInlineType$annotations(ConeKotlinType coneKotlinType) {
    }

    private final void checkType(CheckerContext _context_receiver_0, ConeKotlinType type, KtSourceElement source, DiagnosticReporter reporter) {
        FirClassSymbol<?> serializer2;
        if (SerializationFirUtilsKt.isTypeParameter((ConeKotlinType)ConeTypeUtilsKt.lowerBoundIfFlexible((ConeKotlinType)type))) {
            return;
        }
        if (this.isUnsupportedInlineType(_context_receiver_0, type) && !this.canSupportInlineClasses(_context_receiver_0)) {
            RuntimeVersions runtimeVersions2 = FirVersionReaderKt.getVersionReader(_context_receiver_0.getSession()).getRuntimeVersions();
            KtDiagnosticReportContextHelpersKt.reportOn$default((DiagnosticContext)((DiagnosticContext)_context_receiver_0), (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)source), FirSerializationErrors.INSTANCE.getINLINE_CLASSES_NOT_SUPPORTED(), (Object)RuntimeVersions.Companion.getMINIMAL_VERSION_FOR_INLINE_CLASSES().toString(), (Object)String.valueOf(runtimeVersions2 != null ? runtimeVersions2.getImplementationVersion() : null), null, (int)32, null);
        }
        if ((serializer2 = ContextualSerializersProviderKt.findTypeSerializerOrContextUnchecked(_context_receiver_0, type)) != null) {
            FirRegularClassSymbol firRegularClassSymbol = TypeUtilsKt.toRegularClassSymbol((ConeKotlinType)type, (FirSession)_context_receiver_0.getSession());
            if (firRegularClassSymbol == null) {
                return;
            }
            FirRegularClassSymbol classSymbol = firRegularClassSymbol;
            ConeKotlinType coneKotlinType = SerializationFirCheckerUtilsKt.getSerializableWith(_context_receiver_0, type);
            if (coneKotlinType != null && (coneKotlinType = TypeExpansionUtilsKt.fullyExpandedType((ConeKotlinType)coneKotlinType, (FirSession)_context_receiver_0.getSession())) != null) {
                ConeKotlinType serializerType = coneKotlinType;
                boolean bl = false;
                INSTANCE.checkCustomSerializerMatch(_context_receiver_0, (FirClassSymbol)classSymbol, source, type, serializerType, reporter);
                INSTANCE.checkCustomSerializerIsNotLocal(_context_receiver_0, source, (FirClassSymbol)classSymbol, serializerType, reporter);
                INSTANCE.checkSerializerNullability(_context_receiver_0, type, serializerType, source, reporter);
            }
            this.checkTypeArguments(_context_receiver_0, type, source, reporter);
        } else if (!ConeBuiltinTypeUtilsKt.isEnum((ConeKotlinType)type)) {
            KtDiagnosticReportContextHelpersKt.reportOn$default((DiagnosticContext)((DiagnosticContext)_context_receiver_0), (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)source), FirSerializationErrors.INSTANCE.getSERIALIZER_NOT_FOUND(), (Object)type, null, (int)16, null);
        }
    }

    private final void checkCustomSerializerMatch(CheckerContext _context_receiver_0, FirClassSymbol<?> containingClassSymbol, KtSourceElement source, ConeKotlinType declarationType, ConeKotlinType serializerType, DiagnosticReporter reporter) {
        ConeKotlinType coneKotlinType = SerializationFirUtilsKt.serializerForType(serializerType, _context_receiver_0.getSession());
        if (coneKotlinType == null) {
            return;
        }
        ConeKotlinType serializerForType = coneKotlinType;
        ClassId declarationTypeClassId = ConeTypeUtilsKt.getClassId((ConeKotlinType)declarationType);
        if (declarationTypeClassId == null || !Intrinsics.areEqual((Object)declarationTypeClassId, (Object)ConeTypeUtilsKt.getClassId((ConeKotlinType)serializerForType))) {
            DiagnosticContext diagnosticContext = (DiagnosticContext)_context_receiver_0;
            KtSourceElement ktSourceElement = source;
            if (ktSourceElement == null) {
                ktSourceElement = SerializationFirCheckerUtilsKt.getSerializableOrMetaAnnotationSource(_context_receiver_0, containingClassSymbol);
            }
            KtDiagnosticReportContextHelpersKt.reportOn$default((DiagnosticContext)diagnosticContext, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)ktSourceElement), FirSerializationErrors.INSTANCE.getSERIALIZER_TYPE_INCOMPATIBLE(), (Object)ScopeUtilsKt.defaultType(containingClassSymbol), (Object)serializerType, (Object)serializerForType, null, (int)64, null);
        }
    }

    private final void checkCustomSerializerIsNotLocal(CheckerContext _context_receiver_0, KtSourceElement source, FirClassSymbol<?> classSymbol, ConeKotlinType serializerType, DiagnosticReporter reporter) {
        ClassId classId = ConeTypeUtilsKt.getClassId((ConeKotlinType)serializerType);
        if (classId == null) {
            return;
        }
        ClassId serializerClassId = classId;
        if (serializerClassId.isLocal()) {
            DiagnosticContext diagnosticContext = (DiagnosticContext)_context_receiver_0;
            KtSourceElement ktSourceElement = source;
            if (ktSourceElement == null) {
                ktSourceElement = SerializationFirCheckerUtilsKt.getSerializableOrMetaAnnotationSource(_context_receiver_0, classSymbol);
            }
            KtDiagnosticReportContextHelpersKt.reportOn$default((DiagnosticContext)diagnosticContext, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)ktSourceElement), FirSerializationErrors.INSTANCE.getLOCAL_SERIALIZER_USAGE(), (Object)serializerType, null, (int)16, null);
        }
    }

    private final void checkSerializerNullability(CheckerContext _context_receiver_0, ConeKotlinType classType, ConeKotlinType serializerType, KtSourceElement source, DiagnosticReporter reporter) {
        ConeKotlinType coneKotlinType = SerializationFirUtilsKt.serializerForType(serializerType, _context_receiver_0.getSession());
        if (coneKotlinType == null) {
            return;
        }
        ConeKotlinType serializerForType = coneKotlinType;
        if (!ConeTypeUtilsKt.isMarkedNullable((ConeKotlinType)classType) && ConeTypeUtilsKt.isMarkedNullable((ConeKotlinType)serializerForType)) {
            KtDiagnosticReportContextHelpersKt.reportOn$default((DiagnosticContext)((DiagnosticContext)_context_receiver_0), (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)source), FirSerializationErrors.INSTANCE.getSERIALIZER_NULLABILITY_INCOMPATIBLE(), (Object)serializerType, (Object)classType, null, (int)32, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final List<Pair<ClassId, FirAnnotation>> checkInheritedAnnotations$annotationsFilter(CheckerContext $_context_receiver_0, List<? extends FirAnnotation> annotations) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = annotations;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            FirAnnotation it = (FirAnnotation)element$iv$iv;
            boolean bl = false;
            FirRegularClassSymbol firRegularClassSymbol = FirHelpersKt.toRegularClassSymbol((FirTypeRef)it.getAnnotationTypeRef(), (FirSession)$_context_receiver_0.getSession());
            boolean bl2 = firRegularClassSymbol != null ? SerializationFirUtilsKt.isInheritableSerialInfoAnnotation((FirBasedSymbol)firRegularClassSymbol, $_context_receiver_0.getSession()) : false;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Pair pair;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            FirAnnotation annotation = (FirAnnotation)element$iv$iv;
            boolean bl3 = false;
            if (FirAnnotationUtilsKt.toAnnotationClassId((FirAnnotation)annotation, (FirSession)$_context_receiver_0.getSession()) != null) {
                ClassId it;
                boolean bl4 = false;
                pair = TuplesKt.to((Object)it, (Object)annotation);
            } else {
                pair = null;
            }
            if (pair == null) continue;
            Pair it$iv$iv = pair;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    static {
        ClassId classId = ClassId.topLevel((FqName)new FqName("java.io.Serializable"));
        Intrinsics.checkNotNullExpressionValue((Object)classId, (String)"topLevel(FqName(\"java.io.Serializable\"))");
        JAVA_SERIALIZABLE_ID = classId;
    }
}

