/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index;

import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.SortField;
import org.opensearch.common.util.BigArrays;
import org.opensearch.index.fielddata.IndexFieldData;
import org.opensearch.index.fielddata.IndexFieldDataCache;
import org.opensearch.indices.breaker.CircuitBreakerService;
import org.opensearch.knn.index.KNNVectorDVLeafFieldData;
import org.opensearch.search.DocValueFormat;
import org.opensearch.search.MultiValueMode;
import org.opensearch.search.aggregations.support.ValuesSourceType;
import org.opensearch.search.sort.BucketedSort;
import org.opensearch.search.sort.SortOrder;

public class KNNVectorIndexFieldData
implements IndexFieldData<KNNVectorDVLeafFieldData> {
    private final String fieldName;
    private final ValuesSourceType valuesSourceType;

    public KNNVectorIndexFieldData(String fieldName, ValuesSourceType valuesSourceType) {
        this.fieldName = fieldName;
        this.valuesSourceType = valuesSourceType;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public ValuesSourceType getValuesSourceType() {
        return this.valuesSourceType;
    }

    public KNNVectorDVLeafFieldData load(LeafReaderContext context) {
        return new KNNVectorDVLeafFieldData(context.reader(), this.fieldName);
    }

    public KNNVectorDVLeafFieldData loadDirect(LeafReaderContext context) {
        return this.load(context);
    }

    public SortField sortField(Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested, boolean reverse) {
        throw new UnsupportedOperationException("knn vector field doesn't support this operation");
    }

    public BucketedSort newBucketedSort(BigArrays bigArrays, Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested, SortOrder sortOrder, DocValueFormat format, int bucketSize, BucketedSort.ExtraData extra) {
        throw new UnsupportedOperationException("knn vector field doesn't support this operation");
    }

    public static class Builder
    implements IndexFieldData.Builder {
        private final String name;
        private final ValuesSourceType valuesSourceType;

        public Builder(String name, ValuesSourceType valuesSourceType) {
            this.name = name;
            this.valuesSourceType = valuesSourceType;
        }

        public IndexFieldData<?> build(IndexFieldDataCache cache, CircuitBreakerService breakerService) {
            return new KNNVectorIndexFieldData(this.name, this.valuesSourceType);
        }
    }
}

