/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.commons.destination.message;

import java.io.IOException;
import java.net.URI;
import java.util.List;
import org.opensearch.common.Strings;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.commons.destination.message.LegacyBaseMessage;
import org.opensearch.commons.destination.message.LegacyDestinationType;
import org.opensearch.commons.notifications.model.MethodType;

public class LegacyEmailMessage
extends LegacyBaseMessage {
    private final String accountName;
    private final String host;
    private final int port;
    private final String method;
    private final String from;
    private final List<String> recipients;
    private final String subject;
    private final String message;

    private LegacyEmailMessage(String destinationName, String accountName, String host, Integer port, String method, String from, List<String> recipients, String subject, String message) {
        super(LegacyDestinationType.LEGACY_EMAIL, destinationName, message);
        if (Strings.isNullOrEmpty((String)message)) {
            throw new IllegalArgumentException("Message content is missing");
        }
        if (Strings.isNullOrEmpty((String)accountName)) {
            throw new IllegalArgumentException("Account name should be provided");
        }
        if (Strings.isNullOrEmpty((String)host)) {
            throw new IllegalArgumentException("Host name should be provided");
        }
        if (Strings.isNullOrEmpty((String)from)) {
            throw new IllegalArgumentException("From address should be provided");
        }
        if (recipients == null || recipients.isEmpty()) {
            throw new IllegalArgumentException("List of recipients should be provided");
        }
        this.message = message;
        this.accountName = accountName;
        this.host = host;
        int n = this.port = port == null ? 25 : port;
        if (Strings.isNullOrEmpty((String)method)) {
            this.method = "none";
        } else {
            if (!(MethodType.NONE.toString().equals(method) || MethodType.SSL.toString().equals(method) || MethodType.START_TLS.toString().equals(method))) {
                throw new IllegalArgumentException("Invalid method supplied. Only none, ssl and start_tls are allowed");
            }
            this.method = method;
        }
        this.from = from;
        this.recipients = recipients;
        this.subject = Strings.isNullOrEmpty((String)subject) ? destinationName : subject;
    }

    public LegacyEmailMessage(StreamInput streamInput) throws IOException {
        super(streamInput);
        this.message = super.getMessageContent();
        this.accountName = streamInput.readString();
        this.host = streamInput.readString();
        this.port = streamInput.readInt();
        this.method = streamInput.readString();
        this.from = streamInput.readString();
        this.recipients = streamInput.readStringList();
        this.subject = streamInput.readString();
    }

    public String toString() {
        return "DestinationType: " + this.getChannelType() + ", DestinationName:" + this.destinationName + ", AccountName:" + this.accountName + ", From: " + this.from + ", Host: " + this.host + ", Port: " + this.port + ", Method: " + this.method + ", Subject: <...>, Message: <...>";
    }

    public String getAccountName() {
        return this.accountName;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getMethod() {
        return this.method;
    }

    public String getFrom() {
        return this.from;
    }

    public List<String> getRecipients() {
        return this.recipients;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getMessage() {
        return this.message;
    }

    @Override
    public URI getUri() {
        return this.buildUri(null, null, this.host, this.port, null, null);
    }

    @Override
    public void writeTo(StreamOutput streamOutput) throws IOException {
        super.writeTo(streamOutput);
        streamOutput.writeString(this.accountName);
        streamOutput.writeString(this.host);
        streamOutput.writeInt(this.port);
        streamOutput.writeString(this.method);
        streamOutput.writeString(this.from);
        streamOutput.writeStringCollection(this.recipients);
        streamOutput.writeString(this.subject);
    }

    public static class Builder {
        private final String destinationName;
        private String accountName;
        private String host;
        private Integer port;
        private String method;
        private String from;
        private List<String> recipients;
        private String subject;
        private String message;

        public Builder(String destinationName) {
            this.destinationName = destinationName;
        }

        public Builder withAccountName(String accountName) {
            this.accountName = accountName;
            return this;
        }

        public Builder withHost(String host) {
            this.host = host;
            return this;
        }

        public Builder withPort(Integer port) {
            this.port = port;
            return this;
        }

        public Builder withMethod(String method) {
            this.method = method;
            return this;
        }

        public Builder withFrom(String from) {
            this.from = from;
            return this;
        }

        public Builder withRecipients(List<String> recipients) {
            this.recipients = recipients;
            return this;
        }

        public Builder withSubject(String subject) {
            this.subject = subject;
            return this;
        }

        public Builder withMessage(String message) {
            this.message = message;
            return this;
        }

        public LegacyEmailMessage build() {
            return new LegacyEmailMessage(this.destinationName, this.accountName, this.host, this.port, this.method, this.from, this.recipients, this.subject, this.message);
        }
    }
}

