/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.mapping;

import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.opensearch.cluster.metadata.MappingMetadata;

public class IndexMapping {
    private final Map<String, String> fieldMappings;

    public IndexMapping(Map<String, String> fieldMappings) {
        this.fieldMappings = fieldMappings;
    }

    public IndexMapping(MappingMetadata metaData) {
        this.fieldMappings = this.flatMappings(metaData.getSourceAsMap());
    }

    public int size() {
        return this.fieldMappings.size();
    }

    public String getFieldType(String fieldName) {
        return this.fieldMappings.get(fieldName);
    }

    public <T> Map<String, T> getAllFieldTypes(Function<String, T> transform) {
        return this.fieldMappings.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> transform.apply((String)e.getValue())));
    }

    private Map<String, String> flatMappings(Map<String, Object> indexMapping) {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        this.flatMappings(indexMapping.getOrDefault("properties", Collections.emptyMap()), "", (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        return builder.build();
    }

    private void flatMappings(Map<String, Object> mappings, String path, BiConsumer<String, String> func) {
        mappings.forEach((fieldName, mappingObject) -> {
            String fullFieldName;
            Map mapping = (Map)mappingObject;
            String string = fullFieldName = path.isEmpty() ? fieldName : path + "." + fieldName;
            if (this.isMultiField(mapping)) {
                func.accept(fullFieldName, "text_keyword");
            } else {
                String type = mapping.getOrDefault("type", "object");
                func.accept(fullFieldName, type);
            }
            if (mapping.containsKey("properties")) {
                this.flatMappings((Map)mapping.get("properties"), fullFieldName, func);
            }
        });
    }

    private boolean isMultiField(Map<String, Object> mapping) {
        return mapping.containsKey("fields");
    }

    @Generated
    public String toString() {
        return "IndexMapping(fieldMappings=" + this.fieldMappings + ")";
    }
}

