/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.request.system;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.opensearch.sql.data.model.ExprTupleValue;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.model.ExprValueUtils;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.opensearch.client.OpenSearchClient;
import org.opensearch.sql.opensearch.data.type.OpenSearchDataType;
import org.opensearch.sql.opensearch.mapping.IndexMapping;
import org.opensearch.sql.opensearch.request.OpenSearchRequest;
import org.opensearch.sql.opensearch.request.system.OpenSearchSystemRequest;

public class OpenSearchDescribeIndexRequest
implements OpenSearchSystemRequest {
    private static final String DEFAULT_TABLE_CAT = "opensearch";
    private static final Integer DEFAULT_NUM_PREC_RADIX = 10;
    private static final Integer DEFAULT_NULLABLE = 2;
    private static final String DEFAULT_IS_AUTOINCREMENT = "NO";
    private final OpenSearchClient client;
    private final OpenSearchRequest.IndexName indexName;

    public OpenSearchDescribeIndexRequest(OpenSearchClient client, String indexName) {
        this(client, new OpenSearchRequest.IndexName(indexName));
    }

    public OpenSearchDescribeIndexRequest(OpenSearchClient client, OpenSearchRequest.IndexName indexName) {
        this.client = client;
        this.indexName = indexName;
    }

    @Override
    public List<ExprValue> search() {
        ArrayList<ExprValue> results = new ArrayList<ExprValue>();
        Map<String, String> meta = this.client.meta();
        int pos = 0;
        for (Map.Entry<String, ExprType> entry : this.getFieldTypes().entrySet()) {
            results.add((ExprValue)this.row(entry.getKey(), entry.getValue().legacyTypeName().toLowerCase(), pos++, this.clusterName(meta)));
        }
        return results;
    }

    public Map<String, ExprType> getFieldTypes() {
        HashMap<String, ExprType> fieldTypes = new HashMap<String, ExprType>();
        Map<String, IndexMapping> indexMappings = this.client.getIndexMappings(this.indexName.getIndexNames());
        for (IndexMapping indexMapping : indexMappings.values()) {
            fieldTypes.putAll(indexMapping.getAllFieldTypes(this::transformESTypeToExprType).entrySet().stream().filter(entry -> !ExprCoreType.UNKNOWN.equals(entry.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        }
        return fieldTypes;
    }

    public Integer getMaxResultWindow() {
        return this.client.getIndexMaxResultWindows(this.indexName.getIndexNames()).values().stream().min(Integer::compare).get();
    }

    private ExprType transformESTypeToExprType(String openSearchType) {
        return OpenSearchDataType.getExprType(openSearchType);
    }

    private ExprTupleValue row(String fieldName, String fieldType, int position, String clusterName) {
        LinkedHashMap<String, ExprValue> valueMap = new LinkedHashMap<String, ExprValue>();
        valueMap.put("TABLE_CAT", ExprValueUtils.stringValue((String)clusterName));
        valueMap.put("TABLE_NAME", ExprValueUtils.stringValue((String)this.indexName.toString()));
        valueMap.put("COLUMN_NAME", ExprValueUtils.stringValue((String)fieldName));
        valueMap.put("TYPE_NAME", ExprValueUtils.stringValue((String)fieldType));
        valueMap.put("NUM_PREC_RADIX", ExprValueUtils.integerValue((Integer)DEFAULT_NUM_PREC_RADIX));
        valueMap.put("NULLABLE", ExprValueUtils.integerValue((Integer)DEFAULT_NULLABLE));
        valueMap.put("ORDINAL_POSITION", ExprValueUtils.integerValue((Integer)position));
        valueMap.put("IS_NULLABLE", ExprValueUtils.stringValue((String)""));
        valueMap.put("IS_AUTOINCREMENT", ExprValueUtils.stringValue((String)DEFAULT_IS_AUTOINCREMENT));
        valueMap.put("IS_GENERATEDCOLUMN", ExprValueUtils.stringValue((String)""));
        return new ExprTupleValue(valueMap);
    }

    private String clusterName(Map<String, String> meta) {
        return meta.getOrDefault("CLUSTER_NAME", DEFAULT_TABLE_CAT);
    }

    public String toString() {
        return "OpenSearchDescribeIndexRequest{indexName='" + this.indexName + "'}";
    }
}

