/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.storage.scan;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.opensearch.search.aggregations.AggregationBuilder;
import org.opensearch.sql.ast.tree.Sort;
import org.opensearch.sql.expression.Expression;
import org.opensearch.sql.expression.NamedExpression;
import org.opensearch.sql.expression.ReferenceExpression;
import org.opensearch.sql.expression.aggregation.NamedAggregator;
import org.opensearch.sql.opensearch.response.agg.OpenSearchAggregationResponseParser;
import org.opensearch.sql.opensearch.storage.OpenSearchIndexScan;
import org.opensearch.sql.opensearch.storage.script.aggregation.AggregationQueryBuilder;
import org.opensearch.sql.opensearch.storage.serialization.DefaultExpressionSerializer;
import org.opensearch.sql.planner.logical.LogicalAggregation;
import org.opensearch.sql.planner.logical.LogicalSort;
import org.opensearch.sql.storage.TableScanOperator;
import org.opensearch.sql.storage.read.TableScanBuilder;

class OpenSearchIndexScanAggregationBuilder
extends TableScanBuilder {
    private final OpenSearchIndexScan indexScan;
    private List<NamedAggregator> aggregatorList;
    private List<NamedExpression> groupByList;
    private List<Pair<Sort.SortOption, Expression>> sortList;

    OpenSearchIndexScanAggregationBuilder(OpenSearchIndexScan indexScan) {
        this.indexScan = indexScan;
    }

    public TableScanOperator build() {
        AggregationQueryBuilder builder = new AggregationQueryBuilder(new DefaultExpressionSerializer());
        Pair<List<AggregationBuilder>, OpenSearchAggregationResponseParser> aggregationBuilder = builder.buildAggregationBuilder(this.aggregatorList, this.groupByList, this.sortList);
        this.indexScan.getRequestBuilder().pushDownAggregation(aggregationBuilder);
        this.indexScan.getRequestBuilder().pushTypeMapping(builder.buildTypeMapping(this.aggregatorList, this.groupByList));
        return this.indexScan;
    }

    public boolean pushDownAggregation(LogicalAggregation aggregation) {
        this.aggregatorList = aggregation.getAggregatorList();
        this.groupByList = aggregation.getGroupByList();
        return true;
    }

    public boolean pushDownSort(LogicalSort sort) {
        if (this.hasAggregatorInSortBy(sort)) {
            return false;
        }
        this.sortList = sort.getSortList();
        return true;
    }

    private boolean hasAggregatorInSortBy(LogicalSort sort) {
        Set aggregatorNames = this.aggregatorList.stream().map(NamedAggregator::getName).collect(Collectors.toSet());
        for (Pair sortPair : sort.getSortList()) {
            if (!aggregatorNames.contains(((ReferenceExpression)sortPair.getRight()).getAttr())) continue;
            return true;
        }
        return false;
    }
}

