/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common;

import java.io.IOException;
import java.time.Instant;
import lombok.Generated;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.ToXContentObject;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.common.xcontent.XContentParserUtils;
import org.opensearch.commons.authuser.User;
import org.opensearch.ml.common.FunctionName;
import org.opensearch.ml.common.model.MLModelConfig;
import org.opensearch.ml.common.model.MLModelFormat;
import org.opensearch.ml.common.model.MLModelState;
import org.opensearch.ml.common.model.TextEmbeddingModelConfig;

public class MLModel
implements ToXContentObject {
    public static final String ALGORITHM_FIELD = "algorithm";
    public static final String MODEL_NAME_FIELD = "name";
    public static final String OLD_MODEL_VERSION_FIELD = "version";
    public static final String MODEL_VERSION_FIELD = "model_version";
    public static final String OLD_MODEL_CONTENT_FIELD = "content";
    public static final String MODEL_CONTENT_FIELD = "model_content";
    public static final String DESCRIPTION_FIELD = "description";
    public static final String MODEL_FORMAT_FIELD = "model_format";
    public static final String MODEL_STATE_FIELD = "model_state";
    public static final String MODEL_CONTENT_SIZE_IN_BYTES_FIELD = "model_content_size_in_bytes";
    public static final String MODEL_CONTENT_HASH_VALUE_FIELD = "model_content_hash_value";
    public static final String MODEL_CONFIG_FIELD = "model_config";
    public static final String CREATED_TIME_FIELD = "created_time";
    public static final String LAST_UPLOADED_TIME_FIELD = "last_uploaded_time";
    public static final String LAST_LOADED_TIME_FIELD = "last_loaded_time";
    public static final String LAST_UNLOADED_TIME_FIELD = "last_unloaded_time";
    public static final String MODEL_ID_FIELD = "model_id";
    public static final String CHUNK_NUMBER_FIELD = "chunk_number";
    public static final String TOTAL_CHUNKS_FIELD = "total_chunks";
    private String name;
    private FunctionName algorithm;
    private String version;
    private String content;
    private User user;
    private String description;
    private MLModelFormat modelFormat;
    private MLModelState modelState;
    private Long modelContentSizeInBytes;
    private String modelContentHash;
    private MLModelConfig modelConfig;
    private Instant createdTime;
    private Instant lastUploadedTime;
    private Instant lastLoadedTime;
    private Instant lastUnloadedTime;
    private String modelId;
    private Integer chunkNumber;
    private Integer totalChunks;

    public MLModel(String name, FunctionName algorithm, String version, String content, User user, String description, MLModelFormat modelFormat, MLModelState modelState, Long modelContentSizeInBytes, String modelContentHash, MLModelConfig modelConfig, Instant createdTime, Instant lastUploadedTime, Instant lastLoadedTime, Instant lastUnloadedTime, String modelId, Integer chunkNumber, Integer totalChunks) {
        this.name = name;
        this.algorithm = algorithm;
        this.version = version;
        this.content = content;
        this.user = user;
        this.description = description;
        this.modelFormat = modelFormat;
        this.modelState = modelState;
        this.modelContentSizeInBytes = modelContentSizeInBytes;
        this.modelContentHash = modelContentHash;
        this.modelConfig = modelConfig;
        this.createdTime = createdTime;
        this.lastUploadedTime = lastUploadedTime;
        this.lastLoadedTime = lastLoadedTime;
        this.lastUnloadedTime = lastUnloadedTime;
        this.modelId = modelId;
        this.chunkNumber = chunkNumber;
        this.totalChunks = totalChunks;
    }

    public MLModel(StreamInput input) throws IOException {
        this.name = input.readOptionalString();
        this.algorithm = (FunctionName)input.readEnum(FunctionName.class);
        this.version = input.readString();
        this.content = input.readOptionalString();
        this.user = input.readBoolean() ? new User(input) : null;
        if (input.available() > 0) {
            this.description = input.readOptionalString();
            if (input.readBoolean()) {
                this.modelFormat = (MLModelFormat)input.readEnum(MLModelFormat.class);
            }
            if (input.readBoolean()) {
                this.modelState = (MLModelState)input.readEnum(MLModelState.class);
            }
            this.modelContentSizeInBytes = input.readOptionalLong();
            this.modelContentHash = input.readOptionalString();
            if (input.readBoolean()) {
                this.modelConfig = new TextEmbeddingModelConfig(input);
            }
            this.createdTime = input.readOptionalInstant();
            this.lastUploadedTime = input.readOptionalInstant();
            this.lastLoadedTime = input.readOptionalInstant();
            this.lastUnloadedTime = input.readOptionalInstant();
            this.modelId = input.readOptionalString();
            this.chunkNumber = input.readOptionalInt();
            this.totalChunks = input.readOptionalInt();
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.name);
        out.writeEnum((Enum)this.algorithm);
        out.writeString(this.version);
        out.writeOptionalString(this.content);
        if (this.user != null) {
            out.writeBoolean(true);
            this.user.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalString(this.description);
        if (this.modelFormat != null) {
            out.writeBoolean(true);
            out.writeEnum((Enum)this.modelFormat);
        } else {
            out.writeBoolean(false);
        }
        if (this.modelState != null) {
            out.writeBoolean(true);
            out.writeEnum((Enum)this.modelState);
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalLong(this.modelContentSizeInBytes);
        out.writeOptionalString(this.modelContentHash);
        if (this.modelConfig != null) {
            out.writeBoolean(true);
            this.modelConfig.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalInstant(this.createdTime);
        out.writeOptionalInstant(this.lastUploadedTime);
        out.writeOptionalInstant(this.lastLoadedTime);
        out.writeOptionalInstant(this.lastUnloadedTime);
        out.writeOptionalString(this.modelId);
        out.writeOptionalInt(this.chunkNumber);
        out.writeOptionalInt(this.totalChunks);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.name != null) {
            builder.field(MODEL_NAME_FIELD, this.name);
        }
        if (this.algorithm != null) {
            builder.field(ALGORITHM_FIELD, (Object)this.algorithm);
        }
        if (this.version != null) {
            builder.field(MODEL_VERSION_FIELD, this.version);
        }
        if (this.content != null) {
            builder.field(MODEL_CONTENT_FIELD, this.content);
        }
        if (this.user != null) {
            builder.field("user", (ToXContent)this.user);
        }
        if (this.description != null) {
            builder.field(DESCRIPTION_FIELD, this.description);
        }
        if (this.modelFormat != null) {
            builder.field(MODEL_FORMAT_FIELD, (Object)this.modelFormat);
        }
        if (this.modelState != null) {
            builder.field(MODEL_STATE_FIELD, (Object)this.modelState);
        }
        if (this.modelContentSizeInBytes != null) {
            builder.field(MODEL_CONTENT_SIZE_IN_BYTES_FIELD, this.modelContentSizeInBytes);
        }
        if (this.modelContentHash != null) {
            builder.field(MODEL_CONTENT_HASH_VALUE_FIELD, this.modelContentHash);
        }
        if (this.modelConfig != null) {
            builder.field(MODEL_CONFIG_FIELD, (ToXContent)this.modelConfig);
        }
        if (this.createdTime != null) {
            builder.field(CREATED_TIME_FIELD, this.createdTime.toEpochMilli());
        }
        if (this.lastUploadedTime != null) {
            builder.field(LAST_UPLOADED_TIME_FIELD, this.lastUploadedTime.toEpochMilli());
        }
        if (this.lastLoadedTime != null) {
            builder.field(LAST_LOADED_TIME_FIELD, this.lastLoadedTime.toEpochMilli());
        }
        if (this.lastUnloadedTime != null) {
            builder.field(LAST_UNLOADED_TIME_FIELD, this.lastUnloadedTime.toEpochMilli());
        }
        if (this.modelId != null) {
            builder.field(MODEL_ID_FIELD, this.modelId);
        }
        if (this.chunkNumber != null) {
            builder.field(CHUNK_NUMBER_FIELD, this.chunkNumber);
        }
        if (this.totalChunks != null) {
            builder.field(TOTAL_CHUNKS_FIELD, this.totalChunks);
        }
        builder.endObject();
        return builder;
    }

    public static MLModel parse(XContentParser parser) throws IOException {
        String name = null;
        FunctionName algorithm = null;
        Object version = null;
        Integer oldVersion = null;
        String content = null;
        String oldContent = null;
        User user = null;
        String description = null;
        MLModelFormat modelFormat = null;
        MLModelState modelState = null;
        Long modelContentSizeInBytes = null;
        String modelContentHash = null;
        TextEmbeddingModelConfig modelConfig = null;
        Instant createdTime = null;
        Instant lastUploadedTime = null;
        Instant lastLoadedTime = null;
        Instant lastUnloadedTime = null;
        String modelId = null;
        Integer chunkNumber = null;
        Integer totalChunks = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block44: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "name": {
                    name = parser.text();
                    continue block44;
                }
                case "model_content": {
                    content = parser.text();
                    continue block44;
                }
                case "content": {
                    oldContent = parser.text();
                    continue block44;
                }
                case "model_version": {
                    version = parser.text();
                    continue block44;
                }
                case "version": {
                    oldVersion = parser.intValue(false);
                    continue block44;
                }
                case "chunk_number": {
                    chunkNumber = parser.intValue(false);
                    continue block44;
                }
                case "total_chunks": {
                    totalChunks = parser.intValue(false);
                    continue block44;
                }
                case "user": {
                    user = User.parse(parser);
                    continue block44;
                }
                case "algorithm": {
                    algorithm = FunctionName.from(parser.text());
                    continue block44;
                }
                case "model_id": {
                    modelId = parser.text();
                    continue block44;
                }
                case "description": {
                    description = parser.text();
                    continue block44;
                }
                case "model_format": {
                    modelFormat = MLModelFormat.from(parser.text());
                    continue block44;
                }
                case "model_state": {
                    modelState = MLModelState.from(parser.text());
                    continue block44;
                }
                case "model_content_size_in_bytes": {
                    modelContentSizeInBytes = parser.longValue();
                    continue block44;
                }
                case "model_content_hash_value": {
                    modelContentHash = parser.text();
                    continue block44;
                }
                case "model_config": {
                    modelConfig = TextEmbeddingModelConfig.parse(parser);
                    continue block44;
                }
                case "created_time": {
                    createdTime = Instant.ofEpochMilli(parser.longValue());
                    continue block44;
                }
                case "last_uploaded_time": {
                    lastUploadedTime = Instant.ofEpochMilli(parser.longValue());
                    continue block44;
                }
                case "last_loaded_time": {
                    lastLoadedTime = Instant.ofEpochMilli(parser.longValue());
                    continue block44;
                }
                case "last_unloaded_time": {
                    lastUnloadedTime = Instant.ofEpochMilli(parser.longValue());
                    continue block44;
                }
            }
            parser.skipChildren();
        }
        return MLModel.builder().name(name).algorithm(algorithm).version((String)(version == null ? "" + oldVersion : version)).content(content == null ? oldContent : content).user(user).description(description).modelFormat(modelFormat).modelState(modelState).modelContentSizeInBytes(modelContentSizeInBytes).modelContentHash(modelContentHash).modelConfig(modelConfig).createdTime(createdTime).lastUploadedTime(lastUploadedTime).lastLoadedTime(lastLoadedTime).lastUnloadedTime(lastUnloadedTime).modelId(modelId).chunkNumber(chunkNumber).totalChunks(totalChunks).build();
    }

    public static MLModel fromStream(StreamInput in) throws IOException {
        MLModel mlModel = new MLModel(in);
        return mlModel;
    }

    @Generated
    public static MLModelBuilder builder() {
        return new MLModelBuilder();
    }

    @Generated
    public MLModelBuilder toBuilder() {
        return new MLModelBuilder().name(this.name).algorithm(this.algorithm).version(this.version).content(this.content).user(this.user).description(this.description).modelFormat(this.modelFormat).modelState(this.modelState).modelContentSizeInBytes(this.modelContentSizeInBytes).modelContentHash(this.modelContentHash).modelConfig(this.modelConfig).createdTime(this.createdTime).lastUploadedTime(this.lastUploadedTime).lastLoadedTime(this.lastLoadedTime).lastUnloadedTime(this.lastUnloadedTime).modelId(this.modelId).chunkNumber(this.chunkNumber).totalChunks(this.totalChunks);
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public FunctionName getAlgorithm() {
        return this.algorithm;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public String getContent() {
        return this.content;
    }

    @Generated
    public User getUser() {
        return this.user;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public MLModelFormat getModelFormat() {
        return this.modelFormat;
    }

    @Generated
    public MLModelState getModelState() {
        return this.modelState;
    }

    @Generated
    public Long getModelContentSizeInBytes() {
        return this.modelContentSizeInBytes;
    }

    @Generated
    public String getModelContentHash() {
        return this.modelContentHash;
    }

    @Generated
    public MLModelConfig getModelConfig() {
        return this.modelConfig;
    }

    @Generated
    public Instant getCreatedTime() {
        return this.createdTime;
    }

    @Generated
    public Instant getLastUploadedTime() {
        return this.lastUploadedTime;
    }

    @Generated
    public Instant getLastLoadedTime() {
        return this.lastLoadedTime;
    }

    @Generated
    public Instant getLastUnloadedTime() {
        return this.lastUnloadedTime;
    }

    @Generated
    public String getModelId() {
        return this.modelId;
    }

    @Generated
    public Integer getChunkNumber() {
        return this.chunkNumber;
    }

    @Generated
    public Integer getTotalChunks() {
        return this.totalChunks;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setModelId(String modelId) {
        this.modelId = modelId;
    }

    @Generated
    public static class MLModelBuilder {
        @Generated
        private String name;
        @Generated
        private FunctionName algorithm;
        @Generated
        private String version;
        @Generated
        private String content;
        @Generated
        private User user;
        @Generated
        private String description;
        @Generated
        private MLModelFormat modelFormat;
        @Generated
        private MLModelState modelState;
        @Generated
        private Long modelContentSizeInBytes;
        @Generated
        private String modelContentHash;
        @Generated
        private MLModelConfig modelConfig;
        @Generated
        private Instant createdTime;
        @Generated
        private Instant lastUploadedTime;
        @Generated
        private Instant lastLoadedTime;
        @Generated
        private Instant lastUnloadedTime;
        @Generated
        private String modelId;
        @Generated
        private Integer chunkNumber;
        @Generated
        private Integer totalChunks;

        @Generated
        MLModelBuilder() {
        }

        @Generated
        public MLModelBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public MLModelBuilder algorithm(FunctionName algorithm) {
            this.algorithm = algorithm;
            return this;
        }

        @Generated
        public MLModelBuilder version(String version) {
            this.version = version;
            return this;
        }

        @Generated
        public MLModelBuilder content(String content) {
            this.content = content;
            return this;
        }

        @Generated
        public MLModelBuilder user(User user) {
            this.user = user;
            return this;
        }

        @Generated
        public MLModelBuilder description(String description) {
            this.description = description;
            return this;
        }

        @Generated
        public MLModelBuilder modelFormat(MLModelFormat modelFormat) {
            this.modelFormat = modelFormat;
            return this;
        }

        @Generated
        public MLModelBuilder modelState(MLModelState modelState) {
            this.modelState = modelState;
            return this;
        }

        @Generated
        public MLModelBuilder modelContentSizeInBytes(Long modelContentSizeInBytes) {
            this.modelContentSizeInBytes = modelContentSizeInBytes;
            return this;
        }

        @Generated
        public MLModelBuilder modelContentHash(String modelContentHash) {
            this.modelContentHash = modelContentHash;
            return this;
        }

        @Generated
        public MLModelBuilder modelConfig(MLModelConfig modelConfig) {
            this.modelConfig = modelConfig;
            return this;
        }

        @Generated
        public MLModelBuilder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        @Generated
        public MLModelBuilder lastUploadedTime(Instant lastUploadedTime) {
            this.lastUploadedTime = lastUploadedTime;
            return this;
        }

        @Generated
        public MLModelBuilder lastLoadedTime(Instant lastLoadedTime) {
            this.lastLoadedTime = lastLoadedTime;
            return this;
        }

        @Generated
        public MLModelBuilder lastUnloadedTime(Instant lastUnloadedTime) {
            this.lastUnloadedTime = lastUnloadedTime;
            return this;
        }

        @Generated
        public MLModelBuilder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        @Generated
        public MLModelBuilder chunkNumber(Integer chunkNumber) {
            this.chunkNumber = chunkNumber;
            return this;
        }

        @Generated
        public MLModelBuilder totalChunks(Integer totalChunks) {
            this.totalChunks = totalChunks;
            return this;
        }

        @Generated
        public MLModel build() {
            return new MLModel(this.name, this.algorithm, this.version, this.content, this.user, this.description, this.modelFormat, this.modelState, this.modelContentSizeInBytes, this.modelContentHash, this.modelConfig, this.createdTime, this.lastUploadedTime, this.lastLoadedTime, this.lastUnloadedTime, this.modelId, this.chunkNumber, this.totalChunks);
        }

        @Generated
        public String toString() {
            return "MLModel.MLModelBuilder(name=" + this.name + ", algorithm=" + this.algorithm + ", version=" + this.version + ", content=" + this.content + ", user=" + this.user + ", description=" + this.description + ", modelFormat=" + this.modelFormat + ", modelState=" + this.modelState + ", modelContentSizeInBytes=" + this.modelContentSizeInBytes + ", modelContentHash=" + this.modelContentHash + ", modelConfig=" + this.modelConfig + ", createdTime=" + this.createdTime + ", lastUploadedTime=" + this.lastUploadedTime + ", lastLoadedTime=" + this.lastLoadedTime + ", lastUnloadedTime=" + this.lastUnloadedTime + ", modelId=" + this.modelId + ", chunkNumber=" + this.chunkNumber + ", totalChunks=" + this.totalChunks + ")";
        }
    }
}

