/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.ast.expression;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import lombok.Generated;
import org.opensearch.sql.ast.AbstractNodeVisitor;
import org.opensearch.sql.ast.expression.UnresolvedExpression;

public class QualifiedName
extends UnresolvedExpression {
    private final List<String> parts;

    public QualifiedName(String name) {
        this.parts = Collections.singletonList(name);
    }

    public QualifiedName(Iterable<String> parts) {
        List partsList = StreamSupport.stream(parts.spliterator(), false).collect(Collectors.toList());
        if (partsList.isEmpty()) {
            throw new IllegalArgumentException("parts is empty");
        }
        this.parts = partsList;
    }

    public static QualifiedName of(String first, String ... rest) {
        Objects.requireNonNull(first);
        ArrayList<String> parts = new ArrayList<String>();
        parts.add(first);
        parts.addAll(Arrays.asList(rest));
        return new QualifiedName(parts);
    }

    public static QualifiedName of(Iterable<String> parts) {
        return new QualifiedName(parts);
    }

    public Optional<QualifiedName> getPrefix() {
        if (this.parts.size() == 1) {
            return Optional.empty();
        }
        return Optional.of(QualifiedName.of(this.parts.subList(0, this.parts.size() - 1)));
    }

    public String getSuffix() {
        return this.parts.get(this.parts.size() - 1);
    }

    public Optional<String> first() {
        if (this.parts.size() == 1) {
            return Optional.empty();
        }
        return Optional.of(this.parts.get(0));
    }

    public QualifiedName rest() {
        return QualifiedName.of(this.parts.subList(1, this.parts.size()));
    }

    @Override
    public String toString() {
        return String.join((CharSequence)".", this.parts);
    }

    public List<UnresolvedExpression> getChild() {
        return ImmutableList.of();
    }

    @Override
    public <R, C> R accept(AbstractNodeVisitor<R, C> nodeVisitor, C context) {
        return nodeVisitor.visitQualifiedName(this, context);
    }

    @Generated
    public List<String> getParts() {
        return this.parts;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QualifiedName)) {
            return false;
        }
        QualifiedName other = (QualifiedName)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<String> this$parts = this.getParts();
        List<String> other$parts = other.getParts();
        return !(this$parts == null ? other$parts != null : !((Object)this$parts).equals(other$parts));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof QualifiedName;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $parts = this.getParts();
        result = result * 59 + ($parts == null ? 43 : ((Object)$parts).hashCode());
        return result;
    }
}

