/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.asn1.ber.tlv;

import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.IntegerDecoderException;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.util.Strings;

public final class IntegerDecoder {
    private static final int[] MASK = new int[]{255, 65535, 0xFFFFFF, -1};

    private IntegerDecoder() {
    }

    public static int parse(BerValue value, int min, int max) throws IntegerDecoderException {
        int result = IntegerDecoder.parseInt(value);
        if (result >= min && result <= max) {
            return result;
        }
        throw new IntegerDecoderException(I18n.err(I18n.ERR_01306_VALUE_NOT_IN_RANGE, min, max));
    }

    public static int parse(BerValue value) throws IntegerDecoderException {
        return IntegerDecoder.parseInt(value);
    }

    private static int parseInt(BerValue value) throws IntegerDecoderException {
        int result = 0;
        byte[] bytes = value.getData();
        if (Strings.isEmpty(bytes)) {
            throw new IntegerDecoderException(I18n.err(I18n.ERR_01304_0_BYTES_LONG_INTEGER, new Object[0]));
        }
        boolean positive = true;
        switch (bytes.length) {
            case 5: {
                if (bytes[0] == 0) {
                    if ((bytes[1] & 0xFFFFFF80) != -128) {
                        throw new IntegerDecoderException(I18n.err(I18n.ERR_01304_0_BYTES_LONG_INTEGER, new Object[0]));
                    }
                    result = bytes[1] & 0xFF;
                    result = result << 8 | bytes[2] & 0xFF;
                    result = result << 8 | bytes[3] & 0xFF;
                    result = result << 8 | bytes[4] & 0xFF;
                    break;
                }
                throw new IntegerDecoderException(I18n.err(I18n.ERR_01304_0_BYTES_LONG_INTEGER, new Object[0]));
            }
            case 4: {
                if (bytes[0] == 0) {
                    result = bytes[1] & 0xFF;
                } else {
                    result = bytes[0] & 0xFF;
                    if ((bytes[0] & 0xFFFFFF80) == -128) {
                        positive = false;
                    }
                    result = result << 8 | bytes[1] & 0xFF;
                }
                result = result << 8 | bytes[2] & 0xFF;
                result = result << 8 | bytes[3] & 0xFF;
                break;
            }
            case 3: {
                if (bytes[0] == 0) {
                    result = bytes[1] & 0xFF;
                } else {
                    result = bytes[0] & 0xFF;
                    if ((bytes[0] & 0xFFFFFF80) == -128) {
                        positive = false;
                    }
                    result = result << 8 | bytes[1] & 0xFF;
                }
                result = result << 8 | bytes[2] & 0xFF;
                break;
            }
            case 2: {
                if (bytes[0] == 0) {
                    result = bytes[1] & 0xFF;
                    break;
                }
                result = bytes[0] & 0xFF;
                if ((bytes[0] & 0xFFFFFF80) == -128) {
                    positive = false;
                }
                result = result << 8 | bytes[1] & 0xFF;
                break;
            }
            case 1: {
                result = result << 8 | bytes[0] & 0xFF;
                if ((bytes[0] & 0xFFFFFF80) != -128) break;
                positive = false;
                break;
            }
            default: {
                throw new IntegerDecoderException(I18n.err(I18n.ERR_01305_ABOVE_4_BYTES_INTEGER, new Object[0]));
            }
        }
        if (!positive) {
            result = -(~result + 1 & MASK[bytes.length - 1]);
        }
        return result;
    }
}

