/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.util.Locale;
import java.util.Objects;
import org.apache.lucene.document.FeatureField;
import org.apache.lucene.search.Query;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.schema.RankField;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QParserPlugin;
import org.apache.solr.search.SyntaxError;

public class RankQParserPlugin
extends QParserPlugin {
    public static final String NAME = "rank";
    public static final String FIELD = "f";
    public static final String FUNCTION = "function";
    public static final String WEIGHT = "weight";
    public static final String PIVOT = "pivot";
    public static final String SCALING_FACTOR = "scalingFactor";
    public static final String EXPONENT = "exponent";
    private static final FeatureFieldFunction DEFAULT_FUNCTION = FeatureFieldFunction.SATU;

    @Override
    public QParser createParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
        Objects.requireNonNull(localParams, "LocalParams String can't be null");
        Objects.requireNonNull(req, "SolrQueryRequest can't be null");
        return new RankQParser(qstr, localParams, params, req);
    }

    private static enum FeatureFieldFunction {
        SATU{

            @Override
            public Query createQuery(String fieldName, SolrParams params) throws SyntaxError {
                Float weight = params.getFloat(RankQParserPlugin.WEIGHT);
                Float pivot = params.getFloat(RankQParserPlugin.PIVOT);
                if (pivot == null && (weight == null || Float.compare(weight.floatValue(), 1.0f) == 0)) {
                    return FeatureField.newSaturationQuery((String)"_rank_", (String)fieldName);
                }
                if (pivot == null) {
                    throw new SyntaxError("A pivot value needs to be provided if the weight is not 1 on \"satu\" function");
                }
                if (weight == null) {
                    weight = Float.valueOf(1.0f);
                }
                try {
                    return FeatureField.newSaturationQuery((String)"_rank_", (String)fieldName, (float)weight.floatValue(), (float)pivot.floatValue());
                }
                catch (IllegalArgumentException iae) {
                    throw new SyntaxError(iae.getMessage());
                }
            }
        }
        ,
        LOG{

            @Override
            public Query createQuery(String fieldName, SolrParams params) throws SyntaxError {
                float weight = params.getFloat(RankQParserPlugin.WEIGHT, 1.0f);
                float scalingFactor = params.getFloat(RankQParserPlugin.SCALING_FACTOR, 1.0f);
                try {
                    return FeatureField.newLogQuery((String)"_rank_", (String)fieldName, (float)weight, (float)scalingFactor);
                }
                catch (IllegalArgumentException iae) {
                    throw new SyntaxError(iae.getMessage());
                }
            }
        }
        ,
        SIGM{

            @Override
            public Query createQuery(String fieldName, SolrParams params) throws SyntaxError {
                float weight = params.getFloat(RankQParserPlugin.WEIGHT, 1.0f);
                Float pivot = params.getFloat(RankQParserPlugin.PIVOT);
                if (pivot == null) {
                    throw new SyntaxError("A pivot value needs to be provided when using \"sigm\" function");
                }
                Float exponent = params.getFloat(RankQParserPlugin.EXPONENT);
                if (exponent == null) {
                    throw new SyntaxError("An exponent value needs to be provided when using \"sigm\" function");
                }
                try {
                    return FeatureField.newSigmoidQuery((String)"_rank_", (String)fieldName, (float)weight, (float)pivot.floatValue(), (float)exponent.floatValue());
                }
                catch (IllegalArgumentException iae) {
                    throw new SyntaxError(iae.getMessage());
                }
            }
        };


        public abstract Query createQuery(String var1, SolrParams var2) throws SyntaxError;
    }

    public static class RankQParser
    extends QParser {
        private final String field;

        public RankQParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
            super(qstr, localParams, params, req);
            this.field = localParams.get(RankQParserPlugin.FIELD);
        }

        @Override
        public Query parse() throws SyntaxError {
            if (this.field == null || this.field.isEmpty()) {
                throw new SyntaxError("Field can't be empty in rank queries");
            }
            SchemaField schemaField = this.req.getSchema().getFieldOrNull(this.field);
            if (schemaField == null) {
                throw new SyntaxError("Field \"" + this.field + "\" not found");
            }
            if (!(schemaField.getType() instanceof RankField)) {
                throw new SyntaxError("Field \"" + this.field + "\" is not a RankField");
            }
            return this.getFeatureFieldFunction(this.localParams.get(RankQParserPlugin.FUNCTION)).createQuery(this.field, this.localParams);
        }

        private FeatureFieldFunction getFeatureFieldFunction(String function) throws SyntaxError {
            FeatureFieldFunction f = null;
            if (function == null || function.isEmpty()) {
                f = DEFAULT_FUNCTION;
            } else {
                try {
                    f = FeatureFieldFunction.valueOf(function.toUpperCase(Locale.ROOT));
                }
                catch (IllegalArgumentException iae) {
                    throw new SyntaxError("Unknown function in rank query: \"" + function + "\"");
                }
            }
            return f;
        }
    }
}

