/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.testing.s3mock.dto;

import com.adobe.testing.s3mock.dto.Owner;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Date;
import java.util.Objects;

public class MultipartUpload {
    @JsonProperty(value="Key")
    private final String key;
    @JsonProperty(value="UploadId")
    private final String uploadId;
    @JsonProperty(value="Owner")
    private final Owner owner;
    @JsonProperty(value="Initiator")
    private final Owner initiator;
    @JsonProperty(value="StorageClass")
    private final String storageClass = "STANDARD";
    @JsonProperty(value="Initiated")
    @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", timezone="UTC")
    private final Date initiated;

    public MultipartUpload(String key, String uploadId, Owner owner, Owner initiator, Date initiated) {
        this.key = key;
        this.uploadId = uploadId;
        this.owner = owner;
        this.initiator = initiator;
        this.initiated = initiated;
    }

    public String getKey() {
        return this.key;
    }

    public String getUploadId() {
        return this.uploadId;
    }

    public Owner getOwner() {
        return this.owner;
    }

    public Owner getInitiator() {
        return this.initiator;
    }

    public String getStorageClass() {
        return "STANDARD";
    }

    public Date getInitiated() {
        return this.initiated;
    }

    public String toString() {
        return "MultipartUpload{key='" + this.key + '\'' + ", uploadId='" + this.uploadId + '\'' + ", owner=" + this.owner + ", initiator=" + this.initiator + ", storageClass='" + "STANDARD" + '\'' + ", initiated=" + this.initiated + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultipartUpload that = (MultipartUpload)o;
        return Objects.equals(this.key, that.key) && Objects.equals(this.uploadId, that.uploadId) && Objects.equals(this.owner, that.owner) && Objects.equals(this.initiator, that.initiator) && Objects.equals("STANDARD", that.storageClass) && Objects.equals(this.initiated, that.initiated);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.uploadId, this.owner, this.initiator, "STANDARD", this.initiated);
    }
}

