"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createSvelteSys = void 0;
const utils_1 = require("./utils");
/**
 * This should only be accessed by TS svelte module resolution.
 */
function createSvelteSys(ts, logger) {
    const svelteSys = {
        ...ts.sys,
        fileExists(path) {
            return ts.sys.fileExists((0, utils_1.ensureRealSvelteFilePath)(path));
        },
        readDirectory(path, extensions, exclude, include, depth) {
            const extensionsWithSvelte = (extensions !== null && extensions !== void 0 ? extensions : []).concat('.svelte');
            return ts.sys.readDirectory(path, extensionsWithSvelte, exclude, include, depth);
        }
    };
    if (ts.sys.realpath) {
        const realpath = ts.sys.realpath;
        svelteSys.realpath = function (path) {
            if ((0, utils_1.isVirtualSvelteFilePath)(path)) {
                return realpath((0, utils_1.toRealSvelteFilePath)(path)) + '.ts';
            }
            return realpath(path);
        };
    }
    return svelteSys;
}
exports.createSvelteSys = createSvelteSys;
//# sourceMappingURL=svelte-sys.js.map