'''OpenGL extension NV.fbo_color_attachments

This module customises the behaviour of the 
OpenGL.raw.GLES2.NV.fbo_color_attachments to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension increases the number of available framebuffer object
	color attachment points.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/NV/fbo_color_attachments.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GLES2 import _types, _glgets
from OpenGL.raw.GLES2.NV.fbo_color_attachments import *
from OpenGL.raw.GLES2.NV.fbo_color_attachments import _EXTENSION_NAME

def glInitFboColorAttachmentsNV():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION