/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.impl;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gephi.graph.api.AttributeUtils;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.ColumnIterable;
import org.gephi.graph.api.Element;
import org.gephi.graph.api.Estimator;
import org.gephi.graph.api.GraphView;
import org.gephi.graph.api.Interval;
import org.gephi.graph.api.TimeRepresentation;
import org.gephi.graph.api.types.IntervalBooleanMap;
import org.gephi.graph.api.types.IntervalByteMap;
import org.gephi.graph.api.types.IntervalCharMap;
import org.gephi.graph.api.types.IntervalDoubleMap;
import org.gephi.graph.api.types.IntervalFloatMap;
import org.gephi.graph.api.types.IntervalIntegerMap;
import org.gephi.graph.api.types.IntervalLongMap;
import org.gephi.graph.api.types.IntervalMap;
import org.gephi.graph.api.types.IntervalShortMap;
import org.gephi.graph.api.types.IntervalStringMap;
import org.gephi.graph.api.types.TimeMap;
import org.gephi.graph.api.types.TimeSet;
import org.gephi.graph.api.types.TimestampBooleanMap;
import org.gephi.graph.api.types.TimestampByteMap;
import org.gephi.graph.api.types.TimestampCharMap;
import org.gephi.graph.api.types.TimestampDoubleMap;
import org.gephi.graph.api.types.TimestampFloatMap;
import org.gephi.graph.api.types.TimestampIntegerMap;
import org.gephi.graph.api.types.TimestampLongMap;
import org.gephi.graph.api.types.TimestampMap;
import org.gephi.graph.api.types.TimestampShortMap;
import org.gephi.graph.api.types.TimestampStringMap;
import org.gephi.graph.impl.AttributesImpl;
import org.gephi.graph.impl.ColumnImpl;
import org.gephi.graph.impl.ColumnStore;
import org.gephi.graph.impl.DefaultColumnsImpl;
import org.gephi.graph.impl.GraphStore;
import org.gephi.graph.impl.GraphStoreConfiguration;
import org.gephi.graph.impl.GraphViewImpl;
import org.gephi.graph.impl.TimeIndexStore;

public abstract class ElementImpl
implements Element {
    protected final GraphStore graphStore;
    protected final AttributesImpl attributes;

    public ElementImpl(Object id, GraphStore graphStore) {
        if (id == null) {
            throw new NullPointerException();
        }
        this.graphStore = graphStore;
        this.attributes = new AttributesImpl(this.getColumnStore());
        this.attributes.setId(id);
    }

    abstract ColumnStore getColumnStore();

    abstract TimeIndexStore getTimeIndexStore();

    abstract boolean isValid();

    abstract DefaultColumnsImpl.TableDefaultColumns getDefaultColumns();

    @Override
    public Object getId() {
        return this.attributes.getId();
    }

    @Override
    public String getLabel() {
        return this.attributes.getLabel();
    }

    @Override
    public void setLabel(String label) {
        this.setAttribute(this.getDefaultColumns().label, (Object)label);
    }

    @Override
    public Object getAttribute(String key) {
        return this.getAttribute(this.checkColumnExists(key));
    }

    @Override
    public Object getAttribute(Column column) {
        this.checkColumn(column);
        return this.attributes.getAttribute(column);
    }

    @Override
    public Object getAttribute(String key, double timestamp) {
        return this.getAttribute(this.checkColumnExists(key), timestamp);
    }

    @Override
    public Object getAttribute(Column column, double timestamp) {
        this.checkTimeRepresentationTimestamp();
        this.checkDouble(timestamp);
        this.checkColumn(column);
        this.checkColumnDynamic(column);
        return this.attributes.getAttribute(column, timestamp, null);
    }

    @Override
    public Object getAttribute(String key, Interval interval) {
        return this.getAttribute(this.checkColumnExists(key), interval);
    }

    @Override
    public Object getAttribute(Column column, Interval interval) {
        this.checkTimeRepresentationInterval();
        this.checkColumn(column);
        this.checkColumnDynamic(column);
        return this.attributes.getAttribute(column, interval, null);
    }

    @Override
    public Object getAttribute(String key, GraphView view) {
        return this.getAttribute(this.checkColumnExists(key), view);
    }

    @Override
    public Object getAttribute(Column column, GraphView view) {
        Estimator estimator = column.getEstimator();
        return this.getAttribute(column, view, estimator);
    }

    protected Object getAttribute(Column column, GraphView view, Estimator estimator) {
        this.checkColumn(column);
        if (!column.isDynamic()) {
            return this.getAttribute(column);
        }
        Interval interval = view.getTimeInterval();
        this.checkViewExist(view);
        return this.attributes.getAttribute(column, interval, estimator);
    }

    @Override
    public Object[] getAttributes() {
        return this.attributes.getBackingArray();
    }

    @Override
    public Set<String> getAttributeKeys() {
        return this.getColumnStore().getColumnKeys();
    }

    @Override
    public ColumnIterable getAttributeColumns() {
        return this.getColumnStore();
    }

    @Override
    public Object removeAttribute(String key) {
        return this.removeAttribute(this.checkColumnExists(key));
    }

    @Override
    public Object removeAttribute(Column column) {
        this.checkColumn(column);
        this.checkReadOnlyColumn(column);
        Object oldValue = this.attributes.setAttribute(column, column.getDefaultValue());
        this.updateIndex(column, oldValue, column.getDefaultValue());
        return oldValue;
    }

    @Override
    public Object removeAttribute(Column column, double timestamp) {
        this.checkTimeRepresentationTimestamp();
        this.checkDouble(timestamp);
        return this.removeTimeAttribute(column, timestamp);
    }

    @Override
    public Object removeAttribute(String key, double timestamp) {
        return this.removeAttribute(this.checkColumnExists(key), timestamp);
    }

    @Override
    public Object removeAttribute(Column column, Interval interval) {
        this.checkTimeRepresentationInterval();
        return this.removeTimeAttribute(column, interval);
    }

    @Override
    public Object removeAttribute(String key, Interval interval) {
        return this.removeAttribute(this.checkColumnExists(key), interval);
    }

    private Object removeTimeAttribute(Column column, Object timeObject) {
        this.checkColumn(column);
        this.checkColumnDynamic(column);
        this.checkReadOnlyColumn(column);
        Object oldValue = this.attributes.removeTimeAttribute(column, timeObject);
        if (oldValue != null && this.isValid()) {
            TimeIndexStore timeIndexStore = this.getTimeIndexStore();
            if (timeIndexStore != null) {
                timeIndexStore.remove(timeObject);
            }
            ((ColumnImpl)column).incrementVersion(this);
        }
        return oldValue;
    }

    @Override
    public void setAttribute(String key, Object value) {
        this.setAttribute(this.checkColumnExists(key), value);
    }

    @Override
    public void setAttribute(Column column, Object value) {
        this.checkColumn(column);
        this.checkReadOnlyColumn(column);
        value = AttributeUtils.standardizeValue(value);
        this.checkType(column, value);
        Object oldValue = this.attributes.setAttribute(column, value);
        this.updateIndex(column, oldValue, value);
    }

    @Override
    public void setAttribute(String key, Object value, double timestamp) {
        this.setAttribute(this.checkColumnExists(key), value, timestamp);
    }

    @Override
    public void setAttribute(Column column, Object value, double timestamp) {
        this.checkTimeRepresentationTimestamp();
        this.checkDouble(timestamp);
        this.setTimeAttribute(column, value, timestamp);
    }

    @Override
    public void setAttribute(String key, Object value, Interval interval) {
        this.setAttribute(this.checkColumnExists(key), value, interval);
    }

    @Override
    public void setAttribute(Column column, Object value, Interval interval) {
        this.checkTimeRepresentationInterval();
        this.setTimeAttribute(column, value, interval);
    }

    private void setTimeAttribute(Column column, Object value, Object timeObject) {
        this.checkColumn(column);
        this.checkColumnDynamic(column);
        this.checkReadOnlyColumn(column);
        this.checkType(column, value);
        Object newValue = this.attributes.setAttribute(column, value, timeObject);
        this.updateIndex(column, null, newValue);
    }

    private void updateIndex(Column column, Object oldValue, Object newValue) {
        if (this.isValid()) {
            TimeIndexStore timeIndexStore;
            ColumnStore columnStore = this.getColumnStore();
            ColumnImpl columnImpl = (ColumnImpl)column;
            if (columnImpl.isDynamic() && (timeIndexStore = this.getTimeIndexStore()) != null) {
                if (TimeMap.class.isAssignableFrom(columnImpl.getTypeClass())) {
                    if (oldValue instanceof TimeMap) {
                        timeIndexStore.remove((TimeMap)oldValue);
                    } else if (oldValue != null) {
                        timeIndexStore.remove(oldValue);
                    }
                    if (newValue instanceof TimeMap) {
                        timeIndexStore.add((TimeMap)newValue);
                    } else if (newValue != null) {
                        timeIndexStore.add(newValue);
                    }
                } else if (TimeSet.class.isAssignableFrom(columnImpl.getTypeClass())) {
                    if (oldValue instanceof TimeSet) {
                        timeIndexStore.remove((TimeSet)oldValue, (Element)this);
                    } else if (oldValue != null) {
                        timeIndexStore.remove(oldValue, (Element)this);
                    }
                    if (newValue instanceof TimeSet) {
                        timeIndexStore.add((TimeSet)newValue, (Element)this);
                    } else if (newValue != null) {
                        timeIndexStore.add(newValue, (Element)this);
                    }
                }
            }
            if (columnStore != null) {
                columnStore.indexStore.set(column, oldValue, newValue, this);
            }
            columnImpl.incrementVersion(this);
        }
    }

    @Override
    public boolean addTimestamp(double timestamp) {
        this.checkDouble(timestamp);
        this.checkTimeRepresentationTimestamp();
        return this.addTime(timestamp);
    }

    @Override
    public boolean addInterval(Interval interval) {
        this.checkTimeRepresentationInterval();
        return this.addTime(interval);
    }

    private boolean addTime(Object timeObject) {
        this.checkEnabledTimeSet();
        boolean res = this.attributes.addTime(timeObject);
        if (res) {
            this.updateIndex(this.getDefaultColumns().timeset, null, timeObject);
        }
        return res;
    }

    @Override
    public boolean removeTimestamp(double timestamp) {
        this.checkDouble(timestamp);
        this.checkTimeRepresentationTimestamp();
        return this.removeTime(timestamp);
    }

    @Override
    public boolean removeInterval(Interval interval) {
        this.checkTimeRepresentationInterval();
        return this.removeTime(interval);
    }

    private boolean removeTime(Object timeObject) {
        this.checkEnabledTimeSet();
        boolean res = this.attributes.removeTime(timeObject);
        if (res) {
            this.updateIndex(this.getDefaultColumns().timeset, timeObject, null);
        }
        return res;
    }

    @Override
    public double[] getTimestamps() {
        this.checkTimeRepresentationTimestamp();
        this.checkEnabledTimeSet();
        Object res = this.attributes.getTimeSetArray();
        if (res == null) {
            return new double[0];
        }
        return (double[])res;
    }

    @Override
    public Interval[] getIntervals() {
        this.checkTimeRepresentationInterval();
        this.checkEnabledTimeSet();
        Object res = this.attributes.getTimeSetArray();
        if (res == null) {
            return new Interval[0];
        }
        return (Interval[])res;
    }

    @Override
    public Interval getTimeBounds() {
        this.checkEnabledTimeSet();
        TimeSet timeSet = this.attributes.getTimeSet();
        if (timeSet != null) {
            Double min = timeSet.getMinDouble();
            Double max = timeSet.getMaxDouble();
            if (min != null) {
                return new Interval(min, max);
            }
        }
        return null;
    }

    @Override
    public boolean hasTimestamp(double timestamp) {
        this.checkTimeRepresentationTimestamp();
        this.checkEnabledTimeSet();
        return this.attributes.hasTime(timestamp);
    }

    @Override
    public boolean hasInterval(Interval interval) {
        this.checkTimeRepresentationInterval();
        this.checkEnabledTimeSet();
        return this.attributes.hasTime(interval);
    }

    @Override
    public Iterable<Map.Entry> getAttributes(Column column) {
        this.checkColumn(column);
        this.checkColumnDynamic(column);
        return this.attributes.getAttributes(column);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void indexAttributes() {
        ElementImpl elementImpl = this;
        synchronized (elementImpl) {
            TimeIndexStore timeIndexStore;
            ColumnStore columnStore = this.getColumnStore();
            if (columnStore != null) {
                columnStore.indexStore.index(this);
            }
            if ((timeIndexStore = this.getTimeIndexStore()) != null) {
                timeIndexStore.index(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearAttributes() {
        ElementImpl elementImpl = this;
        synchronized (elementImpl) {
            ColumnStore columnStore = this.getColumnStore();
            if (columnStore != null) {
                int length = columnStore.length;
                ColumnImpl[] cols = columnStore.columns;
                for (int i = 0; i < length; ++i) {
                    ColumnImpl c = cols[i];
                    if (c.isProperty() || c.isReadOnly()) continue;
                    this.removeAttribute(c);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroyAttributes() {
        ElementImpl elementImpl = this;
        synchronized (elementImpl) {
            TimeIndexStore timeIndexStore;
            ColumnStore columnStore = this.getColumnStore();
            if (columnStore != null) {
                columnStore.indexStore.clear(this);
            }
            if ((timeIndexStore = this.getTimeIndexStore()) != null) {
                timeIndexStore.clear(this);
            }
        }
    }

    public int hashCode() {
        int hash = 7;
        hash = 29 * hash + this.getId().hashCode();
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ElementImpl other = (ElementImpl)obj;
        return this.getId().equals(other.getId());
    }

    protected Estimator getEstimator(Column column) {
        Estimator estimator = column.getEstimator();
        if (estimator == null) {
            return GraphStoreConfiguration.DEFAULT_ESTIMATOR;
        }
        return estimator;
    }

    protected GraphStore getGraphStore() {
        return this.graphStore;
    }

    protected void checkTimeRepresentationTimestamp() {
        if (!this.getTimeRepresentation().equals((Object)TimeRepresentation.TIMESTAMP)) {
            throw new RuntimeException("Can't use timestamps as the configuration is set to " + (Object)((Object)this.getTimeRepresentation()));
        }
    }

    protected void checkTimeRepresentationInterval() {
        if (!this.getTimeRepresentation().equals((Object)TimeRepresentation.INTERVAL)) {
            throw new RuntimeException("Can't use intervals as the configuration is set to " + (Object)((Object)this.getTimeRepresentation()));
        }
    }

    void checkEnabledTimeSet() {
    }

    void checkDouble(double timestamp) {
        if (Double.isInfinite(timestamp) || Double.isNaN(timestamp)) {
            throw new IllegalArgumentException("Timestamp can't be NaN or infinity");
        }
    }

    Column checkColumnExists(String key) {
        ColumnImpl col = this.getColumnStore().getColumn(key);
        if (col == null) {
            throw new IllegalArgumentException("The column '" + key + "' is not found");
        }
        return col;
    }

    void checkColumn(Column column) {
        if (column.getIndex() == -1) {
            throw new IllegalArgumentException("The column does not exist");
        }
        ColumnStore columnStore = this.getColumnStore();
        if (columnStore != null && columnStore.getColumnByIndex(column.getIndex()) != column) {
            throw new IllegalArgumentException("The column does not belong to the right column store");
        }
    }

    void checkReadOnlyColumn(Column column) {
        if (column.isReadOnly()) {
            throw new RuntimeException("Can't modify the read-only '" + column.getId() + "' column");
        }
    }

    void checkColumnDynamic(Column column) {
        if (!((ColumnImpl)column).isDynamic()) {
            throw new IllegalArgumentException("The column is not dynamic");
        }
    }

    void checkType(Column column, Object value) {
        if (value != null) {
            Class typeClass = column.getTypeClass();
            if (TimestampMap.class.isAssignableFrom(typeClass)) {
                this.checkTimeRepresentationTimestamp();
                if (value instanceof Double && !typeClass.equals(TimestampDoubleMap.class) || value instanceof Float && !typeClass.equals(TimestampFloatMap.class) || value instanceof Boolean && !typeClass.equals(TimestampBooleanMap.class) || value instanceof Integer && !typeClass.equals(TimestampIntegerMap.class) || value instanceof Long && !typeClass.equals(TimestampLongMap.class) || value instanceof Short && !typeClass.equals(TimestampShortMap.class) || value instanceof Byte && !typeClass.equals(TimestampByteMap.class) || value instanceof String && !typeClass.equals(TimestampStringMap.class) || value instanceof Character && !typeClass.equals(TimestampCharMap.class)) {
                    throw new IllegalArgumentException("The object class does not match with the dynamic type (" + typeClass.getName() + ")");
                }
            } else if (IntervalMap.class.isAssignableFrom(typeClass)) {
                this.checkTimeRepresentationInterval();
                if (value instanceof Double && !typeClass.equals(IntervalDoubleMap.class) || value instanceof Float && !typeClass.equals(IntervalFloatMap.class) || value instanceof Boolean && !typeClass.equals(IntervalBooleanMap.class) || value instanceof Integer && !typeClass.equals(IntervalIntegerMap.class) || value instanceof Long && !typeClass.equals(IntervalLongMap.class) || value instanceof Short && !typeClass.equals(IntervalShortMap.class) || value instanceof Byte && !typeClass.equals(IntervalByteMap.class) || value instanceof String && !typeClass.equals(IntervalStringMap.class) || value instanceof Character && !typeClass.equals(IntervalCharMap.class)) {
                    throw new IllegalArgumentException("The object class does not match with the dynamic type (" + typeClass.getName() + ")");
                }
            } else if (List.class.isAssignableFrom(typeClass)) {
                if (!(value instanceof List)) {
                    throw new IllegalArgumentException("The object class does not match with the list type (" + typeClass.getName() + ")");
                }
            } else if (Set.class.isAssignableFrom(typeClass)) {
                if (!(value instanceof Set)) {
                    throw new IllegalArgumentException("The object class does not match with the set type (" + typeClass.getName() + ")");
                }
            } else if (Map.class.isAssignableFrom(typeClass)) {
                if (!(value instanceof Map)) {
                    throw new IllegalArgumentException("The object class does not match with the map type (" + typeClass.getName() + ")");
                }
            } else if (!value.getClass().equals(typeClass)) {
                throw new IllegalArgumentException("The object class does not match with the column type (" + typeClass.getName() + ")");
            }
        }
    }

    void checkViewExist(GraphView view) {
        this.graphStore.viewStore.checkNonNullViewObject(view);
        if (!view.isMainView()) {
            this.graphStore.viewStore.checkViewExist((GraphViewImpl)view);
        }
    }

    TimeRepresentation getTimeRepresentation() {
        if (this.graphStore != null) {
            return this.graphStore.configuration.getTimeRepresentation();
        }
        return GraphStoreConfiguration.DEFAULT_TIME_REPRESENTATION;
    }
}

