/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.datalab.plugin.manipulators.nodes.ui;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.miginfocom.swing.MigLayout;
import org.gephi.datalab.api.DataLaboratoryHelper;
import org.gephi.datalab.plugin.manipulators.nodes.MergeNodes;
import org.gephi.datalab.spi.DialogControls;
import org.gephi.datalab.spi.Manipulator;
import org.gephi.datalab.spi.ManipulatorUI;
import org.gephi.datalab.spi.rows.merge.AttributeRowsMergeStrategy;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.Element;
import org.gephi.graph.api.Node;
import org.gephi.ui.components.richtooltip.RichTooltip;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public final class MergeNodesUI
extends JPanel
implements ManipulatorUI {
    private static final ImageIcon CONFIG_BUTTONS_ICON = ImageUtilities.loadImageIcon((String)"DataLaboratoryPlugin/gear.png", (boolean)false);
    private static final ImageIcon INFO_LABELS_ICON = ImageUtilities.loadImageIcon((String)"DataLaboratoryPlugin/information.png", (boolean)false);
    private MergeNodes manipulator;
    private JCheckBox deleteMergedNodesCheckBox;
    private JComboBox nodesComboBox;
    private Node[] nodes;
    private StrategyComboBox[] strategiesComboBoxes;
    private StrategyConfigurationButton[] strategiesConfigurationButtons;
    private JScrollPane scroll;

    public MergeNodesUI() {
        this.initComponents();
    }

    public void setup(Manipulator m, DialogControls dialogControls) {
        this.manipulator = (MergeNodes)m;
        this.loadSettings();
    }

    public void unSetup() {
        this.manipulator.setDeleteMergedNodes(this.deleteMergedNodesCheckBox.isSelected());
        this.manipulator.setSelectedNode(this.nodes[this.nodesComboBox.getSelectedIndex()]);
        AttributeRowsMergeStrategy[] chosenStrategies = new AttributeRowsMergeStrategy[this.strategiesComboBoxes.length];
        for (int i = 0; i < this.strategiesComboBoxes.length; ++i) {
            chosenStrategies[i] = this.strategiesComboBoxes[i].getSelectedItem() != null ? ((StrategyWrapper)this.strategiesComboBoxes[i].getSelectedItem()).getStrategy() : null;
        }
        this.manipulator.setMergeStrategies(chosenStrategies);
    }

    public String getDisplayName() {
        return this.manipulator.getName();
    }

    public JPanel getSettingsPanel() {
        return this;
    }

    public boolean isModal() {
        return true;
    }

    public void loadSettings() {
        JPanel settingsPanel = new JPanel();
        settingsPanel.setLayout((LayoutManager)new MigLayout("fillx"));
        this.loadDescription(settingsPanel);
        this.loadDeleteMergedNodesCheckBox(settingsPanel);
        this.loadSelectedRow(settingsPanel);
        this.loadColumnsStrategies(settingsPanel);
        this.scroll.setViewportView(settingsPanel);
    }

    private void loadColumnsStrategies(JPanel settingsPanel) {
        Column[] columns = this.manipulator.getColumns();
        this.strategiesConfigurationButtons = new StrategyConfigurationButton[columns.length];
        this.strategiesComboBoxes = new StrategyComboBox[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            StrategyComboBox strategyComboBox;
            StrategyInfoLabel infoLabel = new StrategyInfoLabel(i);
            this.strategiesConfigurationButtons[i] = new StrategyConfigurationButton(i);
            this.strategiesComboBoxes[i] = strategyComboBox = new StrategyComboBox(this.strategiesConfigurationButtons[i], infoLabel);
            for (AttributeRowsMergeStrategy strategy : this.getColumnAvailableStrategies(columns[i])) {
                strategyComboBox.addItem(new StrategyWrapper(strategy));
            }
            strategyComboBox.refresh();
            settingsPanel.add((Component)new JLabel(columns[i].getTitle() + ": "), "wrap");
            settingsPanel.add((Component)infoLabel, "split 3");
            settingsPanel.add(this.strategiesConfigurationButtons[i]);
            settingsPanel.add((Component)strategyComboBox, "growx, wrap 15px");
        }
    }

    private List<AttributeRowsMergeStrategy> getColumnAvailableStrategies(Column column) {
        ArrayList<AttributeRowsMergeStrategy> availableStrategies = new ArrayList<AttributeRowsMergeStrategy>();
        for (AttributeRowsMergeStrategy strategy : DataLaboratoryHelper.getDefault().getAttributeRowsMergeStrategies()) {
            strategy.setup((Element[])this.nodes, (Element)this.manipulator.getSelectedNode(), column);
            if (!strategy.canExecute()) continue;
            availableStrategies.add(strategy);
        }
        return availableStrategies;
    }

    private void loadDescription(JPanel settingsPanel) {
        JLabel descriptionLabel = new JLabel();
        descriptionLabel.setText(this.getMessage("MergeNodesUI.description"));
        settingsPanel.add((Component)descriptionLabel, "wrap 25px");
    }

    private void loadDeleteMergedNodesCheckBox(JPanel settingsPanel) {
        this.deleteMergedNodesCheckBox = new JCheckBox(this.getMessage("MergeNodesUI.deleteMergedNodesText"), this.manipulator.isDeleteMergedNodes());
        settingsPanel.add((Component)this.deleteMergedNodesCheckBox, "wrap 25px");
    }

    private void loadSelectedRow(JPanel settingsPanel) {
        JLabel selectedRowLabel = new JLabel();
        selectedRowLabel.setText(this.getMessage("MergeNodesUI.selectedRowText"));
        settingsPanel.add((Component)selectedRowLabel, "wrap");
        this.nodesComboBox = new JComboBox();
        this.nodes = this.manipulator.getNodes();
        Node selectedNode = this.manipulator.getSelectedNode();
        for (int i = 0; i < this.nodes.length; ++i) {
            this.nodesComboBox.addItem(this.nodes[i].getId() + " - " + this.nodes[i].getLabel());
            if (this.nodes[i] != selectedNode) continue;
            this.nodesComboBox.setSelectedIndex(i);
        }
        settingsPanel.add((Component)this.nodesComboBox, "growx, wrap 25px");
    }

    private String getMessage(String resName) {
        return NbBundle.getMessage(MergeNodesUI.class, (String)resName);
    }

    private AttributeRowsMergeStrategy getStrategy(int strategyIndex) {
        StrategyWrapper sw;
        if (this.strategiesComboBoxes[strategyIndex] != null && (sw = (StrategyWrapper)this.strategiesComboBoxes[strategyIndex].getSelectedItem()) != null) {
            return sw.getStrategy();
        }
        return null;
    }

    private void initComponents() {
        this.scroll = new JScrollPane();
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scroll, -1, 594, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scroll, -1, 320, Short.MAX_VALUE));
    }

    class StrategyWrapper {
        private final AttributeRowsMergeStrategy strategy;

        public StrategyWrapper(AttributeRowsMergeStrategy strategy) {
            this.strategy = strategy;
        }

        public String toString() {
            return this.strategy.getName();
        }

        public AttributeRowsMergeStrategy getStrategy() {
            return this.strategy;
        }
    }

    class StrategyInfoLabel
    extends JLabel {
        private final int strategyIndex;

        public StrategyInfoLabel(int strategyIndex) {
            this.strategyIndex = strategyIndex;
            this.setIcon(INFO_LABELS_ICON);
            this.prepareRichTooltip();
        }

        public void refreshEnabledState() {
            AttributeRowsMergeStrategy strategy = MergeNodesUI.this.getStrategy(this.strategyIndex);
            this.setEnabled(strategy != null && strategy.getDescription() != null && !strategy.getDescription().isEmpty());
        }

        private void prepareRichTooltip() {
            this.addMouseListener(new MouseAdapter(){
                RichTooltip richTooltip;

                @Override
                public void mouseEntered(MouseEvent e) {
                    if (StrategyInfoLabel.this.isEnabled()) {
                        this.richTooltip = this.buildTooltip(MergeNodesUI.this.getStrategy(StrategyInfoLabel.this.strategyIndex));
                    }
                    if (this.richTooltip != null) {
                        this.richTooltip.showTooltip((JComponent)StrategyInfoLabel.this);
                    }
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    if (this.richTooltip != null) {
                        this.richTooltip.hideTooltip();
                        this.richTooltip = null;
                    }
                }

                private RichTooltip buildTooltip(AttributeRowsMergeStrategy strategy) {
                    if (strategy.getDescription() != null && !strategy.getDescription().isEmpty()) {
                        RichTooltip tooltip = new RichTooltip(strategy.getName(), strategy.getDescription());
                        if (strategy.getIcon() != null) {
                            tooltip.setMainImage(ImageUtilities.icon2Image((Icon)strategy.getIcon()));
                        }
                        return tooltip;
                    }
                    return null;
                }
            });
        }
    }

    class StrategyComboBox
    extends JComboBox
    implements ActionListener {
        private final StrategyConfigurationButton button;
        private final StrategyInfoLabel infoLabel;

        public StrategyComboBox(StrategyConfigurationButton button, StrategyInfoLabel infoLabel) {
            this.button = button;
            this.infoLabel = infoLabel;
            this.addActionListener(this);
        }

        public void refresh() {
            this.button.refreshEnabledState();
            this.infoLabel.refreshEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.refresh();
        }
    }

    class StrategyConfigurationButton
    extends JButton
    implements ActionListener {
        private final int strategyIndex;

        public StrategyConfigurationButton(int strategyIndex) {
            this.strategyIndex = strategyIndex;
            this.setIcon(CONFIG_BUTTONS_ICON);
            this.setToolTipText(MergeNodesUI.this.getMessage("MergeNodesUI.configurationText"));
            this.addActionListener(this);
        }

        public void refreshEnabledState() {
            AttributeRowsMergeStrategy strategy = MergeNodesUI.this.getStrategy(this.strategyIndex);
            this.setEnabled(strategy != null && strategy.getUI() != null);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DataLaboratoryHelper.getDefault().showAttributeRowsMergeStrategyUIDialog(MergeNodesUI.this.getStrategy(this.strategyIndex));
        }
    }
}

