/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.load.json;

import java.util.ArrayList;
import tim.prune.load.json.JsonPoint;

public class JsonBlock {
    private String _latitude = null;
    private String _longitude = null;
    private String _altitude = null;
    private Expectation _nextField = Expectation.NONE;
    private BlockType _type = BlockType.NONE;
    private boolean _hasNonNumbers = false;
    private ArrayList<String> _pointCoords = null;
    private ArrayList<ArrayList<String>> _coordList = null;

    private String modifyAltitudeString(String string) {
        if (string == null || string.equals("") || string.equals("\"\"")) {
            return null;
        }
        String string2 = string;
        if (string.length() > 2 && string.startsWith("\"") && string.endsWith("\"")) {
            string2 = string.substring(1, string.length() - 1);
        }
        if (string2.equals("NaN")) {
            return null;
        }
        return string2;
    }

    public void addToken(String string) {
        if (string == null || string.isEmpty()) {
            return;
        }
        if (!this._hasNonNumbers && !JsonBlock.looksLikeNumber(string)) {
            this._hasNonNumbers = true;
        }
        if (string.equals("\"latitude\"")) {
            this._nextField = Expectation.LATITUDE;
        } else if (string.equals("\"longitude\"")) {
            this._nextField = Expectation.LONGITUDE;
        } else if (string.equals("\"altitude\"")) {
            this._nextField = Expectation.ALTITUDE;
        } else if (string.equals("\"coordinates\"")) {
            this._nextField = Expectation.COORDS;
        } else {
            switch (this._nextField) {
                case LATITUDE: {
                    this._latitude = string;
                    this._type = BlockType.FIELDS;
                    break;
                }
                case LONGITUDE: {
                    this._longitude = string;
                    this._type = BlockType.FIELDS;
                    break;
                }
                case ALTITUDE: {
                    this._altitude = this.modifyAltitudeString(string);
                    this._type = BlockType.FIELDS;
                    break;
                }
                default: {
                    if (this._hasNonNumbers || !JsonBlock.looksLikeNumber(string)) break;
                    if (this._pointCoords == null) {
                        this._pointCoords = new ArrayList();
                    }
                    this._pointCoords.add(string);
                    this._type = BlockType.POINTCOORDS;
                }
            }
            this._nextField = Expectation.NONE;
        }
    }

    private static boolean looksLikeNumber(String string) {
        double d = Double.NaN;
        try {
            d = Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {}
        return !Double.isNaN(d);
    }

    public boolean areFieldsValid() {
        return this._type == BlockType.FIELDS && this._latitude != null && this._longitude != null;
    }

    public boolean areSingleCoordsValid() {
        return !this._hasNonNumbers && this._pointCoords != null && this._pointCoords.size() >= 2 && this._pointCoords.size() <= 3;
    }

    public JsonPoint createSinglePoint(boolean bl) {
        return new JsonPoint(this._latitude, this._longitude, this._altitude, bl);
    }

    public void addSingleCoordsFrom(JsonBlock jsonBlock) {
        if (this._type == BlockType.NONE && this._nextField == Expectation.COORDS && jsonBlock._type == BlockType.POINTCOORDS) {
            this._type = BlockType.FIELDS;
            this._longitude = jsonBlock.getSinglePointCoords(0);
            this._latitude = jsonBlock.getSinglePointCoords(1);
            this._altitude = jsonBlock.getSinglePointCoords(2);
        } else if (!(this._type != BlockType.NONE && this._type != BlockType.ISPOINTLIST || this._hasNonNumbers || this._nextField != Expectation.NONE || jsonBlock._type != BlockType.POINTCOORDS)) {
            this._type = BlockType.ISPOINTLIST;
            if (this._coordList == null) {
                this._coordList = new ArrayList();
            }
            this._coordList.add(jsonBlock._pointCoords);
        }
    }

    private String getSinglePointCoords(int n) {
        if (this._pointCoords == null || n < 0 || n >= this._pointCoords.size()) {
            return null;
        }
        return this._pointCoords.get(n);
    }

    public boolean isCoordListValid() {
        return !this._hasNonNumbers && this._type == BlockType.ISPOINTLIST && this._coordList != null;
    }

    public boolean hasValidCoordList() {
        return this._type == BlockType.HASPOINTLIST && this._coordList != null;
    }

    public void addCoordListFrom(JsonBlock jsonBlock) {
        if (this._type == BlockType.NONE && this._nextField == Expectation.COORDS && jsonBlock._type == BlockType.ISPOINTLIST) {
            this._coordList = jsonBlock._coordList;
            this._type = BlockType.HASPOINTLIST;
        } else if (!(this._type != BlockType.NONE && this._type != BlockType.ISPOINTLIST || this._hasNonNumbers || jsonBlock._type != BlockType.ISPOINTLIST)) {
            if (this._coordList == null) {
                this._coordList = new ArrayList();
            }
            this._coordList.addAll(jsonBlock._coordList);
            this._type = BlockType.ISPOINTLIST;
        }
    }

    public int getNumPoints() {
        if (this.hasValidCoordList()) {
            return this._coordList.size();
        }
        return 0;
    }

    public JsonPoint createPointFromList(int n) {
        if (n < 0 || n >= this.getNumPoints()) {
            return null;
        }
        ArrayList<String> arrayList = this._coordList.get(n);
        if (arrayList.size() < 2 || arrayList.size() > 3) {
            return null;
        }
        String string = arrayList.get(0);
        String string2 = arrayList.get(1);
        String string3 = arrayList.size() == 3 ? arrayList.get(2) : null;
        return new JsonPoint(string2, string, string3, n == 0);
    }

    private static enum BlockType {
        NONE,
        FIELDS,
        POINTCOORDS,
        ISPOINTLIST,
        HASPOINTLIST;

    }

    private static enum Expectation {
        NONE,
        LATITUDE,
        LONGITUDE,
        ALTITUDE,
        COORDS;

    }
}

