/*
 * Decompiled with CFR 0.152.
 */
package grails.util;

import grails.io.IOUtils;
import grails.util.BuildSettings;
import grails.util.CollectionUtils;
import grails.util.EnvironmentBlockEvaluator;
import grails.util.Holder;
import grails.util.Metadata;
import grails.util.SupplierUtil;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.net.URL;
import java.nio.file.Files;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.codehaus.groovy.control.MultipleCompilationErrorsException;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GeneratedLambda;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.dgmimpl.NumberNumberMinus;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.grails.io.support.UrlResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Environment
extends Enum<Environment>
implements GroovyObject {
    public static final /* enum */ Environment DEVELOPMENT;
    public static final /* enum */ Environment PRODUCTION;
    public static final /* enum */ Environment TEST;
    public static final /* enum */ Environment APPLICATION;
    public static final /* enum */ Environment CUSTOM;
    private static final Supplier<Logger> LOG;
    public static String KEY;
    public static final String ENV_KEY = "GRAILS_ENV";
    public static String ENV_GRAILS_HOME;
    public static String RELOAD_ENABLED;
    public static String RUN_ACTIVE;
    public static String FULL_STACKTRACE;
    public static final String RELOAD_LOCATION = "grails.reload.location";
    public static final String INTERACTIVE_MODE_ENABLED = "grails.interactive.mode.enabled";
    public static final String DEFAULT = "grails.env.default";
    public static final String INITIALIZING = "grails.env.initializing";
    public static final String STANDALONE = "grails.env.standalone";
    private static final String PRODUCTION_ENV_SHORT_NAME = "prod";
    private static final String DEVELOPMENT_ENVIRONMENT_SHORT_NAME = "dev";
    private static final String TEST_ENVIRONMENT_SHORT_NAME = "test";
    private static Map<String, String> envNameMappings;
    private static Holder<Environment> cachedCurrentEnvironment;
    private static final boolean DEVELOPMENT_MODE;
    private static Boolean RELOADING_AGENT_ENABLED;
    private static boolean initializingState;
    private static final String GRAILS_IMPLEMENTATION_TITLE = "Grails";
    private static final String GRAILS_VERSION;
    private static final boolean STANDALONE_DEPLOYED;
    private static final boolean WAR_DEPLOYED;
    public static Throwable currentReloadError;
    public static MultipleCompilationErrorsException currentCompilationError;
    private String name;
    private String reloadLocation;
    public static final Environment MIN_VALUE;
    public static final Environment MAX_VALUE;
    private static final /* synthetic */ Environment[] $VALUES;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    private Environment() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.initialize();
    }

    static {
        String string;
        boolean bl;
        boolean bl2;
        Map map;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        Environment environment;
        Environment environment2;
        Environment environment3;
        Environment environment4;
        Environment environment5;
        Environment environment6;
        Environment environment7;
        DEVELOPMENT = environment7 = Environment.$INIT("DEVELOPMENT", 0);
        PRODUCTION = environment6 = Environment.$INIT("PRODUCTION", 1);
        TEST = environment5 = Environment.$INIT("TEST", 2);
        APPLICATION = environment4 = Environment.$INIT("APPLICATION", 3);
        CUSTOM = environment3 = Environment.$INIT("CUSTOM", 4);
        MIN_VALUE = environment2 = DEVELOPMENT;
        MAX_VALUE = environment = CUSTOM;
        Environment[] environmentArray = new Environment[]{DEVELOPMENT, PRODUCTION, TEST, APPLICATION, CUSTOM};
        $VALUES = environmentArray;
        public final class __clinit__lambda1
        extends Closure
        implements GeneratedLambda {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public __clinit__lambda1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public T doCall() {
                return LoggerFactory.getLogger(Environment.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != __clinit__lambda1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        Supplier<Object> supplier = SupplierUtil.memoized(new __clinit__lambda1(Environment.class, Environment.class)::doCall);
        LOG = supplier;
        KEY = string6 = "grails.env";
        ENV_GRAILS_HOME = string5 = "GRAILS_HOME";
        RELOAD_ENABLED = string4 = "grails.reload.enabled";
        RUN_ACTIVE = string3 = "grails.run.active";
        FULL_STACKTRACE = string2 = "grails.full.stacktrace";
        envNameMappings = map = CollectionUtils.newMap(DEVELOPMENT_ENVIRONMENT_SHORT_NAME, DEVELOPMENT.getName(), PRODUCTION_ENV_SHORT_NAME, PRODUCTION.getName(), TEST_ENVIRONMENT_SHORT_NAME, TEST.getName());
        Holder holder = new Holder("Environment");
        cachedCurrentEnvironment = holder;
        DEVELOPMENT_MODE = bl2 = ScriptBytecodeAdapter.compareEqual((Object)((Object)Environment.getCurrent()), (Object)((Object)DEVELOPMENT)) && BuildSettings.GRAILS_APP_DIR_PRESENT;
        Object var17_17 = null;
        RELOADING_AGENT_ENABLED = (Boolean)ScriptBytecodeAdapter.castToType(var17_17, Boolean.class);
        initializingState = bl = false;
        Object var19_19 = null;
        currentReloadError = (Throwable)ScriptBytecodeAdapter.castToType(var19_19, Throwable.class);
        Object var20_20 = null;
        currentCompilationError = (MultipleCompilationErrorsException)ScriptBytecodeAdapter.castToType(var20_20, MultipleCompilationErrorsException.class);
        Package p = Environment.class.getPackage();
        String version = ShortTypeHandling.castToString((Object)(p != null ? p.getImplementationVersion() : null));
        if (version == null || Environment.isBlank(version)) {
            try {
                URL manifestURL = IOUtils.findResourceRelativeToClass(Environment.class, "/META-INF/MANIFEST.MF");
                Manifest grailsManifest = null;
                if (manifestURL != null) {
                    UrlResource r = new UrlResource(manifestURL);
                    if (r.exists()) {
                        InputStream inputStream = null;
                        Manifest mf = null;
                        try {
                            Manifest manifest;
                            InputStream inputStream2;
                            inputStream = inputStream2 = r.getInputStream();
                            mf = manifest = new Manifest(inputStream);
                        }
                        finally {
                            try {
                                inputStream.close();
                            }
                            catch (IOException e) {
                            }
                        }
                        String implTitle = mf.getMainAttributes().getValue(Attributes.Name.IMPLEMENTATION_TITLE);
                        if (!Environment.isBlank(implTitle) && implTitle.equals(GRAILS_IMPLEMENTATION_TITLE)) {
                            Manifest manifest;
                            grailsManifest = manifest = mf;
                        }
                    }
                }
                if (grailsManifest != null) {
                    String string7;
                    version = string7 = grailsManifest.getMainAttributes().getValue(Attributes.Name.IMPLEMENTATION_VERSION);
                }
                if (Environment.isBlank(version)) {
                    String string8;
                    version = string8 = "Unknown";
                }
            }
            catch (Exception e) {
                String string9;
                version = string9 = "Unknown";
            }
        }
        GRAILS_VERSION = string = version;
        URL url = Environment.class.getResource("");
        if (url != null) {
            String protocol = url.getProtocol();
            if (protocol.equals("jar")) {
                String fullPath = url.toString();
                if (fullPath.contains(IOUtils.RESOURCE_WAR_PREFIX)) {
                    boolean bl3;
                    STANDALONE_DEPLOYED = bl3 = true;
                } else {
                    int i = fullPath.indexOf(IOUtils.RESOURCE_JAR_PREFIX);
                    if (ScriptBytecodeAdapter.compareGreaterThan((Object)i, (Object)-1)) {
                        boolean bl4;
                        String string10;
                        fullPath = string10 = fullPath.substring(i + IOUtils.RESOURCE_JAR_PREFIX.length());
                        STANDALONE_DEPLOYED = bl4 = fullPath.contains(IOUtils.RESOURCE_JAR_PREFIX);
                    } else {
                        boolean bl5;
                        STANDALONE_DEPLOYED = bl5 = false;
                    }
                }
            } else {
                boolean bl6;
                STANDALONE_DEPLOYED = bl6 = false;
            }
        } else {
            boolean bl7;
            STANDALONE_DEPLOYED = bl7 = false;
        }
        URL loadedLocation = Environment.class.getClassLoader().getResource(Metadata.FILE);
        if (loadedLocation != null) {
            boolean bl8;
            String path = loadedLocation.getPath();
            WAR_DEPLOYED = bl8 = Environment.isWebPath(path);
        } else {
            URL uRL;
            loadedLocation = uRL = Thread.currentThread().getContextClassLoader().getResource(Metadata.FILE);
            if (loadedLocation != null) {
                boolean bl9;
                String path = loadedLocation.getPath();
                WAR_DEPLOYED = bl9 = Environment.isWebPath(path);
            } else {
                boolean bl10;
                WAR_DEPLOYED = bl10 = false;
            }
        }
    }

    public static String getGrailsVersion() {
        return GRAILS_VERSION;
    }

    public static void setCurrentReloadError(Throwable currentReloadError) {
        Throwable throwable;
        Environment.currentReloadError = throwable = currentReloadError;
    }

    public static MultipleCompilationErrorsException getCurrentCompilationError() {
        return currentCompilationError;
    }

    public static Throwable getCurrentReloadError() {
        return currentReloadError;
    }

    public static boolean isReloadInProgress() {
        return Boolean.getBoolean("grails.reloading.in.progress");
    }

    private void initialize() {
        String string;
        this.name = string = this.toString().toLowerCase(Locale.ENGLISH);
    }

    public static Environment getCurrent() {
        String envName = Environment.getEnvironmentInternal();
        Environment env = null;
        if (!Environment.isBlank(envName)) {
            Environment environment;
            env = environment = Environment.getEnvironment(envName);
            if (env != null) {
                return env;
            }
        }
        Environment current = (Environment)ShortTypeHandling.castToEnum((Object)((Object)cachedCurrentEnvironment.get()), Environment.class);
        if (current != null) {
            return current;
        }
        return Environment.cacheCurrentEnvironment();
    }

    private static Environment resolveCurrentEnvironment() {
        String envName = Environment.getEnvironmentInternal();
        if (Environment.isBlank(envName)) {
            Metadata metadata = Metadata.getCurrent();
            if (metadata != null) {
                String string;
                envName = string = metadata.getEnvironment();
            }
            if (Environment.isBlank(envName)) {
                return DEVELOPMENT;
            }
        }
        Environment env = Environment.getEnvironment(envName);
        if (env == null) {
            try {
                Environment environment;
                env = environment = Environment.valueOf(envName.toUpperCase());
            }
            catch (IllegalArgumentException e) {
            }
        }
        if (env == null) {
            Environment environment;
            env = environment = CUSTOM;
            env.setName(envName);
        }
        return env;
    }

    private static Environment cacheCurrentEnvironment() {
        Environment env = Environment.resolveCurrentEnvironment();
        cachedCurrentEnvironment.set(env);
        return env;
    }

    public static Environment getCurrentEnvironment() {
        return Environment.getCurrent();
    }

    public static void reset() {
        cachedCurrentEnvironment.set(null);
        Metadata.reset();
    }

    public static boolean isDevelopmentMode() {
        return DEVELOPMENT_MODE;
    }

    public static boolean isDevelopmentEnvironmentAvailable() {
        return BuildSettings.GRAILS_APP_DIR_PRESENT && !Environment.isStandaloneDeployed() && !Environment.isWarDeployed();
    }

    public static boolean isDevelopmentRun() {
        Environment env = Environment.getCurrent();
        return env.isDevelopmentEnvironmentAvailable() && Boolean.getBoolean(RUN_ACTIVE) && ScriptBytecodeAdapter.compareEqual((Object)((Object)env), (Object)((Object)DEVELOPMENT));
    }

    public static boolean isDevtoolsRestart() {
        boolean isDevToolsRestart;
        block7: {
            File pidFile = new File(StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)BuildSettings.TARGET_DIR.toString(), (CharSequence)File.separator), (CharSequence)".grailspid"));
            LOG.get().debug("Looking for pid file at: {}", (Object)pidFile);
            isDevToolsRestart = false;
            try {
                if (!Environment.isDevelopmentMode()) break block7;
                String pid = ManagementFactory.getRuntimeMXBean().getName();
                if (pidFile.exists()) {
                    if (pid.equals(Files.readAllLines(pidFile.toPath()).get(0))) {
                        boolean bl;
                        LOG.get().debug("spring-dev-tools restart detected.");
                        isDevToolsRestart = bl = true;
                    } else {
                        LOG.get().debug("spring-dev-tools first app start - creating pid file.");
                        Environment.writeDevToolsPidFile(pidFile, pid);
                    }
                    break block7;
                }
                LOG.get().debug("spring-dev-tools pid file did not exist.");
                Environment.writeDevToolsPidFile(pidFile, pid);
            }
            catch (Exception ex) {
                LOG.get().error("spring-dev-tools restart detection error: {}", (Throwable)ex);
            }
        }
        LOG.get().debug("spring-dev-tools restart: {}", (Object)isDevToolsRestart);
        return isDevToolsRestart;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void writeDevToolsPidFile(File pidFile, String content) {
        BufferedWriter writer = null;
        try {
            try {
                BufferedWriter bufferedWriter;
                writer = bufferedWriter = new BufferedWriter(new FileWriter(pidFile));
                writer.write(content);
            }
            catch (Exception ex) {
                LOG.get().error("spring-dev-tools restart unable to write pid file: {}", (Throwable)ex);
            }
        }
        catch (Throwable throwable) {
            try {
                if (!(writer != null)) throw throwable;
                writer.flush();
                writer.close();
                throw throwable;
            }
            catch (Exception ignored) {
            }
            throw throwable;
        }
        try {
            if (writer == null) return;
            boolean bl = true;
            if (!bl) return;
            writer.flush();
            writer.close();
            return;
        }
        catch (Exception ignored) {
        }
        return;
    }

    public static boolean isWarDeployed() {
        if (!Environment.isStandalone()) {
            return WAR_DEPLOYED;
        }
        return false;
    }

    private static boolean isWebPath(String path) {
        return path.contains("/WEB-INF/classes") || path.contains("_wl_cls_gen.jar!/");
    }

    public static boolean isStandalone() {
        return Boolean.getBoolean(STANDALONE);
    }

    public static boolean isStandaloneDeployed() {
        return Environment.isStandalone() && STANDALONE_DEPLOYED;
    }

    public static boolean isFork() {
        return Boolean.getBoolean("grails.fork.active");
    }

    public static boolean isWithinShell() {
        return DefaultGroovyMethods.getRootLoader((ClassLoader)Environment.class.getClassLoader()) != null;
    }

    public static boolean isSystemSet() {
        return Environment.getEnvironmentInternal() != null;
    }

    public static Environment getEnvironment(String shortName) {
        String envName = ShortTypeHandling.castToString((Object)envNameMappings.get(shortName));
        if (envName != null) {
            return Environment.valueOf(envName.toUpperCase());
        }
        Environment environment = Environment.valueOf(shortName.toUpperCase());
        try {
            return environment;
        }
        catch (IllegalArgumentException ise) {
            Environment environment2 = (Environment)ShortTypeHandling.castToEnum(null, Environment.class);
            return environment2;
        }
    }

    public static Closure<?> getEnvironmentSpecificBlock(Closure<?> closure) {
        Environment env = Environment.getCurrent();
        return Environment.getEnvironmentSpecificBlock(env, closure);
    }

    public static Closure<?> getEnvironmentSpecificBlock(Environment env, Closure<?> closure) {
        if (closure == null) {
            return (Closure)ScriptBytecodeAdapter.castToType(null, Closure.class);
        }
        EnvironmentBlockEvaluator evaluator = Environment.evaluateEnvironmentSpecificBlock(env, closure);
        return evaluator.getCallable();
    }

    public static Object executeForCurrentEnvironment(Closure<?> closure) {
        Environment env = Environment.getCurrent();
        return Environment.executeForEnvironment(env, closure);
    }

    public static Object executeForEnvironment(Environment env, Closure<?> closure) {
        if (closure == null) {
            return null;
        }
        EnvironmentBlockEvaluator evaluator = Environment.evaluateEnvironmentSpecificBlock(env, closure);
        return evaluator.execute();
    }

    private static EnvironmentBlockEvaluator evaluateEnvironmentSpecificBlock(Environment environment, Closure<?> closure) {
        EnvironmentBlockEvaluator evaluator = new EnvironmentBlockEvaluator(environment);
        closure.setDelegate((Object)evaluator);
        closure.call();
        return evaluator;
    }

    private static boolean isBlank(String value) {
        return value == null || value.trim().length() == 0;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        String string;
        this.name = string = name;
    }

    public boolean isReloadEnabled() {
        boolean reloadOverride = Boolean.getBoolean(RELOAD_ENABLED);
        this.getReloadLocation();
        boolean reloadLocationSpecified = this.hasLocation(this.reloadLocation);
        return ScriptBytecodeAdapter.compareEqual((Object)((Object)this), (Object)((Object)DEVELOPMENT)) && reloadLocationSpecified || reloadOverride && reloadLocationSpecified;
    }

    public static boolean isInteractiveMode() {
        return Boolean.getBoolean(INTERACTIVE_MODE_ENABLED);
    }

    public static boolean isInitializing() {
        return initializingState;
    }

    public static void setInitializing(boolean initializing) {
        boolean bl;
        initializingState = bl = initializing;
        System.setProperty(INITIALIZING, String.valueOf(initializing));
    }

    public static boolean isReloadingAgentEnabled() {
        if (RELOADING_AGENT_ENABLED != null) {
            return DefaultTypeTransformation.booleanUnbox((Object)RELOADING_AGENT_ENABLED);
        }
        try {
            Class.forName("org.springframework.boot.devtools.RemoteSpringApplication");
            boolean bl = Environment.getCurrent().isReloadEnabled();
            RELOADING_AGENT_ENABLED = bl;
            LOG.get().debug("Found spring-dev-tools on the class path");
        }
        catch (ClassNotFoundException e) {
            boolean bl = false;
            RELOADING_AGENT_ENABLED = bl;
            try {
                Class.forName("org.springsource.loaded.TypeRegistry");
                String jvmVersion = System.getProperty("java.specification.version");
                LOG.get().debug("Found spring-loaded on the class path");
                boolean bl2 = Environment.getCurrent().isReloadEnabled();
                RELOADING_AGENT_ENABLED = bl2;
            }
            catch (ClassNotFoundException e1) {
                boolean bl3 = false;
                RELOADING_AGENT_ENABLED = bl3;
            }
        }
        return DefaultTypeTransformation.booleanUnbox((Object)RELOADING_AGENT_ENABLED);
    }

    public String getReloadLocation() {
        if (this.reloadLocation != null) {
            return this.reloadLocation;
        }
        String location = this.getReloadLocationInternal();
        if (this.hasLocation(location)) {
            String string;
            this.reloadLocation = string = location;
            return location;
        }
        return ".";
    }

    private boolean hasLocation(String location) {
        return location != null && location.length() > 0;
    }

    public boolean hasReloadLocation() {
        this.getReloadLocation();
        return this.hasLocation(this.reloadLocation);
    }

    private String getReloadLocationInternal() {
        String location = System.getProperty(RELOAD_LOCATION);
        if (!this.hasLocation(location)) {
            String string;
            location = string = System.getProperty(BuildSettings.APP_BASE_DIR);
        }
        if (!this.hasLocation(location)) {
            File current = new File(".", "grails-app");
            if (current.exists()) {
                String string;
                location = string = current.getParentFile().getAbsolutePath();
            } else {
                File file;
                current = file = new File(".", "settings.gradle");
                if (current.exists()) {
                    String string;
                    location = string = IOUtils.findApplicationDirectory();
                }
            }
        }
        return location;
    }

    private static String getEnvironmentInternal() {
        String envName = System.getProperty(KEY);
        return Environment.isBlank(envName) ? System.getenv(ENV_KEY) : envName;
    }

    @Generated
    public static final Environment[] values() {
        return (Environment[])ScriptBytecodeAdapter.castToType((Object)$VALUES.clone(), Environment[].class);
    }

    @Generated
    public Environment next() {
        Number ordinal = DefaultGroovyMethods.next((Number)this.ordinal());
        if (ScriptBytecodeAdapter.compareGreaterThanEqual((Object)ordinal, (Object)DefaultGroovyMethods.size((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)$VALUES, Object[].class))))) {
            Integer n = 0;
            ordinal = n;
        }
        return (Environment)ShortTypeHandling.castToEnum((Object)BytecodeInterface8.objectArrayGet((Object[])$VALUES, (int)DefaultTypeTransformation.intUnbox((Object)ordinal)), Environment.class);
    }

    @Generated
    public Environment previous() {
        Number ordinal = DefaultGroovyMethods.previous((Number)this.ordinal());
        if (ScriptBytecodeAdapter.compareLessThan((Object)ordinal, (Object)0)) {
            Number number;
            ordinal = number = NumberNumberMinus.minus((Number)DefaultGroovyMethods.size((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)$VALUES, Object[].class))), (Number)1);
        }
        return (Environment)ShortTypeHandling.castToEnum((Object)BytecodeInterface8.objectArrayGet((Object[])$VALUES, (int)DefaultTypeTransformation.intUnbox((Object)ordinal)), Environment.class);
    }

    @Generated
    public static Environment valueOf(String name) {
        return (Environment)ShortTypeHandling.castToEnum((Object)((Object)Enum.valueOf(Environment.class, name)), Environment.class);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Generated
    public static final /* synthetic */ Environment $INIT(Object ... para) {
        Object[] objectArray = ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{para}, (int[])new int[]{0});
        switch (ScriptBytecodeAdapter.selectConstructorAndTransformArguments((Object[])objectArray, (int)-1, Environment.class)) {
            case -1348271900: {
                return new Environment();
            }
            default: {
                throw new IllegalArgumentException("This class has been compiled with a super class which is binary incompatible with the current super class found on classpath. You should recompile this class with the new version.");
            }
        }
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != Environment.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }
}

