/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Name;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.SelectField;
import org.jooq.SelectHavingStep;
import org.jooq.TableLike;
import org.jooq.impl.DSL;

public class DBUtils {
    public static boolean checkIfTableExists(DSLContext create, String tableName) {
        Result res = create.select(new SelectField[0]).from((TableLike)DSL.table((String)"sqlite_master")).where(new Condition[]{DSL.field((String)"type").eq((Object)"table").and(DSL.field((String)"name").eq((Object)tableName))}).fetch();
        return res.size() > 0;
    }

    public static Result<Record> fetchTables(DSLContext create) {
        return create.select(new SelectField[0]).from((TableLike)DSL.table((String)"sqlite_master")).where(new Condition[]{DSL.field((String)"type").eq((Object)"table")}).fetch();
    }

    public static List<Field<String>> getStringFieldsFromList(Collection<String> fieldNames) {
        return fieldNames.stream().map(s -> DSL.field((Name)DSL.name((String)s), String.class)).collect(Collectors.toList());
    }

    public static List<Field<?>> getFieldsFromList(Collection<String> fieldNames) {
        return fieldNames.stream().map(s -> DSL.field((Name)DSL.name((String)s), String.class)).collect(Collectors.toList());
    }

    public static List<Field<Double>> getDoubleFieldsFromList(Collection<String> fieldNames) {
        return fieldNames.stream().map(s -> DSL.field((Name)DSL.name((String)s), Double.class)).collect(Collectors.toList());
    }

    public static List<Field<?>> getStringFieldsFromTable(Collection<String> fieldNames, TableLike<Record> table) {
        return fieldNames.stream().map(s -> table.field(s, String.class)).collect(Collectors.toList());
    }

    public static List<Field<?>> getSelectFieldsForMetricName(String metricName, List<String> metrics, List<String> dimensions) {
        List<Field<?>> selectFields = DBUtils.getFieldsFromList(dimensions);
        for (String metric : metrics) {
            if (metric.equals(metricName)) {
                selectFields.add(DSL.field((String)metric, Double.class).as(metric));
                continue;
            }
            selectFields.add(DSL.val(null, Double.class).as(metric));
        }
        return selectFields;
    }

    public static Set<String> getRecordSetByField(SelectHavingStep<Record> table, Field field, Condition condition, DSLContext create) {
        Result records = create.select((SelectField)field).from(table).where(new Condition[]{condition}).fetch();
        HashSet<String> res = new HashSet<String>();
        for (int i = 0; i < records.size(); ++i) {
            res.add(((Record)records.get(i)).get(0).toString());
        }
        return res;
    }

    public static String getAggFieldName(String fieldName, String aggName) {
        return aggName + "_" + fieldName;
    }

    public static Map<String, Field<Double>> getDoubleFieldMapFromList(Collection<String> fieldNames) {
        return fieldNames.stream().collect(Collectors.toMap(s -> s, s -> DSL.field((Name)DSL.name((String)s), Double.class)));
    }
}

