/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.rca.framework.metrics;

import java.util.Collections;
import java.util.List;
import org.opensearch.performanceanalyzer.rca.stats.eval.Statistics;
import org.opensearch.performanceanalyzer.rca.stats.measurements.MeasurementSet;

public enum ExceptionsAndErrors implements MeasurementSet
{
    RCA_FRAMEWORK_CRASH("RcaFrameworkCrash"),
    CONFIG_DIR_NOT_FOUND("ConfigDirectoryNotFound"),
    WRITE_UPDATED_RCA_CONF_ERROR("WriteUpdatedRcaConfError"),
    MUTE_ERROR("MuteError"),
    EXCEPTION_IN_OPERATE("ExceptionInOperate", "namedCount", Statistics.NAMED_COUNTERS),
    EXCEPTION_IN_COMPUTE("ExceptionInCompute", "namedCount", Statistics.NAMED_COUNTERS),
    EXCEPTION_IN_GATHER("ExceptionInGather", "namedCount", Statistics.NAMED_COUNTERS),
    EXCEPTION_IN_PERSIST("ExceptionInPersist", "namedCount", Statistics.NAMED_COUNTERS),
    READER_METRICSDB_ACCESS_ERRORS("ReaderMetricsdbAccessError"),
    SHARD_STATE_COLLECTOR_ERROR("ShardStateCollectorError"),
    ADMISSION_CONTROL_COLLECTOR_ERROR("AdmissionControlCollectorError"),
    CLUSTER_MANAGER_THROTTLING_COLLECTOR_ERROR("ClusterManagerThrottlingMetricsCollectorError"),
    FAULT_DETECTION_COLLECTOR_ERROR("FaultDetectionMetricsCollectorError"),
    CLUSTER_APPLIER_SERVICE_STATS_COLLECTOR_ERROR("ClusterApplierServiceStatsCollectorError"),
    CLUSTER_MANAGER_CLUSTER_UPDATE_STATS_COLLECTOR_ERROR("ClusterManagerClusterStateUpdateStatsCollectorError"),
    ELECTION_TERM_COLLECTOR_ERROR("ElectionTermCollectorError"),
    SHARD_INDEXING_PRESSURE_COLLECTOR_ERROR("ShardIndexingPressureMetricsCollectorError"),
    NODESTATS_COLLECTION_ERROR("NodeStatsCollectionError");

    private String name;
    private String unit;
    private List<Statistics> statsList;

    private ExceptionsAndErrors(String name) {
        this.name = name;
        this.unit = "count";
        this.statsList = Collections.singletonList(Statistics.COUNT);
    }

    private ExceptionsAndErrors(String name, String unit, Statistics stats) {
        this.name = name;
        this.unit = unit;
        this.statsList = Collections.singletonList(stats);
    }

    public String toString() {
        return this.name + "-" + this.unit;
    }

    @Override
    public List<Statistics> getStatsList() {
        return this.statsList;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getUnit() {
        return this.unit;
    }
}

