/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.decisionmaker.deciders;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.performanceanalyzer.PerformanceAnalyzerApp;
import org.opensearch.performanceanalyzer.decisionmaker.deciders.Decision;
import org.opensearch.performanceanalyzer.rca.framework.core.NonLeafNode;
import org.opensearch.performanceanalyzer.rca.framework.core.RcaConf;
import org.opensearch.performanceanalyzer.rca.framework.metrics.ExceptionsAndErrors;
import org.opensearch.performanceanalyzer.rca.framework.metrics.RcaGraphMetrics;
import org.opensearch.performanceanalyzer.rca.scheduler.FlowUnitOperationArgWrapper;

public abstract class Decider
extends NonLeafNode<Decision> {
    private static final Logger LOG = LogManager.getLogger(Decider.class);
    protected final int decisionFrequency;
    protected RcaConf rcaConf;

    public Decider(long evalIntervalSeconds, int decisionFrequency) {
        super(0, evalIntervalSeconds);
        this.decisionFrequency = decisionFrequency;
        this.rcaConf = null;
    }

    @Override
    public abstract String name();

    @Override
    public void generateFlowUnitListFromLocal(FlowUnitOperationArgWrapper args) {
        Decision decision;
        LOG.debug("decider: Executing fromLocal: {}", (Object)this.name());
        long startTime = System.currentTimeMillis();
        try {
            decision = this.operate();
        }
        catch (Exception ex) {
            LOG.error("decider: Exception in operate", (Throwable)ex);
            PerformanceAnalyzerApp.ERRORS_AND_EXCEPTIONS_AGGREGATOR.updateStat(ExceptionsAndErrors.EXCEPTION_IN_OPERATE, this.name(), 1);
            decision = new Decision(System.currentTimeMillis(), this.name());
        }
        long duration = System.currentTimeMillis() - startTime;
        PerformanceAnalyzerApp.RCA_GRAPH_METRICS_AGGREGATOR.updateStat(RcaGraphMetrics.GRAPH_NODE_OPERATE_CALL, this.name(), duration);
        this.setLocalFlowUnit(decision);
    }

    @Override
    public void persistFlowUnit(FlowUnitOperationArgWrapper args) {
    }

    @Override
    public void generateFlowUnitListFromWire(FlowUnitOperationArgWrapper args) {
        throw new IllegalArgumentException(this.name() + ": not expected to be called over the wire");
    }

    @Override
    public void handleNodeMuted() {
        this.setLocalFlowUnit(new Decision(System.currentTimeMillis(), this.name()));
    }

    @Override
    public abstract Decision operate();

    @Override
    public void readRcaConf(RcaConf conf) {
        this.rcaConf = conf;
    }
}

