/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.decisionmaker.deciders.jvm.sizing;

import com.google.common.annotations.VisibleForTesting;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.opensearch.performanceanalyzer.AppContext;
import org.opensearch.performanceanalyzer.PerformanceAnalyzerApp;
import org.opensearch.performanceanalyzer.decisionmaker.actions.Action;
import org.opensearch.performanceanalyzer.decisionmaker.actions.HeapSizeIncreaseAction;
import org.opensearch.performanceanalyzer.decisionmaker.deciders.AlarmMonitor;
import org.opensearch.performanceanalyzer.decisionmaker.deciders.DecisionPolicy;
import org.opensearch.performanceanalyzer.decisionmaker.deciders.jvm.JvmActionsAlarmMonitor;
import org.opensearch.performanceanalyzer.rca.configs.HeapSizeIncreasePolicyConfig;
import org.opensearch.performanceanalyzer.rca.framework.api.flow_units.ResourceFlowUnit;
import org.opensearch.performanceanalyzer.rca.framework.api.summaries.HotClusterSummary;
import org.opensearch.performanceanalyzer.rca.framework.api.summaries.HotNodeSummary;
import org.opensearch.performanceanalyzer.rca.framework.core.RcaConf;
import org.opensearch.performanceanalyzer.rca.framework.metrics.RcaRuntimeMetrics;
import org.opensearch.performanceanalyzer.rca.framework.util.RcaConsts;
import org.opensearch.performanceanalyzer.rca.store.rca.cluster.NodeKey;
import org.opensearch.performanceanalyzer.rca.store.rca.jvmsizing.LargeHeapClusterRca;

public class HeapSizeIncreasePolicy
implements DecisionPolicy {
    private final LargeHeapClusterRca largeHeapClusterRca;
    private AppContext appContext;
    private RcaConf rcaConf;
    private final HeapSizeIncreaseClusterMonitor heapSizeIncreaseClusterMonitor = new HeapSizeIncreaseClusterMonitor();
    private int unhealthyNodePercentage;

    public HeapSizeIncreasePolicy(LargeHeapClusterRca largeHeapClusterRca) {
        this.largeHeapClusterRca = largeHeapClusterRca;
    }

    @Override
    public List<Action> evaluate() {
        HeapSizeIncreaseAction heapSizeIncreaseAction;
        this.addToClusterMonitor();
        ArrayList<Action> actions = new ArrayList<Action>();
        if (!this.heapSizeIncreaseClusterMonitor.isHealthy() && (heapSizeIncreaseAction = new HeapSizeIncreaseAction(this.appContext)).isActionable()) {
            PerformanceAnalyzerApp.RCA_RUNTIME_METRICS_AGGREGATOR.updateStat(RcaRuntimeMetrics.HEAP_SIZE_INCREASE_ACTION_SUGGESTED, "", 1);
            actions.add(heapSizeIncreaseAction);
        }
        return actions;
    }

    private void addToClusterMonitor() {
        long currTime = System.currentTimeMillis();
        if (this.largeHeapClusterRca.getFlowUnits().isEmpty()) {
            return;
        }
        ResourceFlowUnit flowUnit = (ResourceFlowUnit)this.largeHeapClusterRca.getFlowUnits().get(0);
        if (flowUnit.getSummary() == null) {
            return;
        }
        List<HotNodeSummary> hotNodeSummaries = ((HotClusterSummary)flowUnit.getSummary()).getHotNodeSummaryList();
        hotNodeSummaries.forEach(hotNodeSummary -> {
            NodeKey nodeKey = new NodeKey(hotNodeSummary.getNodeID(), hotNodeSummary.getHostAddress());
            this.heapSizeIncreaseClusterMonitor.recordIssue(nodeKey, currTime);
        });
    }

    public void setAppContext(@Nonnull AppContext appContext) {
        this.appContext = appContext;
    }

    public void setRcaConf(RcaConf rcaConf) {
        this.rcaConf = rcaConf;
        this.readThresholdValuesFromConf();
    }

    private void readThresholdValuesFromConf() {
        HeapSizeIncreasePolicyConfig policyConfig = this.rcaConf.getJvmScaleUpPolicyConfig();
        this.unhealthyNodePercentage = policyConfig.getUnhealthyNodePercentage();
        this.heapSizeIncreaseClusterMonitor.setDayBreachThreshold(policyConfig.getDayBreachThreshold());
        this.heapSizeIncreaseClusterMonitor.setWeekBreachThreshold(policyConfig.getWeekBreachThreshold());
    }

    @VisibleForTesting
    public int getUnhealthyNodePercentage() {
        return this.unhealthyNodePercentage;
    }

    private class HeapSizeIncreaseClusterMonitor {
        private static final int DEFAULT_DAY_BREACH_THRESHOLD = 8;
        private static final int DEFAULT_WEEK_BREACH_THRESHOLD = 3;
        private static final String PERSISTENCE_PREFIX = "heap-size-increase-alarm-";
        private final Map<NodeKey, AlarmMonitor> perNodeMonitor = new HashMap<NodeKey, AlarmMonitor>();
        private int dayBreachThreshold = 8;
        private int weekBreachThreshold = 3;

        HeapSizeIncreaseClusterMonitor() {
        }

        public void recordIssue(NodeKey nodeKey, long currTimeStamp) {
            this.perNodeMonitor.computeIfAbsent(nodeKey, key -> new JvmActionsAlarmMonitor(this.dayBreachThreshold, this.weekBreachThreshold, Paths.get(RcaConsts.CONFIG_DIR_PATH, PERSISTENCE_PREFIX + key.getNodeId().toString()))).recordIssue(currTimeStamp, 1.0);
        }

        public boolean isHealthy() {
            int numDataNodesInCluster = HeapSizeIncreasePolicy.this.appContext.getDataNodeInstances().size();
            double unhealthyCount = 0.0;
            for (AlarmMonitor monitor : this.perNodeMonitor.values()) {
                if (monitor.isHealthy()) continue;
                unhealthyCount += 1.0;
            }
            return unhealthyCount / (double)numDataNodesInCluster * 100.0 < (double)HeapSizeIncreasePolicy.this.unhealthyNodePercentage;
        }

        public void setDayBreachThreshold(int dayBreachThreshold) {
            this.dayBreachThreshold = dayBreachThreshold;
        }

        public void setWeekBreachThreshold(int weekBreachThreshold) {
            this.weekBreachThreshold = weekBreachThreshold;
        }
    }
}

