# This file has been autogenerated by the pywayland scanner

# Copyright 2016 The Chromium Authors.
# Copyright 2017 Intel Corporation
# Copyright 2018 Collabora, Ltd
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice (including the next
# paragraph) shall be included in all copies or substantial portions of the
# Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.

from __future__ import annotations

import enum

from pywayland.protocol_core import (
    Argument,
    ArgumentType,
    Global,
    Interface,
    Proxy,
    Resource,
)
from .zwp_linux_buffer_release_v1 import ZwpLinuxBufferReleaseV1


class ZwpLinuxSurfaceSynchronizationV1(Interface):
    """Per-surface explicit synchronization support

    This object implements per-surface explicit synchronization.

    Synchronization refers to co-ordination of pipelined operations performed
    on buffers. Most GPU clients will schedule an asynchronous operation to
    render to the buffer, then immediately send the buffer to the compositor to
    be attached to a surface.

    In implicit synchronization, ensuring that the rendering operation is
    complete before the compositor displays the buffer is an implementation
    detail handled by either the kernel or userspace graphics driver.

    By contrast, in explicit synchronization, dma_fence objects mark when the
    asynchronous operations are complete. When submitting a buffer, the client
    provides an acquire fence which will be waited on before the compositor
    accesses the buffer. The Wayland server, through a
    :class:`~pywayland.protocol.zwp_linux_explicit_synchronization_unstable_v1.ZwpLinuxBufferReleaseV1`
    object, will inform the client with an event which may be accompanied by a
    release fence, when the compositor will no longer access the buffer
    contents due to the specific commit that requested the release event.

    Each surface can be associated with only one object of this interface at
    any time.

    In version 1 of this interface, explicit synchronization is only guaranteed
    to be supported for buffers created with any version of the wp_linux_dmabuf
    buffer factory. Version 2 additionally guarantees explicit synchronization
    support for opaque EGL buffers, which is a type of platform specific
    buffers described in the EGL_WL_bind_wayland_display extension. Compositors
    are free to support explicit synchronization for additional buffer types.
    """

    name = "zwp_linux_surface_synchronization_v1"
    version = 2

    class error(enum.IntEnum):
        invalid_fence = 0
        duplicate_fence = 1
        duplicate_release = 2
        no_surface = 3
        unsupported_buffer = 4
        no_buffer = 5


class ZwpLinuxSurfaceSynchronizationV1Proxy(Proxy[ZwpLinuxSurfaceSynchronizationV1]):
    interface = ZwpLinuxSurfaceSynchronizationV1

    @ZwpLinuxSurfaceSynchronizationV1.request()
    def destroy(self) -> None:
        """Destroy synchronization object

        Destroy this explicit synchronization object.

        Any fence set by this object with set_acquire_fence since the last
        commit will be discarded by the server. Any fences set by this object
        before the last commit are not affected.

        :class:`~pywayland.protocol.zwp_linux_explicit_synchronization_unstable_v1.ZwpLinuxBufferReleaseV1`
        objects created by this object are not affected by this request.
        """
        self._marshal(0)
        self._destroy()

    @ZwpLinuxSurfaceSynchronizationV1.request(
        Argument(ArgumentType.FileDescriptor),
    )
    def set_acquire_fence(self, fd: int) -> None:
        """Set the acquire fence

        Set the acquire fence that must be signaled before the compositor may
        sample from the buffer attached with :func:`WlSurface.attach()
        <pywayland.protocol.wayland.WlSurface.attach>`. The fence is a
        dma_fence kernel object.

        The acquire fence is double-buffered state, and will be applied on the
        next :func:`WlSurface.commit()
        <pywayland.protocol.wayland.WlSurface.commit>` request for the
        associated surface. Thus, it applies only to the buffer that is
        attached to the surface at commit time.

        If the provided fd is not a valid dma_fence fd, then an INVALID_FENCE
        error is raised.

        If a fence has already been attached during the same commit cycle, a
        DUPLICATE_FENCE error is raised.

        If the associated :class:`~pywayland.protocol.wayland.WlSurface` was
        destroyed, a NO_SURFACE error is raised.

        If at surface commit time the attached buffer does not support explicit
        synchronization, an UNSUPPORTED_BUFFER error is raised.

        If at surface commit time there is no buffer attached, a NO_BUFFER
        error is raised.

        :param fd:
            acquire fence fd
        :type fd:
            `ArgumentType.FileDescriptor`
        """
        self._marshal(1, fd)

    @ZwpLinuxSurfaceSynchronizationV1.request(
        Argument(ArgumentType.NewId, interface=ZwpLinuxBufferReleaseV1),
    )
    def get_release(self) -> Proxy[ZwpLinuxBufferReleaseV1]:
        """Release fence for last-attached buffer

        Create a listener for the release of the buffer attached by the client
        with :func:`WlSurface.attach()
        <pywayland.protocol.wayland.WlSurface.attach>`. See
        :class:`~pywayland.protocol.zwp_linux_explicit_synchronization_unstable_v1.ZwpLinuxBufferReleaseV1`
        documentation for more information.

        The release object is double-buffered state, and will be associated
        with the buffer that is attached to the surface at
        :func:`WlSurface.commit()
        <pywayland.protocol.wayland.WlSurface.commit>` time.

        If a
        :class:`~pywayland.protocol.zwp_linux_explicit_synchronization_unstable_v1.ZwpLinuxBufferReleaseV1`
        object has already been requested for the surface in the same commit
        cycle, a DUPLICATE_RELEASE error is raised.

        If the associated :class:`~pywayland.protocol.wayland.WlSurface` was
        destroyed, a NO_SURFACE error is raised.

        If at surface commit time there is no buffer attached, a NO_BUFFER
        error is raised.

        :returns:
            :class:`~pywayland.protocol.zwp_linux_explicit_synchronization_unstable_v1.ZwpLinuxBufferReleaseV1`
            -- new
            :class:`~pywayland.protocol.zwp_linux_explicit_synchronization_unstable_v1.ZwpLinuxBufferReleaseV1`
            object
        """
        release = self._marshal_constructor(2, ZwpLinuxBufferReleaseV1)
        return release


class ZwpLinuxSurfaceSynchronizationV1Resource(Resource):
    interface = ZwpLinuxSurfaceSynchronizationV1


class ZwpLinuxSurfaceSynchronizationV1Global(Global):
    interface = ZwpLinuxSurfaceSynchronizationV1


ZwpLinuxSurfaceSynchronizationV1._gen_c()
ZwpLinuxSurfaceSynchronizationV1.proxy_class = ZwpLinuxSurfaceSynchronizationV1Proxy
ZwpLinuxSurfaceSynchronizationV1.resource_class = ZwpLinuxSurfaceSynchronizationV1Resource
ZwpLinuxSurfaceSynchronizationV1.global_class = ZwpLinuxSurfaceSynchronizationV1Global
