/*******************************************************************************
 * Copyright (c) 2006 - 2022 Wind River Systems and others.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     Wind River Systems - initial API and implementation
 *     Intel Corporation - OneAPI Debugger enhancements
 *******************************************************************************/
package org.eclipse.cdt.dsf.iss.ui.viewmodel;

import org.eclipse.cdt.dsf.concurrent.ThreadSafe;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.SteppingController;
import org.eclipse.cdt.dsf.gdb.internal.ui.viewmodel.GdbViewModelAdapter;
import org.eclipse.cdt.dsf.iss.ui.viewmodel.launch.FCHVMProvider;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.ui.viewmodel.IVMProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IColumnPresentationFactory;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;

@SuppressWarnings("restriction")
@ThreadSafe
public class IssGdbViewModelAdapter extends GdbViewModelAdapter {
	String ID_FCH_VIEW = "org.eclipse.cdt.dsf.iss.ui.fch.view"; //$NON-NLS-1$

	public IssGdbViewModelAdapter(DsfSession session, SteppingController controller) {
		super(session, controller);
		getSession().registerModelAdapter(IColumnPresentationFactory.class, this);
	}

	@Override
	public void dispose() {
		getSession().unregisterModelAdapter(IColumnPresentationFactory.class);
		super.dispose();
	}

	@Override
	protected IVMProvider createViewModelProvider(IPresentationContext context) {
		if (ID_FCH_VIEW.equals(context.getId())) {
			return new FCHVMProvider(this, context, getSession());
		} else {
			return super.createViewModelProvider(context);
		}
	}
}
