/*******************************************************************************
 * Copyright (c) 2015 - 2020 Intel Corporation.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     Intel Corporation - Implementation for Function Call History View
 *******************************************************************************/
package org.eclipse.cdt.dsf.iss.mi.service.command.output;

import org.eclipse.cdt.dsf.mi.service.command.output.MIConst;
import org.eclipse.cdt.dsf.mi.service.command.output.MIResult;
import org.eclipse.cdt.dsf.mi.service.command.output.MITuple;
import org.eclipse.cdt.dsf.mi.service.command.output.MIValue;

public class MIFunctionRecord {
    final private String funcIndex;
    final private String funcName;
    final private String funcLevel;
    final private String insnbegin;
    final private String insnend;
    final private String srcbegin;
    final private String srcend;
    final private String srcLoc;

    private MIFunctionRecord(String index, String fName, String fLevel,
            String insbegin, String insend, String srbegin, String srend,
            String srLoc) {
        funcIndex = index;
        funcName = fName;
        funcLevel = fLevel;
        insnbegin = insbegin;
        insnend = insend;
        srcbegin = srbegin;
        srcend = srend;
        srcLoc = srLoc;
    }

    public String getFuncIndex() {
        return funcIndex;
    }

    public String getFuncName() {
        return funcName;
    }

    public String getFuncLevel() {
        return funcLevel;
    }

    public String getInsbegin() {
        return insnbegin;
    }

    public String getInsend() {
        return insnend;
    }

    public String getSrcbegin() {
        return srcbegin;
    }

    public String getSrcend() {
        return srcend;
    }

    public String getSrcloc() {
        return srcLoc;
    }

    public static MIFunctionRecord parse(MITuple tuple) {
        MIResult[] results = tuple.getMIResults();

        String index = "0"; //$NON-NLS-1$
        String name = "????"; //$NON-NLS-1$
        String level = "0"; //$NON-NLS-1$
        String ibegin = "0"; //$NON-NLS-1$
        String iend = "0"; //$NON-NLS-1$
        String sbegin = "0"; //$NON-NLS-1$
        String send = "0"; //$NON-NLS-1$
        String sLoc = "????"; //$NON-NLS-1$

        for (int j = 0; j < results.length; j++) {
            MIResult result = results[j];
            String var = result.getVariable();

            if (var.equals("index")) { //$NON-NLS-1$
                MIValue val = results[j].getMIValue();
                if (val instanceof MIConst) {
                    index = ((MIConst) val).getCString().trim();
                }
            } else if (var.equals("function")) { //$NON-NLS-1$
                MIValue val = results[j].getMIValue();
                if (val instanceof MIConst) {
                    name = ((MIConst) val).getCString().trim();
                }
            } else if (var.equals("level")) { //$NON-NLS-1$
                MIValue val = results[j].getMIValue();
                if (val instanceof MIConst) {
                    level = ((MIConst) val).getCString().trim();
                }
            } else if (var.equals("insn begin")) { //$NON-NLS-1$
                MIValue val = results[j].getMIValue();
                if (val instanceof MIConst) {
                    ibegin = ((MIConst) val).getCString().trim();
                }
            } else if (var.equals("insn end")) { //$NON-NLS-1$
                MIValue val = results[j].getMIValue();
                if (val instanceof MIConst) {
                    iend = ((MIConst) val).getCString().trim();
                }
            } else if (var.equals("min line")) { //$NON-NLS-1$
                MIValue val = results[j].getMIValue();
                if (val instanceof MIConst) {
                    sbegin = ((MIConst) val).getCString().trim();
                }
            } else if (var.equals("max line")) { //$NON-NLS-1$
                MIValue val = results[j].getMIValue();
                if (val instanceof MIConst) {
                    send = ((MIConst) val).getCString().trim();
                }
            } else if (var.equals("file")) { //$NON-NLS-1$
                MIValue val = results[j].getMIValue();
                if (val instanceof MIConst) {
                    sLoc = ((MIConst) val).getCString().trim();
                }
            }
        }
        return new MIFunctionRecord(index, name, level, ibegin, iend, sbegin,
                send, sLoc);
    }
}
