/*******************************************************************************
 * Copyright (c) 2015 - 2020 Intel Corporation and others.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     Intel Corporation - Initial implementation.
 *******************************************************************************/
package org.eclipse.cdt.dsf.iss.service;

import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.datamodel.IDMData;
import org.eclipse.cdt.dsf.gdb.service.IReverseRunControl;
import org.eclipse.cdt.dsf.mi.service.IMIExecutionDMContext;

@SuppressWarnings("restriction")
public interface IIssReverseRunControl extends  IReverseRunControl {
	public interface IFunctionRecordDMData extends IDMData {
		String getName();
		String getId();
		String getLevel();
		String getFile();
		int getBeginLine();
		int getEndLine();
	}

	public int getFunctionCallRecordMinStackDepth();
	void getFunctionCallRecordList(DataRequestMonitor<IFunctionRecordDMData> rm, int index);
	void getFunctionCallCountVM(IMIExecutionDMContext execDmc, DataRequestMonitor<Integer>rm);
	void shiftWindowForward(int i);
	void shiftWindowBackward(int i);
	void getPartialFunctionCallRecordVM(IMIExecutionDMContext execDmc, DataRequestMonitor<IFunctionRecordDMContext[]> rm);
}
