/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.translog;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.lucene.backward_codecs.store.EndiannessReverserUtil;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexFormatTooNewException;
import org.apache.lucene.index.IndexFormatTooOldException;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.NIOFSDirectory;
import org.apache.lucene.store.OutputStreamIndexOutput;
import org.opensearch.common.io.Channels;
import org.opensearch.index.translog.ChannelFactory;
import org.opensearch.index.translog.TranslogCorruptedException;

public final class Checkpoint {
    final long offset;
    final int numOps;
    final long generation;
    final long minSeqNo;
    final long maxSeqNo;
    final long globalCheckpoint;
    final long minTranslogGeneration;
    final long trimmedAboveSeqNo;
    private static final int VERSION_LUCENE_BIG_ENDIAN = 3;
    private static final int CURRENT_VERSION = 4;
    private static final String CHECKPOINT_CODEC = "ckp";
    static final int V4_FILE_SIZE = CodecUtil.headerLength((String)"ckp") + 4 + 8 + 8 + 8 + 8 + 8 + 8 + 8 + CodecUtil.footerLength();

    Checkpoint(long offset, int numOps, long generation, long minSeqNo, long maxSeqNo, long globalCheckpoint, long minTranslogGeneration, long trimmedAboveSeqNo) {
        assert (minSeqNo <= maxSeqNo) : "minSeqNo [" + minSeqNo + "] is higher than maxSeqNo [" + maxSeqNo + "]";
        assert (trimmedAboveSeqNo <= maxSeqNo) : "trimmedAboveSeqNo [" + trimmedAboveSeqNo + "] is higher than maxSeqNo [" + maxSeqNo + "]";
        assert (minTranslogGeneration <= generation) : "minTranslogGen [" + minTranslogGeneration + "] is higher than generation [" + generation + "]";
        this.offset = offset;
        this.numOps = numOps;
        this.generation = generation;
        this.minSeqNo = minSeqNo;
        this.maxSeqNo = maxSeqNo;
        this.globalCheckpoint = globalCheckpoint;
        this.minTranslogGeneration = minTranslogGeneration;
        this.trimmedAboveSeqNo = trimmedAboveSeqNo;
    }

    private void write(DataOutput out) throws IOException {
        out.writeLong(this.offset);
        out.writeInt(this.numOps);
        out.writeLong(this.generation);
        out.writeLong(this.minSeqNo);
        out.writeLong(this.maxSeqNo);
        out.writeLong(this.globalCheckpoint);
        out.writeLong(this.minTranslogGeneration);
        out.writeLong(this.trimmedAboveSeqNo);
    }

    long maxEffectiveSeqNo() {
        if (this.trimmedAboveSeqNo == -2L) {
            return this.maxSeqNo;
        }
        return Math.min(this.trimmedAboveSeqNo, this.maxSeqNo);
    }

    static Checkpoint emptyTranslogCheckpoint(long offset, long generation, long globalCheckpoint, long minTranslogGeneration) {
        long minSeqNo = -1L;
        long maxSeqNo = -1L;
        long trimmedAboveSeqNo = -2L;
        return new Checkpoint(offset, 0, generation, -1L, -1L, globalCheckpoint, minTranslogGeneration, -2L);
    }

    static Checkpoint readCheckpointV3(DataInput in) throws IOException {
        return Checkpoint.readCheckpointV4(EndiannessReverserUtil.wrapDataInput((DataInput)in));
    }

    static Checkpoint readCheckpointV4(DataInput in) throws IOException {
        long offset = in.readLong();
        int numOps = in.readInt();
        long generation = in.readLong();
        long minSeqNo = in.readLong();
        long maxSeqNo = in.readLong();
        long globalCheckpoint = in.readLong();
        long minTranslogGeneration = in.readLong();
        long trimmedAboveSeqNo = in.readLong();
        return new Checkpoint(offset, numOps, generation, minSeqNo, maxSeqNo, globalCheckpoint, minTranslogGeneration, trimmedAboveSeqNo);
    }

    public String toString() {
        return "Checkpoint{offset=" + this.offset + ", numOps=" + this.numOps + ", generation=" + this.generation + ", minSeqNo=" + this.minSeqNo + ", maxSeqNo=" + this.maxSeqNo + ", globalCheckpoint=" + this.globalCheckpoint + ", minTranslogGeneration=" + this.minTranslogGeneration + ", trimmedAboveSeqNo=" + this.trimmedAboveSeqNo + "}";
    }

    public static Checkpoint read(Path path) throws IOException {
        try (NIOFSDirectory dir = new NIOFSDirectory(path.getParent());){
            Checkpoint checkpoint;
            block15: {
                IndexInput indexInput = dir.openInput(path.getFileName().toString(), IOContext.DEFAULT);
                try {
                    CodecUtil.checksumEntireFile((IndexInput)indexInput);
                    int fileVersion = CodecUtil.checkHeader((DataInput)indexInput, (String)CHECKPOINT_CODEC, (int)3, (int)4);
                    assert (fileVersion == 4 || fileVersion == 3) : fileVersion;
                    assert (indexInput.length() == (long)V4_FILE_SIZE) : indexInput.length();
                    Checkpoint checkpoint2 = checkpoint = fileVersion == 4 ? Checkpoint.readCheckpointV4((DataInput)indexInput) : Checkpoint.readCheckpointV3((DataInput)indexInput);
                    if (indexInput == null) break block15;
                }
                catch (Throwable throwable) {
                    try {
                        if (indexInput != null) {
                            try {
                                indexInput.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (NoSuchFileException | CorruptIndexException | IndexFormatTooNewException | IndexFormatTooOldException e) {
                        throw new TranslogCorruptedException(path.toString(), e);
                    }
                }
                indexInput.close();
            }
            return checkpoint;
        }
    }

    public static void write(ChannelFactory factory, Path checkpointFile, Checkpoint checkpoint, OpenOption ... options) throws IOException {
        byte[] bytes = Checkpoint.createCheckpointBytes(checkpointFile, checkpoint);
        try (FileChannel channel = factory.open(checkpointFile, options);){
            Channels.writeToChannel(bytes, (WritableByteChannel)channel);
            channel.force(true);
        }
    }

    public static void write(FileChannel fileChannel, Path checkpointFile, Checkpoint checkpoint) throws IOException {
        byte[] bytes = Checkpoint.createCheckpointBytes(checkpointFile, checkpoint);
        Channels.writeToChannel(bytes, fileChannel, 0L);
        fileChannel.force(false);
    }

    private static byte[] createCheckpointBytes(Path checkpointFile, Checkpoint checkpoint) throws IOException {
        ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream(V4_FILE_SIZE){

            @Override
            public synchronized byte[] toByteArray() {
                return this.buf;
            }
        };
        String resourceDesc = "checkpoint(path=\"" + checkpointFile + "\", gen=" + checkpoint + ")";
        try (OutputStreamIndexOutput indexOutput = new OutputStreamIndexOutput(resourceDesc, checkpointFile.toString(), (OutputStream)byteOutputStream, V4_FILE_SIZE);){
            CodecUtil.writeHeader((DataOutput)indexOutput, (String)CHECKPOINT_CODEC, (int)4);
            checkpoint.write((DataOutput)indexOutput);
            CodecUtil.writeFooter((IndexOutput)indexOutput);
            assert (indexOutput.getFilePointer() == (long)V4_FILE_SIZE) : "get you numbers straight; bytes written: " + indexOutput.getFilePointer() + ", buffer size: " + V4_FILE_SIZE;
            assert (indexOutput.getFilePointer() < 512L) : "checkpoint files have to be smaller than 512 bytes for atomic writes; size: " + indexOutput.getFilePointer();
        }
        return byteOutputStream.toByteArray();
    }

    public long getMinTranslogGeneration() {
        return this.minTranslogGeneration;
    }

    public long getGeneration() {
        return this.generation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Checkpoint that = (Checkpoint)o;
        if (this.offset != that.offset) {
            return false;
        }
        if (this.numOps != that.numOps) {
            return false;
        }
        if (this.generation != that.generation) {
            return false;
        }
        if (this.minSeqNo != that.minSeqNo) {
            return false;
        }
        if (this.maxSeqNo != that.maxSeqNo) {
            return false;
        }
        if (this.globalCheckpoint != that.globalCheckpoint) {
            return false;
        }
        return this.trimmedAboveSeqNo == that.trimmedAboveSeqNo;
    }

    public int hashCode() {
        int result = Long.hashCode(this.offset);
        result = 31 * result + this.numOps;
        result = 31 * result + Long.hashCode(this.generation);
        result = 31 * result + Long.hashCode(this.minSeqNo);
        result = 31 * result + Long.hashCode(this.maxSeqNo);
        result = 31 * result + Long.hashCode(this.globalCheckpoint);
        result = 31 * result + Long.hashCode(this.trimmedAboveSeqNo);
        return result;
    }
}

