/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.model;

import com.google.common.base.Objects;
import java.io.IOException;
import java.time.Instant;
import org.opensearch.ad.annotation.Generated;
import org.opensearch.ad.model.ADTaskState;
import org.opensearch.ad.model.ADTaskType;
import org.opensearch.ad.model.AnomalyDetector;
import org.opensearch.ad.model.DetectionDateRange;
import org.opensearch.ad.model.Entity;
import org.opensearch.ad.util.ParseUtils;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.io.stream.Writeable;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.ToXContentObject;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.common.xcontent.XContentParserUtils;
import org.opensearch.commons.authuser.User;

public class ADTask
implements ToXContentObject,
Writeable {
    public static final String TASK_ID_FIELD = "task_id";
    public static final String LAST_UPDATE_TIME_FIELD = "last_update_time";
    public static final String STARTED_BY_FIELD = "started_by";
    public static final String STOPPED_BY_FIELD = "stopped_by";
    public static final String ERROR_FIELD = "error";
    public static final String STATE_FIELD = "state";
    public static final String DETECTOR_ID_FIELD = "detector_id";
    public static final String TASK_PROGRESS_FIELD = "task_progress";
    public static final String INIT_PROGRESS_FIELD = "init_progress";
    public static final String CURRENT_PIECE_FIELD = "current_piece";
    public static final String EXECUTION_START_TIME_FIELD = "execution_start_time";
    public static final String EXECUTION_END_TIME_FIELD = "execution_end_time";
    public static final String IS_LATEST_FIELD = "is_latest";
    public static final String TASK_TYPE_FIELD = "task_type";
    public static final String CHECKPOINT_ID_FIELD = "checkpoint_id";
    public static final String COORDINATING_NODE_FIELD = "coordinating_node";
    public static final String WORKER_NODE_FIELD = "worker_node";
    public static final String DETECTOR_FIELD = "detector";
    public static final String DETECTION_DATE_RANGE_FIELD = "detection_date_range";
    public static final String ENTITY_FIELD = "entity";
    public static final String PARENT_TASK_ID_FIELD = "parent_task_id";
    public static final String ESTIMATED_MINUTES_LEFT_FIELD = "estimated_minutes_left";
    public static final String USER_FIELD = "user";
    public static final String HISTORICAL_TASK_PREFIX = "HISTORICAL";
    private String taskId = null;
    private Instant lastUpdateTime = null;
    private String startedBy = null;
    private String stoppedBy = null;
    private String error = null;
    private String state = null;
    private String detectorId = null;
    private Float taskProgress = null;
    private Float initProgress = null;
    private Instant currentPiece = null;
    private Instant executionStartTime = null;
    private Instant executionEndTime = null;
    private Boolean isLatest = null;
    private String taskType = null;
    private String checkpointId = null;
    private AnomalyDetector detector = null;
    private String coordinatingNode = null;
    private String workerNode = null;
    private DetectionDateRange detectionDateRange = null;
    private Entity entity = null;
    private String parentTaskId = null;
    private Integer estimatedMinutesLeft = null;
    private User user = null;

    private ADTask() {
    }

    public ADTask(StreamInput input) throws IOException {
        this.taskId = input.readOptionalString();
        this.taskType = input.readOptionalString();
        this.detectorId = input.readOptionalString();
        this.detector = input.readBoolean() ? new AnomalyDetector(input) : null;
        this.state = input.readOptionalString();
        this.taskProgress = input.readOptionalFloat();
        this.initProgress = input.readOptionalFloat();
        this.currentPiece = input.readOptionalInstant();
        this.executionStartTime = input.readOptionalInstant();
        this.executionEndTime = input.readOptionalInstant();
        this.isLatest = input.readOptionalBoolean();
        this.error = input.readOptionalString();
        this.checkpointId = input.readOptionalString();
        this.lastUpdateTime = input.readOptionalInstant();
        this.startedBy = input.readOptionalString();
        this.stoppedBy = input.readOptionalString();
        this.coordinatingNode = input.readOptionalString();
        this.workerNode = input.readOptionalString();
        this.user = input.readBoolean() ? new User(input) : null;
        if (input.available() > 0) {
            this.detectionDateRange = input.readBoolean() ? new DetectionDateRange(input) : null;
            this.entity = input.readBoolean() ? new Entity(input) : null;
            this.parentTaskId = input.readOptionalString();
            this.estimatedMinutesLeft = input.readOptionalInt();
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.taskId);
        out.writeOptionalString(this.taskType);
        out.writeOptionalString(this.detectorId);
        if (this.detector != null) {
            out.writeBoolean(true);
            this.detector.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalString(this.state);
        out.writeOptionalFloat(this.taskProgress);
        out.writeOptionalFloat(this.initProgress);
        out.writeOptionalInstant(this.currentPiece);
        out.writeOptionalInstant(this.executionStartTime);
        out.writeOptionalInstant(this.executionEndTime);
        out.writeOptionalBoolean(this.isLatest);
        out.writeOptionalString(this.error);
        out.writeOptionalString(this.checkpointId);
        out.writeOptionalInstant(this.lastUpdateTime);
        out.writeOptionalString(this.startedBy);
        out.writeOptionalString(this.stoppedBy);
        out.writeOptionalString(this.coordinatingNode);
        out.writeOptionalString(this.workerNode);
        if (this.user != null) {
            out.writeBoolean(true);
            this.user.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        if (this.detectionDateRange != null) {
            out.writeBoolean(true);
            this.detectionDateRange.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        if (this.entity != null) {
            out.writeBoolean(true);
            this.entity.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalString(this.parentTaskId);
        out.writeOptionalInt(this.estimatedMinutesLeft);
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean isHistoricalTask() {
        return this.taskType.startsWith(HISTORICAL_TASK_PREFIX);
    }

    public boolean isEntityTask() {
        return ADTaskType.HISTORICAL_HC_ENTITY.name().equals(this.taskType);
    }

    public String getDetectorLevelTaskId() {
        return this.getParentTaskId() != null ? this.getParentTaskId() : this.getTaskId();
    }

    public boolean isDone() {
        return !ADTaskState.NOT_ENDED_STATES.contains(this.getState());
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        XContentBuilder xContentBuilder = builder.startObject();
        if (this.taskId != null) {
            xContentBuilder.field(TASK_ID_FIELD, this.taskId);
        }
        if (this.lastUpdateTime != null) {
            xContentBuilder.field(LAST_UPDATE_TIME_FIELD, this.lastUpdateTime.toEpochMilli());
        }
        if (this.startedBy != null) {
            xContentBuilder.field(STARTED_BY_FIELD, this.startedBy);
        }
        if (this.stoppedBy != null) {
            xContentBuilder.field(STOPPED_BY_FIELD, this.stoppedBy);
        }
        if (this.error != null) {
            xContentBuilder.field(ERROR_FIELD, this.error);
        }
        if (this.state != null) {
            xContentBuilder.field(STATE_FIELD, this.state);
        }
        if (this.detectorId != null) {
            xContentBuilder.field(DETECTOR_ID_FIELD, this.detectorId);
        }
        if (this.taskProgress != null) {
            xContentBuilder.field(TASK_PROGRESS_FIELD, this.taskProgress);
        }
        if (this.initProgress != null) {
            xContentBuilder.field(INIT_PROGRESS_FIELD, this.initProgress);
        }
        if (this.currentPiece != null) {
            xContentBuilder.field(CURRENT_PIECE_FIELD, this.currentPiece.toEpochMilli());
        }
        if (this.executionStartTime != null) {
            xContentBuilder.field(EXECUTION_START_TIME_FIELD, this.executionStartTime.toEpochMilli());
        }
        if (this.executionEndTime != null) {
            xContentBuilder.field(EXECUTION_END_TIME_FIELD, this.executionEndTime.toEpochMilli());
        }
        if (this.isLatest != null) {
            xContentBuilder.field(IS_LATEST_FIELD, this.isLatest);
        }
        if (this.taskType != null) {
            xContentBuilder.field(TASK_TYPE_FIELD, this.taskType);
        }
        if (this.checkpointId != null) {
            xContentBuilder.field(CHECKPOINT_ID_FIELD, this.checkpointId);
        }
        if (this.coordinatingNode != null) {
            xContentBuilder.field(COORDINATING_NODE_FIELD, this.coordinatingNode);
        }
        if (this.workerNode != null) {
            xContentBuilder.field(WORKER_NODE_FIELD, this.workerNode);
        }
        if (this.detector != null) {
            xContentBuilder.field(DETECTOR_FIELD, (ToXContent)this.detector);
        }
        if (this.detectionDateRange != null) {
            xContentBuilder.field(DETECTION_DATE_RANGE_FIELD, (ToXContent)this.detectionDateRange);
        }
        if (this.entity != null) {
            xContentBuilder.field(ENTITY_FIELD, (ToXContent)this.entity);
        }
        if (this.parentTaskId != null) {
            xContentBuilder.field(PARENT_TASK_ID_FIELD, this.parentTaskId);
        }
        if (this.estimatedMinutesLeft != null) {
            xContentBuilder.field(ESTIMATED_MINUTES_LEFT_FIELD, this.estimatedMinutesLeft);
        }
        if (this.user != null) {
            xContentBuilder.field(USER_FIELD, (ToXContent)this.user);
        }
        return xContentBuilder.endObject();
    }

    public static ADTask parse(XContentParser parser) throws IOException {
        return ADTask.parse(parser, null);
    }

    public static ADTask parse(XContentParser parser, String taskId) throws IOException {
        Instant lastUpdateTime = null;
        String startedBy = null;
        String stoppedBy = null;
        String error = null;
        String state = null;
        String detectorId = null;
        Float taskProgress = null;
        Float initProgress = null;
        Instant currentPiece = null;
        Instant executionStartTime = null;
        Instant executionEndTime = null;
        Boolean isLatest = null;
        String taskType = null;
        String checkpointId = null;
        AnomalyDetector detector = null;
        String parsedTaskId = taskId;
        String coordinatingNode = null;
        String workerNode = null;
        DetectionDateRange detectionDateRange = null;
        Entity entity = null;
        String parentTaskId = null;
        Integer estimatedMinutesLeft = null;
        User user = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block50: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "last_update_time": {
                    lastUpdateTime = ParseUtils.toInstant(parser);
                    continue block50;
                }
                case "started_by": {
                    startedBy = parser.text();
                    continue block50;
                }
                case "stopped_by": {
                    stoppedBy = parser.text();
                    continue block50;
                }
                case "error": {
                    error = parser.text();
                    continue block50;
                }
                case "state": {
                    state = parser.text();
                    continue block50;
                }
                case "detector_id": {
                    detectorId = parser.text();
                    continue block50;
                }
                case "task_progress": {
                    taskProgress = Float.valueOf(parser.floatValue());
                    continue block50;
                }
                case "init_progress": {
                    initProgress = Float.valueOf(parser.floatValue());
                    continue block50;
                }
                case "current_piece": {
                    currentPiece = ParseUtils.toInstant(parser);
                    continue block50;
                }
                case "execution_start_time": {
                    executionStartTime = ParseUtils.toInstant(parser);
                    continue block50;
                }
                case "execution_end_time": {
                    executionEndTime = ParseUtils.toInstant(parser);
                    continue block50;
                }
                case "is_latest": {
                    isLatest = parser.booleanValue();
                    continue block50;
                }
                case "task_type": {
                    taskType = parser.text();
                    continue block50;
                }
                case "checkpoint_id": {
                    checkpointId = parser.text();
                    continue block50;
                }
                case "detector": {
                    detector = AnomalyDetector.parse(parser);
                    continue block50;
                }
                case "task_id": {
                    parsedTaskId = parser.text();
                    continue block50;
                }
                case "coordinating_node": {
                    coordinatingNode = parser.text();
                    continue block50;
                }
                case "worker_node": {
                    workerNode = parser.text();
                    continue block50;
                }
                case "detection_date_range": {
                    detectionDateRange = DetectionDateRange.parse(parser);
                    continue block50;
                }
                case "entity": {
                    entity = Entity.parse(parser);
                    continue block50;
                }
                case "parent_task_id": {
                    parentTaskId = parser.text();
                    continue block50;
                }
                case "estimated_minutes_left": {
                    estimatedMinutesLeft = parser.intValue();
                    continue block50;
                }
                case "user": {
                    user = User.parse((XContentParser)parser);
                    continue block50;
                }
            }
            parser.skipChildren();
        }
        AnomalyDetector anomalyDetector = detector == null ? null : new AnomalyDetector(detectorId, detector.getVersion(), detector.getName(), detector.getDescription(), detector.getTimeField(), detector.getIndices(), detector.getFeatureAttributes(), detector.getFilterQuery(), detector.getDetectionInterval(), detector.getWindowDelay(), detector.getShingleSize(), detector.getUiMetadata(), detector.getSchemaVersion(), detector.getLastUpdateTime(), detector.getCategoryField(), detector.getUser(), detector.getResultIndex());
        return new Builder().taskId(parsedTaskId).lastUpdateTime(lastUpdateTime).startedBy(startedBy).stoppedBy(stoppedBy).error(error).state(state).detectorId(detectorId).taskProgress(taskProgress).initProgress(initProgress).currentPiece(currentPiece).executionStartTime(executionStartTime).executionEndTime(executionEndTime).isLatest(isLatest).taskType(taskType).checkpointId(checkpointId).coordinatingNode(coordinatingNode).workerNode(workerNode).detector(anomalyDetector).detectionDateRange(detectionDateRange).entity(entity).parentTaskId(parentTaskId).estimatedMinutesLeft(estimatedMinutesLeft).user(user).build();
    }

    @Generated
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ADTask that = (ADTask)o;
        return Objects.equal((Object)this.getTaskId(), (Object)that.getTaskId()) && Objects.equal((Object)this.getLastUpdateTime(), (Object)that.getLastUpdateTime()) && Objects.equal((Object)this.getStartedBy(), (Object)that.getStartedBy()) && Objects.equal((Object)this.getStoppedBy(), (Object)that.getStoppedBy()) && Objects.equal((Object)this.getError(), (Object)that.getError()) && Objects.equal((Object)this.getState(), (Object)that.getState()) && Objects.equal((Object)this.getDetectorId(), (Object)that.getDetectorId()) && Objects.equal((Object)this.getTaskProgress(), (Object)that.getTaskProgress()) && Objects.equal((Object)this.getInitProgress(), (Object)that.getInitProgress()) && Objects.equal((Object)this.getCurrentPiece(), (Object)that.getCurrentPiece()) && Objects.equal((Object)this.getExecutionStartTime(), (Object)that.getExecutionStartTime()) && Objects.equal((Object)this.getExecutionEndTime(), (Object)that.getExecutionEndTime()) && Objects.equal((Object)this.getLatest(), (Object)that.getLatest()) && Objects.equal((Object)this.getTaskType(), (Object)that.getTaskType()) && Objects.equal((Object)this.getCheckpointId(), (Object)that.getCheckpointId()) && Objects.equal((Object)this.getCoordinatingNode(), (Object)that.getCoordinatingNode()) && Objects.equal((Object)this.getWorkerNode(), (Object)that.getWorkerNode()) && Objects.equal((Object)this.getDetector(), (Object)that.getDetector()) && Objects.equal((Object)this.getDetectionDateRange(), (Object)that.getDetectionDateRange()) && Objects.equal((Object)this.getEntity(), (Object)that.getEntity()) && Objects.equal((Object)this.getParentTaskId(), (Object)that.getParentTaskId()) && Objects.equal((Object)this.getEstimatedMinutesLeft(), (Object)that.getEstimatedMinutesLeft()) && Objects.equal((Object)this.getUser(), (Object)that.getUser());
    }

    @Generated
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.taskId, this.lastUpdateTime, this.startedBy, this.stoppedBy, this.error, this.state, this.detectorId, this.taskProgress, this.initProgress, this.currentPiece, this.executionStartTime, this.executionEndTime, this.isLatest, this.taskType, this.checkpointId, this.coordinatingNode, this.workerNode, this.detector, this.detectionDateRange, this.entity, this.parentTaskId, this.estimatedMinutesLeft, this.user});
    }

    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public Instant getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public String getStartedBy() {
        return this.startedBy;
    }

    public String getStoppedBy() {
        return this.stoppedBy;
    }

    public String getError() {
        return this.error;
    }

    public void setError(String error) {
        this.error = error;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getDetectorId() {
        return this.detectorId;
    }

    public Float getTaskProgress() {
        return this.taskProgress;
    }

    public Float getInitProgress() {
        return this.initProgress;
    }

    public Instant getCurrentPiece() {
        return this.currentPiece;
    }

    public Instant getExecutionStartTime() {
        return this.executionStartTime;
    }

    public Instant getExecutionEndTime() {
        return this.executionEndTime;
    }

    public Boolean getLatest() {
        return this.isLatest;
    }

    public String getTaskType() {
        return this.taskType;
    }

    public String getCheckpointId() {
        return this.checkpointId;
    }

    public AnomalyDetector getDetector() {
        return this.detector;
    }

    public String getCoordinatingNode() {
        return this.coordinatingNode;
    }

    public String getWorkerNode() {
        return this.workerNode;
    }

    public DetectionDateRange getDetectionDateRange() {
        return this.detectionDateRange;
    }

    public Entity getEntity() {
        return this.entity;
    }

    public String getEntityModelId() {
        return this.entity == null ? null : (String)this.entity.getModelId(this.getDetectorId()).orElse(null);
    }

    public String getParentTaskId() {
        return this.parentTaskId;
    }

    public Integer getEstimatedMinutesLeft() {
        return this.estimatedMinutesLeft;
    }

    public User getUser() {
        return this.user;
    }

    public void setDetectionDateRange(DetectionDateRange detectionDateRange) {
        this.detectionDateRange = detectionDateRange;
    }

    public void setLatest(Boolean latest) {
        this.isLatest = latest;
    }

    public void setLastUpdateTime(Instant lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    public static class Builder {
        private String taskId = null;
        private String taskType = null;
        private String detectorId = null;
        private AnomalyDetector detector = null;
        private String state = null;
        private Float taskProgress = null;
        private Float initProgress = null;
        private Instant currentPiece = null;
        private Instant executionStartTime = null;
        private Instant executionEndTime = null;
        private Boolean isLatest = null;
        private String error = null;
        private String checkpointId = null;
        private Instant lastUpdateTime = null;
        private String startedBy = null;
        private String stoppedBy = null;
        private String coordinatingNode = null;
        private String workerNode = null;
        private DetectionDateRange detectionDateRange = null;
        private Entity entity = null;
        private String parentTaskId;
        private Integer estimatedMinutesLeft;
        private User user = null;

        public Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public Builder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        public Builder startedBy(String startedBy) {
            this.startedBy = startedBy;
            return this;
        }

        public Builder stoppedBy(String stoppedBy) {
            this.stoppedBy = stoppedBy;
            return this;
        }

        public Builder error(String error) {
            this.error = error;
            return this;
        }

        public Builder state(String state) {
            this.state = state;
            return this;
        }

        public Builder detectorId(String detectorId) {
            this.detectorId = detectorId;
            return this;
        }

        public Builder taskProgress(Float taskProgress) {
            this.taskProgress = taskProgress;
            return this;
        }

        public Builder initProgress(Float initProgress) {
            this.initProgress = initProgress;
            return this;
        }

        public Builder currentPiece(Instant currentPiece) {
            this.currentPiece = currentPiece;
            return this;
        }

        public Builder executionStartTime(Instant executionStartTime) {
            this.executionStartTime = executionStartTime;
            return this;
        }

        public Builder executionEndTime(Instant executionEndTime) {
            this.executionEndTime = executionEndTime;
            return this;
        }

        public Builder isLatest(Boolean isLatest) {
            this.isLatest = isLatest;
            return this;
        }

        public Builder taskType(String taskType) {
            this.taskType = taskType;
            return this;
        }

        public Builder checkpointId(String checkpointId) {
            this.checkpointId = checkpointId;
            return this;
        }

        public Builder detector(AnomalyDetector detector) {
            this.detector = detector;
            return this;
        }

        public Builder coordinatingNode(String coordinatingNode) {
            this.coordinatingNode = coordinatingNode;
            return this;
        }

        public Builder workerNode(String workerNode) {
            this.workerNode = workerNode;
            return this;
        }

        public Builder detectionDateRange(DetectionDateRange detectionDateRange) {
            this.detectionDateRange = detectionDateRange;
            return this;
        }

        public Builder entity(Entity entity) {
            this.entity = entity;
            return this;
        }

        public Builder parentTaskId(String parentTaskId) {
            this.parentTaskId = parentTaskId;
            return this;
        }

        public Builder estimatedMinutesLeft(Integer estimatedMinutesLeft) {
            this.estimatedMinutesLeft = estimatedMinutesLeft;
            return this;
        }

        public Builder user(User user) {
            this.user = user;
            return this;
        }

        public ADTask build() {
            ADTask adTask = new ADTask();
            adTask.taskId = this.taskId;
            adTask.lastUpdateTime = this.lastUpdateTime;
            adTask.error = this.error;
            adTask.state = this.state;
            adTask.detectorId = this.detectorId;
            adTask.taskProgress = this.taskProgress;
            adTask.initProgress = this.initProgress;
            adTask.currentPiece = this.currentPiece;
            adTask.executionStartTime = this.executionStartTime;
            adTask.executionEndTime = this.executionEndTime;
            adTask.isLatest = this.isLatest;
            adTask.taskType = this.taskType;
            adTask.checkpointId = this.checkpointId;
            adTask.detector = this.detector;
            adTask.startedBy = this.startedBy;
            adTask.stoppedBy = this.stoppedBy;
            adTask.coordinatingNode = this.coordinatingNode;
            adTask.workerNode = this.workerNode;
            adTask.detectionDateRange = this.detectionDateRange;
            adTask.entity = this.entity;
            adTask.parentTaskId = this.parentTaskId;
            adTask.estimatedMinutesLeft = this.estimatedMinutesLeft;
            adTask.user = this.user;
            return adTask;
        }
    }
}

